/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import cn.afterturn.easypoi.excel.entity.params.MergeEntity;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.util.PoiCellUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoiMergeCellUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiMergeCellUtil.class);

    private PoiMergeCellUtil() {
    }

    public static void mergeCells(Sheet sheet, int startRow, Integer ... columns) {
        if (columns == null) {
            throw new ExcelExportException("\u81f3\u5c11\u9700\u8981\u5904\u74061\u5217");
        }
        HashMap<Integer, int[]> mergeMap = new HashMap<Integer, int[]>();
        for (int i = 0; i < columns.length; ++i) {
            mergeMap.put(columns[i], null);
        }
        PoiMergeCellUtil.mergeCells(sheet, mergeMap, startRow, sheet.getLastRowNum());
    }

    public static void mergeCells(Sheet sheet, Map<Integer, int[]> mergeMap, int startRow) {
        PoiMergeCellUtil.mergeCells(sheet, mergeMap, startRow, sheet.getLastRowNum());
    }

    public static void mergeCells(Sheet sheet, Map<Integer, int[]> mergeMap, int startRow, int endRow) {
        HashMap<Integer, MergeEntity> mergeDataMap = new HashMap<Integer, MergeEntity>();
        if (mergeMap.size() == 0) {
            return;
        }
        Set<Integer> sets = mergeMap.keySet();
        for (int i = startRow; i <= endRow; ++i) {
            Row row = sheet.getRow(i);
            for (Integer index : sets) {
                if (row == null || row.getCell(index.intValue()) == null) {
                    if (mergeDataMap.get(index) == null || ((MergeEntity)mergeDataMap.get(index)).getEndRow() != 0) continue;
                    ((MergeEntity)mergeDataMap.get(index)).setEndRow(i - 1);
                    continue;
                }
                String text = PoiCellUtil.getCellValue(row.getCell(index.intValue()));
                if (StringUtils.isNotEmpty((CharSequence)text)) {
                    PoiMergeCellUtil.handlerMergeCells(index, i, text, mergeDataMap, sheet, row.getCell(index.intValue()), mergeMap.get(index));
                    continue;
                }
                PoiMergeCellUtil.mergeCellOrContinue(index, mergeDataMap, sheet);
            }
        }
        if (mergeDataMap.size() > 0) {
            for (Integer index : mergeDataMap.keySet()) {
                if (((MergeEntity)mergeDataMap.get(index)).getEndRow() <= ((MergeEntity)mergeDataMap.get(index)).getStartRow()) continue;
                PoiMergeCellUtil.addMergedRegion(sheet, ((MergeEntity)mergeDataMap.get(index)).getStartRow(), ((MergeEntity)mergeDataMap.get(index)).getEndRow(), index, index);
            }
        }
    }

    private static void handlerMergeCells(Integer index, int rowNum, String text, Map<Integer, MergeEntity> mergeDataMap, Sheet sheet, Cell cell, int[] delys) {
        if (mergeDataMap.containsKey(index)) {
            if (PoiMergeCellUtil.checkIsEqualByCellContents(mergeDataMap.get(index), text, cell, delys, rowNum)) {
                mergeDataMap.get(index).setEndRow(rowNum);
            } else {
                if (mergeDataMap.get(index).getEndRow() > mergeDataMap.get(index).getStartRow()) {
                    PoiMergeCellUtil.addMergedRegion(sheet, mergeDataMap.get(index).getStartRow(), mergeDataMap.get(index).getEndRow(), index, index);
                }
                mergeDataMap.put(index, PoiMergeCellUtil.createMergeEntity(text, rowNum, cell, delys));
            }
        } else {
            mergeDataMap.put(index, PoiMergeCellUtil.createMergeEntity(text, rowNum, cell, delys));
        }
    }

    private static void mergeCellOrContinue(Integer index, Map<Integer, MergeEntity> mergeDataMap, Sheet sheet) {
        if (mergeDataMap.containsKey(index) && mergeDataMap.get(index).getEndRow() != mergeDataMap.get(index).getStartRow()) {
            try {
                PoiMergeCellUtil.addMergedRegion(sheet, mergeDataMap.get(index).getStartRow(), mergeDataMap.get(index).getEndRow(), index, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            mergeDataMap.remove(index);
        }
    }

    private static MergeEntity createMergeEntity(String text, int rowNum, Cell cell, int[] delys) {
        MergeEntity mergeEntity = new MergeEntity(text, rowNum, rowNum);
        if (delys != null && delys.length != 0) {
            ArrayList<String> list = new ArrayList<String>(delys.length);
            mergeEntity.setRelyList(list);
            for (int i = 0; i < delys.length; ++i) {
                list.add(PoiMergeCellUtil.getCellNotNullText(cell, delys[i], rowNum));
            }
        }
        return mergeEntity;
    }

    private static boolean checkIsEqualByCellContents(MergeEntity mergeEntity, String text, Cell cell, int[] delys, int rowNum) {
        if (delys == null || delys.length == 0) {
            return mergeEntity.getText().equals(text);
        }
        if (mergeEntity.getText().equals(text)) {
            for (int i = 0; i < delys.length; ++i) {
                if (mergeEntity.getRelyList().get(i) != null && mergeEntity.getRelyList().get(i).equals(PoiMergeCellUtil.getCellNotNullText(cell, delys[i], rowNum))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getCellNotNullText(Cell cell, int index, int rowNum) {
        if (cell == null || cell.getRow() == null) {
            return null;
        }
        if (cell.getRow().getCell(index) != null && StringUtils.isNotEmpty((CharSequence)PoiCellUtil.getCellValue(cell.getRow().getCell(index)))) {
            return PoiCellUtil.getCellValue(cell.getRow().getCell(index));
        }
        return PoiMergeCellUtil.getCellNotNullText(cell.getRow().getSheet().getRow(--rowNum).getCell(index), index, rowNum);
    }

    public static void addMergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        if (firstRow == lastRow && firstCol == lastCol) {
            return;
        }
        try {
            sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
        }
        catch (Exception e) {
            LOGGER.debug("\u53d1\u751f\u4e86\u4e00\u6b21\u5408\u5e76\u5355\u5143\u683c\u9519\u8bef,{},{},{},{}", (Object[])new Integer[]{firstRow, lastRow, firstCol, lastCol});
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static void setBorder(BorderStyle borderStyle, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cra = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        RegionUtil.setBorderBottom((BorderStyle)borderStyle, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)borderStyle, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)borderStyle, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)borderStyle, (CellRangeAddress)cra, (Sheet)sheet);
    }
}

