/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.entity;

import com.kingbase8.Driver;
import com.kingbase8.KBNotification;
import com.kingbase8.KBProperty;
import com.kingbase8.copy.CopyManager;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ReplicationProtocol;
import com.kingbase8.core.TransactionState;
import com.kingbase8.core.TypeInfo;
import com.kingbase8.core.Version;
import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.dispatcher.entity.FakeConnection;
import com.kingbase8.dispatcher.executor.DispatchCallableStatementV2;
import com.kingbase8.dispatcher.executor.DispatchPreparedStatementV2;
import com.kingbase8.dispatcher.executor.DispatchStatementV2;
import com.kingbase8.fastpath.Fastpath;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.DynamicOid;
import com.kingbase8.jdbc.FieldMetadata;
import com.kingbase8.jdbc.KSQLSavepoint;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.TimestampUtils;
import com.kingbase8.largeobject.LargeObjectManager;
import com.kingbase8.replication.KBReplicationConnection;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LruCache;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class DispatchConnection
implements BaseConnection {
    private PreparedStatement checkConnectionQuery;
    private final boolean replicationConnection;
    private int transStatus;
    public ConnectionMangerV2 pCMV2;
    public int stable_slave_key;
    private Connection mainConn;
    boolean bmaster_check = false;
    public int retrytimes = 0;
    public int retryinterval = 0;
    SQLException master_error = null;
    private String lastSqlType;
    public String passward;
    public String dbName;
    public Properties m_pros = new Properties();
    public String url;
    private Map<String, Connection> slaveConnMap = new HashMap<String, Connection>();
    public Map<String, Map<String, String>> slaveConnInfo = new HashMap<String, Map<String, String>>();
    public static String SLAVE = "slave";
    public int slaveCount;
    public List<String> whiteList = null;
    public List<String> blackList = null;
    public List<String> masterFunctionList = null;
    public List<String> allSendFunctionList = null;
    public List<String> tempTables = null;
    public String masterKeyword = null;
    protected volatile boolean _autoCommit = true;
    protected volatile boolean hasUpdate = false;
    private int resultSetHoldability = 2;
    private boolean readOnly = false;
    private AutoSave autoSave;
    private int fetchSize;
    private int level = 0;
    protected Map<String, Class<?>> typemap;
    private Properties _clientInfo;
    private boolean flushCacheOnDeallocate = true;
    private int threshold = 5;
    private String schema;
    private Executor exec;
    private int networkTimeout;
    private boolean hasSetNetworkTimeout;
    public AtomicInteger lastSlaveID = new AtomicInteger(0);
    public String countUrl;

    @Override
    public String getUsbkeypin() {
        return ((KbConnection)this.mainConn).getUsbkeypin();
    }

    public String getLastSqlType() {
        return this.lastSqlType;
    }

    public void setLastSqlType(String lastSqlType) {
        this.lastSqlType = lastSqlType;
    }

    public Connection getMainConn() throws SQLException {
        if (this.mainConn != null && !this.mainConn.isClosed()) {
            return this.mainConn;
        }
        String _hostip = Driver._hostSpecs(this.m_pros)[0].getHost();
        int _hostport = Driver._hostSpecs(this.m_pros)[0].getPort();
        String node = this.pCMV2.nodeMap.get(_hostip + ":" + _hostport);
        if (this.m_pros.getProperty("isMonitor") == null && !this.pCMV2.master_online_ip.equals(node) && !this.pCMV2.slave_online_ip.contains(node + ",")) {
            String debugmsg = String.format("Create Fake Master _connection for : {%s} ", node);
            if (KBLOGGER.isLoggable(Level.INFO)) {
                KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
            }
            this.mainConn = new FakeConnection("master_key", _hostip, _hostport);
            ((FakeConnection)this.mainConn).addSqlException(new SQLException("The node is not online."));
            return this.mainConn;
        }
        boolean b_connect = true;
        KbConnection _con = null;
        try {
            _con = new KbConnection(Driver._hostSpecs(this.m_pros), Driver.user(this.m_pros), Driver.database(this.m_pros), this.m_pros, this.url, this.pCMV2._connVersion.get(node), this.pCMV2);
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Master _connection for : {%s} Exception: {%s}", node, e.getMessage());
            if (KBLOGGER.isLoggable(Level.SEVERE)) {
                KBLOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                KBLOGGER.log(Level.SEVERE, e);
            }
            if (!this.bmaster_check) {
                throw new SQLException(e);
            }
            this.master_error = e;
            b_connect = false;
        }
        if (!b_connect) {
            this.mainConn = new FakeConnection("master_key", _hostip, _hostport);
            if (this.master_error != null) {
                ((FakeConnection)this.mainConn).addSqlException(this.master_error);
            }
            return this.mainConn;
        }
        _con.setDispatchConn(this);
        _con.setIsSlave(false);
        this.mainConn = _con;
        return this.mainConn;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setHasUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public DispatchConnection(KbConnection main_Conn, String pass_ward, String db_Name, Properties prop_s, ConnectionMangerV2 cCMV2) throws SQLException {
        this.pCMV2 = cCMV2;
        this.mainConn = main_Conn;
        this.passward = pass_ward;
        this.dbName = db_Name;
        this.m_pros = prop_s;
        this.bmaster_check = KBProperty.MASTER_CHECK.getBoolean(prop_s);
        this.lastSlaveID.set(this.pCMV2.lastSlaveID.getAndIncrement());
        this.retrytimes = KBProperty.RETRYTIMES.getIntNoCheck(prop_s);
        this.retryinterval = KBProperty.RETRYINTERVAL.getIntNoCheck(prop_s);
        this.whiteList = this.initFunctionList(KBProperty.WHITELIST.get(prop_s));
        this.blackList = this.initFunctionList(KBProperty.BLACKLIST.get(prop_s));
        this.masterFunctionList = this.initFunctionList(KBProperty.MASTERFUNCTIONLIST.get(prop_s));
        this.tempTables = this.initFunctionList(KBProperty.TEMPTABLE.get(prop_s));
        this.masterKeyword = KBProperty.MASTER_KEYWORD.get(prop_s);
        this.allSendFunctionList = this.initFunctionList(KBProperty.ALL_SEND_FUNCTION_LIST.get(prop_s));
        this.initSlavesInfo(this.m_pros);
        if (KBProperty.STABLE_SLAVE.getBoolean(this.m_pros) || KBProperty.LOADBALANCE_STRATEGY.getInt(this.m_pros) == 2) {
            this.stable_slave_key = this.slaveCount > 0 ? Math.abs(this.lastSlaveID.getAndIncrement() % this.slaveCount) : -1;
        }
        this.url = this.getUrl();
        this.countUrl = this.getCountUrl();
        this.getMasterConnection();
        this.getAllSlaveConn();
        if (this.bmaster_check) {
            this.CheckClusteInfo(prop_s);
        }
        this.replicationConnection = KBProperty.REPLICATION.get(this.m_pros) != null;
    }

    public List<String> initFunctionList(String function) {
        if (function != null) {
            String[] funs;
            ArrayList<String> functions = new ArrayList<String>();
            for (String fun : funs = function.split(";")) {
                int start = 0;
                int _index = fun.indexOf("\"", start);
                StringBuilder str = new StringBuilder();
                boolean _flag = false;
                while (_index != -1) {
                    if (!_flag) {
                        str.append(fun.substring(start, _index).toLowerCase());
                    } else {
                        str.append(fun.substring(start, _index));
                    }
                    _flag = !_flag;
                    start = _index + 1;
                    _index = fun.indexOf("\"", start);
                }
                str.append(fun.substring(start, fun.length()).toLowerCase());
                functions.add(str.toString());
            }
            return functions;
        }
        return null;
    }

    public void initSlavesInfo(Properties pros) throws KSQLException {
        String[] slavePorts;
        HashMap<String, HashMap<String, String>> nodeToSlaveIPMap = new HashMap<String, HashMap<String, String>>();
        String nodeList = KBProperty.NODE_LIST.get(pros);
        if (nodeList == null || nodeList.isEmpty()) {
            throw new KSQLException("The nodeList cannot be empty.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        String[] nodes = nodeList.split(",");
        String[] _hosts = KBProperty.KB_HOST.get(pros).split(",");
        String[] _hostPorts = KBProperty.KB_PORT.get(pros).split(",");
        String slaveList = KBProperty.SLAVE_ADD.get(pros);
        String slavePortList = KBProperty.SLAVE_PORT.get(pros);
        String[] slaves = slaveList == null || slaveList.isEmpty() ? new String[]{} : slaveList.split(",");
        String[] stringArray = slavePorts = slavePortList == null || slavePortList.isEmpty() ? new String[]{} : slavePortList.split(",");
        if (slaves.length != slavePorts.length) {
            throw new KSQLException("The number of standby machines does not match the number of ports.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        if (slaves.length + _hosts.length != nodes.length) {
            throw new KSQLException("The number of _hosts does not match the number of nodes.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int i = _hosts.length; i < nodes.length; ++i) {
            HashMap<String, String> info = (HashMap<String, String>)nodeToSlaveIPMap.get(nodes[i]);
            if (info == null) {
                info = new HashMap<String, String>();
                info.put("ADDRESS", slaves[i - _hosts.length]);
                info.put("PORT", slavePorts[i - _hosts.length]);
            } else {
                info.put("ADDRESS", (String)info.get("ADDRESS") + "," + slaves[i - _hosts.length]);
                info.put("PORT", (String)info.get("PORT") + "," + slavePorts[i - _hosts.length]);
            }
            nodeToSlaveIPMap.put(nodes[i], info);
        }
        this.slaveConnInfo.clear();
        int _index = 0;
        for (String _key : nodeToSlaveIPMap.keySet()) {
            String slaveName = "slave" + _index;
            this.slaveConnInfo.put(slaveName, (Map<String, String>)nodeToSlaveIPMap.get(_key));
            ++_index;
        }
        this.slaveCount = _index;
    }

    public Connection createSlaveConnection(String _key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(_key);
        String url = "jdbc:kingbase8://" + infoMap.get("ADDRESS") + ":" + infoMap.get("PORT") + "/" + this.dbName;
        KBLOGGER.log(Level.SEVERE, "createSlaveConnection _key " + _key + " " + url, new Object[0]);
        String _host = infoMap.get("ADDRESS").split(",")[0] + ":" + infoMap.get("PORT").split(",")[0];
        String node = this.pCMV2.nodeMap.get(_host);
        if (this.m_pros.getProperty("isMonitor") == null && !this.pCMV2.slave_online_ip.contains(node + ",") && !this.pCMV2.master_online_ip.equals(node)) {
            String debugmsg = String.format("Create Fake Slave _connection for : {_key:%s %s} ", _key, node);
            if (KBLOGGER.isLoggable(Level.INFO)) {
                KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
            }
            FakeConnection tagConn = this.setSlaveToFakebyKey(_key);
            tagConn.addSqlException(new SQLException("The node is not online."));
            return tagConn;
        }
        try {
            KbConnection _conn = null;
            Properties slave_pros = new Properties(this.m_pros);
            slave_pros.setProperty("HOST", infoMap.get("ADDRESS"));
            slave_pros.setProperty("PORT", infoMap.get("PORT"));
            _conn = new KbConnection(Driver._hostSpecs(slave_pros), Driver.user(slave_pros), Driver.database(slave_pros), slave_pros, url, this.pCMV2._connVersion.get(node), this.pCMV2);
            _conn.setDispatchConn(this);
            _conn.setMasterConnection(this.mainConn);
            _conn.setIsSlave(true);
            this.slaveConnMap.put(_key, _conn);
            if (KBLOGGER.isLoggable(Level.INFO)) {
                KBLOGGER.log(Level.INFO, "create SlaveConnection success (session={0} url={1})", this, url);
            }
            return _conn;
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Slave _connection for : {_key:%s %s} Exception: {%s}", _key, node, e.getMessage());
            if (KBLOGGER.isLoggable(Level.SEVERE)) {
                KBLOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                KBLOGGER.log(Level.SEVERE, e);
            }
            FakeConnection tagConn = this.setSlaveToFakebyKey(_key);
            tagConn.addSqlException(e);
            return tagConn;
        }
    }

    public FakeConnection setSlaveToFakebyKey(String _key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(_key);
        String debugmsg = String.format("set Slave _connection to Fake state for : {_key:%s %s} ", _key, infoMap.get("ADDRESS") + ":" + infoMap.get("PORT"));
        if (KBLOGGER.isLoggable(Level.SEVERE)) {
            KBLOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
        }
        FakeConnection tagConn = new FakeConnection(_key, infoMap.get("ADDRESS").split(",")[0], Integer.valueOf(infoMap.get("PORT").split(",")[0]));
        if (this.slaveConnMap.containsKey(_key)) {
            try {
                Connection _conn = this.slaveConnMap.get(_key);
                if (_conn != null && !_conn.isClosed()) {
                    _conn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.slaveConnMap.put(_key, tagConn);
        return tagConn;
    }

    public Connection getSlaveConnection(String _key) throws SQLException {
        KBLOGGER.log(Level.INFO, "getSlaveConnection _key:" + _key, new Object[0]);
        if (_key == null) {
            return this.mainConn;
        }
        Connection _conn = null;
        if (!this.slaveConnMap.containsKey(_key)) {
            _conn = this.createSlaveConnection(_key);
        } else {
            _conn = this.slaveConnMap.get(_key);
            if (_conn == null || _conn.isClosed() && !(_conn instanceof FakeConnection) || _conn instanceof FakeConnection && ((FakeConnection)_conn).getSlaveStatus()) {
                if (KBLOGGER.isLoggable(Level.INFO)) {
                    String debugmsg;
                    if (_conn instanceof FakeConnection) {
                        String node = this.pCMV2.nodeMap.get(((FakeConnection)_conn).getSlaveIP() + ":" + ((FakeConnection)_conn).getSlavePort());
                        debugmsg = String.format("getSlaveConnection recreate fake slave _connection for : {%s}", node);
                    } else {
                        debugmsg = _conn != null ? String.format("getSlaveConnection recreate KbConnection slave _connection for : {%s}", ((KbConnection)_conn).getURL()) : String.format("getSlaveConnection recreate null slave _connection", new Object[0]);
                    }
                    KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                _conn = this.createSlaveConnection(_key);
                this.resetConnInfo(_conn);
            }
        }
        return _conn;
    }

    public List<Connection> getAllSlaveConn() throws SQLException {
        KBLOGGER.log(Level.INFO, "getAllSlaveConn slaveCount:" + this.slaveCount + "\n", new Object[0]);
        ArrayList<Connection> _conns = new ArrayList<Connection>();
        for (int i = 0; i < this.slaveCount; ++i) {
            String _key = SLAVE + i;
            _conns.add(this.getSlaveConnection(_key));
        }
        return _conns;
    }

    protected String getUrl() {
        String url = "jdbc:kingbase8://" + KBProperty.KB_HOST.get(this.m_pros) + ":" + KBProperty.KB_PORT.get(this.m_pros) + "/" + this.dbName + "?_hostLoadRate=" + KBProperty.HOSTLOADRATE.get(this.m_pros);
        return url;
    }

    protected String getCountUrl() {
        String url = null;
        try {
            url = ConnectionMangerV2.getClusterKey(this.m_pros) + " hostLoadRate=" + KBProperty.HOSTLOADRATE.get(this.m_pros);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return url;
    }

    @Override
    public void close() throws SQLException {
        block5: {
            try {
                KBLOGGER.log(Level.INFO, "dispatch main close()", new Object[0]);
                this.mainConn.close();
            }
            catch (SQLException e) {
                if (!KBLOGGER.isLoggable(Level.SEVERE)) break block5;
                KBLOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", e.getMessage());
                KBLOGGER.log(Level.SEVERE, e);
            }
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                KBLOGGER.log(Level.INFO, "dispatch slave close()", new Object[0]);
                Connection _con = it.next();
                _con.close();
            }
            catch (SQLException e) {
                KBLOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", e.getMessage());
                KBLOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void checkslavestatus() throws SQLException {
        for (int i = 0; i < this.slaveCount; ++i) {
            String _key = SLAVE + i;
            Connection _con = this.getSlaveConnection(_key);
            if (_con instanceof FakeConnection) {
                String node = this.pCMV2.nodeMap.get(((FakeConnection)_con).getSlaveIP() + ":" + ((FakeConnection)_con).getSlavePort());
                if (!this.pCMV2.slave_online_ip.contains(node + ",") && !this.pCMV2.master_online_ip.equals(node)) continue;
                if (KBLOGGER.isLoggable(Level.INFO)) {
                    String debugmsg = String.format("checkslavestatus recreate slave _connection for : {%s}", ((FakeConnection)_con).getSlaveIP());
                    KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                ((FakeConnection)_con).setSlaveStatus(true);
                continue;
            }
            try {
                if (_con.isValid(5)) continue;
                _con.close();
                KBLOGGER.log(Level.INFO, "checkslavestatus: find _connect on " + ((KbConnection)_con).getHostIp() + " is invalid  need re_connect\n", new Object[0]);
                FakeConnection tagConn = new FakeConnection(_key, ((KbConnection)_con).getHostIp(), ((KbConnection)_con).getHostPort());
                this.slaveConnMap.put(_key, tagConn);
                tagConn.setSlaveStatus(false);
                continue;
            }
            catch (SQLException e) {
                KBLOGGER.log(Level.INFO, "checkslavestatus Exception: " + e.getMessage() + " find _connect on " + ((KbConnection)_con).getHostIp() + " is invalid  need re_connect\n", new Object[0]);
                FakeConnection tagConn = new FakeConnection(_key, ((KbConnection)_con).getHostIp(), ((KbConnection)_con).getHostPort());
                this.slaveConnMap.put(_key, tagConn);
                tagConn.setSlaveStatus(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkslaveisup(String slaveip) throws SQLException {
        boolean bres;
        block38: {
            ResultSet resultSet;
            Statement stcheck;
            String _sql;
            Connection _conn;
            block37: {
                block36: {
                    bres = false;
                    _conn = this.mainConn;
                    _sql = String.format("select CLIENT_ADDR from pg_stat_replication where CLIENT_ADDR = '%s' ", slaveip);
                    stcheck = null;
                    resultSet = null;
                    if (_conn != null && !(_conn instanceof FakeConnection)) break block36;
                    boolean bl = false;
                    try {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException ei) {
                            KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                            KBLOGGER.log(Level.SEVERE, ei);
                        }
                        if (stcheck != null) {
                            stcheck.close();
                        }
                    }
                    catch (SQLException e) {
                        KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                        KBLOGGER.log(Level.SEVERE, e);
                    }
                    return bl;
                }
                if (!_conn.isClosed()) break block37;
                boolean bl = false;
                try {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException ei) {
                        KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                        KBLOGGER.log(Level.SEVERE, ei);
                    }
                    if (stcheck != null) {
                        stcheck.close();
                    }
                }
                catch (SQLException e) {
                    KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                    KBLOGGER.log(Level.SEVERE, e);
                }
                return bl;
            }
            stcheck = _conn.createStatement();
            resultSet = stcheck.executeQuery(_sql);
            bres = resultSet.next();
            KBLOGGER.log(Level.INFO, "checkslaveisup: " + _sql + " slaveip: " + slaveip + " status: " + bres, new Object[0]);
            try {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException ei) {
                    KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                    KBLOGGER.log(Level.SEVERE, ei);
                }
                if (stcheck != null) {
                    stcheck.close();
                }
                break block38;
            }
            catch (SQLException e) {
                KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                KBLOGGER.log(Level.SEVERE, e);
            }
            break block38;
            catch (SQLException e) {
                try {
                    KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                    KBLOGGER.log(Level.SEVERE, e);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException ei) {
                            KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                            KBLOGGER.log(Level.SEVERE, ei);
                        }
                        if (stcheck != null) {
                            stcheck.close();
                        }
                    }
                    catch (SQLException e2) {
                        KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e2.getMessage());
                        KBLOGGER.log(Level.SEVERE, e2);
                    }
                    throw throwable;
                }
                try {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException ei) {
                        KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                        KBLOGGER.log(Level.SEVERE, ei);
                    }
                    if (stcheck != null) {
                        stcheck.close();
                    }
                }
                catch (SQLException e3) {
                    KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e3.getMessage());
                    KBLOGGER.log(Level.SEVERE, e3);
                }
            }
        }
        return bres;
    }

    public void CloseConnectCluter() throws SQLException {
        try {
            KBLOGGER.log(Level.INFO, "CloseConnectCluter dispatch main close()", new Object[0]);
            this.mainConn.close();
        }
        catch (SQLException e) {
            KBLOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", e.getMessage());
            KBLOGGER.log(Level.SEVERE, e);
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                KBLOGGER.log(Level.INFO, "CloseConnectCluter dispatch slave close()", new Object[0]);
                Connection _con = it.next();
                _con.close();
            }
            catch (SQLException e) {
                KBLOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", e.getMessage());
                KBLOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void ReConnectCluter() throws SQLException {
        this.getMasterConnection();
        this.checkslavestatus();
        this.getAllSlaveConn();
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public void clearWarnings() throws SQLException {
        KBLOGGER.log(Level.INFO, "clearWarnings", new Object[0]);
        ((KbConnection)this.mainConn).clearWarnings();
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.clearWarnings();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void commit() throws SQLException {
        KBLOGGER.log(Level.INFO, " commit", new Object[0]);
        try {
            this.mainConn.commit();
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.commit();
            }
            catch (SQLException sQLException) {}
        }
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        KBLOGGER.log(Level.INFO, " getAutoCommit", new Object[0]);
        return this._autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        KBLOGGER.log(Level.INFO, " getCatalog", new Object[0]);
        return this.mainConn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        KBLOGGER.log(Level.INFO, " getHoldability", new Object[0]);
        return this.mainConn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        KBLOGGER.log(Level.INFO, " getMetaData", new Object[0]);
        return this.mainConn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        KBLOGGER.log(Level.INFO, "  getTransactionIsolation", new Object[0]);
        try {
            return this.mainConn.getTransactionIsolation();
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        KBLOGGER.log(Level.INFO, " getTypeMap", new Object[0]);
        return this.mainConn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        KBLOGGER.log(Level.INFO, " getWarnings", new Object[0]);
        return this.mainConn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        KBLOGGER.log(Level.INFO, " isClosed", new Object[0]);
        return this.mainConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        KBLOGGER.log(Level.INFO, " isReadOnly", new Object[0]);
        return this.mainConn.isReadOnly();
    }

    @Override
    public String nativeSQL(String _sql) throws SQLException {
        KBLOGGER.log(Level.INFO, " nativeSQL", new Object[0]);
        return this.mainConn.nativeSQL(_sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        KBLOGGER.log(Level.INFO, " createStatement", new Object[0]);
        return new DispatchStatementV2(this);
    }

    @Override
    public Statement createStatement(int _resultSetType, int _resultSetConcurrency) throws SQLException {
        KBLOGGER.log(Level.INFO, " createStatement _resultSetType: " + _resultSetType + "; _resultSetConcurrency: " + _resultSetConcurrency, new Object[0]);
        return new DispatchStatementV2(this, _resultSetType, _resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        KBLOGGER.log(Level.INFO, " createStatement _resultSetType: " + _resultSetType + " _resultSetConcurrency: " + _resultSetConcurrency + "; _resultSetHoldability: " + _resultSetHoldability, new Object[0]);
        return new DispatchStatementV2(this, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String _sql) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareCall _sql: " + _sql, new Object[0]);
        return new DispatchCallableStatementV2(this, _sql);
    }

    @Override
    public CallableStatement prepareCall(String _sql, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareCall _sql: " + _sql + "; _resultSetType: " + _resultSetType + "; _resultSetConcurrency: " + _resultSetConcurrency, new Object[0]);
        return new DispatchCallableStatementV2(this, _sql, _resultSetType, _resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String _sql, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareCall _sql: " + _sql + "; _resultSetType: " + _resultSetType + "; _resultSetConcurrency: " + _resultSetConcurrency + "; _resultSetHoldability: " + _resultSetHoldability, new Object[0]);
        return new DispatchCallableStatementV2(this, _sql, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareStatement", new Object[0]);
        return new DispatchPreparedStatementV2(this, _sql);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int autoGeneratedKeys) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareStatement _sql: " + _sql + "; autoGeneratedKeys: " + autoGeneratedKeys, new Object[0]);
        return new DispatchPreparedStatementV2(this, _sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int[] _columnIndexes) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareStatement _sql: " + _sql + "; _columnIndexes: " + _columnIndexes, new Object[0]);
        return new DispatchPreparedStatementV2(this, _sql, _columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, String[] _columnNames) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareStatement _sql: " + _sql + "; _columnNames: " + _columnNames, new Object[0]);
        return new DispatchPreparedStatementV2(this, _sql, _columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareStatement _sql: " + _sql + "; _resultSetType: " + _resultSetType + "; _resultSetConcurrency\uff1a " + _resultSetConcurrency, new Object[0]);
        return new DispatchPreparedStatementV2(this, _sql, _resultSetType, _resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        KBLOGGER.log(Level.INFO, " prepareStatement _sql: " + _sql + "; _resultSetType: " + _resultSetType + "; _resultSetConcurrency\uff1a " + _resultSetConcurrency + "; _resultSetHoldability: " + _resultSetHoldability, new Object[0]);
        return new DispatchPreparedStatementV2(this, _sql, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        KBLOGGER.log(Level.INFO, " releaseSavepoint savepoint: " + savepoint, new Object[0]);
        try {
            this.mainConn.releaseSavepoint(((KSQLSavepoint)savepoint).clone());
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.releaseSavepoint(((KSQLSavepoint)savepoint).clone());
            }
            catch (SQLException sQLException) {}
        }
        ((KSQLSavepoint)savepoint).invalidate();
    }

    @Override
    public void rollback() throws SQLException {
        KBLOGGER.log(Level.INFO, " rollback", new Object[0]);
        try {
            this.mainConn.rollback();
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.rollback();
            }
            catch (SQLException sQLException) {}
        }
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        KBLOGGER.log(Level.INFO, "  rollback {0}", savepoint);
        try {
            this.mainConn.rollback(savepoint);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.rollback(savepoint);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void setAutoCommit(boolean _autoCommit) throws SQLException {
        KBLOGGER.log(Level.INFO, "  setAutoCommit = {0}", _autoCommit);
        try {
            this.mainConn.setAutoCommit(_autoCommit);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.setAutoCommit(_autoCommit);
            }
            catch (SQLException sQLException) {}
        }
        if (this._autoCommit != _autoCommit) {
            this._autoCommit = _autoCommit;
            this.setHasUpdate(false);
            this.setLastSqlType(null);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        KBLOGGER.log(Level.INFO, "  setCatalog = {0}", catalog);
        try {
            this.mainConn.setCatalog(catalog);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        KBLOGGER.log(Level.INFO, "  setHoldability = {0}", holdability);
        this.resultSetHoldability = holdability;
        this.mainConn.setHoldability(holdability);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.setHoldability(holdability);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        KBLOGGER.log(Level.INFO, "  setReadOnly = {0}", readOnly);
        try {
            this.mainConn.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (int i = 0; i < _conns.size(); ++i) {
            if (_conns.get(i) instanceof FakeConnection) continue;
            try {
                _conns.get(i).setReadOnly(readOnly);
                continue;
            }
            catch (SQLException e) {
                try {
                    this.mainConn.setReadOnly(!readOnly);
                }
                catch (SQLException e1) {
                    if (this.mainConn.isClosed()) {
                        this.CloseConnectCluter();
                    }
                    throw e;
                }
                while (--i >= 0) {
                    try {
                        _conns.get(i).setReadOnly(!readOnly);
                    }
                    catch (SQLException sQLException) {}
                }
                throw e;
            }
        }
        this.readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        KBLOGGER.log(Level.INFO, "  setSavepoint", new Object[0]);
        Savepoint sp = null;
        try {
            sp = this.mainConn.setSavepoint();
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.setSavepoint();
            }
            catch (SQLException sQLException) {}
        }
        return sp;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        KBLOGGER.log(Level.INFO, "  setSavepoint(name) = {0}", name);
        Savepoint sp = null;
        try {
            sp = this.mainConn.setSavepoint(name);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.setSavepoint(name);
            }
            catch (SQLException sQLException) {}
        }
        return sp;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        KBLOGGER.log(Level.INFO, "  setTransactionIsolation(level) = {0}", level);
        this.level = level;
        try {
            this.mainConn.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.setTransactionIsolation(level);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        KBLOGGER.log(Level.INFO, "  setTypeMap map: " + map, new Object[0]);
        this.typemap = map;
        try {
            this.mainConn.setTypeMap(map);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                _connection.setTypeMap(map);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void addWarning(SQLWarning warn) {
        ((KbConnection)this.mainConn).addWarning(warn);
    }

    @Override
    public void cancelQuery() throws SQLException {
        KBLOGGER.log(Level.INFO, "  cancelQuery", new Object[0]);
        ((KbConnection)this.mainConn).cancelQuery();
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        KBLOGGER.log(Level.INFO, "  execSQLQuery{0}", s);
        try {
            return ((KbConnection)this.mainConn).execSQLQuery(s);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public ResultSet execSQLQuery(String s, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        KBLOGGER.log(Level.INFO, " execSQLQuery s: " + s + "; _resultSetType: " + _resultSetType + "; _resultSetConcurrency\uff1a " + _resultSetConcurrency, new Object[0]);
        try {
            return ((KbConnection)this.mainConn).execSQLQuery(s, _resultSetType, _resultSetConcurrency);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    public String getCursorName() throws SQLException {
        KBLOGGER.log(Level.INFO, " getCursorName", new Object[0]);
        return ((KbConnection)this.mainConn).getCursorName();
    }

    @Override
    public Encoding getEncoding() {
        KBLOGGER.log(Level.INFO, " getEncoding", new Object[0]);
        return ((KbConnection)this.mainConn).getEncoding();
    }

    public void setCursorName(String cursor) throws SQLException {
        KBLOGGER.log(Level.INFO, " setCursorName cursor: " + cursor, new Object[0]);
        ((KbConnection)this.mainConn).setCursorName(cursor);
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        return ((KbConnection)this.mainConn).getFastpathAPI();
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return ((KbConnection)this.mainConn).getQueryExecutor();
    }

    @Override
    public boolean isValid(int _timeout) throws SQLException {
        KBLOGGER.log(Level.INFO, " isValid _timeout: " + _timeout, new Object[0]);
        if (_timeout < 0) {
            throw new KSQLException(GT.tr("Invalid _timeout ({0}<0).", _timeout), KSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            if (this.replicationConnection) {
                Statement stmt = this.createStatement();
                stmt.execute("IDENTIFY_SYSTEM");
                stmt.close();
            } else {
                if (this.checkConnectionQuery == null) {
                    this.checkConnectionQuery = this.prepareStatement("");
                }
                this.checkConnectionQuery.setQueryTimeout(_timeout);
                this.checkConnectionQuery.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            if (KSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                return true;
            }
            KBLOGGER.log(Level.WARNING, GT.tr("Validating _connection.", new Object[0]), e);
            return false;
        }
    }

    @Override
    public void setMasterConnection(Connection _conn) {
        this.mainConn = (KbConnection)_conn;
        ((KbConnection)this.mainConn).setDispatchConn(this);
        ((KbConnection)this.mainConn).setIsSlave(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean CheckIsMaster(Connection _conn) {
        boolean bres;
        block39: {
            ResultSet resultSet;
            Statement stcheck;
            block38: {
                block37: {
                    block36: {
                        bres = false;
                        stcheck = null;
                        resultSet = null;
                        if (_conn != null && !(_conn instanceof FakeConnection)) break block36;
                        boolean bl = bres;
                        try {
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (SQLException ei) {
                                KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                                KBLOGGER.log(Level.SEVERE, ei);
                            }
                            if (stcheck != null) {
                                stcheck.close();
                            }
                        }
                        catch (SQLException e) {
                            KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                            KBLOGGER.log(Level.SEVERE, e);
                        }
                        return bl;
                    }
                    KBLOGGER.log(Level.INFO, "CheckIsMaster" + ((KbConnection)_conn).getURL() + "\n", new Object[0]);
                    if (!_conn.isClosed()) break block37;
                    boolean bl = bres;
                    try {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException ei) {
                            KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                            KBLOGGER.log(Level.SEVERE, ei);
                        }
                        if (stcheck != null) {
                            stcheck.close();
                        }
                    }
                    catch (SQLException e) {
                        KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                        KBLOGGER.log(Level.SEVERE, e);
                    }
                    return bl;
                }
                stcheck = _conn.createStatement();
                resultSet = stcheck.executeQuery("select * from pg_is_in_recovery()");
                if (!resultSet.next()) break block38;
                bres = !resultSet.getBoolean(1);
            }
            try {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException ei) {
                    KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                    KBLOGGER.log(Level.SEVERE, ei);
                }
                if (stcheck != null) {
                    stcheck.close();
                }
                break block39;
            }
            catch (SQLException e) {
                KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                KBLOGGER.log(Level.SEVERE, e);
            }
            break block39;
            catch (SQLException e) {
                try {
                    KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
                    KBLOGGER.log(Level.SEVERE, e);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException ei) {
                            KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                            KBLOGGER.log(Level.SEVERE, ei);
                        }
                        if (stcheck != null) {
                            stcheck.close();
                        }
                    }
                    catch (SQLException e2) {
                        KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e2.getMessage());
                        KBLOGGER.log(Level.SEVERE, e2);
                    }
                    throw throwable;
                }
                try {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException ei) {
                        KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                        KBLOGGER.log(Level.SEVERE, ei);
                    }
                    if (stcheck != null) {
                        stcheck.close();
                    }
                }
                catch (SQLException e3) {
                    KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e3.getMessage());
                    KBLOGGER.log(Level.SEVERE, e3);
                }
            }
        }
        return bres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties UpdateSlaveinfoFromMaster(Properties pros) throws SQLException {
        Statement stcheck = null;
        ResultSet resultSet = null;
        try {
            stcheck = this.mainConn.createStatement();
            resultSet = stcheck.executeQuery("select CLIENT_ADDR from sys_stat_replication ");
            StringBuffer slave_ip = new StringBuffer("");
            while (resultSet.next()) {
                if (slave_ip.length() == 0) {
                    slave_ip.append(resultSet.getString("CLIENT_ADDR"));
                    continue;
                }
                slave_ip.append(",");
                slave_ip.append(resultSet.getString("CLIENT_ADDR"));
            }
            KBProperty.SLAVE_ADD.set(pros, slave_ip.toString());
        }
        catch (Throwable throwable) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException ei) {
                KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
                KBLOGGER.log(Level.SEVERE, ei);
            }
            if (stcheck != null) {
                stcheck.close();
            }
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException ei) {
            KBLOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", ei.getMessage());
            KBLOGGER.log(Level.SEVERE, ei);
        }
        if (stcheck != null) {
            stcheck.close();
        }
        Properties pros_new = new Properties(pros);
        return pros_new;
    }

    public boolean CheckClusteInfo(Properties prop_s) throws SQLException {
        Connection old_main_conn;
        boolean bMasterChange = false;
        if (KBLOGGER.isLoggable(Level.INFO)) {
            KBLOGGER.log(Level.INFO, "CheckClusteInfo prop_s  _host: " + KBProperty.KB_HOST.get(prop_s) + ":" + KBProperty.KB_PORT.get(prop_s) + " slaveadd: " + KBProperty.SLAVE_ADD.get(prop_s) + ":" + KBProperty.SLAVE_PORT.get(prop_s) + "\n", new Object[0]);
        }
        if ((old_main_conn = this.mainConn) == null) {
            // empty if block
        }
        if (this.CheckIsMaster(this.mainConn)) {
            return bMasterChange;
        }
        bMasterChange = true;
        if (bMasterChange) {
            if (KBLOGGER.isLoggable(Level.INFO)) {
                KBLOGGER.log(Level.INFO, "CheckClusteInfo slaveConnMap size()" + this.slaveConnMap.size() + " " + this.slaveConnMap.toString() + "\n", new Object[0]);
            }
            for (Map.Entry<String, Connection> entry : this.slaveConnMap.entrySet()) {
                String _key = entry.getKey();
                Connection slave_con = entry.getValue();
                if (!this.CheckIsMaster(slave_con)) continue;
                this.setMasterConnection(slave_con);
                if (old_main_conn == null) continue;
                if (!(old_main_conn instanceof FakeConnection)) {
                    ((KbConnection)old_main_conn).setIsSlave(true);
                }
                this.slaveConnMap.put(_key, old_main_conn);
                bMasterChange = true;
                String old_masterip = KBProperty.KB_HOST.get(prop_s);
                String old_masterport = KBProperty.KB_PORT.get(prop_s);
                String old_slaveip = KBProperty.SLAVE_ADD.get(prop_s);
                String old_slaveport = KBProperty.SLAVE_PORT.get(prop_s);
                String new_masterip = ((KbConnection)slave_con).getHostIpst();
                KBProperty.KB_HOST.set(prop_s, new_masterip);
                String new_masterport = ((KbConnection)slave_con).getHostPorts();
                KBProperty.KB_PORT.set(prop_s, new_masterport);
                ArrayList<String> old_slaveips = new ArrayList<String>(Arrays.asList(old_slaveip.split(",")));
                ArrayList<String> old_slaveports = new ArrayList<String>(Arrays.asList(old_slaveport.split(",")));
                ArrayList<String> new_masterips = new ArrayList<String>(Arrays.asList(new_masterip.split(",")));
                ArrayList<String> new_masterports = new ArrayList<String>(Arrays.asList(new_masterport.split(",")));
                block1: for (int i = 0; i < new_masterips.size(); ++i) {
                    for (int j = 0; j < old_slaveips.size(); ++j) {
                        if (!((String)new_masterips.get(i)).equals(old_slaveips.get(j)) || !((String)new_masterports.get(i)).equals(old_slaveports.get(j))) continue;
                        old_slaveips.remove(j);
                        old_slaveports.remove(j);
                        continue block1;
                    }
                }
                String new_slaveip = old_masterip + (old_masterip.endsWith(",") ? "" : ",") + ((Object)old_slaveips).toString().substring(1, ((Object)old_slaveips).toString().length() - 1).replace(" ", "");
                String new_slaveport = old_masterport + (old_masterport.endsWith(",") ? "" : ",") + ((Object)old_slaveports).toString().substring(1, ((Object)old_slaveports).toString().length() - 1).replace(" ", "");
                KBProperty.SLAVE_ADD.set(prop_s, new_slaveip);
                KBProperty.SLAVE_PORT.set(prop_s, new_slaveport);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("ADDRESS", old_masterip);
                info.put("PORT", old_masterport);
                this.slaveConnInfo.put(_key, info);
                this.m_pros = prop_s;
                if (!KBLOGGER.isLoggable(Level.INFO)) break;
                String debugmsg = String.format("CheckClusteInfo::Cluster Change Master DB from " + old_masterip + ":" + old_masterport + " to " + new_masterip + ":" + new_masterport, new Object[0]);
                KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                break;
            }
        }
        if (!this.CheckIsMaster(this.mainConn)) {
            StringBuilder msg = new StringBuilder();
            msg.append("JDBC can't find a vaild master database in cluster " + this.pCMV2.clusterKey + "\n");
            if (this.mainConn instanceof FakeConnection) {
                FakeConnection fakeConnection = (FakeConnection)this.mainConn;
                SQLException sqlException = fakeConnection.getSqlException();
                if (sqlException != null) {
                    msg.append(fakeConnection.getSlaveIP() + ":" + fakeConnection.getSlavePort() + " connect failed! Info:" + sqlException.getMessage() + "\n");
                }
            } else {
                KbConnection kbConnection = (KbConnection)this.mainConn;
                msg.append(kbConnection.getHostIp() + ":" + kbConnection.getHostPort() + " connect success!\n");
            }
            List<Connection> allSlaveConn = this.getAllSlaveConn();
            for (Connection slaveConn : allSlaveConn) {
                if (slaveConn instanceof FakeConnection) {
                    FakeConnection fakeConnection = (FakeConnection)slaveConn;
                    SQLException sqlException = fakeConnection.getSqlException();
                    if (sqlException == null) continue;
                    msg.append(fakeConnection.getSlaveIP() + ":" + fakeConnection.getSlavePort() + " connect failed! Info:" + sqlException.getMessage() + "\n");
                    continue;
                }
                KbConnection kbConnection = (KbConnection)slaveConn;
                msg.append(kbConnection.getHostIp() + ":" + kbConnection.getHostPort() + " connect success!\n");
            }
            this.close();
            KSQLException sqlException2 = new KSQLException(msg.toString(), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
            throw sqlException2;
        }
        return bMasterChange;
    }

    @Override
    public Connection getMasterConnection() throws SQLException {
        return this.getMainConn();
    }

    public Properties getConnectionProperties() {
        return this.m_pros;
    }

    public void setConnectionProperties(Properties pros) {
        this.m_pros = pros;
    }

    public void setTransStatus(int transStatus) {
        this.transStatus = transStatus;
    }

    public int getTransStatus() {
        return this.transStatus;
    }

    public boolean isCompatibleOldDateFormat() {
        return false;
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
    }

    @Override
    public boolean isZeroResend() {
        return false;
    }

    public boolean isUseSlaveSynRead() {
        return false;
    }

    public boolean checkDBLinkSql() {
        return false;
    }

    @Override
    public KBNotification[] getNotifications() throws SQLException {
        KBLOGGER.log(Level.INFO, " getNotifications", new Object[0]);
        try {
            return ((KbConnection)this.mainConn).getNotifications();
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        return ((KbConnection)this.mainConn).getCopyAPI();
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        KBLOGGER.log(Level.INFO, " getLargeObjectAPI", new Object[0]);
        try {
            return ((KbConnection)this.mainConn).getLargeObjectAPI();
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public void addDataType(String type, String className) {
        ((KbConnection)this.mainConn).addDataType(type, className);
    }

    @Override
    public void addDataType(String type, Class<? extends KBobject> klass) throws SQLException {
        ((KbConnection)this.mainConn).addDataType(type, klass);
    }

    @Override
    public void setPrepareThreshold(int threshold) {
        KBLOGGER.log(Level.INFO, " setPrepareThreshold threshold: " + threshold, new Object[0]);
        this.threshold = threshold;
        ((KbConnection)this.mainConn).setPrepareThreshold(threshold);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((KbConnection)_connection).setPrepareThreshold(threshold);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getPrepareThreshold() {
        return ((KbConnection)this.mainConn).getPrepareThreshold();
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        KBLOGGER.log(Level.INFO, " setDefaultFetchSize fetchSize: " + fetchSize, new Object[0]);
        this.fetchSize = fetchSize;
        ((KbConnection)this.mainConn).setDefaultFetchSize(fetchSize);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                ((KbConnection)_connection).setDefaultFetchSize(fetchSize);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public int getDefaultFetchSize() {
        return ((KbConnection)this.mainConn).getDefaultFetchSize();
    }

    @Override
    public int getBackendPID() {
        return ((KbConnection)this.mainConn).getBackendPID();
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return ((KbConnection)this.mainConn).escapeIdentifier(identifier);
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return ((KbConnection)this.mainConn).escapeIdentifier(literal);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return ((KbConnection)this.mainConn).getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return ((KbConnection)this.mainConn).getAutosave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        this.autoSave = autoSave;
        ((KbConnection)this.mainConn).setAutosave(autoSave);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((KbConnection)_connection).setAutosave(autoSave);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public KBReplicationConnection getReplicationAPI() {
        return ((KbConnection)this.mainConn).getReplicationAPI();
    }

    @Override
    public Clob createClob() throws SQLException {
        KBLOGGER.log(Level.INFO, " createClob", new Object[0]);
        return this.mainConn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        KBLOGGER.log(Level.INFO, " createBlob", new Object[0]);
        return this.mainConn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        KBLOGGER.log(Level.INFO, " createNClob", new Object[0]);
        return this.mainConn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        KBLOGGER.log(Level.INFO, " createSQLXML", new Object[0]);
        return this.mainConn.createSQLXML();
    }

    @Override
    public void setClientInfo(String name, String _value) throws SQLClientInfoException {
        KBLOGGER.log(Level.INFO, " setClientInfo name: " + name + "; _value: " + _value, new Object[0]);
        try {
            this.mainConn.setClientInfo(name, _value);
        }
        catch (SQLClientInfoException e) {
            try {
                if (this.mainConn.isClosed()) {
                    this.CloseConnectCluter();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((KbConnection)_connection).setClientInfo(name, _value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setClientInfo(Properties propes) throws SQLClientInfoException {
        KBLOGGER.log(Level.INFO, " setClientInfo propes", new Object[0]);
        this._clientInfo = propes;
        try {
            this.mainConn.setClientInfo(propes);
        }
        catch (SQLClientInfoException e) {
            try {
                if (this.mainConn.isClosed()) {
                    this.CloseConnectCluter();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((KbConnection)_connection).setClientInfo(propes);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        KBLOGGER.log(Level.INFO, " getClientInfo name: " + name, new Object[0]);
        return this.mainConn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        KBLOGGER.log(Level.INFO, " getClientInfo", new Object[0]);
        return this.mainConn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        KBLOGGER.log(Level.INFO, " createArrayOf typeName: " + typeName + "; elements: " + elements, new Object[0]);
        try {
            return this.mainConn.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        KBLOGGER.log(Level.INFO, " createStruct typeName: " + typeName + "; attributes: " + attributes, new Object[0]);
        return this.mainConn.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        KBLOGGER.log(Level.INFO, " setSchema schema: " + schema, new Object[0]);
        try {
            ((KbConnection)this.mainConn).setSchema(schema);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            try {
                ((KbConnection)_connection).setSchema(schema);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return ((KbConnection)this.mainConn).getSchema();
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public void abort(Executor exec) throws SQLException {
        KBLOGGER.log(Level.INFO, " abort", new Object[0]);
        ((KbConnection)this.mainConn).abort(exec);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            ((KbConnection)_connection).abort(exec);
        }
    }

    @Override
    public void setNetworkTimeout(Executor exec, int millisecs) throws SQLException {
        KBLOGGER.log(Level.INFO, " setNetworkTimeout millisecs: " + millisecs, new Object[0]);
        ((KbConnection)this.mainConn).setNetworkTimeout(exec, millisecs);
        List<Connection> _conns = this.getAllSlaveConn();
        for (int i = 0; i < _conns.size(); ++i) {
            if (_conns.get(i) instanceof FakeConnection) continue;
            try {
                ((KbConnection)_conns.get(i)).setNetworkTimeout(exec, millisecs);
                continue;
            }
            catch (SQLException e) {
                ((KbConnection)this.mainConn).setNetworkTimeout(exec, this.getNetworkTimeout());
                while (--i >= 0) {
                    ((KbConnection)_conns.get(i)).setNetworkTimeout(exec, this.getNetworkTimeout());
                }
                throw e;
            }
        }
        this.exec = exec;
        this.networkTimeout = millisecs;
        this.hasSetNetworkTimeout = true;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.hasSetNetworkTimeout) {
            return this.networkTimeout;
        }
        return KBProperty.SOCKET_TIMEOUT.getInt(this.m_pros) * 1000;
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        if (clz.isAssignableFrom(this.getClass())) {
            return clz.cast(this);
        }
        if (clz.isAssignableFrom(KbConnection.class)) {
            return this.mainConn.unwrap(clz);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        return this.mainConn.isWrapperFor(clz);
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        try {
            ((KbConnection)this.mainConn).execSQLQuery(s);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return ((KbConnection)this.mainConn).getReplicationProtocol();
    }

    @Override
    public Object getObject(String type, String _value, byte[] byteValue) throws SQLException {
        return ((KbConnection)this.mainConn).getObject(type, _value, byteValue);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return ((KbConnection)this.mainConn).getTypeInfo();
    }

    @Override
    public boolean haveMinimumServerVersion(int version) {
        return ((KbConnection)this.mainConn).haveMinimumServerVersion(version);
    }

    @Override
    public boolean haveMinimumServerVersion(Version version) {
        return ((KbConnection)this.mainConn).haveMinimumServerVersion(version);
    }

    @Override
    public byte[] _encodeString(String str) throws SQLException {
        return ((KbConnection)this.mainConn)._encodeString(str);
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return ((KbConnection)this.mainConn).escapeString(str);
    }

    @Override
    public boolean getStandardConformingStrings() {
        return ((KbConnection)this.mainConn).getStandardConformingStrings();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return ((KbConnection)this.mainConn).getTimestampUtils();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return ((KbConnection)this.mainConn).getStringVarcharFlag();
    }

    @Override
    public TransactionState getTransactionState() {
        return ((KbConnection)this.mainConn).getTransactionState();
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return ((KbConnection)this.mainConn).binaryTransferSend(oid);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return ((KbConnection)this.mainConn).isColumnSanitiserDisabled();
    }

    @Override
    public void addTimerTask(TimerTask _timerTask, long milliSeconds) {
        ((KbConnection)this.mainConn).addTimerTask(_timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTas_keyStore() {
        ((KbConnection)this.mainConn).purgeTimerTas_keyStore();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return ((KbConnection)this.mainConn).getFieldMetadataCache();
    }

    @Override
    public CachedQuery createQuery(String _sql, boolean escapeProcessing, boolean isParameterized, String ... _columnNames) throws SQLException {
        return ((KbConnection)this.mainConn).createQuery(_sql, escapeProcessing, isParameterized, _columnNames);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.flushCacheOnDeallocate = flushCacheOnDeallocate;
        ((KbConnection)this.mainConn).setFlushCacheOnDeallocate(flushCacheOnDeallocate);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((KbConnection)_connection).setFlushCacheOnDeallocate(flushCacheOnDeallocate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object elements) throws SQLException {
        KBLOGGER.log(Level.INFO, " createArrayOf typeName: " + typeName + "; elements: " + elements, new Object[0]);
        try {
            return ((KbConnection)this.mainConn).createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public KBNotification[] getNotifications(int _timeoutMillis) throws SQLException {
        KBLOGGER.log(Level.INFO, " getNotifications _timeoutMillis: " + _timeoutMillis, new Object[0]);
        try {
            return ((KbConnection)this.mainConn).getNotifications(_timeoutMillis);
        }
        catch (SQLException e) {
            if (this.mainConn.isClosed()) {
                this.CloseConnectCluter();
            }
            throw e;
        }
    }

    @Override
    public Map<String, String> getParameterStatuses() {
        return ((KbConnection)this.mainConn).getParameterStatuses();
    }

    @Override
    public String getParameterStatus(String parameterName) {
        return ((KbConnection)this.mainConn).getParameterStatus(parameterName);
    }

    @Override
    public boolean hintReadOnly() {
        return ((KbConnection)this.mainConn).hintReadOnly();
    }

    public void resetConnInfo() throws SQLException {
        if (!this._autoCommit) {
            this.setAutoCommit(this._autoCommit);
        }
        if (this._clientInfo != null) {
            this.setClientInfo(this._clientInfo);
        }
        if (this.readOnly) {
            this.setReadOnly(this.readOnly);
        }
        if (this.resultSetHoldability != 2) {
            this.setHoldability(this.resultSetHoldability);
        }
        if (this.level != 0) {
            this.setTransactionIsolation(this.level);
        }
        if (this.typemap != null) {
            this.setTypeMap(this.typemap);
        }
        if (this.networkTimeout != 0) {
            this.setNetworkTimeout(this.exec, this.networkTimeout);
        }
        if (this.autoSave != null) {
            this.setAutosave(this.autoSave);
        }
        if (this.fetchSize != 0) {
            this.setDefaultFetchSize(this.fetchSize);
        }
        if (!this.flushCacheOnDeallocate) {
            this.setFlushCacheOnDeallocate(this.flushCacheOnDeallocate);
        }
        if (this.threshold != 5) {
            this.setPrepareThreshold(this.threshold);
        }
        if (this.schema != null) {
            this.setSchema(this.schema);
        }
    }

    public void resetConnInfo(Connection _connection) throws SQLException {
        if (!(_connection instanceof KbConnection)) {
            return;
        }
        KbConnection _conn = (KbConnection)_connection;
        if (!this._autoCommit) {
            _conn.setAutoCommit(this._autoCommit);
        }
        if (this._clientInfo != null) {
            _conn.setClientInfo(this._clientInfo);
        }
        if (this.readOnly) {
            _conn.setReadOnly(this.readOnly);
        }
        if (this.resultSetHoldability != 2) {
            _conn.setHoldability(this.resultSetHoldability);
        }
        if (this.level != 0) {
            _conn.setTransactionIsolation(this.level);
        }
        if (this.typemap != null) {
            _conn.setTypeMap(this.typemap);
        }
        if (this.networkTimeout != 0) {
            _conn.setNetworkTimeout(this.exec, this.networkTimeout);
        }
        if (this.autoSave != null) {
            _conn.setAutosave(this.autoSave);
        }
        if (this.fetchSize != 0) {
            _conn.setDefaultFetchSize(this.fetchSize);
        }
        if (!this.flushCacheOnDeallocate) {
            _conn.setFlushCacheOnDeallocate(this.flushCacheOnDeallocate);
        }
        if (this.threshold != 5) {
            _conn.setPrepareThreshold(this.threshold);
        }
        if (this.schema != null) {
            _conn.setSchema(this.schema);
        }
    }

    @Override
    public String getCompatibleLevel() {
        return ((KbConnection)this.mainConn).getCompatibleLevel();
    }

    @Override
    public boolean getUnpairedComment() {
        return ((KbConnection)this.mainConn).getUnpairedComment();
    }

    @Override
    public boolean getContainsANSIQuotes() {
        return ((KbConnection)this.mainConn).getContainsANSIQuotes();
    }

    @Override
    public boolean isDatabaseSupportRowid() {
        return ((KbConnection)this.mainConn).isDatabaseSupportRowid();
    }

    @Override
    public DynamicOid getDynamicOid() {
        return ((KbConnection)this.mainConn).getDynamicOid();
    }

    @Override
    public boolean isUsePgValueType() {
        return ((KbConnection)this.mainConn).isUsePgValueType();
    }
}

