/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.jdbc.AbstractTypeInfoCache;
import com.kingbase8.jdbc.TypeInfoCache;
import com.kingbase8.util.TraceLogger;
import java.util.HashMap;
import java.util.logging.Level;

public class SQLServerTypeInfoCache
extends AbstractTypeInfoCache {
    private static final Object[][] typesT = new Object[][]{{"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"oid", 26, -5, "java.lang.Long", 1028}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 7915, -7, "java.lang.Boolean", 7916}, {"date", 7754, 91, "java.sql.Date", 7764}, {"time", 7755, 92, "java.sql.Time", 7765}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}, {"json", 114, 1111, "com.kingbase8.util.KBobject", 199}, {"point", 600, 1111, "com.kingbase8.geometric.KBpoint", 1017}, {"tinyint", 5026, -6, "java.lang.Short", 5027}, {"smallint", 5061, 5, "java.lang.Short", 5062}, {"int", 5063, 4, "java.lang.Integer", 5064}, {"bigint", 5065, -5, "java.lang.Long", 5066}, {"decimal", 5067, 3, "java.math.BigDecimal", 5068}, {"numeric", 5067, 2, "java.math.BigDecimal", 5068}, {"float", 6071, 8, "java.lang.Double", 6072}, {"real", 6069, 7, "java.lang.Float", 6070}, {"datetime", 7881, 93, "java.sql.Timestamp", 7891}, {"datetime2", 7690, 93, "java.sql.Timestamp", 7680}, {"smalldatetime", 5045, 93, "java.sql.Timestamp", 5046}, {"nchar", 5039, -15, "java.lang.String", 5040}, {"nvarchar", 5041, -9, "java.lang.String", 5042}, {"binary", 5022, -2, "[B", 5023}, {"varbinary", 5024, -3, "[B", 5025}, {"char", 8016, 1, "java.lang.String", 8017}, {"varchar", 8018, 12, "java.lang.String", 8019}, {"money", 5069, 3, "java.math.BigDecimal", 5070}, {"timestamp", 5043, -2, "[B", -1}, {"xml", 7654, -16, "java.lang.String", 12082}};
    private static final HashMap<String, String> typeAliasesMap;

    public SQLServerTypeInfoCache(TypeInfoCache typeInfoCache, BaseConnection baseConnection) {
        super(typeInfoCache, baseConnection);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public Object[][] getTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return typesT;
    }

    @Override
    public HashMap<String, String> getTypeAliases() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return typeAliasesMap;
    }

    @Override
    public int getPrecision(int oidT, int typemod, BaseConnection baseConnection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        if (oidT == baseConnection.getDynamicOid().ORACLE_RAW) {
            return 0;
        }
        switch (oidT) {
            case 5026: 
            case 7014: 
            case 8100: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 3;
            }
            case 21: 
            case 5061: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 5;
            }
            case 23: 
            case 26: 
            case 5063: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 10;
            }
            case 701: 
            case 6071: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 15;
            }
            case 20: 
            case 5065: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 19;
            }
            case 700: 
            case 6069: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 7;
            }
            case 16: 
            case 18: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 1;
            }
            case 1700: 
            case 5067: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemod == -1) {
                    return 0;
                }
                return (typemod - 4 & 0xFFFF0000) >> 16;
            }
            case 1042: 
            case 1043: 
            case 5022: 
            case 5024: 
            case 5039: 
            case 5041: 
            case 8016: 
            case 8018: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                if (typemod > 8004) {
                    return Integer.MAX_VALUE;
                }
                return typemod - 4;
            }
            case 6073: {
                return Integer.MAX_VALUE;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 5045: 
            case 7690: 
            case 7754: 
            case 7755: 
            case 7881: 
            case 8020: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getDisplaySize(oidT, typemod, baseConnection);
            }
            case 7915: {
                return 1;
            }
            case 1560: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return typemod;
            }
            case 1562: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemod;
            }
            case 27: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 18;
            }
            case 7000: 
            case 7002: {
                return typemod >> 8 & 0xFF;
            }
            case 6123: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 23;
            }
            case 25: 
            case 6077: {
                return 65535;
            }
            case 790: 
            case 5069: {
                return 19;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getDisplaySize(int oidT, int typemodT, BaseConnection baseConnection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int value = 0;
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        if (oidT == baseConnection.getDynamicOid().ORACLE_RAW) {
            if (typemodT == -1) {
                return this.typeInfoCache.unknownLength;
            }
            return typemodT - 4;
        }
        switch (oidT) {
            case 7015: 
            case 7016: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 8;
            }
            case 5026: {
                return 3;
            }
            case 7014: 
            case 8100: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 4;
            }
            case 21: 
            case 5061: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 6;
                return value;
            }
            case 23: 
            case 5063: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 11;
                return value;
            }
            case 26: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 10;
                return value;
            }
            case 20: 
            case 5065: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 20;
                return value;
            }
            case 18: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 1;
            }
            case 700: 
            case 6069: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 13;
            }
            case 701: 
            case 6071: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 22;
            }
            case 16: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 1;
                return value;
            }
            case 7754: {
                return "yyyy-mm-dd".length();
            }
            case 1082: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 13;
                return value;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 8020: {
                int secondSizeT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                switch (typemodT) {
                    case -1: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = 7;
                        break;
                    }
                    case 0: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = 0;
                        break;
                    }
                    case 1: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = 3;
                        break;
                    }
                    default: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = typemodT + 1;
                    }
                }
                switch (oidT) {
                    case 1083: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 8 + secondSizeT;
                    }
                    case 1266: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 8 + secondSizeT + 6;
                    }
                    case 1184: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 22 + secondSizeT + 6;
                    }
                    case 1114: 
                    case 8020: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 22 + secondSizeT;
                    }
                }
                return 22 + secondSizeT;
            }
            case 5045: 
            case 7690: 
            case 7755: 
            case 7881: {
                int secondsizeST;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                switch (typemodT) {
                    case -1: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondsizeST = 8;
                        break;
                    }
                    case 0: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondsizeST = 0;
                        break;
                    }
                    default: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondsizeST = typemodT + 1;
                    }
                }
                switch (oidT) {
                    case 7881: {
                        return 23;
                    }
                    case 5045: {
                        return 16;
                    }
                    case 7755: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 8 + secondsizeST;
                    }
                    case 7690: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 19 + secondsizeST;
                    }
                }
                return 22 + secondsizeST;
            }
            case 1186: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 49;
            }
            case 5022: 
            case 5024: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                if (typemodT == Integer.MAX_VALUE) {
                    return typemodT;
                }
                return (typemodT - 4) * 2;
            }
            case 6073: {
                return Integer.MAX_VALUE;
            }
            case 1042: 
            case 1043: 
            case 5039: 
            case 5041: 
            case 8016: 
            case 8018: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                if (typemodT > 8004) {
                    return Integer.MAX_VALUE;
                }
                return typemodT - 4;
            }
            case 1700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 131089;
                }
                int precision = typemodT - 4 >> 16 & 0xFFFF;
                int scale = typemodT - 4 & 0xFFFF;
                if (scale == 0) {
                    return 20;
                }
                return 1 + precision + 1;
            }
            case 5067: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 131089;
                }
                int precisionSqlServer = typemodT - 4 >> 16 & 0xFFFF;
                return 1 + precisionSqlServer + 1;
            }
            case 7915: {
                return 1;
            }
            case 1560: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return typemodT;
            }
            case 1562: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemodT;
            }
            case 25: 
            case 6077: {
                return 65535;
            }
            case 17: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.typeInfoCache.unknownLength;
            }
            case 27: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 18;
            }
            case 6123: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 23;
            }
            case 7002: {
                return 5;
            }
            case 7000: {
                return 11;
            }
            case 790: 
            case 5069: {
                return 21;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getScale(int oidT, int typemodT, BaseConnection baseConnection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        switch (oidT) {
            case 700: 
            case 6069: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 0;
            }
            case 701: 
            case 6071: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 0;
            }
            case 1700: 
            case 5067: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 0;
                }
                return typemodT - 4 & 0xFFFF;
            }
            case 7881: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 3;
            }
            case 5045: {
                return 0;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 6;
                }
                return typemodT;
            }
            case 7690: 
            case 7755: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 7;
                }
                return typemodT;
            }
            case 1186: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 6;
                }
                return typemodT & 0xFFFF;
            }
            case 7000: 
            case 7002: {
                return typemodT & 0xFF;
            }
            case 790: 
            case 5069: {
                return 4;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getColumnSize(int oidT, int typemodT, BaseConnection baseConnection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getPrecision(oidT, typemodT, baseConnection);
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        typeAliasesMap = new HashMap();
        typeAliasesMap.put("smallint", "int2");
        typeAliasesMap.put("integer", "int4");
        typeAliasesMap.put("int", "int4");
        typeAliasesMap.put("bigint", "int8");
        typeAliasesMap.put("float", "float8");
        typeAliasesMap.put("boolean", "bool");
        typeAliasesMap.put("decimal", "numeric");
    }
}

