/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq;

import com.alibaba.cloud.stream.binder.rocketmq.custom.RocketMQBeanContainerCache;
import com.alibaba.cloud.stream.binder.rocketmq.extend.ErrorAcknowledgeHandler;
import com.alibaba.cloud.stream.binder.rocketmq.integration.inbound.RocketMQInboundChannelAdapter;
import com.alibaba.cloud.stream.binder.rocketmq.integration.inbound.pull.DefaultErrorAcknowledgeHandler;
import com.alibaba.cloud.stream.binder.rocketmq.integration.inbound.pull.RocketMQMessageSource;
import com.alibaba.cloud.stream.binder.rocketmq.integration.outbound.RocketMQProducerMessageHandler;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQExtendedBindingProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQProducerProperties;
import com.alibaba.cloud.stream.binder.rocketmq.provisioning.RocketMQTopicProvisioner;
import com.alibaba.cloud.stream.binder.rocketmq.utils.RocketMQUtils;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.util.StringUtils;

public class RocketMQMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<RocketMQConsumerProperties>, ExtendedProducerProperties<RocketMQProducerProperties>, RocketMQTopicProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, RocketMQConsumerProperties, RocketMQProducerProperties> {
    private final RocketMQExtendedBindingProperties extendedBindingProperties;
    private final RocketMQBinderConfigurationProperties binderConfigurationProperties;

    public RocketMQMessageChannelBinder(RocketMQBinderConfigurationProperties binderConfigurationProperties, RocketMQExtendedBindingProperties extendedBindingProperties, RocketMQTopicProvisioner provisioningProvider) {
        super(new String[0], (ProvisioningProvider)provisioningProvider);
        this.extendedBindingProperties = extendedBindingProperties;
        this.binderConfigurationProperties = binderConfigurationProperties;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<RocketMQProducerProperties> extendedProducerProperties, MessageChannel channel, MessageChannel errorChannel) throws Exception {
        if (!((RocketMQProducerProperties)extendedProducerProperties.getExtension()).getEnabled()) {
            throw new RuntimeException("Binding for channel " + destination.getName() + " has been disabled, message can't be delivered");
        }
        RocketMQProducerProperties mqProducerProperties = RocketMQUtils.mergeRocketMQProperties(this.binderConfigurationProperties, (RocketMQProducerProperties)extendedProducerProperties.getExtension());
        RocketMQProducerMessageHandler messageHandler = new RocketMQProducerMessageHandler(destination, extendedProducerProperties, mqProducerProperties);
        messageHandler.setApplicationContext((ApplicationContext)this.getApplicationContext());
        if (errorChannel != null) {
            messageHandler.setSendFailureChannel(errorChannel);
        }
        MessageConverterConfigurer.PartitioningInterceptor partitioningInterceptor = ((AbstractMessageChannel)channel).getInterceptors().stream().filter(channelInterceptor -> channelInterceptor instanceof MessageConverterConfigurer.PartitioningInterceptor).map(channelInterceptor -> (MessageConverterConfigurer.PartitioningInterceptor)channelInterceptor).findFirst().orElse(null);
        messageHandler.setPartitioningInterceptor(partitioningInterceptor);
        messageHandler.setBeanFactory((BeanFactory)this.getApplicationContext().getBeanFactory());
        messageHandler.setErrorMessageStrategy(this.getErrorMessageStrategy());
        return messageHandler;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<RocketMQProducerProperties> producerProperties, MessageChannel errorChannel) throws Exception {
        throw new UnsupportedOperationException("The abstract binder should not call this method");
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<RocketMQConsumerProperties> extendedConsumerProperties) throws Exception {
        boolean anonymous;
        boolean bl = anonymous = !StringUtils.hasLength((String)group);
        if (anonymous && NamespaceUtil.isDLQTopic((String)destination.getName())) {
            throw new RuntimeException("group must be configured for DLQ" + destination.getName());
        }
        group = anonymous ? RocketMQUtils.anonymousGroup(destination.getName()) : group;
        RocketMQUtils.mergeRocketMQProperties(this.binderConfigurationProperties, (RocketMQConsumerProperties)extendedConsumerProperties.getExtension());
        ((RocketMQConsumerProperties)extendedConsumerProperties.getExtension()).setGroup(group);
        RocketMQInboundChannelAdapter inboundChannelAdapter = new RocketMQInboundChannelAdapter(destination.getName(), extendedConsumerProperties);
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)extendedConsumerProperties);
        if (extendedConsumerProperties.getMaxAttempts() > 1) {
            inboundChannelAdapter.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)extendedConsumerProperties));
            inboundChannelAdapter.setRecoveryCallback((RecoveryCallback<Object>)errorInfrastructure.getRecoverer());
        } else {
            inboundChannelAdapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        }
        return inboundChannelAdapter;
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<RocketMQConsumerProperties> extendedConsumerProperties) {
        RocketMQUtils.mergeRocketMQProperties(this.binderConfigurationProperties, (RocketMQConsumerProperties)extendedConsumerProperties.getExtension());
        ((RocketMQConsumerProperties)extendedConsumerProperties.getExtension()).setGroup(group);
        RocketMQMessageSource messageSource = new RocketMQMessageSource(name, extendedConsumerProperties);
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)messageSource, this.registerErrorInfrastructure(destination, group, (ConsumerProperties)extendedConsumerProperties, true));
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, ExtendedConsumerProperties<RocketMQConsumerProperties> properties) {
        return message -> {
            MessagingException payload;
            AcknowledgmentCallback ack;
            Object patt8589$temp = message.getPayload();
            if (patt8589$temp instanceof MessagingException && (ack = StaticMessageHeaderAccessor.getAcknowledgmentCallback((Message)(payload = (MessagingException)patt8589$temp).getFailedMessage())) != null) {
                ErrorAcknowledgeHandler handler = RocketMQBeanContainerCache.getBean(((RocketMQConsumerProperties)properties.getExtension()).getPull().getErrAcknowledge(), ErrorAcknowledgeHandler.class, new DefaultErrorAcknowledgeHandler());
                ack.acknowledge(handler.handler(payload.getFailedMessage()));
            }
        };
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return new DefaultErrorMessageStrategy();
    }

    public RocketMQConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (RocketMQConsumerProperties)this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public RocketMQProducerProperties getExtendedProducerProperties(String channelName) {
        return (RocketMQProducerProperties)this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.extendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.extendedBindingProperties.getExtendedPropertiesEntryClass();
    }
}

