/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;

public abstract class AbstractLambdaWrapper<T, Children extends AbstractLambdaWrapper<T, Children>>
extends AbstractWrapper<T, SFunction<T, ?>, Children> {
    private Map<String, ColumnCache> columnMap = null;
    private boolean initColumnMap = false;

    @Override
    protected void initEntityClass() {
        super.initEntityClass();
        if (this.entityClass != null) {
            this.columnMap = LambdaUtils.getColumnMap(this.entityClass);
            this.initColumnMap = true;
        }
    }

    protected String columnsToString(SFunction<T, ?> ... columns) {
        return this.columnsToString(true, columns);
    }

    protected String columnsToString(boolean onlyColumn, SFunction<T, ?> ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString((SFunction<T, ?>)i, onlyColumn)).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(SFunction<T, ?> column) {
        return this.columnToString(column, true);
    }

    protected String columnToString(SFunction<T, ?> column, boolean onlyColumn) {
        return this.getColumn(LambdaUtils.resolve(column), onlyColumn);
    }

    private String getColumn(SerializedLambda lambda, boolean onlyColumn) throws MybatisPlusException {
        String fieldName = PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
        Class aClass = lambda.getInstantiatedType();
        if (!this.initColumnMap) {
            this.columnMap = LambdaUtils.getColumnMap(aClass);
        }
        Assert.notNull(this.columnMap, "can not find lambda cache for this entity [%s]", aClass.getName());
        ColumnCache columnCache = this.columnMap.get(LambdaUtils.formatKey(fieldName));
        Assert.notNull(columnCache, "can not find lambda cache for this property [%s] of entity [%s]", fieldName, aClass.getName());
        return onlyColumn ? columnCache.getColumn() : columnCache.getColumnSelect();
    }
}

