/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.ai.enmu.DifyCategoryEnum;
import com.bringspring.ai.service.DifyDatasetService;
import com.bringspring.ai.vo.DifyDataSetConfigVO;
import com.bringspring.ai.vo.DifyDataSetSynchronousVO;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.service.SysConfigService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ai/difyconfig/dataset"})
public class DifyDataSetConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyDataSetConfigController.class);
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private DifyDatasetService difyDatasetService;

    @NotCheckLogin
    @GetMapping
    public ActionResult list() {
        List list = this.sysConfigService.list((Wrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode()));
        List result = new ArrayList();
        for (SysConfigEntity sys : list) {
            result = JsonUtil.getJsonToList((String)sys.getKeyValue(), DifyDataSetConfigVO.class);
        }
        return ActionResult.success(result);
    }

    @NotCheckLogin
    @GetMapping(value={"/{datasetId}"})
    public ActionResult<DifyDataSetConfigVO> get(@PathVariable(value="datasetId") String datasetId) {
        SysConfigEntity entity;
        List result;
        Optional<DifyDataSetConfigVO> first;
        DifyDataSetConfigVO rs = new DifyDataSetConfigVO();
        List list = this.sysConfigService.list((Wrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode()));
        if (CollectionUtil.isNotEmpty((Collection)list) && (first = (result = JsonUtil.getJsonToList((String)(entity = (SysConfigEntity)list.get(0)).getKeyValue(), DifyDataSetConfigVO.class)).stream().filter(item -> datasetId.equals(item.getDataSetId())).findFirst()).isPresent()) {
            rs = first.get();
        }
        return ActionResult.success((Object)rs);
    }

    @NotCheckLogin
    @PostMapping
    public ActionResult create(@RequestBody DifyDataSetConfigVO difyDataSetConfigVO) {
        List list = this.sysConfigService.list((Wrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode()));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            SysConfigEntity entity = (SysConfigEntity)list.get(0);
            List result = JsonUtil.getJsonToList((String)entity.getKeyValue(), DifyDataSetConfigVO.class);
            result.add(difyDataSetConfigVO);
            String datasetId = this.difyDatasetService.createDataset(difyDataSetConfigVO.getDataSetName(), difyDataSetConfigVO.getDescription());
            String documentId = this.difyDatasetService.createDocument(datasetId, difyDataSetConfigVO.getDocumentName());
            difyDataSetConfigVO.setDataSetId(datasetId);
            difyDataSetConfigVO.setDocumentId(documentId);
            String jsonObj = JsonUtil.getObjectToString((Object)result);
            SysConfigEntity saveEntity = new SysConfigEntity();
            saveEntity.setCategory(DifyCategoryEnum.KNOWLEDGE_BASE.getCode());
            saveEntity.setName(DifyCategoryEnum.KNOWLEDGE_BASE.getDescribe());
            saveEntity.setKeyName(DifyCategoryEnum.KNOWLEDGE_BASE.getCode());
            saveEntity.setKeyValue(jsonObj);
            this.sysConfigService.create(saveEntity);
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @NotCheckLogin
    @PutMapping
    public ActionResult update(@RequestBody DifyDataSetConfigVO difyDataSetConfigVO) {
        List list = this.sysConfigService.list((Wrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode()));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            SysConfigEntity entity = (SysConfigEntity)list.get(0);
            List result = JsonUtil.getJsonToList((String)entity.getKeyValue(), DifyDataSetConfigVO.class);
            result.removeIf(item -> difyDataSetConfigVO.getDataSetId().equals(item.getDataSetId()));
            result.add(difyDataSetConfigVO);
            String jsonObj = JsonUtil.getObjectToString((Object)result);
            SysConfigEntity saveEntity = new SysConfigEntity();
            saveEntity.setCategory(DifyCategoryEnum.KNOWLEDGE_BASE.getCode());
            saveEntity.setName(DifyCategoryEnum.KNOWLEDGE_BASE.getDescribe());
            saveEntity.setKeyName(DifyCategoryEnum.KNOWLEDGE_BASE.getCode());
            saveEntity.setKeyValue(jsonObj);
            this.sysConfigService.create(saveEntity);
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @DeleteMapping(value={"{datasetId}"})
    public ActionResult delete(@PathVariable(value="datasetId") String datasetId) {
        List list = this.sysConfigService.list((Wrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode()));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            SysConfigEntity entity = (SysConfigEntity)list.get(0);
            List result = JsonUtil.getJsonToList((String)entity.getKeyValue(), DifyDataSetConfigVO.class);
            result.removeIf(item -> datasetId.equals(item.getDataSetId()));
            String jsonObj = JsonUtil.getObjectToString((Object)result);
            SysConfigEntity saveEntity = new SysConfigEntity();
            saveEntity.setCategory(DifyCategoryEnum.KNOWLEDGE_BASE.getCode());
            saveEntity.setName(DifyCategoryEnum.KNOWLEDGE_BASE.getDescribe());
            saveEntity.setKeyName(DifyCategoryEnum.KNOWLEDGE_BASE.getCode());
            saveEntity.setKeyValue(jsonObj);
            this.sysConfigService.create(saveEntity);
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @NotCheckLogin
    @PostMapping(value={"/synchronous"})
    public ActionResult synchronous(@RequestBody DifyDataSetSynchronousVO data) {
        String jsonData = JsonUtil.getObjectToString(data.getData());
        this.difyDatasetService.invokeDatasetSynchronous(data.getDataSetId(), data.getDocumentId(), jsonData);
        return ActionResult.success((String)MsgCode.SU005.get());
    }
}

