/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.AppAuthenticator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import utils.HttpRequestUtils;
import utils.SecretSignatureUtils;

public class UaaAppAuthenticator
implements AppAuthenticator {
    public static final String OPEN_PARAM_PREFIX = "y_";
    public static final String OPEN_PARAM_APPID = "y_appid";
    public static final String OPEN_PARAM_SIGN = "y_SIGN";
    private String signParamName;
    private String paramNamePrefix;
    private String appidParamName;

    public UaaAppAuthenticator() {
    }

    public UaaAppAuthenticator(String signParamName, String paramNamePrefix, String appidParamName) {
        this.signParamName = signParamName;
        this.paramNamePrefix = paramNamePrefix;
        this.appidParamName = appidParamName;
    }

    public String getSignParamName() {
        return this.signParamName;
    }

    public void setSignParamName(String signParamName) {
        this.signParamName = signParamName;
    }

    public String getParamNamePrefix() {
        return this.paramNamePrefix;
    }

    public void setParamNamePrefix(String paramNamePrefix) {
        this.paramNamePrefix = paramNamePrefix;
    }

    public String getAppidParamName() {
        return this.appidParamName;
    }

    public void setAppidParamName(String appidParamName) {
        this.appidParamName = appidParamName;
    }

    @Override
    public String generateSign(String secret, Map<String, String[]> params) throws Exception {
        String fullParamStr = this.uniqSortParams(params);
        return SecretSignatureUtils.hmacSHA256(fullParamStr, secret);
    }

    private String uniqSortParams(Map<String, String[]> params) {
        boolean prefix = HttpRequestUtils.StringUtils.isNotEmpty(this.paramNamePrefix);
        params.remove(this.signParamName);
        Object[] paramKeys = new String[params.keySet().size()];
        int idx = 0;
        Iterator<String> var5 = params.keySet().iterator();
        while (true) {
            if (!var5.hasNext()) {
                Arrays.sort(paramKeys, 0, idx);
                StringBuilder builder = new StringBuilder();
                Object[] var16 = paramKeys;
                int var7 = paramKeys.length;
                for (int var8 = 0; var8 < var7; ++var8) {
                    Object key = var16[var8];
                    Object[] values = params.get(key);
                    if (values != null && values.length > 0) {
                        Arrays.sort(values);
                        Object[] var11 = values;
                        int var12 = values.length;
                        for (int var13 = 0; var13 < var12; ++var13) {
                            Object val2 = var11[var13];
                            builder.append((String)key).append("=").append((String)val2);
                        }
                        continue;
                    }
                    builder.append((String)key).append("=");
                }
                return builder.toString();
            }
            String param = var5.next();
            if (prefix && param.startsWith(this.paramNamePrefix)) continue;
            paramKeys[idx++] = param;
        }
    }
}

