/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.IResult;

public class DefaultResult<T>
implements IResult<T> {
    private static final SuccessResult SUCCESS = new SuccessResult();
    private static final FailResult FAIL = new FailResult();
    private boolean success;
    private String message;
    private T data;

    public DefaultResult() {
    }

    public DefaultResult(boolean success, String message) {
        this(success, message, null);
    }

    public DefaultResult(boolean success, T data) {
        this(success, null, data);
    }

    public DefaultResult(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }

    public static <T> DefaultResult<T> successResult() {
        return SUCCESS;
    }

    public static <T> DefaultResult<T> successResult(T data) {
        return new DefaultResult<T>(true, null, data);
    }

    public static <T> DefaultResult<T> successResult(String message, T data) {
        return new DefaultResult<T>(true, message, data);
    }

    public static <T> DefaultResult<T> failResult() {
        return FAIL;
    }

    public static <T> DefaultResult<T> failResult(String message) {
        return new DefaultResult<Object>(false, message, null);
    }

    public static <T> DefaultResult<T> failResult(String message, T data) {
        return new DefaultResult<T>(false, message, data);
    }

    public static <T> DefaultResult<T> failResult(T data) {
        return new DefaultResult<T>(false, null, data);
    }

    public static <T> DefaultResult<T> result(boolean success, String message, T data) {
        return new DefaultResult<T>(success, message, data);
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public void setData(T obj) {
        this.data = obj;
    }

    private static class FailResult
    extends DefaultResult<Object> {
        public FailResult() {
            super(false, null, null);
        }
    }

    private static class SuccessResult
    extends DefaultResult<Object> {
        public SuccessResult() {
            super(true, null, null);
        }
    }
}

