/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.model.FlowHandleModel;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowlaunch.FlowLaunchListVO;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowNature;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u53d1\u8d77"}, value="FlowLaunch")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowLaunch"})
public class FlowLaunchController {
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNewService flowTaskNewService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private UserService userService;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u53d1\u8d77\u5217\u8868(\u5e26\u5206\u9875)")
    @GetMapping
    public ActionResult<PageListVO<FlowLaunchListVO>> list(PaginationFlowTask paginationFlowTask) {
        List<FlowTaskEntity> data = this.flowTaskService.getLaunchList(paginationFlowTask);
        List<FlowEngineEntity> engineList = this.flowEngineService.getFlowList(data.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        LinkedList<FlowLaunchListVO> listVO = new LinkedList<FlowLaunchListVO>();
        for (FlowTaskEntity taskEntity : data) {
            List<FlowTaskOperatorEntity> operatorList;
            FlowLaunchListVO vo = (FlowLaunchListVO)JsonUtil.getJsonToBean((Object)taskEntity, FlowLaunchListVO.class);
            FlowEngineEntity entity = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (entity != null) {
                vo.setFormData(entity.getFormData());
                vo.setFormType(entity.getFormType());
            }
            if (CollectionUtil.isNotEmpty(operatorList = this.flowTaskOperatorService.getListByNode(taskEntity.getId(), taskEntity.getThisStepId())) && !taskEntity.getStatus().equals(2)) {
                if (operatorList.size() > 1) {
                    ArrayList strings = new ArrayList();
                    operatorList.stream().forEach(operator -> {
                        UserEntity userInfo = this.userService.getInfo(operator.getHandleId());
                        strings.add(userInfo.getRealName());
                    });
                    String handleName = strings.stream().collect(Collectors.joining(","));
                    vo.setThisStep(vo.getThisStep() + "-" + handleName);
                } else {
                    UserEntity userEntity = this.userService.getInfo(operatorList.get(0).getHandleId());
                    if (ObjectUtil.isNotEmpty((Object)userEntity) && !vo.getThisStep().equals(userEntity.getRealName())) {
                        vo.setThisStep(vo.getThisStep() + "-" + userEntity.getRealName());
                    }
                }
            }
            listVO.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationFlowTask), PaginationVO.class);
        return ActionResult.page(listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u53d1\u8d77")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowTaskEntity entity = this.flowTaskService.getInfo(id);
        if (entity != null) {
            if (!FlowNature.ParentId.equals(entity.getParentId()) && StringUtils.isNotEmpty((String)entity.getParentId())) {
                return ActionResult.fail((String)"\u5b50\u8868\u6570\u636e\u4e0d\u80fd\u5220\u9664");
            }
            this.flowTaskService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u53d1\u8d77\u50ac\u529e")
    @PostMapping(value={"/Press/{taskId}"})
    public ActionResult press(@PathVariable(value="taskId") String taskId) throws WorkFlowException {
        boolean flag = this.flowTaskNewService.press(taskId);
        if (flag) {
            return ActionResult.success((String)"\u50ac\u529e\u6210\u529f");
        }
        return ActionResult.fail((String)"\u672a\u627e\u5230\u50ac\u529e\u4eba");
    }

    @ApiOperation(value="\u64a4\u56de\u6d41\u7a0b\u53d1\u8d77")
    @RepeatSubmit
    @PutMapping(value={"/{id}/Actions/Withdraw"})
    public ActionResult revoke(@PathVariable(value="id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskEntity flowTaskEntity = this.flowTaskService.getInfo(id);
        FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
        flowModel.setFlowId(flowTaskEntity.getFlowId());
        flowModel.setProcessId(flowTaskEntity.getProcessId());
        this.flowTaskNewService.revoke(flowTaskEntity, flowModel);
        return ActionResult.success((String)"\u64a4\u56de\u6210\u529f");
    }
}

