/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.model.flowrelation.FlowRelationListVO;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u76d1\u63a7"}, value="FlowRelation")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowRelation"})
public class FlowRelationController {
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u4e0e\u6211\u76f8\u5173\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<FlowRelationListVO>> list(PaginationFlowTask paginationFlowTask) {
        List<FlowTaskListModel> listByRelation = this.flowTaskService.getListByRelation(paginationFlowTask);
        List<FlowEngineEntity> engineList = this.flowEngineService.getFlowList(listByRelation.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        List<UserEntity> userList = this.serviceUtil.getUserName(listByRelation.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        LinkedList<FlowRelationListVO> listVO = new LinkedList<FlowRelationListVO>();
        for (FlowTaskListModel taskEntity : listByRelation) {
            FlowRelationListVO vo = (FlowRelationListVO)JsonUtil.getJsonToBean((Object)taskEntity, FlowRelationListVO.class);
            UserEntity user = userList.stream().filter(t -> t.getId().equals(taskEntity.getCreatorUserId())).findFirst().orElse(null);
            vo.setUserName(user != null ? user.getRealName() : "");
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (engine == null) continue;
            vo.setFormData(engine.getFormData());
            vo.setFormType(engine.getFormType());
            listVO.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationFlowTask), PaginationVO.class);
        return ActionResult.page(listVO, (PaginationVO)paginationVO);
    }
}

