/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.ecs.docking.enums.PayStateEnums;
import com.bringspring.ecs.entity.EcsAdvancePaymentEntity;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.enums.VoucherPushStateEnum;
import com.bringspring.ecs.model.bankcard.EcsBankCardInfoVO;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentCrForm;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentInfoVO;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentListVO;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentPagination;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentPaginationExportModel;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentUpForm;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.model.records.EcsRecordsPaymentVO;
import com.bringspring.ecs.service.EcsAdvancePaymentService;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d39\u63a7\u9884\u4ed8\u6b3e\u8bb0\u5f55\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsAdvancePayment"})
public class EcsAdvancePaymentController {
    private static final Logger log = LoggerFactory.getLogger(EcsAdvancePaymentController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsAdvancePaymentService ecsAdvancePaymentService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private EcsBankCardService ecsBankCardService;
    @Autowired
    private EcsPaymentRecordsService paymentRecordsService;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsAdvancePaymentPagination pagination) throws IOException, WorkFlowException {
        String userId = this.userProvider.get().getUserId();
        List<EcsAdvancePaymentEntity> list = this.ecsAdvancePaymentService.getList(pagination);
        List listVO = JsonUtil.getJsonToList(list, EcsAdvancePaymentInfoVO.class);
        for (EcsAdvancePaymentInfoVO infoVO : listVO) {
            EcsBankCardEntity bankCard;
            infoVO.setUserName(this.baseDataUtil.userSelectValue(infoVO.getUserId()));
            infoVO.setCompanyName(this.baseDataUtil.comSelectValues(infoVO.getCompanyId()));
            infoVO.setCreatorUserName(this.baseDataUtil.userSelectValue(infoVO.getCreatorUserId()));
            infoVO.setAuditStatusName(this.baseDataUtil.getDictName(infoVO.getAuditStatus(), "EcsRecordStatus"));
            BigDecimal subtract = infoVO.getTotalAdvanceAmount().subtract(infoVO.getRepaymentAmount()).subtract(infoVO.getRepayingAmount());
            infoVO.setTotalUnpaidLoan(subtract);
            FlowTaskEntity flowTaskEntity = this.flowTaskService.getDraftTaskByProcessId(infoVO.getId());
            if (flowTaskEntity != null) {
                FlowTaskNodeEntity flowTaskNode = (FlowTaskNodeEntity)this.flowTaskNodeService.getById((Serializable)((Object)flowTaskEntity.getThisStepId()));
                String taskOperatorId = "";
                if (flowTaskNode != null) {
                    List operatorEntities = this.flowTaskOperatorService.getListByNode(flowTaskEntity.getId(), flowTaskNode.getId());
                    for (FlowTaskOperatorEntity operatorEntity : operatorEntities) {
                        if (!userId.equals(operatorEntity.getHandleId())) continue;
                        taskOperatorId = operatorEntity.getId();
                    }
                }
                infoVO.setTaskId(flowTaskEntity.getId());
                infoVO.setTaskNodeId(flowTaskEntity.getThisStepId());
                infoVO.setTaskOperatorId(taskOperatorId);
                infoVO.setFlowState(flowTaskEntity.getStatus());
                infoVO.setFlowId(flowTaskEntity.getFlowId());
                infoVO.setEnCode(flowTaskEntity.getFlowCode());
            }
            if ((bankCard = (EcsBankCardEntity)this.ecsBankCardService.getById((Serializable)((Object)infoVO.getBankCardId()))) != null) {
                infoVO.setBankCardInfo((EcsBankCardInfoVO)JsonUtil.getJsonToBean((Object)bankCard, EcsBankCardInfoVO.class));
            }
            EcsPaymentRecordsEntity recordsEntity = (EcsPaymentRecordsEntity)this.paymentRecordsService.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsPaymentRecordsEntity::getSourceId, (Object)infoVO.getId()));
            infoVO.setPayVoucherStatus("\u672a\u63a8\u9001");
            if (recordsEntity != null) {
                if (StrUtil.isNotBlank((CharSequence)recordsEntity.getReceiptUrl()) && recordsEntity.getPayState().equals(PayStateEnums.PYSTAT_04.getCode())) {
                    infoVO.setReceipetStatus("1");
                    infoVO.setPayVoucherStatus(VoucherPushStateEnum.getDescByCode(recordsEntity.getPayVoucherStatus()));
                    infoVO.setPayVoucherNum(recordsEntity.getPayVoucherNum());
                    infoVO.setPayVoucherTime(recordsEntity.getPayVoucherTime());
                } else if (recordsEntity.getPayState().equals(PayStateEnums.PYSTAT_02.getCode())) {
                    infoVO.setReceipetStatus("0");
                }
            } else {
                infoVO.setReceipetStatus("2");
            }
            infoVO.setCostVoucherStatus(VoucherPushStateEnum.getDescByCode(infoVO.getCostVoucherStatus()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getUserAdvanceList"})
    public ActionResult<?> getUserAdvanceList(@RequestBody EcsAdvancePaymentPagination pagination) throws IOException, WorkFlowException {
        List<EcsAdvancePaymentEntity> list = this.ecsAdvancePaymentService.getUserAdvanceList(pagination);
        List listVO = JsonUtil.getJsonToList(list, EcsAdvancePaymentInfoVO.class);
        for (EcsAdvancePaymentInfoVO infoVO : listVO) {
            infoVO.setUserName(this.baseDataUtil.userSelectValue(infoVO.getUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countByState"})
    public ActionResult<?> countByEnabledMark(@RequestBody EcsAdvancePaymentPagination pagination) {
        List<Map<String, Object>> maps = this.ecsAdvancePaymentService.countByState(pagination);
        return ActionResult.success(maps);
    }

    @PostMapping(value={"/getSummaryInformation"})
    public ActionResult<?> getSummaryInformation(@RequestBody EcsAdvancePaymentPagination pagination) {
        Map<String, Object> maps = this.ecsAdvancePaymentService.getSummaryInformation(pagination);
        return ActionResult.success(maps);
    }

    @PostMapping
    public ActionResult<?> create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        EcsAdvancePaymentCrForm crForm = (EcsAdvancePaymentCrForm)((Object)JsonUtil.getJsonToBean(crData, EcsAdvancePaymentCrForm.class));
        String visualId = "681479917535233989";
        String mainId = RandomUtil.uuId();
        this.ecsAdvancePaymentService.create(mainId, crForm);
        FlowUtil.saveOrSubmit((String)crForm.getTaskId(), (String)crForm.getFlowId(), (String)crForm.getTemplateId(), (String)mainId, (Object)((Object)crForm), (Integer)crForm.getStatus(), (String)crForm.getTitle());
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f", (Object)((Object)crForm));
    }

    @GetMapping(value={"/generatePDF/{id}"})
    public ActionResult<?> generatePDF(@PathVariable(value="id") String id) {
        DownloadVO downloadVO = this.ecsAdvancePaymentService.generatePDF(id);
        return ActionResult.success((Object)downloadVO);
    }

    @GetMapping(value={"/getAdvancePDF/{id}"})
    public ActionResult<?> getRecordPDF(@PathVariable(value="id") String id) {
        EcsUploadVO downloadVO = this.ecsAdvancePaymentService.getAdvancePDF(id);
        return ActionResult.success((Object)Lists.newArrayList((Object[])new EcsUploadVO[]{downloadVO}));
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult<?> Export(EcsAdvancePaymentPaginationExportModel ecsAdvancePaymentPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)ecsAdvancePaymentPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        EcsAdvancePaymentPagination ecsAdvancePaymentPagination = (EcsAdvancePaymentPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ecsAdvancePaymentPaginationExportModel), EcsAdvancePaymentPagination.class));
        List<EcsAdvancePaymentEntity> list = this.ecsAdvancePaymentService.getTypeList(ecsAdvancePaymentPagination, ecsAdvancePaymentPaginationExportModel.getDataType());
        for (EcsAdvancePaymentEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, EcsAdvancePaymentListVO.class);
        for (EcsAdvancePaymentListVO ecsAdvancePaymentListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)ecsAdvancePaymentPaginationExportModel.getSelectKey()) ? ecsAdvancePaymentPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "reimbCompany": {
                        entitys.add(new ExcelExportEntity("\u62a5\u9500\u516c\u53f8", (Object)"reimbCompany"));
                        continue block36;
                    }
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u6807\u9898", (Object)"title"));
                        continue block36;
                    }
                    case "organizationId": {
                        entitys.add(new ExcelExportEntity("\u8d39\u7528\u90e8\u95e8", (Object)"organizationId"));
                        continue block36;
                    }
                    case "reasons": {
                        entitys.add(new ExcelExportEntity("\u62a5\u9500\u4e8b\u7531", (Object)"reasons"));
                        continue block36;
                    }
                    case "bankCardId": {
                        entitys.add(new ExcelExportEntity("\u94f6\u884c\u5361id", (Object)"bankCardId"));
                        continue block36;
                    }
                    case "subjectCode": {
                        entitys.add(new ExcelExportEntity("\u8d39\u7528\u79d1\u76ee\u7f16\u7801", (Object)"subjectCode"));
                        continue block36;
                    }
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"contractId"));
                        continue block36;
                    }
                    case "totalAdvanceAmount": {
                        entitys.add(new ExcelExportEntity("\u603b\u9884\u4ed8\u6b3e\u91d1\u989d", (Object)"totalAdvanceAmount"));
                        continue block36;
                    }
                    case "repaymentAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u8fd8\u6b3e\u91d1\u989d", (Object)"repaymentAmount"));
                        continue block36;
                    }
                    case "repayingAmount": {
                        entitys.add(new ExcelExportEntity("\u8fd8\u6b3e\u4e2d\u91d1\u989d", (Object)"repayingAmount"));
                        continue block36;
                    }
                    case "advanceSubmitTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u63d0\u4ea4\u65f6\u95f4", (Object)"advanceSubmitTime"));
                        continue block36;
                    }
                    case "advancePredictTime": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u8fd8\u6b3e\u65f6\u95f4", (Object)"advancePredictTime"));
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsAdvancePaymentInfoVO> info(@PathVariable(value="id") String id) {
        EcsAdvancePaymentEntity entity = this.ecsAdvancePaymentService.getInfo(id);
        EcsAdvancePaymentInfoVO vo = (EcsAdvancePaymentInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsAdvancePaymentInfoVO.class);
        vo.setUserName(this.baseDataUtil.userSelectValue(vo.getUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> update(@PathVariable(value="id") String id, @RequestBody @Valid EcsAdvancePaymentUpForm upForm) throws DataException, WorkFlowException {
        this.ecsAdvancePaymentService.update(id, upForm);
        FlowTaskEntity draftTaskByProcessId = this.flowTaskService.getDraftTaskByProcessId(id);
        String taskId = null;
        if (draftTaskByProcessId != null) {
            taskId = draftTaskByProcessId.getId();
        }
        FlowUtil.saveOrSubmit((String)taskId, (String)upForm.getFlowId(), (String)upForm.getTemplateId(), (String)id, (Object)((Object)upForm), (Integer)upForm.getStatus(), (String)upForm.getTitle());
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult<?> delete(@PathVariable(value="id") String id) {
        EcsAdvancePaymentEntity entity = this.ecsAdvancePaymentService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getFlowId, FlowTaskEntity::getFlowCode, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    log.error("\u5220\u9664\u6d41\u7a0b\u5931\u8d25", (Throwable)e);
                }
            }
            this.ecsAdvancePaymentService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/batchReview"})
    @DSTransactional
    public ActionResult<?> batchReview(@RequestBody List<String> ids) throws DataException {
        this.ecsAdvancePaymentService.batchReview(ids);
        return ActionResult.success((String)"\u4ed8\u6b3e\u590d\u6838\u6210\u529f");
    }

    @PostMapping(value={"/batchReviewPayment"})
    @DSTransactional
    public ActionResult<?> batchReviewPayment(@RequestBody EcsRecordsPaymentVO paymentVO) {
        return this.ecsAdvancePaymentService.batchReviewPayment(paymentVO);
    }

    @GetMapping(value={"/getApprovedByOrganization/{type}"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult<?> getApprovedByCode(String taskId, String taskNodeId, String createUserId, @PathVariable Integer type) {
        type = type == null || type <= 0 ? 1 : type;
        Map<String, Object> map = this.ecsAdvancePaymentService.getApprovedByCode(taskId, type);
        return ActionResult.success(map);
    }

    @GetMapping(value={"/getApprovedByUser/{type}"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult<?> getApprovedByUser(String taskId, String taskNodeId, String createUserId, @PathVariable Integer type) {
        type = type == null || type <= 0 ? 1 : type;
        Map<String, Object> map = this.ecsAdvancePaymentService.getApprovedByUser(taskId, type);
        return ActionResult.success(map);
    }
}

