/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBankTransactionHistoryEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryCrForm;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryInfoVO;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryListVO;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryPagination;
import com.bringspring.ecs.model.ecsbanktransactionhistory.EcsBankTransactionHistoryUpForm;
import com.bringspring.ecs.service.EcsBankTransactionHistoryService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u94f6\u884c\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55"}, value="example")
@RequestMapping(value={"/api/example/EcsBankTransactionHistory"})
public class EcsBankTransactionHistoryController {
    private static final Logger log = LoggerFactory.getLogger(EcsBankTransactionHistoryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsBankTransactionHistoryService ecsBankTransactionHistoryService;
    @Autowired
    private EcsCompanyService companyService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u94f6\u884c\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u5217\u8868")
    public ActionResult list(@RequestBody EcsBankTransactionHistoryPagination ecsBankTransactionHistoryPagination) throws IOException {
        List<EcsBankTransactionHistoryEntity> list = this.ecsBankTransactionHistoryService.getList(ecsBankTransactionHistoryPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBankTransactionHistoryListVO.class);
        for (EcsBankTransactionHistoryListVO vo : listVO) {
            EcsCompanyEntity companyEntity = (EcsCompanyEntity)this.companyService.getById((Serializable)((Object)vo.getCompanyId()));
            vo.setCompanyName(companyEntity.getName());
            vo.setOrganizationName(this.baseDataUtil.comSelectValues(vo.getOrganization()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBankTransactionHistoryPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u94f6\u884c\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsBankTransactionHistoryCrForm ecsBankTransactionHistoryCrForm) throws DataException {
        this.ecsBankTransactionHistoryService.create(ecsBankTransactionHistoryCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u94f6\u884c\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<EcsBankTransactionHistoryInfoVO> info(@PathVariable(value="id") String id) {
        EcsBankTransactionHistoryEntity entity = this.ecsBankTransactionHistoryService.getInfo(id);
        EcsBankTransactionHistoryInfoVO vo = (EcsBankTransactionHistoryInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBankTransactionHistoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u94f6\u884c\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsBankTransactionHistoryInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsBankTransactionHistoryEntity entity = this.ecsBankTransactionHistoryService.getInfo(id);
        EcsBankTransactionHistoryInfoVO vo = (EcsBankTransactionHistoryInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBankTransactionHistoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u94f6\u884c\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsBankTransactionHistoryUpForm ecsBankTransactionHistoryUpForm) throws DataException {
        this.ecsBankTransactionHistoryService.update(id, ecsBankTransactionHistoryUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u94f6\u884c\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsBankTransactionHistoryEntity entity = this.ecsBankTransactionHistoryService.getInfo(id);
        if (entity != null) {
            this.ecsBankTransactionHistoryService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

