/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBudgetAccountEntity;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountCrForm;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountInfoVO;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountListQuery;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountPagination;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountSelector;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountUpForm;
import com.bringspring.ecs.service.EcsBudgetAccountService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9884\u7b97\u79d1\u76ee"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsBudgetAccount"})
public class EcsBudgetAccountController {
    private static final Logger log = LoggerFactory.getLogger(EcsBudgetAccountController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsBudgetAccountService ecsBudgetAccountService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsBudgetAccountPagination ecsBudgetAccountPagination) throws IOException {
        return ActionResult.success((Object)this.ecsBudgetAccountService.getBudgetAccountPageList(ecsBudgetAccountPagination));
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcsBudgetAccountCrForm ecsBudgetAccountCrForm) throws DataException {
        this.ecsBudgetAccountService.create(ecsBudgetAccountCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsBudgetAccountInfoVO> info(@PathVariable(value="id") String id) {
        EcsBudgetAccountEntity entity = this.ecsBudgetAccountService.getInfo(id);
        EcsBudgetAccountInfoVO vo = (EcsBudgetAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetAccountInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsBudgetAccountInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsBudgetAccountEntity entity = this.ecsBudgetAccountService.getInfo(id);
        EcsBudgetAccountInfoVO vo = (EcsBudgetAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetAccountInfoVO.class);
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u542f\u7528", "\u7981\u7528"));
        vo.setOrganizeTdsTree(this.baseDataUtil.comSelectValues(vo.getOrganizeTdsTree()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
        vo.setDeleteMark(this.baseDataUtil.switchSelectValue(vo.getDeleteMark(), "\u6b63\u5e38", "\u5220\u9664"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsBudgetAccountUpForm ecsBudgetAccountUpForm) throws DataException {
        return this.ecsBudgetAccountService.update(id, ecsBudgetAccountUpForm);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        return this.ecsBudgetAccountService.delete(id);
    }

    @GetMapping(value={"/getListTree"})
    public ActionResult getListTree(@RequestParam String parentId, @RequestParam String menuId, String year) {
        List<EcsBudgetAccountInfoVO> listVO = this.ecsBudgetAccountService.getListTree(parentId, menuId, year);
        return ActionResult.success(listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u79d1\u76ee\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<EcsBudgetAccountSelector>> getSelector(EcsBudgetAccountListQuery query) {
        return ActionResult.success(this.ecsBudgetAccountService.getBudgetAccountSelector(query));
    }

    @ApiOperation(value="\u83b7\u53d6\u79d1\u76ee\u7c7b\u522b\u5217\u8868")
    @PostMapping(value={"/getAccountList"})
    public ActionResult getAccountList(@RequestBody EcsBudgetAccountListQuery query) {
        return ActionResult.success(this.ecsBudgetAccountService.getAccountList(query));
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(EcsBudgetAccountEntity entity) throws IOException {
        DownloadVO downloadVO = this.ecsBudgetAccountService.excelAccountTemplate(entity.getYear());
        return ActionResult.success((Object)downloadVO);
    }
}

