/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBudgetAdjustDetailEntity;
import com.bringspring.ecs.entity.EcsBudgetAdjustEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeEntity;
import com.bringspring.ecs.model.ecsbudgetadjust.EcsBudgetAdjustCrForm;
import com.bringspring.ecs.model.ecsbudgetadjust.EcsBudgetAdjustInfoVO;
import com.bringspring.ecs.model.ecsbudgetadjust.EcsBudgetAdjustListVO;
import com.bringspring.ecs.model.ecsbudgetadjust.EcsBudgetAdjustPagination;
import com.bringspring.ecs.model.ecsbudgetadjust.EcsBudgetAdjustUpForm;
import com.bringspring.ecs.service.EcsBudgetAdjustDetailService;
import com.bringspring.ecs.service.EcsBudgetAdjustService;
import com.bringspring.ecs.service.EcsBudgetOrganizeService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9884\u7b97\u8c03\u6574\u7533\u8bf7\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsBudgetAdjust"})
public class EcsBudgetAdjustController {
    private static final Logger log = LoggerFactory.getLogger(EcsBudgetAdjustController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsBudgetAdjustService ecsBudgetAdjustService;
    @Autowired
    private EcsBudgetOrganizeService budgetOrganizeService;
    @Autowired
    private EcsBudgetOrganizeService organizeService;
    @Autowired
    private EcsBudgetAdjustDetailService adjustDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsBudgetAdjustPagination ecsBudgetAdjustPagination) throws IOException {
        List<EcsBudgetAdjustEntity> list = this.ecsBudgetAdjustService.getList(ecsBudgetAdjustPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBudgetAdjustListVO.class);
        for (EcsBudgetAdjustListVO ecsBudgetAdjustVO : listVO) {
            EcsBudgetOrganizeEntity organizeEntity = (EcsBudgetOrganizeEntity)this.organizeService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getYear, (Object)ecsBudgetAdjustVO.getYear())).eq(EcsBudgetOrganizeEntity::getId, (Object)ecsBudgetAdjustVO.getApplyDept()));
            ecsBudgetAdjustVO.setWriteUserId(this.baseDataUtil.userSelectValues(ecsBudgetAdjustVO.getWriteUserId()));
            ecsBudgetAdjustVO.setWriteDept(this.baseDataUtil.comSelectValues(ecsBudgetAdjustVO.getWriteDept()));
            ecsBudgetAdjustVO.setApplyUserId(this.baseDataUtil.userSelectValues(ecsBudgetAdjustVO.getApplyUserId()));
            ecsBudgetAdjustVO.setApplyDept(organizeEntity.getFullName());
            ecsBudgetAdjustVO.setOrganizeName(this.baseDataUtil.getDictName(ecsBudgetAdjustVO.getOrganizeId(), "budgetCompany"));
            ecsBudgetAdjustVO.setStateName(this.baseDataUtil.getDictName(ecsBudgetAdjustVO.getState(), "ApplyState"));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)ecsBudgetAdjustVO.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus, FlowTaskEntity::getFlowCode, FlowTaskEntity::getFlowId});
            if (flowTaskEntity == null) continue;
            ecsBudgetAdjustVO.setFlowState(flowTaskEntity.getStatus());
            ecsBudgetAdjustVO.setFlowId(flowTaskEntity.getFlowId());
            ecsBudgetAdjustVO.setEnCode(flowTaskEntity.getFlowCode());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetAdjustPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        EcsBudgetAdjustCrForm ecsBudgetAdjustCrForm = (EcsBudgetAdjustCrForm)((Object)JsonUtil.getJsonToBean(crData, EcsBudgetAdjustCrForm.class));
        String visualId = "631470284263711045";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcsBudgetAdjustEntity entity = (EcsBudgetAdjustEntity)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetAdjustCrForm), EcsBudgetAdjustEntity.class);
        entity.setId(mainId);
        entity.setCode(this.baseDataUtil.getBillNumber("budgetApply", Boolean.valueOf(false)));
        entity.setApplyTime(new Date());
        entity.setState(String.valueOf(ecsBudgetAdjustCrForm.getStatus()));
        this.ecsBudgetAdjustService.save(entity);
        List<EcsBudgetAdjustDetailEntity> adjustDetailEntityList = ecsBudgetAdjustCrForm.getAdjustDetailEntityList();
        adjustDetailEntityList.forEach(o -> {
            o.setId(RandomUtil.uuId());
            o.setAdjustId(entity.getId());
        });
        this.adjustDetailService.saveBatch(adjustDetailEntityList);
        EcsBudgetOrganizeEntity organizeEntity = this.budgetOrganizeService.getInfo(ecsBudgetAdjustCrForm.getApplyDept(), ecsBudgetAdjustCrForm.getYear());
        String flowTitle = organizeEntity.getFullName();
        FlowUtil.saveOrSubmit((String)ecsBudgetAdjustCrForm.getTaskId(), (String)visualId, (String)ecsBudgetAdjustCrForm.getTemplateId(), (String)mainId, (Object)((Object)ecsBudgetAdjustCrForm), (Integer)ecsBudgetAdjustCrForm.getStatus(), (String)flowTitle);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsBudgetAdjustInfoVO> info(@PathVariable(value="id") String id) {
        EcsBudgetAdjustEntity entity = this.ecsBudgetAdjustService.getInfo(id);
        EcsBudgetAdjustInfoVO vo = (EcsBudgetAdjustInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetAdjustInfoVO.class);
        List adjustDetailEntities = this.adjustDetailService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAdjustDetailEntity::getAdjustId, (Object)id));
        vo.setAdjustDetailEntityList(adjustDetailEntities);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        EcsBudgetAdjustUpForm ecsBudgetAdjustUpForm = (EcsBudgetAdjustUpForm)((Object)JsonUtil.getJsonToBean(upData, EcsBudgetAdjustUpForm.class));
        String applyDept = ecsBudgetAdjustUpForm.getApplyDept();
        String year = ecsBudgetAdjustUpForm.getYear();
        String visualId = "631470284263711045";
        UserInfo userInfo = this.userProvider.get();
        EcsBudgetAdjustEntity entity = this.ecsBudgetAdjustService.getInfo(id);
        List<EcsBudgetAdjustDetailEntity> adjustDetailEntityList = ecsBudgetAdjustUpForm.getAdjustDetailEntityList();
        if (entity != null) {
            EcsBudgetAdjustEntity subentity = (EcsBudgetAdjustEntity)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetAdjustUpForm), EcsBudgetAdjustEntity.class);
            this.ecsBudgetAdjustService.update(id, subentity);
            this.adjustDetailService.remove((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAdjustDetailEntity::getAdjustId, (Object)id));
            adjustDetailEntityList.forEach(o -> {
                o.setId(RandomUtil.uuId());
                o.setAdjustId(entity.getId());
            });
            this.adjustDetailService.saveBatch(adjustDetailEntityList);
            EcsBudgetOrganizeEntity organizeEntity = this.budgetOrganizeService.getInfo(applyDept, year);
            String flowTitle = organizeEntity.getFullName();
            FlowUtil.saveOrSubmit((String)ecsBudgetAdjustUpForm.getTaskId(), (String)ecsBudgetAdjustUpForm.getFlowId(), (String)ecsBudgetAdjustUpForm.getTemplateId(), (String)id, (Object)((Object)ecsBudgetAdjustUpForm), (Integer)ecsBudgetAdjustUpForm.getStatus(), (String)flowTitle);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsBudgetAdjustEntity entity = this.ecsBudgetAdjustService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getFlowId, FlowTaskEntity::getFlowCode, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.ecsBudgetAdjustService.delete(entity);
            this.adjustDetailService.remove((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAdjustDetailEntity::getAdjustId, (Object)id));
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

