/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.constants.GlobalConstants;
import com.bringspring.ecs.entity.EcsBudgetControlModeEntity;
import com.bringspring.ecs.entity.EcsBudgetEntity;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetCrForm;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetInfoVO;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetListVO;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetPagination;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetUpForm;
import com.bringspring.ecs.service.EcsBudgetControlModeService;
import com.bringspring.ecs.service.EcsBudgetService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9884\u7b97\u7ba1\u7406\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsBudget"})
public class EcsBudgetController {
    private static final Logger log = LoggerFactory.getLogger(EcsBudgetController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsBudgetService ecsBudgetService;
    @Autowired
    private EcsBudgetControlModeService ecsBudgetControlModeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsBudgetPagination ecsBudgetPagination) throws IOException {
        List<EcsBudgetEntity> list = this.ecsBudgetService.getList(ecsBudgetPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBudgetListVO.class);
        for (EcsBudgetListVO vo : listVO) {
            vo.setCompanyName(this.baseDataUtil.getDictName(vo.getCompanyId(), "budgetCompany"));
            vo.setControlType("1".equals(vo.getControlType()) ? "\u5e74\u5ea6" : "\u5b63\u5ea6");
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getNewestList"})
    public ActionResult getNewestList(@RequestBody EcsBudgetEntity entity) throws IOException {
        return ActionResult.success(this.ecsBudgetService.getNewestList(entity));
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcsBudgetCrForm ecsBudgetCrForm) throws DataException {
        return this.ecsBudgetService.create(ecsBudgetCrForm);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsBudgetInfoVO> info(@PathVariable(value="id") String id) {
        EcsBudgetEntity entity = this.ecsBudgetService.getInfo(id);
        EcsBudgetInfoVO vo = (EcsBudgetInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetInfoVO.class);
        if ("2".equals(vo.getControlType())) {
            List modeEntities = this.ecsBudgetControlModeService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetControlModeEntity::getBudgetId, (Object)id));
            vo.setControlModeEntities(modeEntities);
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsBudgetInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsBudgetEntity entity = this.ecsBudgetService.getInfo(id);
        EcsBudgetInfoVO vo = (EcsBudgetInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetInfoVO.class);
        if ("2".equals(vo.getControlType())) {
            List modeEntities = this.ecsBudgetControlModeService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetControlModeEntity::getBudgetId, (Object)id));
            vo.setControlModeEntities(modeEntities);
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsBudgetUpForm ecsBudgetUpForm) throws DataException {
        return this.ecsBudgetService.update(id, ecsBudgetUpForm);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsBudgetEntity entity = this.ecsBudgetService.getInfo(id);
        if (entity != null) {
            this.ecsBudgetService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetEntity::getDeleteMark, (Object)GlobalConstants.DEL_FLAG_YES)).eq(EcsBudgetEntity::getId, (Object)id));
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

