/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.UploaderVO;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.ecs.entity.EcsBudgetAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetControlModeEntity;
import com.bringspring.ecs.entity.EcsBudgetEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeEntity;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.BudgetQuarterStatisticsVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountCrForm;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountInfoVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountListVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountPagination;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountPaginationExportModel;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsBudgetOrganizeAccountUpForm;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.ImportDataRequest;
import com.bringspring.ecs.service.EcsBudgetAccountService;
import com.bringspring.ecs.service.EcsBudgetControlModeService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountService;
import com.bringspring.ecs.service.EcsBudgetOrganizeService;
import com.bringspring.ecs.service.EcsBudgetService;
import com.bringspring.ecs.utils.UploadFiles;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u9884\u7b97\u8d39\u7528\u660e\u7ec6"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsBudgetOrganizeAccount"})
public class EcsBudgetOrganizeAccountController {
    private static final Logger log = LoggerFactory.getLogger(EcsBudgetOrganizeAccountController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsBudgetOrganizeAccountService ecsBudgetOrganizeAccountService;
    @Autowired
    private EcsBudgetAccountService ecsBudgetAccountService;
    @Autowired
    private EcsBudgetOrganizeService ecsBudgetOrganizeService;
    @Autowired
    private EcsBudgetService ecsBudgetService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private EcsBudgetControlModeService budgetControlModeService;
    @Autowired
    private UploadFiles uploadFiles;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsBudgetOrganizeAccountPagination ecsBudgetOrganizeAccountPagination) throws IOException {
        EcsBudgetEntity ecsBudgetEntity = null;
        if (StringUtils.isNotEmpty((String)ecsBudgetOrganizeAccountPagination.getYear())) {
            ecsBudgetEntity = (EcsBudgetEntity)this.ecsBudgetService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetEntity::getCompanyId, (Object)ecsBudgetOrganizeAccountPagination.getOrganizeId())).eq(EcsBudgetEntity::getYear, (Object)ecsBudgetOrganizeAccountPagination.getYear()));
        } else {
            List budgetList = this.ecsBudgetService.list((Wrapper)Wrappers.lambdaQuery().orderByDesc(EcsBudgetEntity::getYear));
            ecsBudgetEntity = budgetList.stream().findFirst().orElse(null);
            if (ecsBudgetEntity != null) {
                ecsBudgetOrganizeAccountPagination.setYear(ecsBudgetEntity.getYear());
            }
        }
        if (ecsBudgetEntity == null) {
            return ActionResult.success((Object)new PageListVO());
        }
        List<EcsBudgetOrganizeAccountEntity> list = this.ecsBudgetOrganizeAccountService.getList(ecsBudgetOrganizeAccountPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsBudgetOrganizeAccountListVO.class);
        ArrayList<EcsBudgetControlModeEntity> modeEntities = new ArrayList();
        if ("2".equals(ecsBudgetEntity.getControlType())) {
            modeEntities = this.budgetControlModeService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetControlModeEntity::getBudgetId, (Object)ecsBudgetEntity.getId()));
        }
        List budgetAccountEntityList = this.ecsBudgetAccountService.list();
        List organizeEntities = this.ecsBudgetOrganizeService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getYear, (Object)ecsBudgetOrganizeAccountPagination.getYear()));
        Map<String, String> deptMap = organizeEntities.stream().collect(Collectors.toMap(EcsBudgetOrganizeEntity::getId, EcsBudgetOrganizeEntity::getFullName));
        Map<String, String> accountMap = budgetAccountEntityList.stream().collect(Collectors.toMap(EcsBudgetAccountEntity::getId, EcsBudgetAccountEntity::getFullName));
        for (EcsBudgetOrganizeAccountListVO vo : listVO) {
            vo.setOrganizeId(deptMap.get(vo.getOrganizeId()));
            vo.setCostDept(deptMap.get(vo.getCostDept()));
            vo.setAccountName(accountMap.get(vo.getAccountId()));
            vo.setProject(accountMap.get(vo.getProject()));
            if ("2".equals(ecsBudgetEntity.getControlType())) {
                List<BudgetQuarterStatisticsVO> quarterStatistics = this.ecsBudgetOrganizeAccountService.getQuarterStatistics(modeEntities, vo);
                vo.setQuarterStatisticsVOList(quarterStatistics);
            }
            BigDecimal totalBudget = new BigDecimal(vo.getAnnualBudget());
            BigDecimal usedBudget = new BigDecimal(vo.getAnnualUseBudget());
            BigDecimal pendingBudgetAmount = new BigDecimal(vo.getPendingBudget());
            BigDecimal usedBudgetRatio = BigDecimal.ZERO;
            BigDecimal pendingBudgetRatio = BigDecimal.ZERO;
            BigDecimal availableBudgetRatio = BigDecimal.ZERO;
            if (totalBudget.compareTo(BigDecimal.ZERO) > 0) {
                usedBudgetRatio = usedBudget.divide(totalBudget, 4, 4).multiply(BigDecimal.valueOf(100L));
            }
            if (totalBudget.compareTo(BigDecimal.ZERO) > 0) {
                pendingBudgetRatio = pendingBudgetAmount.divide(totalBudget, 4, 4).multiply(BigDecimal.valueOf(100L));
            }
            if (totalBudget.compareTo(BigDecimal.ZERO) > 0) {
                availableBudgetRatio = BigDecimal.valueOf(100L).subtract(usedBudgetRatio).subtract(pendingBudgetRatio);
            }
            vo.setUsedBudgetRatio(usedBudgetRatio);
            vo.setPendingBudgetRatio(pendingBudgetRatio);
            vo.setAvailableBudgetRatio(availableBudgetRatio);
        }
        PageListVO responseVo = new PageListVO();
        responseVo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetOrganizeAccountPagination), PaginationVO.class);
        responseVo.setPagination(page);
        return ActionResult.success((Object)responseVo);
    }

    @PostMapping(value={"/getAccountList"})
    public ActionResult getAccountList(@RequestBody EcsBudgetOrganizeAccountPagination pagination) throws IOException {
        return ActionResult.success(this.ecsBudgetOrganizeAccountService.getOrganizeAccountList(pagination.getYear(), pagination.getCostDept()));
    }

    @PostMapping(value={"/getBudgetTotal"})
    public ActionResult getBudgetTotal(@RequestBody EcsBudgetOrganizeAccountEntity entity) throws IOException {
        return ActionResult.success((Object)this.ecsBudgetOrganizeAccountService.getBudgetTotal(entity));
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcsBudgetOrganizeAccountCrForm ecsBudgetOrganizeAccountCrForm) throws DataException {
        this.ecsBudgetOrganizeAccountService.create(ecsBudgetOrganizeAccountCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsBudgetOrganizeAccountInfoVO> info(@PathVariable(value="id") String id) {
        EcsBudgetOrganizeAccountEntity entity = this.ecsBudgetOrganizeAccountService.getInfo(id);
        EcsBudgetOrganizeAccountInfoVO vo = (EcsBudgetOrganizeAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetOrganizeAccountInfoVO.class);
        List organizeEntities = this.ecsBudgetOrganizeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getYear, (Object)vo.getYear())).eq(EcsBudgetOrganizeEntity::getOrganizeId, (Object)vo.getOrganizeId()));
        Map<String, String> deptMap = organizeEntities.stream().collect(Collectors.toMap(EcsBudgetOrganizeEntity::getId, EcsBudgetOrganizeEntity::getFullName));
        vo.setCostDeptName(deptMap.get(vo.getCostDept()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsBudgetOrganizeAccountInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsBudgetOrganizeAccountEntity entity = this.ecsBudgetOrganizeAccountService.getInfo(id);
        EcsBudgetOrganizeAccountInfoVO vo = (EcsBudgetOrganizeAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetOrganizeAccountInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsBudgetOrganizeAccountUpForm ecsBudgetOrganizeAccountUpForm) throws DataException {
        this.ecsBudgetOrganizeAccountService.update(id, ecsBudgetOrganizeAccountUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsBudgetOrganizeAccountEntity entity = this.ecsBudgetOrganizeAccountService.getInfo(id);
        if (entity != null) {
            this.ecsBudgetOrganizeAccountService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult Uploader() throws IOException {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (!file.getOriginalFilename().endsWith(".xlsx") && !file.getOriginalFilename().endsWith(".xls")) {
            return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
        }
        String filePath = this.configValueUtil.getTemporaryFilePath();
        String fileName = RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file);
        fileName = XSSEscape.escape((String)fileName);
        FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
        String filePath1 = this.configValueUtil.getTemporaryFilePath();
        File temporary = new File(XSSEscape.escapePath((String)(filePath1 + fileName)));
        MultipartFile fileItem = FileUtil.createFileItem((File)temporary);
        ArrayList<EcsUploadVO> ecsUploadVOS = new ArrayList<EcsUploadVO>();
        UploaderVO uploader = this.uploadFiles.uploader(fileItem, "ecs", "annex");
        EcsUploadVO ecsUploadVO = new EcsUploadVO();
        BeanUtil.copyProperties((Object)uploader, (Object)ecsUploadVO, (String[])new String[0]);
        ecsUploadVO.setName(file.getOriginalFilename());
        ecsUploadVO.setFileId(uploader.getName());
        ecsUploadVOS.add(ecsUploadVO);
        DownloadVO vo = DownloadVO.builder().build();
        vo.setName(fileName);
        vo.setUrl(JSON.toJSONString(ecsUploadVOS));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        return ActionResult.success((Object)this.ecsBudgetOrganizeAccountService.getTemplateDownload());
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/importPreview"})
    public ActionResult ImportPreview(String fileName) {
        return this.ecsBudgetOrganizeAccountService.importOrganizeAccountPreview(fileName);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/importData/{menuId}"})
    public ActionResult ImportData(@RequestBody ImportDataRequest data, @PathVariable(value="menuId") String menuId) {
        return this.ecsBudgetOrganizeAccountService.importOrganizeAccountData(data, menuId);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(EcsBudgetOrganizeAccountPaginationExportModel ecsBudgetOrganizeAccountPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)ecsBudgetOrganizeAccountPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO downloadVO = this.ecsBudgetOrganizeAccountService.exportOrganizeAccount(ecsBudgetOrganizeAccountPaginationExportModel);
        return ActionResult.success((Object)downloadVO);
    }
}

