/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.ecs.entity.EcsBudgetOrganizeEntity;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeCrForm;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeInfoVO;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeListQuery;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeListVO;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizePagination;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeUpForm;
import com.bringspring.ecs.model.ecsbudgetorganize.OrganizeDepartMergeVO;
import com.bringspring.ecs.model.ecsbudgetorganize.OrganizeDepartSelectorListVO;
import com.bringspring.ecs.model.ecsbudgetorganize.OrganizeDepartSplitVO;
import com.bringspring.ecs.model.ecsbudgetorganize.OrganizeModel;
import com.bringspring.ecs.service.EcsBudgetOrganizeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9884\u7b97\u7ba1\u7406\u7ec4\u7ec7"}, value="esc")
@RequestMapping(value={"/api/esc/EcsBudgetOrganize"})
public class EcsBudgetOrganizeController {
    private static final Logger log = LoggerFactory.getLogger(EcsBudgetOrganizeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsBudgetOrganizeService ecsBudgetOrganizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsBudgetOrganizePagination ecsBudgetOrganizePagination) throws IOException {
        List<EcsBudgetOrganizeEntity> list = this.ecsBudgetOrganizeService.getList(ecsBudgetOrganizePagination);
        for (EcsBudgetOrganizeEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, EcsBudgetOrganizeListVO.class);
        for (EcsBudgetOrganizeListVO ecsBudgetOrganizeListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsBudgetOrganizePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcsBudgetOrganizeCrForm ecsBudgetOrganizeCrForm) throws DataException {
        this.ecsBudgetOrganizeService.create(ecsBudgetOrganizeCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u65b0\u5efa\u90e8\u95e8")
    @PostMapping(value={"/Department"})
    public ActionResult createDepartment(@RequestBody @Valid EcsBudgetOrganizeEntity entity) throws PermissionException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u5efa\u5931\u8d25");
        }
        this.ecsBudgetOrganizeService.createDepartment(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u90e8\u95e8")
    @PutMapping(value={"/Department/{id}"})
    public ActionResult updateDepartment(@PathVariable(value="id") String id, @RequestBody @Valid EcsBudgetOrganizeEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u5efa\u5931\u8d25");
        }
        if (id.equals(entity.getParentId())) {
            return ActionResult.fail((String)"\u4e0a\u7ea7\u90e8\u95e8\u548c\u90e8\u95e8\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a");
        }
        if (this.ecsBudgetOrganizeService.isExistByFullName(entity, false, true)) {
            return ActionResult.fail((String)"\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.ecsBudgetOrganizeService.updateDepartment(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @PostMapping(value={"/getInfo"})
    public ActionResult<EcsBudgetOrganizeInfoVO> info(@RequestBody EcsBudgetOrganizeEntity budgetOrganizeEntity) {
        EcsBudgetOrganizeEntity entity = this.ecsBudgetOrganizeService.getInfo(budgetOrganizeEntity.getId(), budgetOrganizeEntity.getYear());
        EcsBudgetOrganizeInfoVO vo = (EcsBudgetOrganizeInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetOrganizeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getDetail"})
    public ActionResult<EcsBudgetOrganizeInfoVO> detailInfo(@RequestBody EcsBudgetOrganizeEntity budgetOrganizeEntity) {
        EcsBudgetOrganizeEntity entity = this.ecsBudgetOrganizeService.getInfo(budgetOrganizeEntity.getId(), budgetOrganizeEntity.getYear());
        EcsBudgetOrganizeInfoVO vo = (EcsBudgetOrganizeInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsBudgetOrganizeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsBudgetOrganizeUpForm ecsBudgetOrganizeUpForm) throws DataException {
        this.ecsBudgetOrganizeService.update(id, ecsBudgetOrganizeUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/UserDepartment/Selector"})
    public ActionResult<ListVO<OrganizeDepartSelectorListVO>> getListUserDepartment(@RequestBody EcsBudgetOrganizeListQuery query) {
        List<EcsBudgetOrganizeEntity> list = this.ecsBudgetOrganizeService.getOrganizeListDataPermission(query);
        List models = JsonUtil.getJsonToList(list, OrganizeModel.class);
        for (OrganizeModel model : models) {
            if ("department".equals(model.getType())) {
                model.setIcon("icon-ym icon-ym-tree-department1");
                continue;
            }
            if (!"company".equals(model.getType())) continue;
            model.setIcon("icon-ym icon-ym-tree-organization3");
        }
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeDepartSelectorListVO.class);
        if (!CollectionUtil.isEmpty((Collection)listVO)) {
            Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren());
            if (!CollectionUtil.isEmpty(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren())) {
                Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren());
            }
        }
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u667a\u884c\u90e8\u95e8\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/zxUserDepartment/Selector"})
    public ActionResult<ListVO<OrganizeDepartSelectorListVO>> getZxListUserDepartment(@RequestBody EcsBudgetOrganizeListQuery query) {
        List<OrganizeEntity> list = this.ecsBudgetOrganizeService.getZXOrganizeListDataPermission();
        List models = JsonUtil.getJsonToList(list, OrganizeModel.class);
        for (OrganizeModel model : models) {
            if ("department".equals(model.getType())) {
                model.setIcon("icon-ym icon-ym-tree-department1");
                continue;
            }
            if (!"company".equals(model.getType())) continue;
            model.setIcon("icon-ym icon-ym-tree-organization3");
        }
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeDepartSelectorListVO.class);
        if (!CollectionUtil.isEmpty((Collection)listVO)) {
            Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren());
            if (!CollectionUtil.isEmpty(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren())) {
                Collections.sort(((OrganizeDepartSelectorListVO)listVO.get(0)).getChildren().get(0).getChildren());
            }
        }
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/delete"})
    @DSTransactional
    public ActionResult delete(@RequestBody EcsBudgetOrganizeEntity budgetOrganizeEntity) {
        EcsBudgetOrganizeEntity entity = this.ecsBudgetOrganizeService.getInfo(budgetOrganizeEntity.getId(), budgetOrganizeEntity.getYear());
        if (entity != null) {
            this.ecsBudgetOrganizeService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/split"})
    @DSTransactional
    public ActionResult departmentSplit(@RequestBody OrganizeDepartSplitVO splitVO) {
        return this.ecsBudgetOrganizeService.departmentSplit(splitVO);
    }

    @PostMapping(value={"/merge"})
    @DSTransactional
    public ActionResult departmentMerge(@RequestBody OrganizeDepartMergeVO mergeVO) {
        return this.ecsBudgetOrganizeService.departmentMerge(mergeVO);
    }
}

