/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsCompanyAccountEntity;
import com.bringspring.ecs.model.ecscompanyaccount.EcsCompanyAccountCrForm;
import com.bringspring.ecs.model.ecscompanyaccount.EcsCompanyAccountInfoVO;
import com.bringspring.ecs.model.ecscompanyaccount.EcsCompanyAccountListVO;
import com.bringspring.ecs.model.ecscompanyaccount.EcsCompanyAccountPagination;
import com.bringspring.ecs.model.ecscompanyaccount.EcsCompanyAccountUpForm;
import com.bringspring.ecs.service.EcsCompanyAccountService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u516c\u53f8\u4ed8\u6b3e\u8d26\u6237"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsCompanyAccount"})
public class EcsCompanyAccountController {
    private static final Logger log = LoggerFactory.getLogger(EcsCompanyAccountController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsCompanyAccountService ecsCompanyAccountService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsCompanyAccountPagination ecsCompanyAccountPagination) throws IOException {
        List<EcsCompanyAccountEntity> list = this.ecsCompanyAccountService.getList(ecsCompanyAccountPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsCompanyAccountListVO.class);
        for (EcsCompanyAccountListVO ecsCompanyAccountListVO : listVO) {
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsCompanyAccountPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getPayAccList"})
    public ActionResult getPayAccList(@RequestBody EcsCompanyAccountPagination ecsCompanyAccountPagination) {
        return ActionResult.success(this.ecsCompanyAccountService.getPayAccountList(ecsCompanyAccountPagination));
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsCompanyAccountCrForm ecsCompanyAccountCrForm) throws DataException {
        this.ecsCompanyAccountService.create(ecsCompanyAccountCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsCompanyAccountInfoVO> info(@PathVariable(value="id") String id) {
        EcsCompanyAccountEntity entity = this.ecsCompanyAccountService.getInfo(id);
        EcsCompanyAccountInfoVO vo = (EcsCompanyAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsCompanyAccountInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsCompanyAccountInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsCompanyAccountEntity entity = this.ecsCompanyAccountService.getInfo(id);
        EcsCompanyAccountInfoVO vo = (EcsCompanyAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsCompanyAccountInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsCompanyAccountUpForm ecsCompanyAccountUpForm) throws DataException {
        this.ecsCompanyAccountService.update(id, ecsCompanyAccountUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsCompanyAccountEntity entity = this.ecsCompanyAccountService.getInfo(id);
        if (entity != null) {
            this.ecsCompanyAccountService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

