/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.model.ecscompany.EcsCompanyCrForm;
import com.bringspring.ecs.model.ecscompany.EcsCompanyInfoVO;
import com.bringspring.ecs.model.ecscompany.EcsCompanyListVO;
import com.bringspring.ecs.model.ecscompany.EcsCompanyPagination;
import com.bringspring.ecs.model.ecscompany.EcsCompanyPaginationExportModel;
import com.bringspring.ecs.model.ecscompany.EcsCompanyUpForm;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u516c\u53f8\u7ba1\u7406"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsCompany"})
public class EcsCompanyController {
    private static final Logger log = LoggerFactory.getLogger(EcsCompanyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsCompanyPagination ecsCompanyPagination) throws IOException {
        List<EcsCompanyEntity> list = this.ecsCompanyService.getList(ecsCompanyPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsCompanyListVO.class);
        for (EcsCompanyListVO ecsCompanyListVO : listVO) {
            ecsCompanyListVO.setCompanyName(this.baseDataUtil.getDictName(ecsCompanyListVO.getCompanyId(), "ecsCompany"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsCompanyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getAllList"})
    public ActionResult<?> getAllList(@RequestBody EcsCompanyPagination ecsCompanyPagination) throws IOException {
        ecsCompanyPagination.setEnableMark(1);
        List<EcsCompanyListVO> list = this.ecsCompanyService.getCompanyCommonList(ecsCompanyPagination);
        return ActionResult.success(list);
    }

    @PostMapping(value={"/selectList"})
    public ActionResult<?> getlist(@RequestBody EcsCompanyPagination ecsCompanyPagination) throws IOException {
        ecsCompanyPagination.setListQuery("1");
        List<EcsCompanyEntity> list = this.ecsCompanyService.getList(ecsCompanyPagination);
        return ActionResult.success(list);
    }

    @PostMapping(value={"/treeList"})
    public ActionResult<?> treeList(@RequestBody EcsCompanyPagination ecsProjectPagination) {
        List<EcsCompanyListVO> listVO = this.ecsCompanyService.getCompanyCommonList(ecsProjectPagination);
        List collect = listVO.stream().sorted(Comparator.comparing(EcsCompanyListVO::getCommonNum).reversed()).map(entity -> {
            TreeNode treeNode = new TreeNode((Object)entity.getId(), (Object)entity.getParentId(), entity.getName(), null);
            HashMap<String, Object> extraMap = new HashMap<String, Object>();
            extraMap.put("taxId", entity.getTaxId());
            extraMap.put("parentId", entity.getParentId());
            extraMap.put("parentName", entity.getParentName());
            extraMap.put("organization", entity.getOrganization());
            extraMap.put("address", entity.getAddress());
            extraMap.put("phone", entity.getPhone());
            extraMap.put("openBank", entity.getOpenBank());
            extraMap.put("enterpriseAccount", entity.getEnterpriseAccount());
            extraMap.put("useEnterpriseName", entity.getUseEnterpriseName());
            extraMap.put("failureDate", entity.getFailureDate());
            extraMap.put("visualRange", entity.getVisualRange());
            extraMap.put("enableMark", entity.getEnableMark());
            treeNode.setExtra(extraMap);
            return treeNode;
        }).collect(Collectors.toList());
        List build = TreeUtil.build(collect, (Object)"0");
        return ActionResult.success((Object)build);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsCompanyCrForm ecsCompanyCrForm) throws DataException {
        return this.ecsCompanyService.create(ecsCompanyCrForm);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsCompanyInfoVO> info(@PathVariable(value="id") String id) {
        EcsCompanyEntity entity = this.ecsCompanyService.getInfo(id);
        EcsCompanyInfoVO vo = (EcsCompanyInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsCompanyInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsCompanyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsCompanyEntity entity = this.ecsCompanyService.getInfo(id);
        EcsCompanyInfoVO vo = (EcsCompanyInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsCompanyInfoVO.class);
        vo.setOrganization(this.baseDataUtil.getDictName(vo.getOrganization(), "ecsCompany"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsCompanyUpForm ecsCompanyUpForm) throws DataException {
        return this.ecsCompanyService.update(id, ecsCompanyUpForm);
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsCompanyEntity entity = this.ecsCompanyService.getInfo(id);
        if (entity != null) {
            this.ecsCompanyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(EcsCompanyPaginationExportModel ecsCompanyPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)ecsCompanyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        EcsCompanyPagination ecsCompanyPagination = (EcsCompanyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ecsCompanyPaginationExportModel), EcsCompanyPagination.class));
        List<EcsCompanyListVO> listVO = this.ecsCompanyService.getCompanyCommonList(ecsCompanyPagination);
        for (EcsCompanyListVO vo : listVO) {
            vo.setOrganization(this.baseDataUtil.getDictName(vo.getOrganization()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)ecsCompanyPaginationExportModel.getSelectKey()) ? ecsCompanyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "organization": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"organization"));
                        continue block30;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"name"));
                        continue block30;
                    }
                    case "taxId": {
                        entitys.add(new ExcelExportEntity("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Object)"taxId"));
                        continue block30;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u4f01\u4e1a\u5730\u5740", (Object)"address"));
                        continue block30;
                    }
                    case "phone": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u7535\u8bdd", (Object)"phone"));
                        continue block30;
                    }
                    case "openBank": {
                        entitys.add(new ExcelExportEntity("\u5f00\u6237\u884c", (Object)"openBank"));
                        continue block30;
                    }
                    case "enterpriseAccount": {
                        entitys.add(new ExcelExportEntity("\u4f01\u4e1a\u8d26\u53f7", (Object)"enterpriseAccount"));
                        continue block30;
                    }
                    case "useEnterpriseName": {
                        entitys.add(new ExcelExportEntity("\u66fe\u7528\u4f01\u4e1a\u540d\u79f0", (Object)"useEnterpriseName"));
                        continue block30;
                    }
                    case "failureDate": {
                        entitys.add(new ExcelExportEntity("\u66fe\u7528\u4f01\u4e1a\u540d\u5931\u6548\u65f6\u95f4", (Object)"failureDate"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

