/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.hutool.core.lang.tree.Tree;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.model.customer.CustomerInfoVO;
import com.bringspring.ecs.model.hrms.detailcc.HrmsAttendanceGetapprovaldetailCcPagination;
import com.bringspring.ecs.model.oa.fms.SignApplyPagination;
import com.bringspring.ecs.model.relationcc.EcsRecordsRelationCcInfoVO;
import com.bringspring.ecs.service.EcsExtendService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ecs/extend"})
public class EcsExtendController {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsExtendService ecsExtendService;

    @PostMapping(value={"/getTravelApplyList"})
    public ActionResult<?> getTravelApplyList(@RequestBody HrmsAttendanceGetapprovaldetailCcPagination pagination) {
        String userId = this.userProvider.get().getUserId();
        List<EcsRecordsRelationCcInfoVO> list = this.ecsExtendService.getListByUserId(userId, pagination);
        PageListVO vo = new PageListVO();
        vo.setList(list);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getProvinceTree"})
    public ActionResult<?> getProvinceList() {
        List<Tree<String>> list = this.ecsExtendService.getProvinceTree();
        return ActionResult.success(list);
    }

    @GetMapping(value={"/getFullPathByAreaId"})
    public ActionResult<?> getFullPathByAreaId(String areaId) {
        List<String> fullPath = this.ecsExtendService.getFullPathByAreaId(areaId);
        return ActionResult.success(fullPath);
    }

    @GetMapping(value={"/getUserForReimbUserIds"})
    public ActionResult<?> getUserForReimbUserIds() {
        List<String> list = this.ecsExtendService.getUserForReimbUserIds();
        return ActionResult.success(list);
    }

    @GetMapping(value={"/getCbspList"})
    public ActionResult<?> getCbspList(SignApplyPagination pagination) {
        List<Tree<String>> list = this.ecsExtendService.getCbspList(pagination);
        return ActionResult.success(list);
    }

    @GetMapping(value={"/getCustomerList"})
    public ActionResult<?> getCustomerList(String companyId, String customerName) {
        if (companyId == null || companyId.isEmpty()) {
            companyId = this.userProvider.get().getOrganizeId();
        }
        List<CustomerInfoVO> list = this.ecsExtendService.getCustomerList(companyId, customerName);
        return ActionResult.success(list);
    }
}

