/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.invoice.EcsInvoicePagination;
import com.bringspring.ecs.model.invoice.EcsInvoicePaginationExportModel;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ecs/EcsInvoice"})
public class EcsInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(EcsInvoiceController.class);
    @Autowired
    private EcsInvoiceService invoiceService;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @PostMapping(value={"getList"})
    public ActionResult<?> getList(@RequestBody EcsInvoicePagination ecsInvoicePagination) {
        List<EcsInvoiceEntity> list = this.invoiceService.getList(ecsInvoicePagination);
        List jsonToList = JsonUtil.getJsonToList(list, EcsInvoiceInfoVO.class);
        HashSet<String> recordIds = new HashSet<String>();
        for (EcsInvoiceInfoVO ecsInvoiceEntity : jsonToList) {
            recordIds.add(ecsInvoiceEntity.getRecordId());
        }
        if (CollUtil.isNotEmpty(recordIds)) {
            List recordsList = this.recordsService.listByIds(recordIds);
            Map<String, EcsRecordsEntity> collect = recordsList.stream().collect(Collectors.toMap(EcsRecordsEntity::getId, a -> a));
            for (EcsInvoiceInfoVO infoVO : jsonToList) {
                EcsRecordsEntity entity = collect.get(infoVO.getRecordId());
                if (entity == null) continue;
                FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)entity.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus, FlowTaskEntity::getFlowCode, FlowTaskEntity::getFlowId});
                if (flowTaskEntity != null) {
                    infoVO.setFlowState(flowTaskEntity.getStatus());
                    infoVO.setFlowId(flowTaskEntity.getFlowId());
                    infoVO.setEnCode(flowTaskEntity.getEnCode());
                }
                infoVO.setRecordReimbNumber(entity.getOrderNumber());
                infoVO.setRecordReimbDate(DateUtil.formatDate((Date)entity.getCreatorTime()));
                infoVO.setRecordReimbUserId(entity.getUserId());
                infoVO.setRecordReimbUserName(this.baseDataUtil.userSelectValue(entity.getUserId()));
                infoVO.setRecordStatus(entity.getAuditStatus());
                infoVO.setRecordStatusName(this.baseDataUtil.getDictName(entity.getAuditStatus(), "EcsRecordStatus"));
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(jsonToList);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsInvoicePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"pdfToImage"})
    public ActionResult<?> pdfToImage(@RequestBody Map<String, String> data) throws IOException {
        String url = data.get("url");
        BufferedImage image = this.invoiceService.pdfToImage(url);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", outputStream);
        String s = Base64Utils.encodeToString((byte[])outputStream.toByteArray());
        return ActionResult.success((String)"\u6210\u529f", (Object)s);
    }

    @NotCheckLogin
    @PostMapping(value={"/validate"})
    @DSTransactional
    public ActionResult<?> validate(@RequestBody Map<String, Object> data) throws Exception {
        EcsInvoiceInfoVO infoVO1 = this.invoiceService.recognizeInvoice(data);
        return ActionResult.success((Object)infoVO1);
    }

    @PostMapping(value={"/manualCreate"})
    @DSTransactional
    public ActionResult<?> manualCreate(@RequestBody Map<String, Object> data) throws Exception {
        EcsInvoiceInfoVO infoVO1 = this.invoiceService.manualCreate(data);
        return ActionResult.success((Object)infoVO1);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsInvoiceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsInvoiceEntity entity = (EcsInvoiceEntity)this.invoiceService.getById((Serializable)((Object)id));
        EcsInvoiceInfoVO vo = (EcsInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsInvoiceInfoVO.class);
        EcsRecordsEntity byId = (EcsRecordsEntity)this.recordsService.getById((Serializable)((Object)vo.getRecordId()));
        if (!Objects.isNull(byId)) {
            vo.setRecordReimbUserId(this.baseDataUtil.userSelectValue(byId.getUserId()));
            vo.setRecordStatus(byId.getAuditStatus());
            vo.setRecordStatusName(this.baseDataUtil.getDictName(byId.getAuditStatus(), "EcsRecordStatus"));
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/Actions/Export"})
    public ActionResult<?> export(EcsInvoicePaginationExportModel exportModel) {
        DownloadVO export = this.invoiceService.export(exportModel);
        return ActionResult.success((Object)export);
    }

    @PostMapping(value={"/receiveInvoice"})
    public ActionResult<?> receiveInvoice(@RequestBody Map<String, Object> data) throws Exception {
        this.invoiceService.receiveInvoice(data);
        return ActionResult.success();
    }
}

