/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.ecs.model.invoicerecord.EcsInvoiceRecordConfirmVO;
import com.bringspring.ecs.model.invoicerecord.EcsInvoiceRecordInfoVO;
import com.bringspring.ecs.service.EcsInvoiceRecordService;
import io.swagger.annotations.Api;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"ecs_invoice_record"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsInvoiceRecord"})
public class EcsInvoiceRecordController {
    private static final Logger log = LoggerFactory.getLogger(EcsInvoiceRecordController.class);
    @Autowired
    private EcsInvoiceRecordService invoiceRecordService;

    @GetMapping(value={"/getReceiveInvoiceList/{id}"})
    public ActionResult<?> getReceiveInvoiceList(@PathVariable(value="id") String id) {
        List<EcsInvoiceRecordInfoVO> list = this.invoiceRecordService.getReceiveInvoiceList(id);
        return ActionResult.success(list);
    }

    @PostMapping(value={"/confirmReceiveInvoice"})
    public ActionResult<?> confirmReceiveInvoice(@RequestBody EcsInvoiceRecordConfirmVO confirmVO) {
        this.invoiceRecordService.confirmReceiveInvoice(confirmVO);
        return ActionResult.success();
    }

    @PostMapping(value={"/batchReceiveInvoice"})
    @DSTransactional
    public ActionResult<?> batchReceiveInvoice(@RequestBody List<String> recordIds) {
        this.invoiceRecordService.batchReceiveInvoice(recordIds);
        return ActionResult.success((String)"\u6279\u91cf\u6536\u7968\u6210\u529f");
    }
}

