/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.entity.EcsInvoiceRuleEntity;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRuleCrForm;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRuleInfoVO;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRuleListVO;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRulePagination;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRuleUpForm;
import com.bringspring.ecs.service.EcsInvoiceRuleService;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.annotation.ValidateServiceScanner;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"ecs_invoice_rule"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsInvoiceRule"})
public class EcsInvoiceRuleController {
    private static final Logger log = LoggerFactory.getLogger(EcsInvoiceRuleController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsInvoiceRuleService ecsInvoiceRuleService;
    @Autowired
    private ValidateServiceScanner validateServiceScanner;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsInvoiceRulePagination ecsInvoiceRulePagination) throws IOException {
        List<EcsInvoiceRuleEntity> list = this.ecsInvoiceRuleService.getList(ecsInvoiceRulePagination);
        List listVO = JsonUtil.getJsonToList(list, EcsInvoiceRuleListVO.class);
        for (EcsInvoiceRuleListVO ecsInvoiceRuleListVO : listVO) {
            ecsInvoiceRuleListVO.setCompanyId(this.baseDataUtil.comSelectValues(ecsInvoiceRuleListVO.getCompanyId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsInvoiceRulePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getCompanyRule"})
    public ActionResult<?> getCompanyRule(@RequestBody EcsInvoiceRulePagination ecsInvoiceRulePagination) throws IOException {
        List<EcsInvoiceRuleEntity> companyRuleList = this.ecsInvoiceRuleService.getCompanyRuleList(ecsInvoiceRulePagination);
        return ActionResult.success(companyRuleList);
    }

    @PostMapping
    @DSTransactional
    public ActionResult<?> create(@RequestBody @Valid EcsInvoiceRuleCrForm ecsInvoiceRuleCrForm) throws DataException {
        this.ecsInvoiceRuleService.create(ecsInvoiceRuleCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/getValidateServices"})
    public ActionResult<?> getValidateServices() {
        List<Class<?>> annotatedClasses = this.validateServiceScanner.getAnnotatedClasses();
        ArrayList classNames = new ArrayList();
        for (Class<?> clazz : annotatedClasses) {
            ValidateService annotation = clazz.getAnnotation(ValidateService.class);
            if (!ValidateCustomizableType.YES.equals((Object)annotation.customizableType())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", clazz.getSimpleName());
            map.put("name", annotation.value());
            classNames.add(map);
        }
        return ActionResult.success(classNames);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsInvoiceRuleInfoVO> info(@PathVariable(value="id") String id) {
        EcsInvoiceRuleEntity entity = this.ecsInvoiceRuleService.getInfo(id);
        EcsInvoiceRuleInfoVO vo = (EcsInvoiceRuleInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsInvoiceRuleInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsInvoiceRuleInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsInvoiceRuleEntity entity = this.ecsInvoiceRuleService.getInfo(id);
        EcsInvoiceRuleInfoVO vo = (EcsInvoiceRuleInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsInvoiceRuleInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> update(@PathVariable(value="id") String id, @RequestBody @Valid EcsInvoiceRuleUpForm ecsInvoiceRuleUpForm) throws DataException {
        this.ecsInvoiceRuleService.update(id, ecsInvoiceRuleUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> delete(@PathVariable(value="id") String id) {
        EcsInvoiceRuleEntity entity = this.ecsInvoiceRuleService.getInfo(id);
        if (entity != null) {
            this.ecsInvoiceRuleService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

