/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBudgetAccountEntity;
import com.bringspring.ecs.entity.EcsPlatformAccountMappingEntity;
import com.bringspring.ecs.entity.EcsPlatformMappingRecordsEntity;
import com.bringspring.ecs.model.ecsplatformaccountmapping.EcsPlatformAccountMappingCrForm;
import com.bringspring.ecs.model.ecsplatformaccountmapping.EcsPlatformAccountMappingInfoVO;
import com.bringspring.ecs.model.ecsplatformaccountmapping.EcsPlatformAccountMappingListVO;
import com.bringspring.ecs.model.ecsplatformaccountmapping.EcsPlatformAccountMappingPagination;
import com.bringspring.ecs.model.ecsplatformaccountmapping.EcsPlatformAccountMappingUpForm;
import com.bringspring.ecs.model.ecsplatformaccountmapping.EcsPlatformAccountMappingimportVO;
import com.bringspring.ecs.service.EcsBudgetAccountService;
import com.bringspring.ecs.service.EcsPlatformAccountMappingService;
import com.bringspring.ecs.service.EcsPlatformMappingRecordsService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u79d1\u76ee\u6570\u636e\u5bf9\u7167"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsPlatformAccountMapping"})
public class EcsPlatformAccountMappingController {
    private static final Logger log = LoggerFactory.getLogger(EcsPlatformAccountMappingController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsPlatformAccountMappingService ecsPlatformAccountMappingService;
    @Autowired
    private EcsPlatformMappingRecordsService platformMappingRecordsService;
    @Autowired
    private EcsBudgetAccountService ecsBudgetAccountService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsPlatformAccountMappingPagination ecsPlatformAccountMappingPagination) throws IOException {
        List<EcsPlatformAccountMappingEntity> list = this.ecsPlatformAccountMappingService.getList(ecsPlatformAccountMappingPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsPlatformAccountMappingListVO.class);
        for (EcsPlatformAccountMappingListVO ecsPlatformAccountMappingListVO : listVO) {
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsPlatformAccountMappingPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsPlatformAccountMappingCrForm ecsPlatformAccountMappingCrForm) throws DataException {
        this.ecsPlatformAccountMappingService.create(ecsPlatformAccountMappingCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsPlatformAccountMappingInfoVO> info(@PathVariable(value="id") String id) {
        EcsPlatformAccountMappingEntity entity = this.ecsPlatformAccountMappingService.getInfo(id);
        EcsPlatformAccountMappingInfoVO vo = (EcsPlatformAccountMappingInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPlatformAccountMappingInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsPlatformAccountMappingInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsPlatformAccountMappingEntity entity = this.ecsPlatformAccountMappingService.getInfo(id);
        EcsPlatformAccountMappingInfoVO vo = (EcsPlatformAccountMappingInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPlatformAccountMappingInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsPlatformAccountMappingUpForm ecsPlatformAccountMappingUpForm) throws DataException {
        this.ecsPlatformAccountMappingService.update(id, ecsPlatformAccountMappingUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsPlatformAccountMappingEntity entity = this.ecsPlatformAccountMappingService.getInfo(id);
        if (entity != null) {
            this.ecsPlatformAccountMappingService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/import"})
    public ActionResult<?> importData(@RequestParam String companyId, @RequestParam(value="file") MultipartFile file) {
        ImportParams params = new ImportParams();
        params.setHeadRows(1);
        try {
            byte[] bytes = file.getBytes();
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
                Sheet sheet = workbook.getSheetAt(0);
                this.processMergedCells(sheet);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                workbook.write((OutputStream)bos);
                bytes = bos.toByteArray();
            }
            throwable = null;
            try (ByteArrayInputStream importInputStream = new ByteArrayInputStream(bytes);){
                List list = ExcelImportUtil.importExcel((InputStream)importInputStream, EcsPlatformAccountMappingimportVO.class, (ImportParams)params);
                List deptList = this.platformMappingRecordsService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsPlatformMappingRecordsEntity::getCompanyId, (Object)companyId)).eq(EcsPlatformMappingRecordsEntity::getType, (Object)"dept"));
                Map<String, EcsPlatformMappingRecordsEntity> deptMap = deptList.stream().collect(Collectors.toMap(EcsPlatformMappingRecordsEntity::getTargetCode, entity -> entity, (existing, replacement) -> existing));
                List accountEntities = this.ecsBudgetAccountService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAccountEntity::getYear, (Object)"2025"));
                List filteredEntities = accountEntities.stream().filter(entity -> !entity.getParentId().equals("-1")).collect(Collectors.toList());
                Map<String, EcsBudgetAccountEntity> accountEntityMap = filteredEntities.stream().collect(Collectors.toMap(EcsBudgetAccountEntity::getFullName, entity -> entity, (existing, replacement) -> existing));
                ArrayList arrayList = new ArrayList();
                list.forEach(o -> {
                    String ncDeptCode = o.getNcDeptCode();
                    EcsPlatformMappingRecordsEntity recordsEntity = (EcsPlatformMappingRecordsEntity)deptMap.get(ncDeptCode);
                    if (recordsEntity == null) {
                        return;
                    }
                    EcsBudgetAccountEntity accountEntity = (EcsBudgetAccountEntity)accountEntityMap.get(o.getAccountName());
                    if (accountEntity == null) {
                        return;
                    }
                    EcsPlatformAccountMappingEntity accountMappingEntity = new EcsPlatformAccountMappingEntity();
                    BeanUtil.copyProperties((Object)o, (Object)accountMappingEntity, (String[])new String[0]);
                    accountMappingEntity.setAccountCode(accountEntity.getEnCode());
                    accountMappingEntity.setId(RandomUtil.uuId());
                    accountMappingEntity.setDeptRecordId(recordsEntity.getId());
                    accountMappingEntity.setDeptRecordName(recordsEntity.getTargetName());
                    arrayList.add(accountMappingEntity);
                });
                this.ecsPlatformAccountMappingService.saveBatch(arrayList);
                ActionResult actionResult = ActionResult.success();
                return actionResult;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    private void processMergedCells(Sheet sheet) {
        ArrayList mergedRegions = new ArrayList(sheet.getMergedRegions());
        for (CellRangeAddress mergedRegion : mergedRegions) {
            Row firstRow = sheet.getRow(mergedRegion.getFirstRow());
            Cell firstCell = firstRow.getCell(mergedRegion.getFirstColumn());
            String mergedValue = firstCell.toString();
            sheet.removeMergedRegion(mergedRegions.indexOf(mergedRegion));
            for (int rowNum = mergedRegion.getFirstRow(); rowNum <= mergedRegion.getLastRow(); ++rowNum) {
                Row currentRow = sheet.getRow(rowNum) != null ? sheet.getRow(rowNum) : sheet.createRow(rowNum);
                for (int colNum = mergedRegion.getFirstColumn(); colNum <= mergedRegion.getLastColumn(); ++colNum) {
                    Cell currentCell = currentRow.getCell(colNum) != null ? currentRow.getCell(colNum) : currentRow.createCell(colNum);
                    currentCell.setCellValue(mergedValue);
                }
            }
        }
    }
}

