/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.lang.tree.TreeNode;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsPlatformMappingEntity;
import com.bringspring.ecs.entity.SyncEntity;
import com.bringspring.ecs.model.ecsplatformmapping.EcsPlatformMappingCrForm;
import com.bringspring.ecs.model.ecsplatformmapping.EcsPlatformMappingInfoVO;
import com.bringspring.ecs.model.ecsplatformmapping.EcsPlatformMappingListVO;
import com.bringspring.ecs.model.ecsplatformmapping.EcsPlatformMappingPagination;
import com.bringspring.ecs.model.ecsplatformmapping.EcsPlatformMappingUpForm;
import com.bringspring.ecs.service.EcsPlatformMappingService;
import com.bringspring.ecs.utils.TreeEntry;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u6570\u636e\u6620\u5c04"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsPlatformMapping"})
public class EcsPlatformMappingController {
    private static final Logger log = LoggerFactory.getLogger(EcsPlatformMappingController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsPlatformMappingService ecsPlatformMappingService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsPlatformMappingPagination ecsPlatformMappingPagination) throws IOException {
        List<EcsPlatformMappingEntity> list = this.ecsPlatformMappingService.getList(ecsPlatformMappingPagination);
        for (EcsPlatformMappingEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, EcsPlatformMappingListVO.class);
        for (EcsPlatformMappingListVO ecsPlatformMappingListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsPlatformMappingPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/treeList"})
    public ActionResult<?> treeList(@RequestBody EcsPlatformMappingPagination ecsPlatformMappingPagination) {
        List<EcsPlatformMappingEntity> entityList = this.ecsPlatformMappingService.getTypeList(ecsPlatformMappingPagination, "1");
        HashMap sourceIdToDbIdMap = new HashMap(entityList.size());
        HashMap dbIdToSourceIdMap = new HashMap(entityList.size());
        HashMap dbIdEntityMap = new HashMap(entityList.size());
        entityList.forEach(entity -> {
            String dbId = entity.getId();
            String sourceId = entity.getSourceId();
            sourceIdToDbIdMap.put(sourceId, dbId);
            dbIdToSourceIdMap.put(dbId, sourceId);
            dbIdEntityMap.put(dbId, entity);
        });
        List<TreeNode<String>> nodeList = entityList.stream().map(entity -> {
            TreeNode node = new TreeNode();
            node.setId((Object)entity.getId());
            node.setName((CharSequence)entity.getSourceName());
            LinkedHashMap<String, String> extra = new LinkedHashMap<String, String>();
            extra.put("sourceId", entity.getSourceId());
            extra.put("sourceCode", entity.getSourceCode());
            extra.put("sourceName", entity.getSourceName());
            extra.put("type", entity.getType());
            extra.put("originalParentId", entity.getParentId());
            node.setExtra(extra);
            String parentId = this.resolveParentId((EcsPlatformMappingEntity)entity, sourceIdToDbIdMap, dbIdToSourceIdMap);
            node.setParentId((Object)parentId);
            return node;
        }).collect(Collectors.toList());
        List<TreeEntry<String>> treeStructure = this.buildFullTree(nodeList);
        return ActionResult.success(treeStructure);
    }

    private String resolveParentId(EcsPlatformMappingEntity entity, Map<String, String> sourceIdToDbIdMap, Map<String, String> dbIdToSourceIdMap) {
        String originalParentId = entity.getParentId();
        if ("-1".equals(originalParentId) || "0".equals(originalParentId)) {
            return "-1";
        }
        if (dbIdToSourceIdMap.containsKey(originalParentId)) {
            return originalParentId;
        }
        String mappedDbId = sourceIdToDbIdMap.get(originalParentId);
        if (mappedDbId != null) {
            return mappedDbId;
        }
        if (this.isRootBusinessNode(entity)) {
            return "-1";
        }
        log.warn("\u65e0\u6cd5\u786e\u5b9a\u7236\u8282\u70b9\u7684\u5b9e\u4f53: ID={}, SourceID={}, ParentID={}", new Object[]{entity.getId(), entity.getSourceId(), originalParentId});
        return "-1";
    }

    private List<TreeEntry<String>> buildFullTree(List<TreeNode<String>> nodes) {
        LinkedHashMap<String, TreeEntry> nodeMap = new LinkedHashMap<String, TreeEntry>();
        HashMap parentChildMap = new HashMap();
        nodes.forEach(treeNode -> {
            TreeEntry<Object> tree = new TreeEntry<Object>();
            tree.setId(treeNode.getId());
            tree.setParentId(treeNode.getParentId());
            tree.setName(treeNode.getName());
            tree.setExtra(treeNode.getExtra());
            nodeMap.put(tree.getId().toString(), tree);
            parentChildMap.computeIfAbsent(tree.getParentId().toString(), k -> new ArrayList()).add(tree);
        });
        ArrayList<TreeEntry<String>> roots = new ArrayList<TreeEntry<String>>();
        nodeMap.forEach((nodeId, treeNode) -> {
            String parentId = (String)treeNode.getParentId();
            if ("-1".equals(parentId)) {
                roots.add((TreeEntry<String>)treeNode);
            } else {
                TreeEntry parent = (TreeEntry)nodeMap.get(parentId);
                if (parent != null) {
                    if (parent.getChildren() == null) {
                        parent.setChildren(new ArrayList());
                    }
                    parent.getChildren().add(treeNode);
                } else {
                    log.warn("\u6e38\u79bb\u8282\u70b9: {} -> {}", (Object)parentId, nodeId);
                }
            }
        });
        roots.sort(Comparator.comparing(TreeEntry::getId));
        parentChildMap.values().forEach(list -> list.sort(Comparator.comparing(TreeEntry::getId)));
        return roots;
    }

    private boolean isRootBusinessNode(EcsPlatformMappingEntity entity) {
        return "1".equals(entity.getParentId()) || "rongke".equals(entity.getSourceCode());
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsPlatformMappingCrForm ecsPlatformMappingCrForm) throws DataException {
        this.ecsPlatformMappingService.create(ecsPlatformMappingCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsPlatformMappingInfoVO> info(@PathVariable(value="id") String id) {
        EcsPlatformMappingEntity entity = this.ecsPlatformMappingService.getInfo(id);
        EcsPlatformMappingInfoVO vo = (EcsPlatformMappingInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPlatformMappingInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsPlatformMappingInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsPlatformMappingEntity entity = this.ecsPlatformMappingService.getInfo(id);
        EcsPlatformMappingInfoVO vo = (EcsPlatformMappingInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsPlatformMappingInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsPlatformMappingUpForm ecsPlatformMappingUpForm) throws DataException {
        this.ecsPlatformMappingService.update(id, ecsPlatformMappingUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsPlatformMappingEntity entity = this.ecsPlatformMappingService.getInfo(id);
        if (entity != null) {
            this.ecsPlatformMappingService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/import"})
    public ActionResult<?> importData(@RequestParam String importType, @RequestParam String companyId, @RequestParam(value="file") MultipartFile file) {
        ImportParams params = new ImportParams();
        params.setHeadRows(1);
        try {
            List data = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SyncEntity.class, (ImportParams)params);
            this.ecsPlatformMappingService.syncNcData(companyId, importType, data);
            return ActionResult.success();
        }
        catch (Exception e) {
            return null;
        }
    }

    @GetMapping(value={"/syncData"})
    public ActionResult<?> syncData() {
        this.ecsPlatformMappingService.getBaseDataList();
        return ActionResult.success();
    }
}

