/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.docking.enums.PayStateEnums;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.VoucherPushStateEnum;
import com.bringspring.ecs.model.bankcard.EcsBankCardInfoVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.model.records.EcsRecordsCrForm;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.model.records.EcsRecordsPagination;
import com.bringspring.ecs.model.records.EcsRecordsPaginationExportModel;
import com.bringspring.ecs.model.records.EcsRecordsPaymentVO;
import com.bringspring.ecs.model.records.EcsRecordsUpForm;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d39\u63a7\u62a5\u9500\u8bb0\u5f55\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsRecords"})
public class EcsRecordsController {
    private static final Logger log = LoggerFactory.getLogger(EcsRecordsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsRecordsService ecsRecordsService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private EcsBankCardService ecsBankCardService;
    @Autowired
    private EcsPaymentRecordsService paymentRecordsService;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsRecordsPagination ecsRecordsPagination) throws IOException, WorkFlowException {
        String userId = this.userProvider.get().getUserId();
        List<EcsRecordsEntity> list = this.ecsRecordsService.getList(ecsRecordsPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsRecordsInfoVO.class);
        for (EcsRecordsInfoVO infoVO : listVO) {
            EcsBankCardEntity bankCard;
            infoVO.setUserId(this.baseDataUtil.userSelectValue(infoVO.getUserId()));
            infoVO.setOrganization(this.baseDataUtil.comSelectValues(infoVO.getOrganization()));
            infoVO.setCompanyName(this.baseDataUtil.comSelectValues(infoVO.getCompanyId()));
            infoVO.setReimbCompanyName(this.ecsCompanyService.getNameById(infoVO.getReimbCompany()));
            infoVO.setCreatorUserName(this.baseDataUtil.userSelectValue(infoVO.getCreatorUserId()));
            infoVO.setAuditStatusName(this.baseDataUtil.getDictName(infoVO.getAuditStatus(), "EcsRecordStatus"));
            FlowTaskEntity flowTaskEntity = this.flowTaskService.getDraftTaskByProcessId(infoVO.getId());
            if (flowTaskEntity != null) {
                FlowTaskNodeEntity flowTaskNode = (FlowTaskNodeEntity)this.flowTaskNodeService.getById((Serializable)((Object)flowTaskEntity.getThisStepId()));
                String taskOperatorId = "";
                if (flowTaskNode != null) {
                    List operatorEntities = this.flowTaskOperatorService.getListByNode(flowTaskEntity.getId(), flowTaskNode.getId());
                    for (FlowTaskOperatorEntity operatorEntity : operatorEntities) {
                        if (!userId.equals(operatorEntity.getHandleId())) continue;
                        taskOperatorId = operatorEntity.getId();
                    }
                }
                infoVO.setTaskId(flowTaskEntity.getId());
                infoVO.setTaskNodeId(flowTaskEntity.getThisStepId());
                infoVO.setTaskOperatorId(taskOperatorId);
                infoVO.setFlowState(flowTaskEntity.getStatus());
                infoVO.setFlowId(flowTaskEntity.getFlowId());
                infoVO.setEnCode(flowTaskEntity.getFlowCode());
            }
            if ((bankCard = (EcsBankCardEntity)this.ecsBankCardService.getById((Serializable)((Object)infoVO.getBankCardId()))) != null) {
                infoVO.setBankCardInfo((EcsBankCardInfoVO)JsonUtil.getJsonToBean((Object)bankCard, EcsBankCardInfoVO.class));
            }
            EcsPaymentRecordsEntity recordsEntity = (EcsPaymentRecordsEntity)this.paymentRecordsService.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsPaymentRecordsEntity::getSourceId, (Object)infoVO.getId()));
            infoVO.setPayVoucherStatus("\u672a\u63a8\u9001");
            if (recordsEntity != null) {
                if (recordsEntity.getPayState().equals(PayStateEnums.PYSTAT_04.getCode())) {
                    infoVO.setReceipetStatus("1");
                    infoVO.setPayVoucherStatus(VoucherPushStateEnum.getDescByCode(recordsEntity.getPayVoucherStatus()));
                    infoVO.setPayVoucherNum(recordsEntity.getPayVoucherNum());
                    infoVO.setPayVoucherTime(recordsEntity.getPayVoucherTime());
                } else if (recordsEntity.getPayState().equals(PayStateEnums.PYSTAT_02.getCode())) {
                    infoVO.setReceipetStatus("0");
                }
            } else {
                infoVO.setReceipetStatus("2");
            }
            infoVO.setCostVoucherStatus(VoucherPushStateEnum.getDescByCode(infoVO.getCostVoucherStatus()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsRecordsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countByState"})
    public ActionResult<?> countByEnabledMark(@RequestBody EcsRecordsPagination ecsRecordsPagination) {
        List<Map<String, Object>> maps = this.ecsRecordsService.countByState(ecsRecordsPagination);
        return ActionResult.success(maps);
    }

    @PostMapping(value={"/getSummaryInformation"})
    public ActionResult<?> getSummaryInformation(@RequestBody EcsRecordsPagination ecsRecordsPagination) {
        Map<String, Object> maps = this.ecsRecordsService.getSummaryInformation(ecsRecordsPagination);
        return ActionResult.success(maps);
    }

    @GetMapping(value={"/getNewOrderNumber"})
    public ActionResult<?> getNewOrderNumber() {
        try {
            String ecsReimb = this.baseDataUtil.getBillNumber("ecsReimb", Boolean.valueOf(false));
            return ActionResult.success((Object)ecsReimb);
        }
        catch (DataException e) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5355\u636e\u7f16\u53f7\u5931\u8d25");
        }
    }

    @PostMapping
    @DSTransactional
    public ActionResult<?> create(@RequestBody @Valid EcsRecordsCrForm crForm) throws DataException, WorkFlowException {
        String mainId = RandomUtil.uuId();
        this.ecsRecordsService.create(mainId, crForm);
        FlowUtil.saveOrSubmit((String)crForm.getTaskId(), (String)crForm.getFlowId(), (String)crForm.getTemplateId(), (String)mainId, (Object)((Object)crForm), (Integer)crForm.getStatus(), (String)crForm.getTitle());
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f", (Object)((Object)crForm));
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsRecordsInfoVO> info(@PathVariable(value="id") String id) {
        EcsRecordsEntity entity = this.ecsRecordsService.getInfo(id);
        EcsRecordsInfoVO vo = (EcsRecordsInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsRecordsInfoVO.class);
        this.ecsRecordsService.getRecordsSubjectInfo(vo);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsRecordsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsRecordsEntity entity = this.ecsRecordsService.getInfo(id);
        EcsRecordsInfoVO vo = (EcsRecordsInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsRecordsInfoVO.class);
        vo.setOrganization(this.baseDataUtil.comSelectValues(vo.getOrganization()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> update(@PathVariable(value="id") String id, @RequestBody @Valid EcsRecordsUpForm upForm) throws DataException, WorkFlowException {
        this.ecsRecordsService.update(id, upForm);
        FlowTaskEntity draftTaskByProcessId = this.flowTaskService.getDraftTaskByProcessId(id);
        String taskId = null;
        if (draftTaskByProcessId != null) {
            taskId = draftTaskByProcessId.getId();
        }
        FlowUtil.saveOrSubmit((String)taskId, (String)upForm.getFlowId(), (String)upForm.getTemplateId(), (String)id, (Object)((Object)upForm), (Integer)upForm.getStatus(), (String)upForm.getTitle());
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> delete(@PathVariable(value="id") String id) {
        EcsRecordsEntity entity = this.ecsRecordsService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getFlowId, FlowTaskEntity::getFlowCode, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    log.error("\u5220\u9664\u6d41\u7a0b\u5931\u8d25", (Throwable)e);
                }
            }
            this.ecsRecordsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/batchReview"})
    @DSTransactional
    public ActionResult<?> batchReview(@RequestBody List<String> ids) throws DataException {
        this.ecsRecordsService.batchReview(ids);
        return ActionResult.success((String)"\u63d0\u4ea4\u4ed8\u6b3e\u590d\u6838\u6210\u529f");
    }

    @PostMapping(value={"/batchReviewPayment"})
    @DSTransactional
    public ActionResult<?> batchReviewPayment(@RequestBody EcsRecordsPaymentVO paymentVO) {
        return this.ecsRecordsService.batchReviewPayment(paymentVO);
    }

    @PostMapping(value={"/batchVoucher"})
    @DSTransactional
    public ActionResult<?> batchVoucher(@RequestBody List<String> ids) throws DataException {
        this.ecsRecordsService.batchVoucher(ids);
        return ActionResult.success((String)"\u63d0\u4ea4\u5236\u5355\u6210\u529f");
    }

    @PostMapping(value={"/refreshPay"})
    @DSTransactional
    public ActionResult<?> batchPay() {
        this.ecsRecordsService.refreshPayStateOrReceipt();
        return ActionResult.success();
    }

    @GetMapping(value={"/generatePDF/{id}"})
    public ActionResult<?> generatePDF(@PathVariable(value="id") String id) {
        DownloadVO downloadVO = this.ecsRecordsService.generatePDF(id);
        return ActionResult.success((Object)downloadVO);
    }

    @GetMapping(value={"/getRecordPDF/{id}"})
    public ActionResult<?> getRecordPDF(@PathVariable(value="id") String id) {
        EcsUploadVO downloadVO = this.ecsRecordsService.getRecordPDF(id);
        return ActionResult.success((Object)Lists.newArrayList((Object[])new EcsUploadVO[]{downloadVO}));
    }

    @PostMapping(value={"/paymentAmount/{id}"})
    public ActionResult<?> paymentAmount(@PathVariable(value="id") String id) {
        this.ecsRecordsService.paymentAmount(id);
        return ActionResult.success((String)"\u4ed8\u6b3e\u6210\u529f");
    }

    @GetMapping(value={"/leave/count"})
    public ActionResult<?> leaveCount(String userId, String year, String recordType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userId, year, recordType})) {
            return ActionResult.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = this.ecsRecordsService.leaveCount(userId, year, recordType);
        return ActionResult.success((Object)count);
    }

    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody EcsRecordsPaginationExportModel exportModel) throws IOException {
        if (StringUtil.isEmpty((String)exportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        try {
            DownloadVO vo = this.ecsRecordsService.exportExcel(exportModel);
            return ActionResult.success((Object)vo);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            return ActionResult.fail((String)"\u5bfc\u51fa\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getApprovedByOrganization/{type}"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult<?> getApprovedByCode(String taskId, String taskNodeId, String createUserId, @PathVariable Integer type) {
        type = type == null || type <= 0 ? 1 : type;
        Map<String, Object> map = this.ecsRecordsService.getApprovedByCode(taskId, type);
        return ActionResult.success(map);
    }

    @GetMapping(value={"/getApprovedByUser/{type}"})
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public ActionResult<?> getApprovedByUser(String taskId, String taskNodeId, String createUserId, @PathVariable Integer type) {
        type = type == null || type <= 0 ? 1 : type;
        Map<String, Object> map = this.ecsRecordsService.getApprovedByUser(taskId, type);
        return ActionResult.success(map);
    }
}

