/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsReimbStandardEntity;
import com.bringspring.ecs.entity.EcsReimbStandardRelationEntity;
import com.bringspring.ecs.enums.StandardTypeEnum;
import com.bringspring.ecs.model.standard.EcsReimbStandardCrForm;
import com.bringspring.ecs.model.standard.EcsReimbStandardInfoVO;
import com.bringspring.ecs.model.standard.EcsReimbStandardListVO;
import com.bringspring.ecs.model.standard.EcsReimbStandardPagination;
import com.bringspring.ecs.model.standard.EcsReimbStandardUpForm;
import com.bringspring.ecs.service.EcsReimbStandardService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d39\u63a7\u62a5\u9500\u6807\u51c6\u7ba1\u7406\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsReimbStandard"})
public class EcsReimbStandardController {
    private static final Logger log = LoggerFactory.getLogger(EcsReimbStandardController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsReimbStandardService ecsReimbStandardService;
    @Autowired
    private ProvinceService provinceService;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsReimbStandardPagination ecsReimbStandardPagination) throws IOException {
        List<EcsReimbStandardEntity> list = this.ecsReimbStandardService.getList(ecsReimbStandardPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsReimbStandardListVO.class);
        ArrayList<String> idList = new ArrayList<String>();
        for (EcsReimbStandardListVO vo : listVO) {
            idList.add(vo.getId());
        }
        List<EcsReimbStandardRelationEntity> relations = this.ecsReimbStandardService.getRelationList(idList);
        Map<String, List<EcsReimbStandardRelationEntity>> listMap = relations.stream().collect(Collectors.groupingBy(EcsReimbStandardRelationEntity::getStandardId));
        for (EcsReimbStandardListVO ecsReimbStandardListVO : listVO) {
            List<EcsReimbStandardRelationEntity> relationList = listMap.get(ecsReimbStandardListVO.getId());
            ArrayList<String> organizationList = new ArrayList<String>();
            ArrayList<String> employeeLevelList = new ArrayList<String>();
            ArrayList<String> employeeList = new ArrayList<String>();
            ArrayList<List> provinceList = new ArrayList<List>();
            String cityLevel = "";
            for (EcsReimbStandardRelationEntity relationEntity : relationList) {
                if (StandardTypeEnum.ORGANIZATION.getRelationType().equals(relationEntity.getObjectType())) {
                    organizationList.add(relationEntity.getObjectId());
                    continue;
                }
                if (StandardTypeEnum.EMPLOYEE_LEVEL.getRelationType().equals(relationEntity.getObjectType())) {
                    employeeLevelList.add(relationEntity.getObjectId());
                    continue;
                }
                if (StandardTypeEnum.EMPLOYEE.getRelationType().equals(relationEntity.getObjectType())) {
                    employeeList.add(relationEntity.getObjectId());
                    continue;
                }
                if (StandardTypeEnum.PROVINCE.getRelationType().equals(relationEntity.getObjectType())) {
                    if (!StringUtils.isNotBlank((CharSequence)relationEntity.getObjectId())) continue;
                    List province = JsonUtil.getJsonToList((String)relationEntity.getObjectId(), String.class);
                    provinceList.add(province);
                    continue;
                }
                if (!StandardTypeEnum.CITY_LEVEL.getRelationType().equals(relationEntity.getObjectType())) continue;
                cityLevel = relationEntity.getObjectId();
            }
            ecsReimbStandardListVO.setOrganizationId(JsonUtil.getObjectToString(organizationList));
            ecsReimbStandardListVO.setEmployeeLevel(JsonUtil.getObjectToString(employeeLevelList));
            ecsReimbStandardListVO.setEmployee(JsonUtil.getObjectToString(employeeList));
            if (CollUtil.isNotEmpty(provinceList)) {
                ecsReimbStandardListVO.setProvince(JsonUtil.getObjectToString(provinceList));
            }
            ecsReimbStandardListVO.setCityLevel(cityLevel);
        }
        for (EcsReimbStandardListVO vo : listVO) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            vo.setOrganizationName(this.baseDataUtil.comSelectValues(vo.getOrganizationId()));
            vo.setEmployee(this.baseDataUtil.userSelectValues(vo.getEmployee()));
            vo.setProvince(this.baseDataUtil.provinceData(vo.getProvince()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsReimbStandardPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getStandard"})
    public ActionResult<?> getStandard(EcsReimbStandardInfoVO vo) throws DataException {
        EcsReimbStandardInfoVO standard = this.ecsReimbStandardService.getStandard(vo);
        return ActionResult.success((Object)standard);
    }

    @PostMapping
    @DSTransactional
    public ActionResult<?> create(@RequestBody @Valid EcsReimbStandardCrForm ecsReimbStandardCrForm) throws DataException {
        this.ecsReimbStandardService.create(ecsReimbStandardCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsReimbStandardInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        EcsReimbStandardInfoVO info = this.ecsReimbStandardService.getInfo(id);
        return ActionResult.success((Object)info);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsReimbStandardInfoVO> detailInfo(@PathVariable(value="id") String id) throws DataException {
        EcsReimbStandardInfoVO info = this.ecsReimbStandardService.getInfo(id);
        return ActionResult.success((Object)info);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> update(@PathVariable(value="id") String id, @RequestBody @Valid EcsReimbStandardUpForm ecsReimbStandardUpForm) throws DataException {
        this.ecsReimbStandardService.update(id, ecsReimbStandardUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> delete(@PathVariable(value="id") String id) {
        EcsReimbStandardEntity entity = (EcsReimbStandardEntity)this.ecsReimbStandardService.getById((Serializable)((Object)id));
        if (entity != null) {
            this.ecsReimbStandardService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

