/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsSkBankInfoEntity;
import com.bringspring.ecs.model.ecsskbankinfo.EcsSkBankInfoCrForm;
import com.bringspring.ecs.model.ecsskbankinfo.EcsSkBankInfoInfoVO;
import com.bringspring.ecs.model.ecsskbankinfo.EcsSkBankInfoListVO;
import com.bringspring.ecs.model.ecsskbankinfo.EcsSkBankInfoPagination;
import com.bringspring.ecs.model.ecsskbankinfo.EcsSkBankInfoUpForm;
import com.bringspring.ecs.service.EcsSkBankInfoService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u53f8\u5e93\u94f6\u884c\u4fe1\u606f"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsSkBankInfo"})
public class EcsSkBankInfoController {
    private static final Logger log = LoggerFactory.getLogger(EcsSkBankInfoController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsSkBankInfoService ecsSkBankInfoService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsSkBankInfoPagination ecsSkBankInfoPagination) throws IOException {
        List<EcsSkBankInfoEntity> list = this.ecsSkBankInfoService.getList(ecsSkBankInfoPagination);
        List listVO = JsonUtil.getJsonToList(list, EcsSkBankInfoListVO.class);
        for (EcsSkBankInfoListVO ecsSkBankInfoListVO : listVO) {
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsSkBankInfoPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid EcsSkBankInfoCrForm ecsSkBankInfoCrForm) throws DataException {
        this.ecsSkBankInfoService.create(ecsSkBankInfoCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsSkBankInfoInfoVO> info(@PathVariable(value="id") String id) {
        EcsSkBankInfoEntity entity = this.ecsSkBankInfoService.getInfo(id);
        EcsSkBankInfoInfoVO vo = (EcsSkBankInfoInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsSkBankInfoInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsSkBankInfoInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsSkBankInfoEntity entity = this.ecsSkBankInfoService.getInfo(id);
        EcsSkBankInfoInfoVO vo = (EcsSkBankInfoInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsSkBankInfoInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsSkBankInfoUpForm ecsSkBankInfoUpForm) throws DataException {
        this.ecsSkBankInfoService.update(id, ecsSkBankInfoUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/import"})
    public ActionResult<?> importData(@RequestParam(value="file") MultipartFile file) {
        ImportParams params = new ImportParams();
        params.setHeadRows(1);
        try {
            List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), EcsSkBankInfoEntity.class, (ImportParams)params);
            list.forEach(entity -> {
                entity.setId(RandomUtil.uuId());
                entity.setCreatorTime(new Date());
            });
            int batchSize = 1000;
            for (int i = 0; i < list.size(); i += batchSize) {
                int end = Math.min(i + batchSize, list.size());
                List batchList = list.subList(i, end);
                this.ecsSkBankInfoService.saveBatch(batchList);
            }
            return ActionResult.success();
        }
        catch (Exception e) {
            return null;
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsSkBankInfoEntity entity = this.ecsSkBankInfoService.getInfo(id);
        if (entity != null) {
            this.ecsSkBankInfoService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

