/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsTaxLoanInterestEntity;
import com.bringspring.ecs.entity.EcsTaxLoanInterestRecordsEntity;
import com.bringspring.ecs.enums.EcsReminderEnum;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestCrForm;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestInfoVO;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestListVO;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestPagination;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestPaginationExportModel;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestRecordsModel;
import com.bringspring.ecs.model.ecstaxloaninterest.EcsTaxLoanInterestUpForm;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsTaxLoanInterestRecordsService;
import com.bringspring.ecs.service.EcsTaxLoanInterestService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d39\u63a7\u7a0e\u91d1\u53ca\u8d37\u6b3e\u672c\u91d1\u5229\u606f"}, value="oa")
@RequestMapping(value={"/api/ecs/EcsTaxLoanInterest"})
public class EcsTaxLoanInterestController {
    private static final Logger log = LoggerFactory.getLogger(EcsTaxLoanInterestController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcsTaxLoanInterestService ecsTaxLoanInterestService;
    @Autowired
    private EcsTaxLoanInterestRecordsService ecsTaxLoanInterestRecordsService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private EcsCompanyService ecsCompanyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcsTaxLoanInterestPagination ecsTaxLoanInterestPagination) throws IOException {
        List<EcsTaxLoanInterestEntity> list = this.ecsTaxLoanInterestService.getList(ecsTaxLoanInterestPagination);
        for (EcsTaxLoanInterestEntity ecsTaxLoanInterestEntity : list) {
            ecsTaxLoanInterestEntity.setUploadFile(this.baseDataUtil.getFileNameInJson(ecsTaxLoanInterestEntity.getUploadFile()));
            ecsTaxLoanInterestEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(ecsTaxLoanInterestEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, EcsTaxLoanInterestListVO.class);
        for (EcsTaxLoanInterestListVO ecsTaxLoanInterestListVO : listVO) {
        }
        for (EcsTaxLoanInterestListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsTaxLoanInterestPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcsTaxLoanInterestCrForm ecsTaxLoanInterestCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "674520366730775237";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ecsTaxLoanInterestCrForm.setCreatorUserId(userInfo.getUserId());
        ecsTaxLoanInterestCrForm.setCreatorTime(DateUtil.getNow());
        EcsTaxLoanInterestEntity entity = (EcsTaxLoanInterestEntity)JsonUtil.getJsonToBean((Object)((Object)ecsTaxLoanInterestCrForm), EcsTaxLoanInterestEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        EcsCompanyEntity companyEntity = this.ecsCompanyService.getInfo(entity.getReimbCompanyId());
        if (ObjectUtil.isNotEmpty((Object)companyEntity)) {
            entity.setReimbCompanyName(companyEntity.getName());
        }
        this.ecsTaxLoanInterestService.save(entity);
        List<EcsTaxLoanInterestRecordsModel> ecsTaxLoanInterestList = ecsTaxLoanInterestCrForm.getEcsTaxLoanInterestList();
        List jsonToList = JsonUtil.getJsonToList(ecsTaxLoanInterestList, EcsTaxLoanInterestRecordsEntity.class);
        jsonToList.stream().forEach(interest -> {
            interest.setId(RandomUtil.uuId());
            interest.setTaxLoanInterestId(entity.getId());
            interest.setTaxTypeName(this.baseDataUtil.getDictName(interest.getTaxTypeCode(), "taxTypes"));
            interest.setCreatorUserId(userInfo.getUserId());
            interest.setCreatorTime(new Date());
        });
        this.ecsTaxLoanInterestRecordsService.saveBatch(jsonToList);
        FlowUtil.saveOrSubmit((String)ecsTaxLoanInterestCrForm.getTaskId(), (String)flowEngineId, (String)ecsTaxLoanInterestCrForm.getTemplateId(), (String)mainId, (Object)((Object)ecsTaxLoanInterestCrForm), (Integer)ecsTaxLoanInterestCrForm.getStatus(), (String)ecsTaxLoanInterestCrForm.getTitle());
        if (ecsTaxLoanInterestCrForm.getStatus() == 0) {
            return ActionResult.success((String)EcsReminderEnum.TS.getType());
        }
        return ActionResult.success((String)EcsReminderEnum.SUCCEED.getType());
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(EcsTaxLoanInterestPaginationExportModel ecsTaxLoanInterestPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)ecsTaxLoanInterestPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        EcsTaxLoanInterestPagination ecsTaxLoanInterestPagination = (EcsTaxLoanInterestPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ecsTaxLoanInterestPaginationExportModel), EcsTaxLoanInterestPagination.class));
        List<EcsTaxLoanInterestEntity> list = this.ecsTaxLoanInterestService.getTypeList(ecsTaxLoanInterestPagination, ecsTaxLoanInterestPaginationExportModel.getDataType());
        for (EcsTaxLoanInterestEntity ecsTaxLoanInterestEntity : list) {
            ecsTaxLoanInterestEntity.setUploadFile(this.baseDataUtil.getFileNameInJson(ecsTaxLoanInterestEntity.getUploadFile()));
            ecsTaxLoanInterestEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(ecsTaxLoanInterestEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, EcsTaxLoanInterestListVO.class);
        for (EcsTaxLoanInterestListVO ecsTaxLoanInterestListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)ecsTaxLoanInterestPaginationExportModel.getSelectKey()) ? ecsTaxLoanInterestPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block24: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "reimbCompanyName": {
                        entitys.add(new ExcelExportEntity("\u62a5\u9500\u516c\u53f8", (Object)"reimbCompanyName"));
                        continue block24;
                    }
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u62a5\u9500\u6807\u9898", (Object)"title"));
                        continue block24;
                    }
                    case "reason": {
                        entitys.add(new ExcelExportEntity("\u62a5\u9500\u4e8b\u7531", (Object)"reason"));
                        continue block24;
                    }
                    case "applyAmount": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u91d1\u989d(\u5143)", (Object)"applyAmount"));
                        continue block24;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block24;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block24;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u7a0e\u91d1\u672c\u91d1\u5229\u606f\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsTaxLoanInterestInfoVO> info(@PathVariable(value="id") String id) {
        List<EcsTaxLoanInterestRecordsEntity> listByTaxId;
        EcsTaxLoanInterestEntity entity = this.ecsTaxLoanInterestService.getInfo(id);
        EcsTaxLoanInterestInfoVO vo = (EcsTaxLoanInterestInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsTaxLoanInterestInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        if (CollectionUtil.isNotEmpty(listByTaxId = this.ecsTaxLoanInterestRecordsService.getListByTaxId(id))) {
            vo.setEcsTaxLoanInterestList(listByTaxId);
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcsTaxLoanInterestUpForm ecsTaxLoanInterestUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "674520366730775237";
        UserInfo userInfo = this.userProvider.get();
        EcsTaxLoanInterestEntity entity = this.ecsTaxLoanInterestService.getInfo(id);
        if (entity != null) {
            EcsTaxLoanInterestEntity subentity = (EcsTaxLoanInterestEntity)JsonUtil.getJsonToBean((Object)((Object)ecsTaxLoanInterestUpForm), EcsTaxLoanInterestEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.ecsTaxLoanInterestService.updateFrom(id, ecsTaxLoanInterestUpForm);
            FlowUtil.saveOrSubmit((String)ecsTaxLoanInterestUpForm.getTaskId(), (String)flowEngineId, (String)ecsTaxLoanInterestUpForm.getTemplateId(), (String)id, (Object)((Object)ecsTaxLoanInterestUpForm), (Integer)ecsTaxLoanInterestUpForm.getStatus(), (String)ecsTaxLoanInterestUpForm.getTitle());
            if (ecsTaxLoanInterestUpForm.getStatus() == 0) {
                return ActionResult.success((String)EcsReminderEnum.TS.getType());
            }
            return ActionResult.success((String)EcsReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcsTaxLoanInterestEntity entity = this.ecsTaxLoanInterestService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.ecsTaxLoanInterestService.delete(entity);
            this.ecsTaxLoanInterestRecordsService.deleteByTaxId(id);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

