/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.entity.EcsTemplateEntity;
import com.bringspring.ecs.model.template.EcsTemplateCrForm;
import com.bringspring.ecs.model.template.EcsTemplateInfoVO;
import com.bringspring.ecs.model.template.EcsTemplateListVO;
import com.bringspring.ecs.model.template.EcsTemplatePagination;
import com.bringspring.ecs.model.template.EcsTemplateUpForm;
import com.bringspring.ecs.service.EcsTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d39\u63a7\u6a21\u677f\u8868"}, value="ecs")
@RequestMapping(value={"/api/ecs/EcsTemplate"})
public class EcsTemplateController {
    private static final Logger log = LoggerFactory.getLogger(EcsTemplateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsTemplateService ecsTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult<?> list(@RequestBody EcsTemplatePagination ecsTemplatePagination) throws IOException {
        List<EcsTemplateEntity> list = this.ecsTemplateService.getList(ecsTemplatePagination);
        List listVO = JsonUtil.getJsonToList(list, EcsTemplateListVO.class);
        for (EcsTemplateListVO ecsTemplateVO : listVO) {
            ecsTemplateVO.setCompanyName(this.baseDataUtil.comSelectValues(ecsTemplateVO.getCompanyId()));
            ecsTemplateVO.setCreatorUserId(this.baseDataUtil.userSelectValue(ecsTemplateVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecsTemplatePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult<?> create(@RequestBody @Valid EcsTemplateCrForm ecsTemplateCrForm) throws DataException {
        this.ecsTemplateService.create(ecsTemplateCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcsTemplateInfoVO> info(@PathVariable(value="id") String id) {
        EcsTemplateEntity entity = this.ecsTemplateService.getInfo(id);
        EcsTemplateInfoVO vo = (EcsTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsTemplateInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcsTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcsTemplateEntity entity = this.ecsTemplateService.getInfo(id);
        EcsTemplateInfoVO vo = (EcsTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsTemplateInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> update(@PathVariable(value="id") String id, @RequestBody @Valid EcsTemplateUpForm ecsTemplateUpForm) throws DataException {
        this.ecsTemplateService.update(id, ecsTemplateUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult<?> delete(@PathVariable(value="id") String id) {
        EcsTemplateEntity entity = this.ecsTemplateService.getInfo(id);
        if (entity != null) {
            this.ecsTemplateService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

