/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.docking.entity.nc.ReimbursementDetails;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsPlatformAccountMappingEntity;
import com.bringspring.ecs.entity.EcsPlatformMappingEntity;
import com.bringspring.ecs.entity.EcsPlatformMappingRecordsEntity;
import com.bringspring.ecs.entity.EcsProjectEntity;
import com.bringspring.ecs.entity.EcsRecordsChargesDetailEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsProjectEntity;
import com.bringspring.ecs.entity.EcsRecordsSubsidyEntity;
import com.bringspring.ecs.model.hrms.archive.HrmsEmployeeArchiveInfoVO;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsExtendService;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.service.EcsPlatformAccountMappingService;
import com.bringspring.ecs.service.EcsPlatformMappingRecordsService;
import com.bringspring.ecs.service.EcsPlatformMappingService;
import com.bringspring.ecs.service.EcsProjectService;
import com.bringspring.ecs.service.EcsRecordsChargesDetailService;
import com.bringspring.ecs.service.EcsRecordsProjectService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.service.EcsRecordsSubsidyService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FetchReimbursementDetails {
    private static final Logger log = LoggerFactory.getLogger(FetchReimbursementDetails.class);
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private EcsRecordsChargesDetailService recordsChargesDetailService;
    @Autowired
    private EcsInvoiceService invoiceService;
    @Autowired
    private EcsCompanyService companyService;
    @Autowired
    private EcsPlatformMappingService platformMappingService;
    @Autowired
    private EcsPlatformMappingRecordsService platformMappingRecordsService;
    @Autowired
    private EcsPlatformAccountMappingService platformAccountMappingService;
    @Autowired
    private EcsRecordsProjectService recordsProjectService;
    @Autowired
    private EcsProjectService projectService;
    @Autowired
    private EcsPlatformAccountMappingService accountMappingService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsRecordsSubsidyService recordsSubsidyService;
    @Autowired
    private EcsExtendService ecsExtendService;
    @Autowired
    private EcsBankCardService bankCardService;

    public ReimbursementDetails fetchReimbursementDetails(String recordId) {
        String applicantInfo;
        EcsRecordsEntity recordsEntity = (EcsRecordsEntity)this.recordsService.getById((Serializable)((Object)recordId));
        EcsRecordsInfoVO vo = (EcsRecordsInfoVO)JsonUtil.getJsonToBean((Object)recordsEntity, EcsRecordsInfoVO.class);
        this.recordsService.getRecordsSubjectInfo(vo);
        String organization = recordsEntity.getOrganization();
        EcsPlatformMappingEntity platformMappingEntity = (EcsPlatformMappingEntity)this.platformMappingService.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsPlatformMappingEntity::getSourceId, (Object)organization));
        if (platformMappingEntity == null) {
            log.info("\u5e73\u53f0\u6620\u5c04\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u7ec4\u7ec7: {}", (Object)organization);
        }
        List recordsProjectEntities = this.recordsProjectService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsRecordsProjectEntity::getRecordId, (Object)recordId));
        List<String> projectIds = this.extractProjectIds(recordsProjectEntities);
        List projectEntityList = null;
        if (CollectionUtils.isNotEmpty(projectIds)) {
            projectEntityList = this.projectService.list((Wrapper)Wrappers.lambdaQuery().in(EcsProjectEntity::getId, projectIds));
        }
        EcsPlatformMappingRecordsEntity ncDept = (EcsPlatformMappingRecordsEntity)this.platformMappingRecordsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsPlatformMappingRecordsEntity::getCompanyId, (Object)recordsEntity.getReimbCompany())).eq(EcsPlatformMappingRecordsEntity::getPlatform, (Object)"NC")).eq(EcsPlatformMappingRecordsEntity::getMappingId, (Object)platformMappingEntity.getId()));
        if (ObjectUtil.isEmpty((Object)projectEntityList)) {
            log.info("\u5f00\u7968\u6620\u5c04\u90e8\u95e8\u4e0d\u5b58\u5728\uff0cCompanyId,getMappingId ,{}", (Object)(recordsEntity.getReimbCompany() + platformMappingEntity.getId()));
        }
        Map userMap = (applicantInfo = recordsEntity.getApplicantInfo()) != null ? JsonUtil.stringToMap((String)applicantInfo) : Collections.emptyMap();
        EcsCompanyEntity companyEntity = this.companyService.getInfo(recordsEntity.getReimbCompany());
        String usered = "";
        if (companyEntity != null) {
            String ncPrepared = companyEntity.getNcPrepared();
            HrmsEmployeeArchiveInfoVO info = this.ecsExtendService.getEmployeeArchiveInfoById(ncPrepared);
            usered = info.getName();
        } else {
            log.info("\u5f00\u7968\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728\uff0cID: ,{}", (Object)recordsEntity.getReimbCompany());
        }
        List recordsChargesDetailEntities = this.recordsChargesDetailService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsRecordsChargesDetailEntity::getRecordId, (Object)recordId));
        Map<String, EcsRecordsChargesDetailEntity> chargesDetailEntityMap = recordsChargesDetailEntities.stream().collect(Collectors.toMap(EcsRecordsChargesDetailEntity::getId, e -> e));
        List invoiceEntities = this.invoiceService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsInvoiceEntity::getRecordId, (Object)recordId));
        return new ReimbursementDetails(recordsEntity, platformMappingEntity, projectEntityList, ncDept, userMap, companyEntity, chargesDetailEntityMap, invoiceEntities, usered, recordsProjectEntities);
    }

    public BigDecimal calculateTotalAmountAndReimb(String recordId, ReimbursementDetails reimbursementDetails) {
        List subsidyList = this.recordsSubsidyService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsRecordsSubsidyEntity::getRecordId, (Object)recordId));
        BigDecimal totalAmount = subsidyList.stream().map(EcsRecordsSubsidyEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<String, EcsRecordsChargesDetailEntity> chargeDetailsMap = reimbursementDetails.getChargesDetails();
        BigDecimal totalReimbAmount = chargeDetailsMap.values().stream().map(EcsRecordsChargesDetailEntity::getReimbAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalAmount.add(totalReimbAmount);
    }

    public EcsPlatformMappingRecordsEntity getProjectMapping(String projectId, String companyId) {
        EcsPlatformMappingEntity platformMappingEntity = (EcsPlatformMappingEntity)this.platformMappingService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsPlatformMappingEntity::getSourceId, (Object)projectId)).eq(EcsPlatformMappingEntity::getType, (Object)"project"));
        EcsPlatformMappingRecordsEntity mappingRecordsEntity = (EcsPlatformMappingRecordsEntity)this.platformMappingRecordsService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsPlatformMappingRecordsEntity::getCompanyId, (Object)companyId)).eq(EcsPlatformMappingRecordsEntity::getMappingId, (Object)platformMappingEntity.getId()));
        return mappingRecordsEntity;
    }

    public EcsPlatformAccountMappingEntity getAccountMapping(String type, String deptId, String subjectCode) {
        EcsPlatformAccountMappingEntity accountMappingEntity = (EcsPlatformAccountMappingEntity)this.platformAccountMappingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsPlatformAccountMappingEntity::getDeptRecordId, (Object)deptId)).eq(EcsPlatformAccountMappingEntity::getAccountCode, (Object)subjectCode)).eq(StrUtil.isNotBlank((CharSequence)type), EcsPlatformAccountMappingEntity::getType, (Object)type));
        return accountMappingEntity;
    }

    public List<String> extractProjectIds(List<EcsRecordsProjectEntity> recordsProjectEntities) {
        return recordsProjectEntities.stream().map(EcsRecordsProjectEntity::getProjectId).collect(Collectors.toList());
    }

    public EcsBankCardEntity getBankCard(String id) {
        return this.bankCardService.getInfo(id);
    }
}

