/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.service.impl;

import com.bringspring.ecs.docking.entity.vo.ConfirmIncomeRequest;
import com.bringspring.ecs.docking.service.VoucherPushService;
import com.bringspring.ecs.docking.strategy.VoucherOperationContext;
import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import com.bringspring.ecs.docking.utils.OracleDBUtil;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import com.bringspring.ecs.service.EcsRecordsService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VoucherPushServiceImpl
implements VoucherPushService {
    private static final Logger log = LoggerFactory.getLogger(VoucherPushServiceImpl.class);
    @Value(value="${nc.sender}")
    private String sender;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private EcsCompanyService companyService;
    @Autowired
    private VoucherOperationContext voucherOperationContext;
    @Autowired
    private EcsPaymentRecordsService paymentRecordsService;
    @Autowired
    private OracleDBUtil oracleDBUtil;

    @Override
    public boolean pushVoucher(String recordId) throws VoucherPushException {
        EcsRecordsEntity recordsEntity = (EcsRecordsEntity)this.recordsService.getById((Serializable)((Object)recordId));
        EcsCompanyEntity companyEntity = this.companyService.getInfo(recordsEntity.getReimbCompany());
        log.info("\u5f53\u524d\u5f00\u7968\u516c\u53f8,{}", (Object)companyEntity);
        VoucherOperationStrategy actionStrategy = this.voucherOperationContext.getActionMethod(companyEntity.getName());
        if (actionStrategy != null) {
            boolean handler = actionStrategy.handler(recordsEntity);
            return handler;
        }
        throw new VoucherPushException("");
    }

    @Override
    public boolean pushPayVoucher(String recordId) throws VoucherPushException {
        EcsPaymentRecordsEntity paymentRecordsEntity = this.paymentRecordsService.getInfo(recordId);
        VoucherOperationStrategy actionStrategy = this.voucherOperationContext.getActionMethod(paymentRecordsEntity.getSourceType());
        if (actionStrategy != null) {
            boolean handler = actionStrategy.handler(paymentRecordsEntity);
            return handler;
        }
        throw new VoucherPushException("");
    }

    @Override
    public boolean pushRevenueVoucher(ConfirmIncomeRequest confirmIncomeRequest) throws VoucherPushException {
        VoucherOperationStrategy actionStrategy = this.voucherOperationContext.getActionMethod("ConfirmIncome");
        if (actionStrategy != null) {
            boolean handler = actionStrategy.handler(confirmIncomeRequest);
            return handler;
        }
        throw new VoucherPushException("");
    }

    @Override
    public String getVoucherNum(String id) throws VoucherPushException {
        return this.oracleDBUtil.queryById(id);
    }
}

