/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.strategy;

import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class VoucherOperationContext
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Map<String, VoucherOperationStrategy> methodMap = new HashMap<String, VoucherOperationStrategy>();

    public void afterPropertiesSet() throws Exception {
        this.applicationContext.getBeansOfType(VoucherOperationStrategy.class).values().forEach(strategy -> {
            for (String company : strategy.actionMethod()) {
                this.methodMap.put(company, (VoucherOperationStrategy)strategy);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public VoucherOperationStrategy getActionMethod(String actionMethod) {
        return this.methodMap.get(actionMethod);
    }
}

