/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.docking.strategy.voucher;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.bringspring.ecs.docking.entity.nc.ReimbursementDetails;
import com.bringspring.ecs.docking.entity.nc.voucher.Ass;
import com.bringspring.ecs.docking.entity.nc.voucher.AssItem;
import com.bringspring.ecs.docking.entity.nc.voucher.Item;
import com.bringspring.ecs.docking.entity.nc.voucher.UfInterface;
import com.bringspring.ecs.docking.entity.nc.voucher.VoucherHead;
import com.bringspring.ecs.docking.enums.TaxRateEnums;
import com.bringspring.ecs.docking.service.impl.FetchReimbursementDetails;
import com.bringspring.ecs.docking.strategy.VoucherOperationStrategy;
import com.bringspring.ecs.docking.utils.VoucherService;
import com.bringspring.ecs.docking.utils.VoucherUtils;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsPlatformAccountMappingEntity;
import com.bringspring.ecs.entity.EcsPlatformMappingRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsChargesDetailEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsProjectEntity;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.utils.XmlConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RKBranchVoucherPushHanle
implements VoucherOperationStrategy {
    private static final Logger log = LoggerFactory.getLogger(RKBranchVoucherPushHanle.class);
    @Value(value="${nc.sender}")
    private String sender;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private FetchReimbursementDetails fetchReimbursementDetails;
    @Autowired
    private VoucherService voucherService;

    @Override
    public List<String> actionMethod() {
        return Arrays.asList("\u8363\u79d1\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8\u90d1\u5dde\u7b2c\u4e8c\u5206\u516c\u53f8", "\u8363\u79d1\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8\u4e0a\u6d77\u5206\u516c\u53f8", "\u8363\u79d1\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5f90\u5dde\u5206\u516c\u53f8", "\u8363\u79d1\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5317\u4eac\u5206\u516c\u53f8");
    }

    @Override
    public boolean handler(Object data) {
        try {
            JSONObject sendResult;
            BigDecimal bigDecimal;
            EcsRecordsEntity recordsEntity = XmlConverter.convert(data, EcsRecordsEntity.class);
            ReimbursementDetails reimbursementDetails = this.fetchReimbursementDetails.fetchReimbursementDetails(recordsEntity.getId());
            log.info("reimbursementDetails={}", (Object)reimbursementDetails);
            List<EcsRecordsProjectEntity> recordsProjects = reimbursementDetails.getRecordsProjects();
            String bankCardId = recordsEntity.getBankCardId();
            EcsBankCardEntity bankCard = this.fetchReimbursementDetails.getBankCard(bankCardId);
            String type = "";
            String organizationName = reimbursementDetails.getRecords().getOrganizationName();
            UfInterface ufInterface = VoucherUtils.createUfInterface(reimbursementDetails.getCompany(), this.sender);
            VoucherHead voucherHead = VoucherUtils.createVoucherHead(recordsEntity.getId(), reimbursementDetails.getCompany(), reimbursementDetails.getPreparedBy());
            ArrayList<Item> items = new ArrayList<Item>();
            for (EcsInvoiceEntity invoice : reimbursementDetails.getInvoices()) {
                EcsRecordsChargesDetailEntity chargesDetail = reimbursementDetails.getChargesDetails().get(invoice.getSubjectId());
                String ncAccountCode = "";
                String deptNcCode = "";
                String subjectName = chargesDetail.getSubjectName();
                type = this.determineType(chargesDetail);
                EcsPlatformMappingRecordsEntity department = reimbursementDetails.getDepartment();
                deptNcCode = department.getTargetCode();
                EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(type, reimbursementDetails.getDepartment().getId(), chargesDetail.getSubjectCode());
                ncAccountCode = accountMappingEntity.getNcAccountCode();
                String explanation = VoucherUtils.generateExplanation(reimbursementDetails.getApplicantInfo(), chargesDetail, reimbursementDetails.getRecords());
                String invoiceTaxRate = invoice.getInvoiceTaxRate();
                String rate = StrUtil.isNotBlank((CharSequence)invoiceTaxRate) ? TaxRateEnums.getDescByCode(invoiceTaxRate) : TaxRateEnums.getDescByCode("0%");
                BigDecimal deductibleTax = invoice.getDeductibleTax();
                ArrayList<Ass> assList1 = new ArrayList<Ass>();
                Ass ass1 = new Ass();
                for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
                    Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
                    Item item1 = null;
                    item1 = subjectName.equals("01\u63a2\u4eb2\u5047\u8d39\u7528") ? this.createItemBasedOnTax(invoice, ratio, BigDecimal.ZERO, explanation, ncAccountCode) : this.createItemBasedOnTax(invoice, ratio, deductibleTax, explanation, ncAccountCode);
                    ArrayList<AssItem> assItemList1 = new ArrayList<AssItem>();
                    assItemList1.add(VoucherUtils.createAssItem("\u90e8\u95e8", deptNcCode));
                    ass1.setItems(assItemList1);
                    assList1.add(ass1);
                    item1.setAssList(assList1);
                    items.add(item1);
                }
                Item item3 = null;
                ArrayList<Ass> assList3 = new ArrayList<Ass>();
                Ass ass3 = new Ass();
                ArrayList<AssItem> assItemList3 = new ArrayList<AssItem>();
                item3 = bankCard.getAccountType().equals("01") ? VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122102") : VoucherUtils.createItem(3, explanation, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), invoice.getInvoiceAmount(), "122101");
                if (reimbursementDetails.getApplicantInfo() != null && reimbursementDetails.getApplicantInfo().get("name") != null) {
                    assItemList3.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
                }
                assItemList3.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0101"));
                ass3.setItems(assItemList3);
                assList3.add(ass3);
                item3.setAssList(assList3);
                items.add(item3);
            }
            if ("\u5dee\u65c5\u8d39".equals(reimbursementDetails.getRecords().getRecordType()) && BigDecimal.ZERO.compareTo(bigDecimal = this.fetchReimbursementDetails.calculateTotalAmountAndReimb(recordsEntity.getId(), reimbursementDetails)) != 0) {
                this.processTravelAllowance(type, reimbursementDetails, bigDecimal, items, organizationName);
            }
            return (sendResult = this.voucherService.processVoucher(ufInterface, voucherHead, items, recordsEntity.getId(), recordsEntity.getOrderNumber(), recordsEntity.getTitle())) != null && sendResult.getInt((Object)"resultcode") == 1;
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u62a5\u9500\u8bb0\u5f55\u65f6\u53d1\u751f\u5f02\u5e38\uff0cID: {}\uff0c\u9519\u8bef\u4fe1\u606f: {}", new Object[]{"\u672a\u77e5", e.getMessage(), e});
            return false;
        }
    }

    private void processTravelAllowance(String type, ReimbursementDetails reimbursementDetails, BigDecimal totalAmount, List<Item> items, String organizationName) {
        ArrayList<Ass> assList4 = new ArrayList<Ass>();
        String ncAccountCode = "";
        String deptNcCode = "";
        EcsPlatformMappingRecordsEntity department = reimbursementDetails.getDepartment();
        if (department != null) {
            deptNcCode = department.getTargetCode();
            EcsPlatformAccountMappingEntity accountMappingEntity = this.fetchReimbursementDetails.getAccountMapping(type, department.getId(), "0101");
            if (accountMappingEntity != null) {
                ncAccountCode = accountMappingEntity.getNcAccountCode();
            }
        }
        for (EcsRecordsProjectEntity recordsProject : reimbursementDetails.getRecordsProjects()) {
            Double ratio = recordsProject.getRatio() != null ? Double.valueOf(recordsProject.getRatio() / 100.0) : null;
            Item item4 = this.createReimbItemBasedOnTax(totalAmount, ratio, totalAmount, "\u51fa\u5dee\u8865\u52a9", ncAccountCode);
            ArrayList<AssItem> assItemList4 = new ArrayList<AssItem>();
            assItemList4.add(VoucherUtils.createAssItem("\u90e8\u95e8", deptNcCode));
            Ass ass4 = new Ass();
            ass4.setItems(assItemList4);
            assList4.add(ass4);
            item4.setAssList(assList4);
            items.add(item4);
        }
        Item item5 = VoucherUtils.createItem(2, "\u51fa\u5dee\u8865\u52a9", BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), totalAmount, "122102");
        ArrayList<Ass> assList5 = new ArrayList<Ass>();
        Ass ass5 = new Ass();
        ArrayList<AssItem> assItemList5 = new ArrayList<AssItem>();
        assItemList5.add(VoucherUtils.createAssItem("\u4eba\u5458\u6863\u6848", reimbursementDetails.getApplicantInfo().get("name").toString()));
        assItemList5.add(VoucherUtils.createAssItem("\u6b3e\u9879\u6027\u8d28", "0101"));
        ass5.setItems(assItemList5);
        assList5.add(ass5);
        item5.setAssList(assList5);
        items.add(item5);
    }

    private Item createItemBasedOnTax(EcsInvoiceEntity invoice, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        return VoucherUtils.createItem(1, explanation, invoice.getInvoiceAmount(), invoice.getInvoiceAmount(), BigDecimal.ZERO, accountCode);
    }

    private Item createReimbItemBasedOnTax(BigDecimal reimb, Double ratio, BigDecimal deductibleTax, String explanation, String accountCode) {
        return VoucherUtils.createItem(1, explanation, reimb, reimb, BigDecimal.ZERO, accountCode);
    }

    public String determineType(EcsRecordsChargesDetailEntity chargesDetail) {
        String subjectName = chargesDetail.getSubjectName();
        String type = null;
        if ("01\u63a2\u4eb2\u5047\u8d39\u7528".equals(subjectName)) {
            type = "3";
        } else if ("01\u5dee\u65c5\u8d39".equals(subjectName)) {
            type = "0";
        }
        return type;
    }
}

