/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.docking.entity.vo.PaymentVO;
import com.bringspring.ecs.docking.service.SkPaymentService;
import com.bringspring.ecs.entity.EcsAdvancePaymentEntity;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountEntity;
import com.bringspring.ecs.entity.EcsCompanyAccountEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsRecordsAdvanceEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.AdvanceRecordTypeEnum;
import com.bringspring.ecs.enums.BudgetRecordOperateTypeEnum;
import com.bringspring.ecs.enums.RecordAuditEnum;
import com.bringspring.ecs.enums.RecordReviewStatusEnum;
import com.bringspring.ecs.enums.RecordsPdfEnum;
import com.bringspring.ecs.enums.SendCashierTypeEnum;
import com.bringspring.ecs.mapper.EcsAdvancePaymentMapper;
import com.bringspring.ecs.model.bankcard.EcsBankCardInfoVO;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentCrForm;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentInfoVO;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentPagination;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentUpForm;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.model.records.EcsRecordsPaymentVO;
import com.bringspring.ecs.service.EcsAdvancePaymentService;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountService;
import com.bringspring.ecs.service.EcsCompanyAccountService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsMessageService;
import com.bringspring.ecs.service.EcsPdfService;
import com.bringspring.ecs.service.EcsRecordsAdvanceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsAdvancePaymentServiceImpl
extends ServiceImpl<EcsAdvancePaymentMapper, EcsAdvancePaymentEntity>
implements EcsAdvancePaymentService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private EcsRecordsAdvanceService ecsRecordsAdvanceService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsBudgetOrganizeAccountService budgetOrganizeAccountService;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private EcsBankCardService ecsBankCardService;
    @Autowired
    private EcsCompanyAccountService companyAccountService;
    @Autowired
    private SkPaymentService skPaymentService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private EcsMessageService ecsMessageService;
    @Autowired
    private EcsPdfService ecsPdfService;
    @Autowired
    private Executor ecsExecutor;

    @Override
    public List<EcsAdvancePaymentEntity> getList(EcsAdvancePaymentPagination ecsAdvancePaymentPagination) {
        return this.getTypeList(ecsAdvancePaymentPagination, "0");
    }

    @Override
    public List<EcsAdvancePaymentEntity> getTypeList(EcsAdvancePaymentPagination pagination, String dataType) {
        QueryWrapper queryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return new ArrayList<EcsAdvancePaymentEntity>();
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(EcsAdvancePaymentEntity::getId);
        } else {
            try {
                String sidx = pagination.getSidx();
                EcsRecordsEntity ecsRecordsEntity = new EcsRecordsEntity();
                Field declaredField = ecsRecordsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equalsIgnoreCase(pagination.getSort()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                this.log.error("\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5b58\u5728", (Throwable)e);
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<EcsAdvancePaymentEntity> getUserAdvanceList(EcsAdvancePaymentPagination pagination) {
        if (StringUtils.isBlank((CharSequence)pagination.getUserId())) {
            return Collections.emptyList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getUserId, (Object)pagination.getUserId())).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).eq(EcsAdvancePaymentEntity::getAuditStatus, (Object)RecordAuditEnum.PAID.getCode())).apply("total_advance_amount > repayment_amount + repaying_amount", new Object[0])).orderByDesc(EcsAdvancePaymentEntity::getAdvanceSubmitTime);
        if (StringUtils.isNotBlank((CharSequence)pagination.getListType())) {
            if ("person".equals(pagination.getListType())) {
                queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getRecordTypeCode, (Object)"personAdvance");
            } else if ("company".equals(pagination.getListType())) {
                queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getRecordTypeCode, (Object)"companyAdvance");
            } else if ("margin".equals(pagination.getListType())) {
                queryWrapper.lambda().in(EcsAdvancePaymentEntity::getRecordTypeCode, new Object[]{"marginAdvance", "perfMarginAdvance"});
            } else if ("writeOff".equals(pagination.getListType())) {
                queryWrapper.lambda().in(EcsAdvancePaymentEntity::getRecordTypeCode, new Object[]{"personAdvance", "companyAdvance"});
            }
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<Map<String, Object>> countByState(EcsAdvancePaymentPagination pagination) {
        QueryWrapper<EcsAdvancePaymentEntity> queryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return new ArrayList<Map<String, Object>>();
        }
        queryWrapper.select(new String[]{"count(*) as count,audit_status as state"});
        queryWrapper.groupBy((Object)"state");
        return this.listMaps((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> getSummaryInformation(EcsAdvancePaymentPagination pagination) {
        Map map = MapUtil.newHashMap();
        map.put("totalAdvanceAmount", "0");
        map.put("totalRepaymentAmount", "0");
        map.put("totalRepayingAmount", "0");
        QueryWrapper<EcsAdvancePaymentEntity> queryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{"coalesce(sum(total_advance_amount),0) as totalAdvanceAmount", "coalesce(sum(repayment_amount),0) as totalRepaymentAmount", "coalesce(sum(repaying_amount),0) as totalRepayingAmount"});
        map = this.getMap((Wrapper)queryWrapper);
        return map;
    }

    @Override
    public EcsAdvancePaymentEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getId, (Object)id);
        return (EcsAdvancePaymentEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(String mainId, EcsAdvancePaymentCrForm crForm) throws DataException {
        EcsAdvancePaymentEntity entity = (EcsAdvancePaymentEntity)JsonUtil.getJsonToBean((Object)((Object)crForm), EcsAdvancePaymentEntity.class);
        if (crForm.getStatus() == 1) {
            // empty if block
        }
        entity.setRecordYear(String.valueOf(DateUtil.getNowYear()));
        String ecsOrderNumber = null;
        ecsOrderNumber = crForm.getStatus() == 0 ? this.baseDataUtil.getBillNumber("ecsAdvanceBak", Boolean.valueOf(false)) : this.baseDataUtil.getBillNumber("ecsAdvance", Boolean.valueOf(false));
        entity.setOrderNumber(ecsOrderNumber);
        entity.setId(mainId);
        Integer status = crForm.getStatus();
        entity.setAuditStatus(status == 1 ? "20" : "10");
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, EcsAdvancePaymentUpForm upForm) throws DataException {
        EcsAdvancePaymentEntity entity = (EcsAdvancePaymentEntity)JsonUtil.getJsonToBean((Object)((Object)upForm), EcsAdvancePaymentEntity.class);
        if (upForm.getStatus() == 1 && upForm.getOrderNumber().startsWith("B-")) {
            entity.setOrderNumber(this.baseDataUtil.getBillNumber("ecsAdvance", Boolean.valueOf(false)));
        }
        entity.setRecordYear(String.valueOf(DateUtil.getNowYear()));
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(EcsAdvancePaymentEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    private QueryWrapper<EcsAdvancePaymentEntity> getQueryWrapper(EcsAdvancePaymentPagination pagination) {
        Object object;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && pagination.getIsAuth() == 1 && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_advance_payment"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && pagination.getIsAuth() == 1 && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_advance_payment"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getCompanyId())) {
            String[] split = pagination.getCompanyId().split(",");
            queryWrapper.lambda().in(EcsAdvancePaymentEntity::getCompanyId, Arrays.asList(split));
        }
        if ("-1".equals(pagination.getAuditStatus())) {
            pagination.setAuditStatus(null);
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getReviewStatus())) {
            queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getReviewStatus, (Object)pagination.getReviewStatus());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(StringUtils.isNotBlank((CharSequence)pagination.getAuditStatus()), EcsAdvancePaymentEntity::getAuditStatus, (Object)pagination.getAuditStatus())).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).eq(StringUtils.isNotBlank((CharSequence)pagination.getUserId()), EcsAdvancePaymentEntity::getUserId, (Object)pagination.getUserId())).eq(StringUtils.isNotBlank((CharSequence)pagination.getCreatorUserId()), EcsBaseEntity::getCreatorUserId, (Object)pagination.getCreatorUserId())).eq(StringUtils.isNotBlank((CharSequence)pagination.getDepartment()), EcsAdvancePaymentEntity::getOrganizationId, (Object)pagination.getDepartment())).like(StringUtils.isNotBlank((CharSequence)pagination.getTitle()), EcsAdvancePaymentEntity::getTitle, (Object)pagination.getTitle())).like(StringUtils.isNotBlank((CharSequence)pagination.getOrderNumber()), EcsAdvancePaymentEntity::getOrderNumber, (Object)pagination.getOrderNumber());
        if (Objects.nonNull(pagination.getStartTime())) {
            queryWrapper.lambda().ge(EcsBaseEntity::getCreatorTime, (Object)pagination.getStartTime());
        }
        if (Objects.nonNull(pagination.getEndTime())) {
            queryWrapper.lambda().le(EcsBaseEntity::getCreatorTime, (Object)pagination.getEndTime());
        }
        if (Objects.nonNull(pagination.getSubmitReviewStartTime())) {
            queryWrapper.lambda().ge(EcsAdvancePaymentEntity::getSubmitReviewTime, (Object)pagination.getSubmitReviewStartTime());
        }
        if (Objects.nonNull(pagination.getSubmitReviewEndTime())) {
            queryWrapper.lambda().le(EcsAdvancePaymentEntity::getSubmitReviewTime, (Object)pagination.getSubmitReviewEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getReimbCompanyId())) {
            queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getReimbCompany, (Object)pagination.getReimbCompanyId());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getRecordTypeCode())) {
            queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getRecordTypeCode, (Object)pagination.getRecordTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getListType())) {
            if ("person".equals(pagination.getListType())) {
                queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getRecordTypeCode, (Object)"personAdvance");
            } else if ("company".equals(pagination.getListType())) {
                queryWrapper.lambda().eq(EcsAdvancePaymentEntity::getRecordTypeCode, (Object)"companyAdvance");
            } else if ("margin".equals(pagination.getListType())) {
                queryWrapper.lambda().in(EcsAdvancePaymentEntity::getRecordTypeCode, new Object[]{"marginAdvance", "perfMarginAdvance"});
            } else if ("writeOff".equals(pagination.getListType())) {
                queryWrapper.lambda().in(EcsAdvancePaymentEntity::getRecordTypeCode, new Object[]{"personAdvance", "companyAdvance"});
            }
        }
        if (1 == pagination.getIsRunning()) {
            queryWrapper.lambda().notIn(EcsAdvancePaymentEntity::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{RecordAuditEnum.DRAFT.getCode(), RecordAuditEnum.PAID.getCode()}));
        }
        if (1 == pagination.getFlowToBe()) {
            PaginationFlowTask paginationFlowTask = new PaginationFlowTask();
            paginationFlowTask.setFlowCategory("ecsReimbManager");
            List waitList = this.flowTaskService.getWaitListAll(paginationFlowTask);
            ArrayList<String> ids = new ArrayList<String>();
            for (FlowTaskListModel flowTaskListModel : waitList) {
                ids.add(flowTaskListModel.getProcessId());
            }
            if (CollUtil.isNotEmpty(ids)) {
                queryWrapper.lambda().in(EcsAdvancePaymentEntity::getId, ids);
            } else {
                ids.add("1");
                queryWrapper.lambda().in(EcsAdvancePaymentEntity::getId, ids);
            }
        }
        return queryWrapper;
    }

    @Override
    public EcsUploadVO getAdvancePDF(String id) {
        return this.ecsPdfService.getAdvancePDF(id);
    }

    @Override
    public DownloadVO generatePDF(String id) {
        EcsAdvancePaymentEntity recordEntity = this.updateRecordPrintStatus(id);
        EcsAdvancePaymentInfoVO vo = (EcsAdvancePaymentInfoVO)JsonUtil.getJsonToBean((Object)recordEntity, EcsAdvancePaymentInfoVO.class);
        EcsBankCardEntity byId = (EcsBankCardEntity)this.ecsBankCardService.getById((Serializable)((Object)vo.getBankCardId()));
        vo.setBankCardInfo((EcsBankCardInfoVO)JsonUtil.getJsonToBean((Object)byId, EcsBankCardInfoVO.class));
        return this.ecsPdfService.generatePDF(id, vo);
    }

    private EcsAdvancePaymentEntity updateRecordPrintStatus(String id) {
        EcsAdvancePaymentEntity recordEntity = (EcsAdvancePaymentEntity)this.getById((Serializable)((Object)id));
        String isPrinted = recordEntity.getIsPrinted();
        if ("0".equals(isPrinted) || "9".equals(isPrinted) || StringUtils.isEmpty((String)isPrinted)) {
            recordEntity.setIsPrinted("1");
            recordEntity.setGeneratePdfStatus(RecordsPdfEnum.AUTO.getCode());
            recordEntity.setGeneratePdfTime(DateUtil.getNowDate());
            this.updateById(recordEntity);
        }
        return recordEntity;
    }

    private void departmentBudgetAdequate(EcsAdvancePaymentEntity entity) throws DataException {
        if (StringUtils.isEmpty((String)entity.getOrganizationId())) {
            throw new DataException("\u8d39\u7528\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)entity.getSubjectCode())) {
            throw new DataException("\u8d39\u7528\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (entity.getTotalAdvanceAmount() == null || BigDecimal.ZERO.compareTo(entity.getTotalAdvanceAmount()) >= 0) {
            throw new DataException("\u501f\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0001".equals(entity.getSubjectCode())) {
            return;
        }
        EcsBudgetOrganizeAccountEntity departmentBudge = this.budgetOrganizeAccountService.getDepartmentBudge(entity.getOrganizationId(), entity.getSubjectCode());
        if (!this.budgetOrganizeAccountService.isBudgetSufficient(departmentBudge, entity.getTotalAdvanceAmount()).booleanValue()) {
            throw new DataException("\u62a5\u9500\u91d1\u989d\u8d85\u8fc7\u90e8\u95e8\u9884\u7b97");
        }
        entity.setBudgetId(departmentBudge.getId());
    }

    @Override
    @FlowCallBackMethod(fullName="\u8d39\u63a7\u9884\u4ed8\u6b3e\u7533\u8bf7")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        EcsAdvancePaymentEntity entity = this.getInfo(id);
        switch (enableMark) {
            case 1: {
                entity.setAuditStatus(RecordAuditEnum.AUDITING.getCode());
                entity.setAdvanceSubmitTime(new Date());
                if (RecordsPdfEnum.FORCE.getCode().equals(entity.getGeneratePdfStatus())) {
                    entity.setGeneratePdfStatus(RecordsPdfEnum.FORCE_SYSTEM.getCode());
                    entity.setIsPrinted("9");
                    this.auditHandler(id);
                }
                this.updateById(entity);
                break;
            }
            case 2: {
                String title = "\u60a8\u6709\u4e00\u7b14\u5f85\u63d0\u4ea4\u590d\u6838\u7684\u501f\u6b3e\u5355\u5f85\u5904\u7406";
                HashMap<String, String> map = new HashMap<String, String>();
                List<String> userIds = this.ecsCompanyService.getUserIdsByReimbCompany(entity.getReimbCompany(), "1");
                this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_1.getCode(), userIds, title, "\u300c" + title + "\u300d,\u5355\u53f7\uff1a" + entity.getOrderNumber(), map, "\u63d0\u4ea4\u590d\u6838");
                entity.setAuditStatus(RecordAuditEnum.WAITING_PAYMENT.getCode());
                entity.setGeneratePdfStatus(RecordsPdfEnum.FINAL.getCode());
                this.updateById(entity);
                break;
            }
            case 4: {
                try {
                    entity.setIsPrinted("9");
                    this.updateById(entity);
                    this.auditHandler(id);
                }
                catch (Exception e) {
                    this.log.error("\u53d1\u9001\u6253\u5370\u6d88\u606f\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            case 5: {
                if (!"0".equals(model.getRejectAgreeStep())) break;
                if ("1".equals(model.getRejectAuditType())) {
                    entity.setGeneratePdfStatus(RecordsPdfEnum.FORCE.getCode());
                }
            }
            case 3: {
                entity.setAuditStatus(RecordAuditEnum.DRAFT.getCode());
                entity.setIsPrinted("0");
                this.updateById(entity);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.delete(entity);
                break;
            }
        }
        return false;
    }

    private void auditHandler(String id) {
        CompletableFuture.runAsync(() -> {
            for (int retryCount = 0; retryCount < 3; ++retryCount) {
                EcsAdvancePaymentEntity entity = this.getInfo(id);
                if ("9".equals(entity.getIsPrinted())) {
                    this.generatePDF(id);
                    break;
                }
                if (retryCount >= 2) continue;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.error("\u7761\u7720\u4e2d\u65ad", (Throwable)e);
                    break;
                }
            }
        }, this.ecsExecutor);
    }

    @Override
    public void batchReview(List<String> ids) {
        UserInfo userInfo = this.userProvider.get();
        List list = this.listByIds(ids);
        ArrayList<EcsAdvancePaymentEntity> needUpdateList = new ArrayList<EcsAdvancePaymentEntity>();
        for (EcsAdvancePaymentEntity entity : list) {
            if (!Objects.equals(entity.getReviewStatus(), RecordReviewStatusEnum.SUBMITTED.getCode())) continue;
            this.processEntity(entity, userInfo, needUpdateList);
        }
        if (CollUtil.isNotEmpty(needUpdateList)) {
            this.updateBatchById(needUpdateList);
        }
    }

    private void processEntity(EcsAdvancePaymentEntity entity, UserInfo userInfo, List<EcsAdvancePaymentEntity> needUpdateList) {
        String payAccount = entity.getPayAccount();
        EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)payAccount)).eq(EcsCompanyAccountEntity::getCompanyId, (Object)entity.getReimbCompany()));
        EcsAdvancePaymentEntity newEntity = this.createNewEntity(entity, userInfo);
        if ("1".equals(accountEntity.getIsZl())) {
            ActionResult<?> actionResult;
            PaymentVO paymentInfo = this.getPaymentInfo(entity.getId());
            if (AdvanceRecordTypeEnum.COMPANY_ADVANCE.getCode().equals(entity.getRecordTypeCode()) || AdvanceRecordTypeEnum.MARGIN_ADVANCE.getCode().equals(entity.getRecordTypeCode()) || AdvanceRecordTypeEnum.PERF_MARGIN_ADVANCE.getCode().equals(entity.getRecordTypeCode())) {
                paymentInfo.setSourceModule("ECS_ADVANCE_COMPANY");
            }
            if ((actionResult = this.skPaymentService.singlePayment(paymentInfo)).getCode() == 200) {
                needUpdateList.add(newEntity);
                this.sendCashierMessage(needUpdateList);
            }
        } else {
            newEntity.setAuditStatus(RecordAuditEnum.PAID.getCode());
            needUpdateList.add(newEntity);
            this.sendAuditMessage(entity);
        }
    }

    private EcsAdvancePaymentEntity createNewEntity(EcsAdvancePaymentEntity entity, UserInfo userInfo) {
        EcsAdvancePaymentEntity newEntity = new EcsAdvancePaymentEntity();
        newEntity.setId(entity.getId());
        newEntity.setReviewStatus(RecordReviewStatusEnum.REVIEWED.getCode());
        newEntity.setReviewTime(new Date());
        newEntity.setReimbCompany(entity.getReimbCompany());
        newEntity.setReviewUserId(userInfo.getUserId());
        newEntity.setReimbCompany(entity.getReimbCompany());
        newEntity.setReviewUserName(userInfo.getRealName());
        newEntity.setPayAmount(entity.getPayableAmount());
        return newEntity;
    }

    private void sendCashierMessage(List<EcsAdvancePaymentEntity> needUpdateList) {
        String title = String.format("\u60a8\u6709%d\u7b14\u5f85\u4ed8\u6b3e\u7684\u501f\u6b3e\u5355\u5f85\u5904\u7406", needUpdateList.size());
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> userIds = this.getUserIdsByReimbCompany(needUpdateList.get(0), "1");
        this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_3.getCode(), userIds, title, null, map, "\u4ed8\u6b3e");
    }

    private void sendAuditMessage(EcsAdvancePaymentEntity entity) {
        String creatorUserName = this.baseDataUtil.userSelectValue(entity.getCreatorUserId());
        this.ecsMessageService.sendAuditMessage(entity.getId(), entity.getUserId(), creatorUserName, () -> creatorUserName + "\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u501f\u6b3e\u5df2\u4ed8\u6b3e\u5b8c\u6bd5", () -> creatorUserName + "\u63d0\u4ea4\u7684\u300c" + entity.getTitle() + "\u300d" + entity.getRecordType() + "\u501f\u6b3e\u5df2\u4ed8\u6b3e\u5b8c\u6bd5, \u5355\u53f7\uff1a" + entity.getOrderNumber());
    }

    @Override
    public ActionResult<?> batchReviewPayment(EcsRecordsPaymentVO paymentVO) {
        EcsAdvancePaymentEntity ecsRecordsEntity;
        EcsCompanyEntity companyEntity;
        if (StrUtil.isEmpty((CharSequence)paymentVO.getPayAccount())) {
            return ActionResult.fail((String)"\u4ed8\u6b3e\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)paymentVO.getBankPscpt())) {
            return ActionResult.fail((String)"\u94f6\u884c\u9644\u8a00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> ids = paymentVO.getRecords();
        List list = this.listByIds(ids);
        UserInfo userInfo = this.userProvider.get();
        String userId = userInfo.getUserId();
        String userName = userInfo.getRealName();
        ArrayList entityList = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)list) && (StrUtil.isEmpty((CharSequence)(companyEntity = this.ecsCompanyService.getInfo((ecsRecordsEntity = (EcsAdvancePaymentEntity)list.get(0)).getReimbCompany())).getCashierRole()) || StrUtil.isEmpty((CharSequence)companyEntity.getPaymentRole()))) {
            return ActionResult.fail((String)(companyEntity.getName() + "\u672a\u8bbe\u7f6e\u51fa\u7eb3\u5ba1\u6838\u6216\u8005\u4ed8\u6b3e\u590d\u6838\u4eba!"));
        }
        list.iterator().forEachRemaining(entity -> {
            EcsAdvancePaymentEntity newEntity = new EcsAdvancePaymentEntity();
            newEntity.setId(entity.getId());
            newEntity.setReviewStatus(RecordReviewStatusEnum.SUBMITTED.getCode());
            newEntity.setAuditStatus(RecordAuditEnum.PAYMENT_IN.getCode());
            newEntity.setPayAccount(paymentVO.getPayAccount());
            newEntity.setPayRemark(paymentVO.getPayRemark());
            newEntity.setBankPscpt(paymentVO.getBankPscpt());
            newEntity.setSubmitReviewTime(new Date());
            newEntity.setReimbCompany(entity.getReimbCompany());
            newEntity.setSubmitReviewUserId(userId);
            newEntity.setSubmitReviewUserName(userName);
            entityList.add(newEntity);
        });
        if (!entityList.isEmpty()) {
            String title = String.format("\u60a8\u6709%d\u7b14\u5f85\u4ed8\u6b3e\u590d\u6838\u7684\u501f\u6b3e\u5355\u5f85\u5904\u7406", entityList.size());
            HashMap<String, String> map = new HashMap<String, String>();
            List<String> userIds = this.getUserIdsByReimbCompany((EcsAdvancePaymentEntity)entityList.get(0), "2");
            this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_2.getCode(), userIds, title, null, map, "\u4ed8\u6b3e\u590d\u6838");
            this.updateBatchById(entityList);
        }
        return ActionResult.success((String)"\u63d0\u4ea4\u590d\u6838\u6210\u529f");
    }

    @Override
    public List<String> getUserIdsByReimbCompany(EcsAdvancePaymentEntity entity, String type) {
        String reimbCompany = entity.getReimbCompany();
        EcsCompanyEntity companyEntity = this.ecsCompanyService.getInfo(reimbCompany);
        String paymentRole = companyEntity.getPaymentRole();
        String cashierRole = companyEntity.getCashierRole();
        String roleToUse = "";
        if ("1".equals(type)) {
            roleToUse = companyEntity.getCashierRole();
        } else if ("2".equals(type)) {
            roleToUse = companyEntity.getPaymentRole();
        }
        if (StrUtil.isNotBlank((CharSequence)roleToUse)) {
            List data = this.userRelationService.getListByObjectId(roleToUse);
            return data.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<EcsAdvancePaymentEntity> getAdvanceList(String recordId) {
        List<EcsRecordsAdvanceEntity> advanceList = this.ecsRecordsAdvanceService.getAdvanceList(recordId);
        if (CollUtil.isEmpty(advanceList)) {
            return Collections.emptyList();
        }
        List ids = advanceList.stream().map(EcsRecordsAdvanceEntity::getAdvanceId).collect(Collectors.toList());
        List ecsAdvancePaymentEntities = this.listByIds(ids);
        if (CollUtil.isEmpty((Collection)ecsAdvancePaymentEntities)) {
            return Collections.emptyList();
        }
        Map<String, EcsRecordsAdvanceEntity> advanceMap = advanceList.stream().collect(Collectors.toMap(EcsRecordsAdvanceEntity::getAdvanceId, v -> v));
        for (EcsAdvancePaymentEntity ecsAdvancePaymentEntity : ecsAdvancePaymentEntities) {
            EcsRecordsAdvanceEntity ecsRecordsAdvanceEntity = advanceMap.get(ecsAdvancePaymentEntity.getId());
            ecsAdvancePaymentEntity.setTotalUnpaidAmount(ecsRecordsAdvanceEntity.getShouldRepaymentAmount());
            ecsAdvancePaymentEntity.setRepaymentAmount(ecsRecordsAdvanceEntity.getRepaymentAmount());
            ecsAdvancePaymentEntity.setRepayingAmount(ecsRecordsAdvanceEntity.getRepayingAmount());
            ecsAdvancePaymentEntity.setCurrentPaymentAmount(ecsRecordsAdvanceEntity.getCurrentPaymentAmount());
        }
        return ecsAdvancePaymentEntities;
    }

    @Override
    @DSTransactional
    public void advanceApproval(String recordId, BudgetRecordOperateTypeEnum operateType) {
        List<EcsRecordsAdvanceEntity> advanceDetailList = this.ecsRecordsAdvanceService.getAdvanceList(recordId);
        if (CollUtil.isEmpty(advanceDetailList)) {
            return;
        }
        List advanceIds = advanceDetailList.stream().map(EcsRecordsAdvanceEntity::getAdvanceId).collect(Collectors.toList());
        List advanceList = this.listByIds(advanceIds);
        if (CollUtil.isEmpty((Collection)advanceList)) {
            return;
        }
        Map<String, EcsAdvancePaymentEntity> advanceMap = advanceList.stream().collect(Collectors.toMap(EcsAdvancePaymentEntity::getId, v -> v));
        Map<String, EcsRecordsAdvanceEntity> detailMap = advanceDetailList.stream().collect(Collectors.toMap(EcsRecordsAdvanceEntity::getAdvanceId, v -> v));
        for (EcsAdvancePaymentEntity advanceEntity : advanceList) {
            EcsRecordsAdvanceEntity detailEntity = detailMap.get(advanceEntity.getId());
            if (detailEntity == null) continue;
            BigDecimal currentWriteOffAmount = detailEntity.getCurrentPaymentAmount();
            BigDecimal originalRepaymentAmount = advanceEntity.getRepaymentAmount();
            BigDecimal originalRepayingAmount = advanceEntity.getRepayingAmount();
            switch (operateType) {
                case REIMBURSEMENT_SUBMIT: {
                    advanceEntity.setRepayingAmount(originalRepayingAmount.add(currentWriteOffAmount));
                    break;
                }
                case REIMBURSEMENT_CANCEL: {
                    advanceEntity.setRepayingAmount(originalRepayingAmount.subtract(currentWriteOffAmount));
                    break;
                }
                case REIMBURSEMENT_PASS: {
                    advanceEntity.setRepayingAmount(originalRepayingAmount.subtract(currentWriteOffAmount));
                    advanceEntity.setRepaymentAmount(originalRepaymentAmount.add(currentWriteOffAmount));
                }
            }
        }
        this.updateBatchById(advanceList);
    }

    @Override
    public PaymentVO getPaymentInfo(String id) {
        EcsAdvancePaymentEntity recordsEntity = this.getInfo(id);
        EcsBankCardEntity bankCardEntity = this.ecsBankCardService.getInfo(recordsEntity.getBankCardId());
        EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)recordsEntity.getPayAccount())).eq(EcsCompanyAccountEntity::getCompanyId, (Object)recordsEntity.getReimbCompany()));
        PaymentVO vo = new PaymentVO();
        vo.setEncode("EcsAdvancePaymentServiceImpl");
        vo.setSourceModule("ECS_ADVANCE");
        vo.setSourceId(id);
        vo.setSourceCode(recordsEntity.getOrderNumber());
        vo.setTitle(recordsEntity.getTitle());
        vo.setPypartyAccnum(recordsEntity.getPayAccount());
        vo.setRcvpyAccnum(bankCardEntity.getCardNumber().replaceAll("\\s+", ""));
        vo.setRcvpyAccnm(bankCardEntity.getUsername());
        vo.setBankFirmCode(bankCardEntity.getBankFirmCode());
        vo.setPyAccTp(bankCardEntity.getAccountType());
        vo.setAmt(recordsEntity.getTotalAdvanceAmount().setScale(2, RoundingMode.HALF_UP));
        String pscpt = accountEntity.getOpenBank().contains("\u6c11\u751f\u94f6\u884c") ? "386" : (StrUtil.isNotBlank((CharSequence)recordsEntity.getBankPscpt()) ? recordsEntity.getBankPscpt() : recordsEntity.getTitle());
        vo.setPscpt(pscpt);
        return vo;
    }

    @Override
    public void updatePaymentStateById(String id) {
        EcsAdvancePaymentEntity entity = this.getInfo(id);
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(EcsAdvancePaymentEntity::getId, (Object)id)).set(EcsAdvancePaymentEntity::getAuditStatus, (Object)RecordAuditEnum.PAID.getCode()));
    }

    @Override
    public Map<String, Object> getApprovedByCode(String taskId, Integer type) {
        HashMap map = MapUtil.newHashMap();
        map.put("handleId", "");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return map;
        }
        FlowTaskEntity flowTask = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getProcessId});
        String processId = flowTask.getProcessId();
        EcsAdvancePaymentEntity info = (EcsAdvancePaymentEntity)this.getById((Serializable)((Object)processId));
        if (info == null) {
            return map;
        }
        String organization = info.getOrganizationId();
        if (StringUtils.isBlank((CharSequence)organization)) {
            return map;
        }
        OrganizeEntity organizeInfo = this.serviceUtil.getOrganizeInfo(organization);
        String managerId = organizeInfo.getManagerId();
        managerId = this.getManagerByLevel(managerId, type.intValue(), new ArrayList<UserEntity>());
        map.put("handleId", managerId);
        return map;
    }

    @Override
    public Map<String, Object> getApprovedByUser(String taskId, Integer type) {
        HashMap map = MapUtil.newHashMap();
        map.put("handleId", "");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return map;
        }
        FlowTaskEntity flowTask = FlowUtil.getFlowTaskSubmited((String)taskId, (SFunction[])new SFunction[]{FlowTaskEntity::getProcessId});
        String processId = flowTask.getProcessId();
        EcsAdvancePaymentEntity info = (EcsAdvancePaymentEntity)this.getById((Serializable)((Object)processId));
        if (info == null) {
            return map;
        }
        String userId = info.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            return map;
        }
        type = type + 1;
        String managerId = this.getManagerByLevel(userId, type.intValue(), new ArrayList<UserEntity>());
        map.put("handleId", managerId);
        return map;
    }

    private String getManagerByLevel(String managerId, long level, List<UserEntity> userList) {
        if (--level == 0L) {
            return managerId;
        }
        UserEntity userEntity = userList.stream().filter(t -> t.getId().equals(managerId)).findFirst().orElse(null);
        if (userEntity == null && (userEntity = this.serviceUtil.getUserInfo(managerId)) != null) {
            userList.add(userEntity);
        }
        return userEntity != null ? this.getManagerByLevel(userEntity.getManagerId(), level, userList) : "";
    }
}

