/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBankCardEntity;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.enums.DeleteMarkEnum;
import com.bringspring.ecs.mapper.EcsBankCardMapper;
import com.bringspring.ecs.model.bankcard.EcsBankCardCrForm;
import com.bringspring.ecs.model.bankcard.EcsBankCardPagination;
import com.bringspring.ecs.model.bankcard.EcsBankCardUpForm;
import com.bringspring.ecs.service.EcsBankCardService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsBankCardServiceImpl
extends ServiceImpl<EcsBankCardMapper, EcsBankCardEntity>
implements EcsBankCardService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<EcsBankCardEntity> getList(EcsBankCardPagination ecsBankCardPagination) {
        return this.getTypeList(ecsBankCardPagination, "0");
    }

    @Override
    public List<EcsBankCardEntity> getTypeList(EcsBankCardPagination pagination, String dataType) {
        QueryWrapper ecsBankCardQueryWrapper = this.getQueryWrapper(pagination);
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            ecsBankCardQueryWrapper.lambda().orderByDesc(EcsBankCardEntity::getId);
        } else {
            try {
                String sidx = pagination.getSidx();
                EcsBankCardEntity ecsBankCardEntity = new EcsBankCardEntity();
                Field declaredField = ecsBankCardEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBankCardQueryWrapper = "asc".equalsIgnoreCase(pagination.getSort()) ? (QueryWrapper)ecsBankCardQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBankCardQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsBankCardQueryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)ecsBankCardQueryWrapper);
    }

    @Override
    public List<EcsBankCardEntity> getAuthList(EcsBankCardPagination pagination) {
        UserInfo userInfo = this.userProvider.get();
        if (StringUtils.isNotBlank((CharSequence)pagination.getCreatorUserId())) {
            userInfo = this.userProvider.get(pagination.getCreatorUserId(), null);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        if (StringUtils.isNotBlank((CharSequence)pagination.getSearchKey())) {
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(EcsBankCardEntity::getCardNumber, (Object)pagination.getSearchKey())).or()).like(EcsBankCardEntity::getBankName, (Object)pagination.getSearchKey())).or()).like(EcsBankCardEntity::getUsername, (Object)pagination.getSearchKey());
            });
        }
        UserInfo finalUserInfo = userInfo;
        queryWrapper.lambda().and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(EcsBankCardEntity::getVisibleType, (Object)"all")).or(subWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)subWrapper.eq(EcsBaseEntity::getCreatorUserId, (Object)finalUserInfo.getUserId());
            })).or(subWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)subWrapper.eq(EcsBankCardEntity::getVisibleType, (Object)"company")).eq(EcsBankCardEntity::getVisible, (Object)finalUserInfo.getOrganizeId());
            })).or(subWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)subWrapper.eq(EcsBankCardEntity::getVisibleType, (Object)"department-user")).and(innerWrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)innerWrapper.like(EcsBankCardEntity::getVisibleDept, (Object)finalUserInfo.getDepartmentId())).or()).like(EcsBankCardEntity::getVisibleUser, (Object)finalUserInfo.getUserId());
                });
            });
        });
        if (pagination.getIsAuth() == 1) {
            queryWrapper.lambda().eq(EcsBaseEntity::getCreatorUserId, (Object)finalUserInfo.getUserId());
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public EcsBankCardEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBankCardEntity::getId, (Object)id);
        return (EcsBankCardEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsBankCardCrForm ecsBankCardCrForm) {
        String mainId = RandomUtil.uuId();
        EcsBankCardEntity entity = (EcsBankCardEntity)JsonUtil.getJsonToBean((Object)ecsBankCardCrForm, EcsBankCardEntity.class);
        entity.setId(mainId);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        this.save(entity);
        this.setDefault(mainId);
    }

    @Override
    public void update(String id, EcsBankCardUpForm ecsBankCardUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsBankCardEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsBankCardEntity subEntity = (EcsBankCardEntity)JsonUtil.getJsonToBean((Object)ecsBankCardUpForm, EcsBankCardEntity.class);
            this.updateById(subEntity);
        }
    }

    @Override
    public void delete(EcsBankCardEntity entity) {
        if (entity != null) {
            String userId = this.userProvider.get().getUserId();
            entity.setDeleteMark(DeleteMarkEnum.DELETE.getDeleteMark());
            entity.setDeleteTime(new Date());
            entity.setDeleteUserId(userId);
            this.updateById(entity);
        }
    }

    private QueryWrapper<EcsBankCardEntity> getQueryWrapper(EcsBankCardPagination pagination) {
        Object object;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_bank_card"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_bank_card"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        queryWrapper.lambda().eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        if (StringUtils.isNotBlank((CharSequence)pagination.getSearchKey())) {
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(EcsBankCardEntity::getCardNumber, (Object)pagination.getSearchKey())).or()).like(EcsBankCardEntity::getBankName, (Object)pagination.getSearchKey())).or()).like(EcsBankCardEntity::getUsername, (Object)pagination.getSearchKey());
            });
        }
        return queryWrapper;
    }

    @Override
    public EcsBankCardEntity getBankCardByUserId(String userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(EcsBaseEntity::getCreatorUserId, (Object)userId)).eq(EcsBankCardEntity::getIsDefault, (Object)"1")).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        return (EcsBankCardEntity)this.getOne((Wrapper)queryWrapper, false);
    }

    @Override
    @DSTransactional
    public Boolean setDefault(String id) {
        EcsBankCardEntity entity = (EcsBankCardEntity)this.getById((Serializable)((Object)id));
        if (entity != null) {
            UserInfo userInfo = this.userProvider.get();
            if (!userInfo.getUserId().equals(entity.getCreatorUserId())) {
                return false;
            }
            if ("1".equals(entity.getIsDefault())) {
                return true;
            }
            this.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(EcsBankCardEntity::getIsDefault, (Object)"0")).eq(EcsBaseEntity::getCreatorUserId, (Object)userInfo.getUserId()));
            entity.setIsDefault("1");
            this.updateById(entity);
            return true;
        }
        return false;
    }
}

