/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PinYinUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.ecs.entity.EcsBudgetOrganizeAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeEntity;
import com.bringspring.ecs.mapper.EcsBudgetOrganizeMapper;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeCrForm;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeListQuery;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizePagination;
import com.bringspring.ecs.model.ecsbudgetorganize.EcsBudgetOrganizeUpForm;
import com.bringspring.ecs.model.ecsbudgetorganize.OrganizeDepartInfoVO;
import com.bringspring.ecs.model.ecsbudgetorganize.OrganizeDepartMergeVO;
import com.bringspring.ecs.model.ecsbudgetorganize.OrganizeDepartSplitVO;
import com.bringspring.ecs.service.EcsBudgetOrganizeAccountService;
import com.bringspring.ecs.service.EcsBudgetOrganizeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EcsBudgetOrganizeServiceImpl
extends ServiceImpl<EcsBudgetOrganizeMapper, EcsBudgetOrganizeEntity>
implements EcsBudgetOrganizeService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsBudgetOrganizeAccountService ecsBudgetOrganizeAccountService;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public List<EcsBudgetOrganizeEntity> getList(EcsBudgetOrganizePagination ecsBudgetOrganizePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetOrganizeNum = 0;
        QueryWrapper ecsBudgetOrganizeQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBudgetOrganizePagination.getBudgetId())) {
            ++ecsBudgetOrganizeNum;
            ecsBudgetOrganizeQueryWrapper.lambda().like(EcsBudgetOrganizeEntity::getBudgetId, (Object)ecsBudgetOrganizePagination.getBudgetId());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetOrganizeQueryWrapper.lambda().in(EcsBudgetOrganizeEntity::getYear, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetOrganizePagination.getSidx())) {
            ecsBudgetOrganizeQueryWrapper.lambda().orderByDesc(EcsBudgetOrganizeEntity::getYear);
        } else {
            try {
                String sidx = ecsBudgetOrganizePagination.getSidx();
                EcsBudgetOrganizeEntity ecsBudgetOrganizeEntity = new EcsBudgetOrganizeEntity();
                Field declaredField = ecsBudgetOrganizeEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetOrganizeQueryWrapper = "asc".equals(ecsBudgetOrganizePagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetOrganizeQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetOrganizeQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsBudgetOrganizePagination.getCurrentPage(), ecsBudgetOrganizePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetOrganizeQueryWrapper);
            return ecsBudgetOrganizePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsBudgetOrganizePagination.setData(list, list.size());
    }

    @Override
    public List<EcsBudgetOrganizeEntity> getTypeList(EcsBudgetOrganizePagination ecsBudgetOrganizePagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetOrganizeNum = 0;
        QueryWrapper ecsBudgetOrganizeQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBudgetOrganizePagination.getBudgetId())) {
            ++ecsBudgetOrganizeNum;
            ecsBudgetOrganizeQueryWrapper.lambda().like(EcsBudgetOrganizeEntity::getBudgetId, (Object)ecsBudgetOrganizePagination.getBudgetId());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetOrganizeQueryWrapper.lambda().in(EcsBudgetOrganizeEntity::getYear, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetOrganizePagination.getSidx())) {
            ecsBudgetOrganizeQueryWrapper.lambda().orderByDesc(EcsBudgetOrganizeEntity::getYear);
        } else {
            try {
                String sidx = ecsBudgetOrganizePagination.getSidx();
                EcsBudgetOrganizeEntity ecsBudgetOrganizeEntity = new EcsBudgetOrganizeEntity();
                Field declaredField = ecsBudgetOrganizeEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetOrganizeQueryWrapper = "asc".equals(ecsBudgetOrganizePagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetOrganizeQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetOrganizeQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsBudgetOrganizePagination.getCurrentPage(), ecsBudgetOrganizePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetOrganizeQueryWrapper);
                return ecsBudgetOrganizePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsBudgetOrganizePagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsBudgetOrganizeQueryWrapper);
    }

    @Override
    public EcsBudgetOrganizeEntity getInfo(String id, String year) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getId, (Object)id);
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getYear, (Object)year);
        return (EcsBudgetOrganizeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsBudgetOrganizeCrForm ecsBudgetOrganizeCrForm) {
        String mainId = RandomUtil.uuId();
        EcsBudgetOrganizeEntity entity = (EcsBudgetOrganizeEntity)JsonUtil.getJsonToBean((Object)ecsBudgetOrganizeCrForm, EcsBudgetOrganizeEntity.class);
        entity.setYear(mainId);
        this.save(entity);
    }

    @Override
    public void createDepartment(EcsBudgetOrganizeEntity entity) throws PermissionException {
        if (this.isExistByFullName(entity, false, false)) {
            throw new PermissionException("\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        entity.setCategory("manager");
        if (ObjectUtil.isEmpty((Object)entity.getEnCode())) {
            entity.setEnCode(PinYinUtil.getFirstSpell((String)entity.getFullName()));
        }
        UserInfo operatorUser = this.userProvider.get();
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        entity.setDeleteUserId(operatorUser.getUserId());
        entity.setDeleteTime(new Date());
        String organizeIdTree = this.getOrganizeIdTreeALL(entity);
        entity.setOrganizeIdTree(organizeIdTree);
        entity.setOrganizeId(this.getOrganizeIds(entity));
        this.save(entity);
    }

    @Override
    public void update(String id, EcsBudgetOrganizeUpForm ecsBudgetOrganizeUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsBudgetOrganizeEntity entity = this.getInfo(id, ecsBudgetOrganizeUpForm.getYear());
        if (entity != null) {
            EcsBudgetOrganizeEntity subentity = (EcsBudgetOrganizeEntity)JsonUtil.getJsonToBean((Object)ecsBudgetOrganizeUpForm, EcsBudgetOrganizeEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public void update(EcsBudgetOrganizeEntity entity, String category) {
        List<EcsBudgetOrganizeEntity> childrenList = this.getChildrenByCategory(entity.getId(), category);
        if (childrenList.isEmpty()) {
            return;
        }
        for (EcsBudgetOrganizeEntity child : childrenList) {
            String childOrganizeIdTree = this.getOrganizeIdTreeALL(entity);
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeEntity::getOrganizeIdTree, (Object)childOrganizeIdTree)).eq(EcsBudgetOrganizeEntity::getId, (Object)child.getId())).eq(EcsBudgetOrganizeEntity::getYear, (Object)child.getYear()));
            this.update(child, category);
        }
    }

    private List<EcsBudgetOrganizeEntity> getChildrenByCategory(String parentId, String category) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getParentId, (Object)parentId);
        if ("company".equals(category)) {
            queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getCategory, (Object)"company");
        } else {
            queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getCategory, (Object)"department");
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateDepartment(String id, EcsBudgetOrganizeEntity entity) {
        entity.setId(id);
        String organizeIdTree = this.getOrganizeIdTreeALL(entity);
        entity.setOrganizeIdTree(organizeIdTree);
        EcsBudgetOrganizeEntity existingDept = this.getInfo(id, entity.getYear());
        OrganizeEntity organizeInfo = this.organizeService.getInfo(id);
        if (existingDept == null) {
            return this.createNewDepartment(entity, organizeInfo, organizeIdTree);
        }
        return this.updateExistingDepartment(existingDept, entity, organizeInfo, organizeIdTree);
    }

    private boolean createNewDepartment(EcsBudgetOrganizeEntity entity, OrganizeEntity organizeInfo, String organizeIdTree) {
        EcsBudgetOrganizeEntity newDept = new EcsBudgetOrganizeEntity();
        BeanUtil.copyProperties((Object)organizeInfo, (Object)newDept, (String[])new String[0]);
        newDept.setYear(entity.getYear());
        newDept.setBudgetId(entity.getBudgetId());
        newDept.setEnabledMark(entity.getEnabledMark());
        newDept.setOrganizeIdTree(organizeIdTree);
        newDept.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        return this.save(newDept);
    }

    private boolean updateExistingDepartment(EcsBudgetOrganizeEntity existingDept, EcsBudgetOrganizeEntity entity, OrganizeEntity organizeInfo, String organizeIdTree) {
        String oldParentId = existingDept.getParentId();
        boolean parentChanged = !oldParentId.equals(entity.getParentId());
        UpdateWrapper update = Wrappers.update();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)update.lambda().set(EcsBudgetOrganizeEntity::getFullName, (Object)organizeInfo.getFullName())).set(EcsBudgetOrganizeEntity::getEnCode, (Object)entity.getEnCode())).set(EcsBudgetOrganizeEntity::getSortCode, (Object)entity.getSortCode())).set(EcsBudgetOrganizeEntity::getParentId, (Object)entity.getParentId())).set(EcsBudgetOrganizeEntity::getOrganizeIdTree, (Object)organizeIdTree)).set(EcsBudgetOrganizeEntity::getEnabledMark, (Object)entity.getEnabledMark())).set(EcsBudgetOrganizeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).eq(EcsBudgetOrganizeEntity::getId, (Object)existingDept.getId())).eq(EcsBudgetOrganizeEntity::getYear, (Object)existingDept.getYear());
        boolean result = this.update((Wrapper)update);
        if (parentChanged && result) {
            existingDept.setParentId(entity.getParentId());
            existingDept.setOrganizeIdTree(organizeIdTree);
            this.update(existingDept, existingDept.getCategory());
        }
        if (entity.getEnabledMark() == 0) {
            this.ecsBudgetOrganizeAccountService.stopBudgetAccount(entity.getYear(), entity.getId());
        }
        return result;
    }

    @Override
    public List<EcsBudgetOrganizeEntity> getListAll(List<String> idAll, String keyWord) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)keyWord)) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(EcsBudgetOrganizeEntity::getFullName, (Object)keyWord)).or()).like(EcsBudgetOrganizeEntity::getEnCode, (Object)keyWord);
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(EcsBudgetOrganizeEntity::getSortCode)).orderByDesc(EcsBudgetOrganizeEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(EcsBudgetOrganizeEntity::getLastModifyTime);
        }
        if (idAll.size() > 0) {
            queryWrapper.lambda().in(EcsBudgetOrganizeEntity::getId, idAll);
        }
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<EcsBudgetOrganizeEntity> getAllCompanyList(String keyWord) {
        EcsBudgetOrganizePagination ecsBudgetOrganizePagination = new EcsBudgetOrganizePagination();
        ecsBudgetOrganizePagination.setKeyword(keyWord);
        List<EcsBudgetOrganizeEntity> data = this.getList(ecsBudgetOrganizePagination);
        List<EcsBudgetOrganizeEntity> list = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(data, data), EcsBudgetOrganizeEntity.class);
        list = list.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        return list;
    }

    @Override
    public void getCompanyId(String organizeId, String year, List<String> organizeParentIdList) {
        EcsBudgetOrganizeEntity entity = this.getInfo(organizeId, year);
        if (entity != null) {
            if ("company".equals(entity.getCategory())) {
                organizeParentIdList.add(entity.getId());
            }
            if (StringUtils.isNotEmpty((String)entity.getParentId())) {
                this.getCompanyId(entity.getParentId(), year, organizeParentIdList);
            }
        }
    }

    @Override
    public String getOrganizeIds(EcsBudgetOrganizeEntity entity) {
        ArrayList<String> list = new ArrayList<String>();
        this.getCompanyId(entity.getParentId(), entity.getYear(), list);
        Collections.reverse(list);
        StringBuffer organizeIdTree = new StringBuffer();
        String organizeParentIdTree = organizeIdTree.toString();
        if (StringUtils.isNotEmpty(list)) {
            organizeParentIdTree = (String)list.get(list.size() - 1);
        }
        return organizeParentIdTree;
    }

    @Override
    public void getOrganizeIdTree(String organizeId, String year, List<String> organizeParentIdList) {
        EcsBudgetOrganizeEntity entity = this.getInfo(organizeId, year);
        if (entity != null) {
            organizeParentIdList.add(entity.getId());
            if (StringUtils.isNotEmpty((String)entity.getParentId())) {
                this.getOrganizeIdTree(entity.getParentId(), year, organizeParentIdList);
            }
        }
    }

    @Override
    public String getOrganizeIdTreeALL(EcsBudgetOrganizeEntity entity) {
        ArrayList<String> list = new ArrayList<String>();
        this.getOrganizeIdTree(entity.getParentId(), entity.getYear(), list);
        Collections.reverse(list);
        StringBuffer organizeIdTree = new StringBuffer();
        for (String organizeParentId : list) {
            organizeIdTree.append("," + organizeParentId);
        }
        organizeIdTree.append("," + entity.getId());
        String organizeParentIdTree = organizeIdTree.toString();
        if (StringUtils.isNotEmpty((String)organizeParentIdTree)) {
            organizeParentIdTree = organizeParentIdTree.replaceFirst(",", "");
        }
        return organizeParentIdTree;
    }

    @Override
    public boolean isExistByFullName(EcsBudgetOrganizeEntity entity, boolean isCheck, boolean isFilter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getFullName, (Object)entity.getFullName());
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getYear, (Object)entity.getYear());
        if (!isCheck) {
            List entityList;
            if (isFilter) {
                queryWrapper.lambda().ne(EcsBudgetOrganizeEntity::getId, (Object)entity.getId());
            }
            if ((entityList = this.list((Wrapper)queryWrapper)).size() > 0) {
                for (EcsBudgetOrganizeEntity organizeEntity : entityList) {
                    if (organizeEntity == null || !organizeEntity.getParentId().equals(entity.getParentId()) || !organizeEntity.getCategory().equals(entity.getCategory())) continue;
                    return true;
                }
            }
            return false;
        }
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean checkCodeUnique(String code, String id, String year) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EcsBudgetOrganizeEntity::getEnCode, (Object)code);
        queryWrapper.eq(EcsBudgetOrganizeEntity::getYear, (Object)year);
        queryWrapper.last("limit 1");
        EcsBudgetOrganizeEntity entity = (EcsBudgetOrganizeEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id, String year) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getEnCode, (Object)enCode);
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getYear, (Object)year);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(EcsBudgetOrganizeEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public List<EcsBudgetOrganizeEntity> getOrganizeListDataPermission(EcsBudgetOrganizeListQuery query) {
        EcsBudgetOrganizeEntity organizeEntity;
        UserInfo userInfo = this.userProvider.get();
        String organizeId = "";
        HashSet<String> validInputs = new HashSet<String>();
        validInputs.add("12");
        validInputs.add("14");
        validInputs.add("2");
        validInputs.add("3");
        validInputs.add("9");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (Objects.nonNull(query.getMenuId()) && query.getIsAuth() == 1 && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, query.getMenuId(), "ecs_budget_organize"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<EcsBudgetOrganizeEntity>();
            }
            queryWrapper = (QueryWrapper)companyAuth;
        }
        queryWrapper.lambda().orderByAsc(EcsBudgetOrganizeEntity::getSortCode);
        queryWrapper.lambda().eq(StrUtil.isNotBlank((CharSequence)query.getYear()), EcsBudgetOrganizeEntity::getYear, (Object)query.getYear());
        queryWrapper.lambda().eq(StrUtil.isNotBlank((CharSequence)query.getBudgetId()), EcsBudgetOrganizeEntity::getBudgetId, (Object)query.getBudgetId());
        organizeId = this.userProvider.get().getIsAdministrator().booleanValue() ? (StrUtil.isBlank((CharSequence)query.getCompany()) ? query.getOrganizeId() : query.getCompany()) : query.getOrganizeId();
        if (StrUtil.isNotBlank((CharSequence)query.getOrganizeId())) {
            String finalOrganizeId = organizeId;
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(EcsBudgetOrganizeEntity::getOrganizeId, (Object)finalOrganizeId)).or()).eq(EcsBudgetOrganizeEntity::getParentId, (Object)finalOrganizeId);
            });
        }
        if (query.getEnabledMark() != null) {
            queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getEnabledMark, (Object)query.getEnabledMark());
        }
        queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (StrUtil.isNotBlank((CharSequence)organizeId)) {
            if (!validInputs.contains(organizeId)) {
                String parentId;
                EcsBudgetOrganizeEntity currentEntity;
                String currentId = organizeId;
                while ((currentEntity = this.getOrganizeEntity(currentId, query.getYear())) != null && (parentId = currentEntity.getParentId()) != null && !parentId.isEmpty()) {
                    boolean exists = list.stream().anyMatch(entity -> entity.getId().equals(currentEntity.getId()));
                    if (!exists) {
                        list.add(currentEntity);
                    }
                    currentId = parentId;
                }
            } else {
                String finalOrganizeId1 = organizeId;
                List filteredList = list.stream().filter(entity -> !entity.getOrganizeId().equals(finalOrganizeId1)).collect(Collectors.toList());
                List<String> filteredIds = filteredList.stream().map(EcsBudgetOrganizeEntity::getId).collect(Collectors.toList());
                filteredIds.forEach(o -> list.addAll(this.getSubDepartmentsRecursively((String)o, query.getYear(), (Set<String>)new HashSet<String>())));
                EcsBudgetOrganizeEntity budgetOrganizeEntity = (EcsBudgetOrganizeEntity)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getId, (Object)"1")).eq(EcsBudgetOrganizeEntity::getYear, (Object)query.getYear()));
                if (budgetOrganizeEntity != null && list.stream().noneMatch(entity -> entity.getId().equals(budgetOrganizeEntity.getId()))) {
                    list.add(budgetOrganizeEntity);
                }
            }
        } else {
            EcsBudgetOrganizeEntity budgetOrganizeEntity = (EcsBudgetOrganizeEntity)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getId, (Object)"1")).eq(EcsBudgetOrganizeEntity::getYear, (Object)query.getYear()));
            if (budgetOrganizeEntity != null && list.stream().noneMatch(entity -> entity.getId().equals(budgetOrganizeEntity.getId()))) {
                list.add(budgetOrganizeEntity);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)list) && (organizeEntity = (EcsBudgetOrganizeEntity)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getParentId, (Object)"1")).eq(EcsBudgetOrganizeEntity::getOrganizeId, (Object)organizeId)).eq(EcsBudgetOrganizeEntity::getYear, (Object)query.getYear()))) != null && list.stream().noneMatch(entity -> entity.getId().equals(organizeEntity.getId()))) {
            list.add(organizeEntity);
        }
        return list;
    }

    private List<EcsBudgetOrganizeEntity> getSubDepartmentsRecursively(String organizeId, String year, Set<String> processedIds) {
        ArrayList<EcsBudgetOrganizeEntity> result = new ArrayList<EcsBudgetOrganizeEntity>();
        if (processedIds.contains(organizeId)) {
            return result;
        }
        processedIds.add(organizeId);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getParentId, (Object)organizeId)).eq(EcsBudgetOrganizeEntity::getYear, (Object)year)).eq(EcsBudgetOrganizeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).eq(EcsBudgetOrganizeEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        List subDepartments = this.list((Wrapper)queryWrapper);
        result.addAll(subDepartments);
        for (EcsBudgetOrganizeEntity subDepartment : subDepartments) {
            result.addAll(this.getSubDepartmentsRecursively(subDepartment.getId(), year, processedIds));
        }
        return result;
    }

    private EcsBudgetOrganizeEntity getOrganizeEntity(String organizeId, String year) {
        return (EcsBudgetOrganizeEntity)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getId, (Object)organizeId)).eq(EcsBudgetOrganizeEntity::getYear, (Object)year));
    }

    @Override
    public List<OrganizeEntity> getZXOrganizeListDataPermission() {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode);
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.organizeService.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public void delete(EcsBudgetOrganizeEntity entity) {
        if (entity != null) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeEntity::getDeleteMark, (Object)1)).eq(EcsBudgetOrganizeEntity::getId, (Object)entity.getId())).eq(EcsBudgetOrganizeEntity::getYear, (Object)entity.getYear()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActionResult departmentSplit(OrganizeDepartSplitVO splitVO) {
        String type = splitVO.getType();
        String year = splitVO.getYear();
        List accountEntityList = this.ecsBudgetOrganizeAccountService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year)).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)splitVO.getId()));
        BigDecimal totalPendingBudget = accountEntityList.stream().map(EcsBudgetOrganizeAccountEntity::getPendingBudget).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (totalPendingBudget.compareTo(BigDecimal.ZERO) > 0) {
            return ActionResult.fail((String)"\u8be5\u90e8\u95e8\u6709\u672a\u5ba1\u6279\u7ed3\u675f\u62a5\u9500,\u4e0d\u5141\u8bb8\u62c6\u5206");
        }
        switch (type) {
            case "1": {
                this.updateDepartmentName(splitVO);
                break;
            }
            case "2": {
                this.disableDepartment(splitVO);
                this.ecsBudgetOrganizeAccountService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeAccountEntity::getEnabledMark, (Object)0)).eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year)).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)splitVO.getId()));
                break;
            }
            default: {
                throw new IllegalArgumentException("\u65e0\u6548\u7684\u62c6\u5206\u7c7b\u578b");
            }
        }
        return this.saveEcsOrg(accountEntityList, splitVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActionResult departmentMerge(OrganizeDepartMergeVO mergeVO) {
        String year = mergeVO.getYear();
        List<OrganizeDepartInfoVO> departInfoVOList = mergeVO.getOrganizeDepartInfoVOList();
        for (OrganizeDepartInfoVO departInfo : departInfoVOList) {
            BigDecimal totalPendingBudget = this.getTotalPendingBudget(year, departInfo.getId());
            if (totalPendingBudget.compareTo(BigDecimal.ZERO) <= 0) continue;
            return ActionResult.fail((String)(departInfo.getFullName() + "\u6709\u672a\u5ba1\u6279\u7ed3\u675f\u62a5\u9500,\u4e0d\u5141\u8bb8\u62c6\u5206"));
        }
        EcsBudgetOrganizeEntity organizeEntity = this.createNewDepartment(mergeVO);
        List<EcsBudgetOrganizeAccountEntity> newAccountEntityList = this.mergeBudgets(departInfoVOList, year, organizeEntity.getId(), mergeVO.getCompanyId());
        this.disableDepartmentsAndBudgets(departInfoVOList, year);
        this.ecsBudgetOrganizeAccountService.saveBatch(newAccountEntityList);
        return ActionResult.success((String)"\u5408\u5e76\u6210\u529f");
    }

    @Override
    public List<String> getListTreeId(String parentId, String year) {
        List<String> listByParentId = this.getListByParentId(parentId, year).stream().map(item -> item.getId()).collect(Collectors.toList());
        List<String> strings = this.recursionTreeId(listByParentId, year);
        return strings;
    }

    public List<String> recursionTreeId(List<String> currentLevelIds, String year) {
        ArrayList<String> returnIds = new ArrayList<String>();
        if (currentLevelIds != null && !currentLevelIds.isEmpty()) {
            returnIds.addAll(currentLevelIds);
            for (String itemId : currentLevelIds) {
                List<EcsBudgetOrganizeEntity> childEntities = this.getListByParentId(itemId, year);
                if (ObjectUtil.isEmpty(childEntities)) continue;
                List<String> childIds = childEntities.stream().map(EcsBudgetOrganizeEntity::getId).collect(Collectors.toList());
                returnIds.addAll(this.recursionTreeId(childIds, year));
            }
        }
        return returnIds;
    }

    @Override
    public List<EcsBudgetOrganizeEntity> getListByParentId(String parentId, String year) {
        QueryWrapper basDeviceTypeQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)basDeviceTypeQueryWrapper.lambda().eq(EcsBudgetOrganizeEntity::getParentId, (Object)parentId)).eq(EcsBudgetOrganizeEntity::getYear, (Object)year)).orderByAsc(EcsBudgetOrganizeEntity::getSortCode);
        List list = this.list((Wrapper)basDeviceTypeQueryWrapper);
        return list;
    }

    private BigDecimal getTotalPendingBudget(String year, String costDeptId) {
        List accountEntities = this.ecsBudgetOrganizeAccountService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year)).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)costDeptId));
        return accountEntities.stream().map(EcsBudgetOrganizeAccountEntity::getPendingBudget).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private EcsBudgetOrganizeEntity createNewDepartment(OrganizeDepartMergeVO mergeVO) {
        OrganizeEntity serviceOne = (OrganizeEntity)this.organizeService.getOne((Wrapper)Wrappers.lambdaQuery().eq(OrganizeEntity::getId, (Object)mergeVO.getId()));
        EcsBudgetOrganizeEntity organizeEntity = new EcsBudgetOrganizeEntity();
        BeanUtil.copyProperties((Object)serviceOne, (Object)organizeEntity, (String[])new String[0]);
        organizeEntity.setBudgetId(mergeVO.getBudgetId());
        organizeEntity.setYear(mergeVO.getYear());
        this.save(organizeEntity);
        return organizeEntity;
    }

    private List<EcsBudgetOrganizeAccountEntity> mergeBudgets(List<OrganizeDepartInfoVO> departInfoVoList, String year, String newCostDeptId, String companyId) {
        HashMap<String, BigDecimal> annualBudgetMap = new HashMap<String, BigDecimal>();
        for (OrganizeDepartInfoVO depart : departInfoVoList) {
            List accountEntities = this.ecsBudgetOrganizeAccountService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year)).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)depart.getId()));
            for (EcsBudgetOrganizeAccountEntity account : accountEntities) {
                String key = this.createKey(account);
                annualBudgetMap.merge(key, account.getAnnualBudget(), BigDecimal::add);
            }
        }
        return this.createNewAccounts(newCostDeptId, companyId, year, annualBudgetMap);
    }

    private String createKey(EcsBudgetOrganizeAccountEntity account) {
        return String.join((CharSequence)"|", account.getAccountId(), account.getProject(), account.getWriteProject());
    }

    private List<EcsBudgetOrganizeAccountEntity> createNewAccounts(String costDeptId, String companyId, String year, Map<String, BigDecimal> annualBudgets) {
        ArrayList<EcsBudgetOrganizeAccountEntity> newAccounts = new ArrayList<EcsBudgetOrganizeAccountEntity>();
        for (Map.Entry<String, BigDecimal> entry : annualBudgets.entrySet()) {
            String[] split = entry.getKey().split("\\|");
            EcsBudgetOrganizeAccountEntity newAcc = new EcsBudgetOrganizeAccountEntity();
            String mainId = RandomUtil.uuId();
            newAcc.setId(mainId);
            newAcc.setId(RandomUtil.uuId());
            newAcc.setAccountId(split[0]);
            newAcc.setProject(split[1]);
            if (split.length == 3) {
                newAcc.setWriteProject(split[2]);
            }
            newAcc.setAnnualUseBudget(BigDecimal.ZERO);
            newAcc.setPendingBudget(BigDecimal.ZERO);
            newAcc.setCreatorTime(new Date());
            newAcc.setAnnualBudget(entry.getValue());
            newAcc.setInitBudget(entry.getValue());
            newAcc.setCostDept(costDeptId);
            newAcc.setYear(year);
            newAcc.setOrganizeId(companyId);
            newAccounts.add(newAcc);
        }
        return newAccounts;
    }

    private void disableDepartmentsAndBudgets(List<OrganizeDepartInfoVO> departInfoVOList, String year) {
        for (OrganizeDepartInfoVO departInfo : departInfoVOList) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeEntity::getEnabledMark, (Object)0)).eq(EcsBudgetOrganizeEntity::getId, (Object)departInfo.getId())).eq(EcsBudgetOrganizeEntity::getYear, (Object)year));
            this.ecsBudgetOrganizeAccountService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeAccountEntity::getEnabledMark, (Object)0)).eq(EcsBudgetOrganizeAccountEntity::getYear, (Object)year)).eq(EcsBudgetOrganizeAccountEntity::getCostDept, (Object)departInfo.getId()));
        }
    }

    private void updateDepartmentName(OrganizeDepartSplitVO splitAndMergeVO) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeEntity::getFullName, (Object)splitAndMergeVO.getFullName())).eq(EcsBudgetOrganizeEntity::getId, (Object)splitAndMergeVO.getId())).eq(EcsBudgetOrganizeEntity::getYear, (Object)splitAndMergeVO.getYear()));
    }

    private void disableDepartment(OrganizeDepartSplitVO splitAndMergeVO) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsBudgetOrganizeEntity::getEnabledMark, (Object)0)).eq(EcsBudgetOrganizeEntity::getId, (Object)splitAndMergeVO.getId())).eq(EcsBudgetOrganizeEntity::getYear, (Object)splitAndMergeVO.getYear()));
    }

    private ActionResult saveEcsOrg(List<EcsBudgetOrganizeAccountEntity> accountEntityList, OrganizeDepartSplitVO splitAndMergeVO) {
        List<OrganizeDepartInfoVO> organizeDepartInfoList = splitAndMergeVO.getOrganizeDepartInfoVOList();
        for (OrganizeDepartInfoVO vo : organizeDepartInfoList) {
            OrganizeEntity serviceOne = (OrganizeEntity)this.organizeService.getOne((Wrapper)Wrappers.lambdaQuery().eq(OrganizeEntity::getId, (Object)vo.getId()));
            BigDecimal ratio = vo.getRatio();
            EcsBudgetOrganizeEntity organizeEntity = new EcsBudgetOrganizeEntity();
            BeanUtil.copyProperties((Object)serviceOne, (Object)organizeEntity, (String[])new String[0]);
            organizeEntity.setBudgetId(splitAndMergeVO.getBudgetId());
            organizeEntity.setId(serviceOne.getId());
            organizeEntity.setYear(splitAndMergeVO.getYear());
            this.save(organizeEntity);
            if (ratio.compareTo(BigDecimal.ZERO) <= 0) continue;
            this.splitAccountBudget(organizeEntity.getId(), accountEntityList, splitAndMergeVO.getCompanyId(), splitAndMergeVO.getType(), ratio);
        }
        return ActionResult.success((String)"\u65b0\u589e\u90e8\u95e8\u6210\u529f");
    }

    private void splitAccountBudget(String id, List<EcsBudgetOrganizeAccountEntity> accountEntityList, String companyId, String type, BigDecimal ratio) {
        ArrayList<EcsBudgetOrganizeAccountEntity> newAccountEntities = new ArrayList<EcsBudgetOrganizeAccountEntity>();
        ArrayList<EcsBudgetOrganizeAccountEntity> updatedEntities = new ArrayList<EcsBudgetOrganizeAccountEntity>();
        for (EcsBudgetOrganizeAccountEntity organizeAccountEntity : accountEntityList) {
            BigDecimal originalAmount = organizeAccountEntity.getAnnualBudget();
            BigDecimal splitAmount = BigDecimal.ZERO;
            if (originalAmount.compareTo(BigDecimal.ZERO) > 0) {
                splitAmount = originalAmount.multiply(ratio.divide(BigDecimal.valueOf(100L)));
                if ("1".equals(type)) {
                    originalAmount = originalAmount.subtract(splitAmount);
                    organizeAccountEntity.setAnnualBudget(originalAmount);
                    updatedEntities.add(organizeAccountEntity);
                }
            }
            EcsBudgetOrganizeAccountEntity newEntity = new EcsBudgetOrganizeAccountEntity();
            String mainId = RandomUtil.uuId();
            BeanUtil.copyProperties((Object)organizeAccountEntity, (Object)newEntity, (String[])new String[0]);
            newEntity.setId(mainId);
            newEntity.setAnnualBudget(splitAmount);
            newEntity.setInitBudget(splitAmount);
            newEntity.setOrganizeId(companyId);
            newEntity.setCostDept(id);
            newEntity.setAnnualUseBudget(BigDecimal.ZERO);
            newEntity.setPendingBudget(BigDecimal.ZERO);
            newEntity.setCreatorTime(new Date());
            newAccountEntities.add(newEntity);
        }
        if ("1".equals(type)) {
            this.ecsBudgetOrganizeAccountService.updateBatchById(updatedEntities);
        }
        this.ecsBudgetOrganizeAccountService.saveBatch(newAccountEntities);
    }
}

