/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBudgetAccountEntity;
import com.bringspring.ecs.entity.EcsBudgetControlModeEntity;
import com.bringspring.ecs.entity.EcsBudgetEntity;
import com.bringspring.ecs.entity.EcsBudgetOrganizeEntity;
import com.bringspring.ecs.mapper.EcsBudgetMapper;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetCrForm;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetPagination;
import com.bringspring.ecs.model.ecsbudget.EcsBudgetUpForm;
import com.bringspring.ecs.model.ecsbudgetaccount.EcsBudgetAccountInfoVO;
import com.bringspring.ecs.service.EcsBudgetAccountService;
import com.bringspring.ecs.service.EcsBudgetControlModeService;
import com.bringspring.ecs.service.EcsBudgetOrganizeService;
import com.bringspring.ecs.service.EcsBudgetService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsBudgetServiceImpl
extends ServiceImpl<EcsBudgetMapper, EcsBudgetEntity>
implements EcsBudgetService {
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsBudgetControlModeService budgetControlModeService;
    @Autowired
    private EcsBudgetOrganizeService budgetOrganizeService;
    @Autowired
    private EcsBudgetAccountService accountService;

    @Override
    public List<EcsBudgetEntity> getList(EcsBudgetPagination ecsBudgetPagination) {
        Object object;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetNum = 0;
        QueryWrapper ecsBudgetQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsBudgetQueryWrapper, ecsBudgetPagination.getMenuId(), "ecs_budget"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsBudgetEntity>();
            }
            ecsBudgetQueryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(ecsBudgetQueryWrapper, ecsBudgetPagination.getMenuId(), "ecs_budget"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsBudgetEntity>();
            }
            ecsBudgetQueryWrapper = (QueryWrapper)object;
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetPagination.getCompanyId())) {
            ++ecsBudgetNum;
            ecsBudgetQueryWrapper.lambda().eq(EcsBudgetEntity::getCompanyId, (Object)ecsBudgetPagination.getCompanyId());
        }
        ecsBudgetQueryWrapper.lambda().eq(EcsBudgetEntity::getDeleteMark, (Object)0);
        if (StringUtils.isNotEmpty((String)ecsBudgetPagination.getName())) {
            ++ecsBudgetNum;
            ecsBudgetQueryWrapper.lambda().like(EcsBudgetEntity::getName, (Object)ecsBudgetPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetPagination.getControlType())) {
            ++ecsBudgetNum;
            ecsBudgetQueryWrapper.lambda().eq(EcsBudgetEntity::getControlType, (Object)ecsBudgetPagination.getControlType());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetQueryWrapper.lambda().in(EcsBudgetEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetPagination.getSidx())) {
            ecsBudgetQueryWrapper.lambda().orderByDesc(EcsBudgetEntity::getId);
        } else {
            try {
                String sidx = ecsBudgetPagination.getSidx();
                EcsBudgetEntity ecsBudgetEntity = new EcsBudgetEntity();
                Field declaredField = ecsBudgetEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetQueryWrapper = "asc".equals(ecsBudgetPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsBudgetPagination.getCurrentPage(), ecsBudgetPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetQueryWrapper);
            return ecsBudgetPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsBudgetPagination.setData(list, list.size());
    }

    @Override
    public List<EcsBudgetEntity> getTypeList(EcsBudgetPagination ecsBudgetPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsBudgetNum = 0;
        QueryWrapper ecsBudgetQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsBudgetPagination.getCompanyId())) {
            ++ecsBudgetNum;
            ecsBudgetQueryWrapper.lambda().eq(EcsBudgetEntity::getCompanyId, (Object)ecsBudgetPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)ecsBudgetPagination.getName())) {
            ++ecsBudgetNum;
            ecsBudgetQueryWrapper.lambda().like(EcsBudgetEntity::getName, (Object)ecsBudgetPagination.getName());
        }
        if (AllIdList.size() > 0) {
            ecsBudgetQueryWrapper.lambda().in(EcsBudgetEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsBudgetPagination.getSidx())) {
            ecsBudgetQueryWrapper.lambda().orderByDesc(EcsBudgetEntity::getId);
        } else {
            try {
                String sidx = ecsBudgetPagination.getSidx();
                EcsBudgetEntity ecsBudgetEntity = new EcsBudgetEntity();
                Field declaredField = ecsBudgetEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsBudgetQueryWrapper = "asc".equals(ecsBudgetPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsBudgetQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsBudgetQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsBudgetPagination.getCurrentPage(), ecsBudgetPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsBudgetQueryWrapper);
                return ecsBudgetPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsBudgetPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsBudgetQueryWrapper);
    }

    @Override
    public List<EcsBudgetEntity> getNewestList(EcsBudgetEntity entity) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)entity.getCompanyId()), EcsBudgetEntity::getCompanyId, (Object)entity.getCompanyId())).eq(EcsBudgetEntity::getEnabledMark, (Object)1)).orderByDesc(EcsBudgetEntity::getYear));
    }

    @Override
    public EcsBudgetEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsBudgetEntity::getId, (Object)id);
        return (EcsBudgetEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public ActionResult create(EcsBudgetCrForm ecsBudgetCrForm) {
        String mainId = RandomUtil.uuId();
        String yearStr = EcsBudgetServiceImpl.getYearFromDate(ecsBudgetCrForm.getYear());
        ecsBudgetCrForm.setYear(yearStr);
        boolean result = this.checkCompanyBudgetExists(ecsBudgetCrForm, yearStr);
        if (!result) {
            return ActionResult.fail((String)("\u516c\u53f8\u5df2\u5b58\u5728" + yearStr + "\u5e74\u5ea6\u9884\u7b97"));
        }
        EcsBudgetEntity entity = (EcsBudgetEntity)JsonUtil.getJsonToBean((Object)ecsBudgetCrForm, EcsBudgetEntity.class);
        entity.setId(mainId);
        this.save(entity);
        List<EcsBudgetControlModeEntity> controlModeEntities = ecsBudgetCrForm.getControlModeEntities();
        if (CollectionUtil.isNotEmpty(controlModeEntities) && ecsBudgetCrForm.getControlType().equals("2")) {
            controlModeEntities.forEach(o -> {
                o.setId(RandomUtil.uuId());
                o.setBudgetId(mainId);
            });
            this.budgetControlModeService.saveBatch(controlModeEntities);
        }
        String companyId = ecsBudgetCrForm.getCompanyId();
        ArrayList<EcsBudgetOrganizeEntity> organizeEntityArrayList = new ArrayList<EcsBudgetOrganizeEntity>();
        ArrayList<EcsBudgetAccountEntity> accountEntityArrayList = new ArrayList<EcsBudgetAccountEntity>();
        EcsBudgetOrganizeEntity budgetOrganizeEntity = (EcsBudgetOrganizeEntity)this.budgetOrganizeService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetOrganizeEntity::getId, (Object)"1")).eq(EcsBudgetOrganizeEntity::getYear, (Object)yearStr));
        if (ObjectUtil.isEmpty((Object)budgetOrganizeEntity)) {
            this.addNewOrganizationToList(organizeEntityArrayList, "1", yearStr, null);
        }
        this.addNewOrganizationToList(organizeEntityArrayList, companyId, yearStr, mainId);
        this.findAllSubDepartments(companyId).forEach(o -> this.addNewOrganizationToList(organizeEntityArrayList, o.getId(), yearStr, mainId));
        this.addNewAccountToList(accountEntityArrayList, yearStr, mainId);
        if (CollectionUtil.isNotEmpty(accountEntityArrayList)) {
            this.accountService.saveBatch(accountEntityArrayList);
        }
        this.budgetOrganizeService.saveBatch(organizeEntityArrayList);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    private void addNewOrganizationToList(List<EcsBudgetOrganizeEntity> list, String orgId, String yearStr, String budgetId) {
        List organizeEntityList = this.organizeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OrganizeEntity::getId, (Object)orgId)).eq(OrganizeEntity::getEnabledMark, (Object)1));
        organizeEntityList.forEach(o -> {
            EcsBudgetOrganizeEntity ecsBudgetOrganizeEntity = new EcsBudgetOrganizeEntity();
            BeanUtil.copyProperties((Object)o, (Object)ecsBudgetOrganizeEntity, (String[])new String[0]);
            ecsBudgetOrganizeEntity.setYear(yearStr);
            ecsBudgetOrganizeEntity.setBudgetId(budgetId);
            list.add(ecsBudgetOrganizeEntity);
        });
    }

    private void addNewAccountToList(List<EcsBudgetAccountEntity> list, String yearStr, String budgetId) {
        List accountEntities = this.accountService.list((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetAccountEntity::getYear, (Object)yearStr));
        if (CollectionUtil.isEmpty((Collection)accountEntities)) {
            String newYearStr;
            List<EcsBudgetAccountInfoVO> listTree;
            int year = Integer.parseInt(yearStr);
            if (CollectionUtil.isNotEmpty(listTree = this.accountService.getListTree("-1", null, newYearStr = Integer.toString(--year)))) {
                listTree.forEach(o -> {
                    EcsBudgetAccountEntity accountEntity = new EcsBudgetAccountEntity();
                    BeanUtil.copyProperties((Object)o, (Object)accountEntity, (String[])new String[0]);
                    accountEntity.setId(RandomUtil.uuId());
                    accountEntity.setYear(yearStr);
                    list.add(accountEntity);
                    if (o.getChildren() != null && !o.getChildren().isEmpty()) {
                        this.copyChildren(o.getChildren(), accountEntity.getId(), yearStr, budgetId, list, String.valueOf(accountEntity.getId()));
                    }
                });
            }
        }
    }

    private void copyChildren(List<EcsBudgetAccountInfoVO> children, String parentId, String yearStr, String budgetId, List<EcsBudgetAccountEntity> list, String parentIds) {
        for (EcsBudgetAccountInfoVO child : children) {
            EcsBudgetAccountEntity ecsChild = new EcsBudgetAccountEntity();
            BeanUtil.copyProperties((Object)child, (Object)ecsChild, (String[])new String[0]);
            ecsChild.setId(RandomUtil.uuId());
            ecsChild.setYear(yearStr);
            ecsChild.setBudgetId(budgetId);
            ecsChild.setParentId(parentId);
            ecsChild.setParentIds(parentIds + "," + ecsChild.getId());
            list.add(ecsChild);
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            this.copyChildren(child.getChildren(), ecsChild.getId(), yearStr, budgetId, list, ecsChild.getParentIds());
        }
    }

    public boolean checkCompanyBudgetExists(EcsBudgetCrForm ecsBudgetCrForm, String yearStr) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsBudgetEntity::getCompanyId, (Object)ecsBudgetCrForm.getCompanyId())).eq(EcsBudgetEntity::getYear, (Object)yearStr));
        return !CollectionUtil.isNotEmpty((Collection)list);
    }

    @Override
    public ActionResult update(String id, EcsBudgetUpForm ecsBudgetUpForm) {
        UserInfo userInfo = this.userProvider.get();
        String yearStr = EcsBudgetServiceImpl.getYearFromDate(ecsBudgetUpForm.getYear());
        ecsBudgetUpForm.setYear(yearStr);
        EcsBudgetEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsBudgetEntity subentity = (EcsBudgetEntity)JsonUtil.getJsonToBean((Object)ecsBudgetUpForm, EcsBudgetEntity.class);
            this.updateById(subentity);
            if (subentity.getControlType().equals("2")) {
                List<EcsBudgetControlModeEntity> controlModeEntities = ecsBudgetUpForm.getControlModeEntities();
                this.budgetControlModeService.remove((Wrapper)Wrappers.lambdaQuery().eq(EcsBudgetControlModeEntity::getBudgetId, (Object)id));
                controlModeEntities.forEach(o -> {
                    o.setId(RandomUtil.uuId());
                    o.setBudgetId(id);
                });
                this.budgetControlModeService.saveBatch(controlModeEntities);
            }
        }
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @Override
    public void delete(EcsBudgetEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public static String getYearFromDate(String dateStr) {
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Date date = null;
        try {
            date = inputFormat.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        if (calendar.get(2) == 11 && calendar.get(5) == 31) {
            ++year;
        }
        return String.valueOf(year);
    }

    public List<OrganizeEntity> findAllSubDepartments(String parentId) {
        ArrayList<OrganizeEntity> subDepartments = new ArrayList<OrganizeEntity>();
        List list = this.organizeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OrganizeEntity::getParentId, (Object)parentId)).orderByAsc(PermissionEntityBase::getSortCode)).orderByAsc(PermissionEntityBase::getCreatorTime));
        for (OrganizeEntity department : list) {
            if (!department.getParentId().equals(parentId) || subDepartments.contains(department)) continue;
            subDepartments.add(department);
            subDepartments.addAll(this.findAllSubDepartments(department.getId()));
        }
        return subDepartments;
    }
}

