/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsInvoiceLocalEntity;
import com.bringspring.ecs.mapper.EcsInvoiceLocalMapper;
import com.bringspring.ecs.service.EcsInvoiceLocalService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EcsInvoiceLocalServiceImpl
extends ServiceImpl<EcsInvoiceLocalMapper, EcsInvoiceLocalEntity>
implements EcsInvoiceLocalService {
    private static final Logger log = LoggerFactory.getLogger(EcsInvoiceLocalServiceImpl.class);
    private final String LOCAL_OCR_INVOICE_URL = "https://jsbos.bringspring.com/v1/workflows/run";
    @Value(value="${config.Domain:}")
    private String localOcrInvoiceUrl;
    private final String REQUEST_JSON = "{\n    \"inputs\": {\n        \"fileUrl\": {\n            \"transfer_method\": \"remote_url\",\n            \"type\": \"@docType\",\n            \"url\": \"@baseUrl@url\"\n        }\n    },\n    \"response_mode\": \"blocking\",\n    \"user\": \"admin\"\n}";
    @Autowired
    private Executor ecsExecutor;

    @Override
    public void saveInvoiceData(String id, String url) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, url})) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String docType = url.toLowerCase().endsWith("pdf") ? "document" : "image";
                String requestBody = "{\n    \"inputs\": {\n        \"fileUrl\": {\n            \"transfer_method\": \"remote_url\",\n            \"type\": \"@docType\",\n            \"url\": \"@baseUrl@url\"\n        }\n    },\n    \"response_mode\": \"blocking\",\n    \"user\": \"admin\"\n}".replace("@baseUrl", this.localOcrInvoiceUrl).replace("@docType", docType).replace("@url", url);
                try (HttpResponse authorization = ((HttpRequest)HttpUtil.createPost((String)"https://jsbos.bringspring.com/v1/workflows/run").header("Authorization", "Bearer app-brvuVS84GJ6H7VOwtmWfNdQ6")).timeout(30000).body(requestBody).execute(true);){
                    JsonNode outputsNode;
                    String body = authorization.body();
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode responseNode = objectMapper.readTree(body);
                    JsonNode dataNode = responseNode.get("data");
                    if (dataNode != null && dataNode.has("outputs") && (outputsNode = dataNode.get("outputs")).has("result")) {
                        String result = outputsNode.get("result").asText();
                        log.info("\u63d0\u53d6\u7684\u53d1\u7968\u6570\u636e: {}", (Object)result);
                        if (JsonUtil.isJSONString((String)result)) {
                            EcsInvoiceLocalEntity jsonToBean = (EcsInvoiceLocalEntity)JsonUtil.getJsonToBean((String)result, EcsInvoiceLocalEntity.class);
                            jsonToBean.setId(RandomUtil.uuId());
                            jsonToBean.setInvoiceId(id);
                            this.save(jsonToBean);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("\u672c\u5730OCR\u5931\u8d25", (Throwable)e);
            }
        }, this.ecsExecutor);
    }
}

