/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.docking.service.VoucherPushService;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsInvoiceRecordEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.RecordAuditEnum;
import com.bringspring.ecs.enums.RecordNeedReceiveInvoiceEnum;
import com.bringspring.ecs.enums.SendCashierTypeEnum;
import com.bringspring.ecs.enums.VoucherPushStateEnum;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.ecs.mapper.EcsInvoiceRecordMapper;
import com.bringspring.ecs.model.invoicerecord.EcsInvoiceRecordConfirmVO;
import com.bringspring.ecs.model.invoicerecord.EcsInvoiceRecordInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.service.EcsInvoiceRecordService;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.service.EcsMessageService;
import com.bringspring.ecs.service.EcsRecordsService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsInvoiceRecordServiceImpl
extends ServiceImpl<EcsInvoiceRecordMapper, EcsInvoiceRecordEntity>
implements EcsInvoiceRecordService {
    @Autowired
    private EcsInvoiceService invoiceService;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VoucherPushService voucherPushService;
    @Autowired
    private EcsMessageService ecsMessageService;
    @Autowired
    private EcsRecordsService ecsRecordsService;
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public List<EcsInvoiceRecordInfoVO> getReceiveInvoiceList(String id) {
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.lambda().eq(EcsInvoiceEntity::getRecordId, (Object)id);
        List list1 = this.invoiceService.list((Wrapper)queryWrapper1);
        Map<String, EcsInvoiceEntity> invoiceMap = list1.stream().collect(Collectors.toMap(EcsInvoiceEntity::getId, item -> item));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsInvoiceRecordEntity::getRecordId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        List infoList = JsonUtil.getJsonToList((Object)list, EcsInvoiceRecordInfoVO.class);
        for (EcsInvoiceRecordInfoVO info : infoList) {
            EcsInvoiceEntity invoiceEntity = invoiceMap.get(info.getInvoiceId());
            info.setInvoiceType(invoiceEntity.getInvoiceType());
            info.setInvoiceNumber(invoiceEntity.getInvoiceNumber());
        }
        return infoList;
    }

    @Override
    public void confirmReceiveInvoice(EcsInvoiceRecordConfirmVO confirmVO) {
        List<EcsInvoiceRecordInfoVO> invoiceList = confirmVO.getInvoiceList();
        if (CollUtil.isNotEmpty(invoiceList)) {
            for (EcsInvoiceRecordInfoVO infoVO : invoiceList) {
                infoVO.setRemark(confirmVO.getRemark());
            }
            List jsonToList = JsonUtil.getJsonToList(invoiceList, EcsInvoiceRecordEntity.class);
            this.updateBatchById(jsonToList);
        }
        List<EcsInvoiceRecordInfoVO> receiveInvoiceList = this.getReceiveInvoiceList(confirmVO.getRecordId());
        boolean allReceive = true;
        for (EcsInvoiceRecordInfoVO infoVO : receiveInvoiceList) {
            if (infoVO.getInvoiceStatus() != 0) continue;
            allReceive = false;
            break;
        }
        if (allReceive) {
            EcsRecordsEntity byId = (EcsRecordsEntity)this.recordsService.getById((Serializable)((Object)confirmVO.getRecordId()));
            byId.setNeedReceiveInvoice(RecordNeedReceiveInvoiceEnum.NOT_NEED_RECEIVE_INVOICE.getCode());
            if (RecordAuditEnum.WAITING_RECEIPT.getCode().equals(byId.getAuditStatus())) {
                byId.setAuditStatus(RecordAuditEnum.WAITING_PAYMENT.getCode());
            }
            this.recordsService.updateById(byId);
            String title = "\u60a8\u6709\u4e00\u7b14\u5f85\u63d0\u4ea4\u590d\u6838\u7684\u62a5\u9500\u5355\u5f85\u5904\u7406";
            HashMap<String, String> map = new HashMap<String, String>();
            List<String> userIds = this.ecsRecordsService.getUserIdsByReimbCompany(byId, "1");
            this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_1.getCode(), userIds, title, "\u300c" + title + "\u300d,\u5355\u53f7\uff1a" + byId.getOrderNumber(), map, "\u63d0\u4ea4\u590d\u6838");
        }
    }

    @Override
    public void deleteByRecordId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsInvoiceRecordEntity::getRecordId, (Object)id);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void batchReceiveInvoice(List<String> recordIds) {
        if (CollUtil.isEmpty(recordIds)) {
            return;
        }
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(EcsInvoiceRecordEntity::getRecordId, recordIds);
        List list = this.list((Wrapper)queryWrapper);
        for (EcsInvoiceRecordEntity entity : list) {
            if (entity.getInvoiceStatus() != null && entity.getInvoiceStatus() == 1) continue;
            entity.setInvoiceStatus(1);
            entity.setReceivedTime(new Date());
            entity.setReceivedUserId(userInfo.getUserId());
            entity.setReceivedUserName(userInfo.getRealName());
        }
        this.updateBatchById(list);
        List ecsRecordsEntities = this.recordsService.listByIds(recordIds);
        EcsConfigEntity config = this.ecsConfigService.getByKeyName("voucher", "1");
        String keyValue = config.getKeyValue();
        boolean isAuto = "1".equals(keyValue);
        int num = 0;
        for (EcsRecordsEntity recordsEntity : ecsRecordsEntities) {
            ++num;
            recordsEntity.setNeedReceiveInvoice(RecordNeedReceiveInvoiceEnum.NOT_NEED_RECEIVE_INVOICE.getCode());
            if (!RecordAuditEnum.WAITING_RECEIPT.getCode().equals(recordsEntity.getAuditStatus())) continue;
            if (isAuto || recordsEntity.getCompanyId().equals("14")) {
                recordsEntity.setAuditStatus(RecordAuditEnum.WAITING_PAYMENT.getCode());
            } else {
                recordsEntity.setAuditStatus(RecordAuditEnum.WAITING_VOUCHER.getCode());
            }
            if (!isAuto) continue;
            boolean voucher = false;
            try {
                voucher = this.voucherPushService.pushVoucher(recordsEntity.getId());
                if (voucher) {
                    String voucherNum = this.voucherPushService.getVoucherNum(recordsEntity.getId());
                    recordsEntity.setCostVoucherStatus(VoucherPushStateEnum.SUCCESS.getCode());
                    recordsEntity.setCostVoucherTime(new Date());
                    recordsEntity.setCostVoucherNum(voucherNum);
                    continue;
                }
                recordsEntity.setCostVoucherStatus(VoucherPushStateEnum.FAIL.getCode());
                recordsEntity.setCostVoucherTime(new Date());
            }
            catch (VoucherPushException voucherPushException) {}
        }
        this.recordsService.updateBatchById(ecsRecordsEntities);
        if (num > 0 && isAuto) {
            String title = String.format("\u60a8\u6709%d\u7b14\u5f85\u63d0\u4ea4\u590d\u6838\u7684\u62a5\u9500\u5355\u5f85\u5904\u7406", num);
            HashMap<String, String> map = new HashMap<String, String>();
            List<String> userIds = this.ecsRecordsService.getUserIdsByReimbCompany((EcsRecordsEntity)ecsRecordsEntities.get(0), "1");
            this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_1.getCode(), userIds, title, null, map, "\u63d0\u4ea4\u590d\u6838");
        }
    }
}

