/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsInvoiceRuleEntity;
import com.bringspring.ecs.mapper.EcsInvoiceRuleMapper;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRuleCrForm;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRulePagination;
import com.bringspring.ecs.model.invoicerule.EcsInvoiceRuleUpForm;
import com.bringspring.ecs.service.EcsInvoiceRuleService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class EcsInvoiceRuleServiceImpl
extends ServiceImpl<EcsInvoiceRuleMapper, EcsInvoiceRuleEntity>
implements EcsInvoiceRuleService {
    @Override
    public List<EcsInvoiceRuleEntity> getList(EcsInvoiceRulePagination ecsInvoiceRulePagination) {
        return this.getTypeList(ecsInvoiceRulePagination, "0");
    }

    @Override
    public List<EcsInvoiceRuleEntity> getTypeList(EcsInvoiceRulePagination ecsInvoiceRulePagination, String dataType) {
        QueryWrapper ecsInvoiceRuleQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsInvoiceRulePagination.getRuleName())) {
            ecsInvoiceRuleQueryWrapper.lambda().like(EcsInvoiceRuleEntity::getRuleName, (Object)ecsInvoiceRulePagination.getRuleName());
        }
        if (StringUtils.isNotEmpty((String)ecsInvoiceRulePagination.getRuleStrategy())) {
            ecsInvoiceRuleQueryWrapper.lambda().like(EcsInvoiceRuleEntity::getRuleStrategy, (Object)ecsInvoiceRulePagination.getRuleStrategy());
        }
        if (StringUtils.isEmpty((String)ecsInvoiceRulePagination.getSidx())) {
            ecsInvoiceRuleQueryWrapper.lambda().orderByDesc(EcsInvoiceRuleEntity::getId);
        } else {
            try {
                String sidx = ecsInvoiceRulePagination.getSidx();
                EcsInvoiceRuleEntity ecsInvoiceRuleEntity = new EcsInvoiceRuleEntity();
                Field declaredField = ecsInvoiceRuleEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsInvoiceRuleQueryWrapper = "asc".equalsIgnoreCase(ecsInvoiceRulePagination.getSort()) ? (QueryWrapper)ecsInvoiceRuleQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsInvoiceRuleQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(ecsInvoiceRulePagination.getCurrentPage(), ecsInvoiceRulePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsInvoiceRuleQueryWrapper);
            return ecsInvoiceRulePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)ecsInvoiceRuleQueryWrapper);
    }

    @Override
    public List<EcsInvoiceRuleEntity> getCompanyRuleList(EcsInvoiceRulePagination pagination) {
        List companyRules = this.list((Wrapper)new QueryWrapper().lambda().eq(EcsInvoiceRuleEntity::getCompanyId, (Object)pagination.getCompanyId()));
        List publicRules = this.list((Wrapper)new QueryWrapper().lambda().eq(EcsInvoiceRuleEntity::getCompanyId, (Object)"0"));
        Map<String, EcsInvoiceRuleEntity> ruleMap = publicRules.stream().collect(Collectors.toMap(EcsInvoiceRuleEntity::getRuleStrategy, rule -> rule));
        companyRules.forEach(rule -> ruleMap.put(rule.getRuleStrategy(), (EcsInvoiceRuleEntity)rule));
        Collection<EcsInvoiceRuleEntity> values = ruleMap.values();
        if (StringUtils.isNotBlank((CharSequence)pagination.getRuleType())) {
            return values.stream().filter(rule -> pagination.getRuleType().equals(rule.getRuleType())).collect(Collectors.toList());
        }
        return new ArrayList<EcsInvoiceRuleEntity>(ruleMap.values());
    }

    @Override
    public EcsInvoiceRuleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsInvoiceRuleEntity::getId, (Object)id);
        return (EcsInvoiceRuleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcsInvoiceRuleCrForm crForm) throws DataException {
        EcsInvoiceRuleEntity companyCustom = this.getCompanyCustom(crForm.getRuleStrategy(), crForm.getCompanyId());
        if (companyCustom != null) {
            throw new DataException("\u6b64\u89c4\u5219\u5df2\u5b58\u5728");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(EcsInvoiceRuleEntity::getRuleStrategy, (Object)crForm.getRuleStrategy())).eq(EcsInvoiceRuleEntity::getCompanyId, (Object)"0");
        EcsInvoiceRuleEntity defaultRule = (EcsInvoiceRuleEntity)this.getOne((Wrapper)queryWrapper);
        if (defaultRule.getCustomizable() == 0) {
            throw new DataException("\u6b64\u89c4\u5219\u4e0d\u53ef\u5b9a\u5236");
        }
        String mainId = RandomUtil.uuId();
        EcsInvoiceRuleEntity entity = (EcsInvoiceRuleEntity)JsonUtil.getJsonToBean((Object)crForm, EcsInvoiceRuleEntity.class);
        entity.setCustomizable(defaultRule.getCustomizable());
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void update(String id, EcsInvoiceRuleUpForm upForm) {
        if (Objects.equals(upForm.getCompanyId(), "0")) {
            throw new RuntimeException("\u9ed8\u8ba4\u89c4\u5219\u4e0d\u53ef\u4fee\u6539");
        }
        EcsInvoiceRuleEntity companyCustom = this.getCompanyCustom(upForm.getRuleStrategy(), upForm.getCompanyId());
        if (companyCustom != null) {
            companyCustom.setRuleName(upForm.getRuleName());
            companyCustom.setRuleDesc(upForm.getRuleDesc());
            companyCustom.setEnableMark(upForm.getEnableMark());
            this.updateById(companyCustom);
        }
    }

    private EcsInvoiceRuleEntity getCompanyCustom(String ruleStrategy, String companyId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(EcsInvoiceRuleEntity::getRuleStrategy, (Object)ruleStrategy)).eq(EcsInvoiceRuleEntity::getCompanyId, (Object)companyId);
        return (EcsInvoiceRuleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(EcsInvoiceRuleEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

