/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.entity.EcsInvoiceRecordEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.DeleteMarkEnum;
import com.bringspring.ecs.enums.InvoiceRecordEnum;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.mapper.EcsInvoiceMapper;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.invoice.EcsInvoicePagination;
import com.bringspring.ecs.model.invoice.EcsInvoicePaginationExportModel;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.service.EcsInvoiceLocalService;
import com.bringspring.ecs.service.EcsInvoiceRecordService;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.strategy.export.InvoiceExportManage;
import com.bringspring.ecs.strategy.ocr.recognize.InvoiceOcrService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceStrategyManager;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EcsInvoiceServiceImpl
extends ServiceImpl<EcsInvoiceMapper, EcsInvoiceEntity>
implements EcsInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(EcsInvoiceServiceImpl.class);
    @Autowired
    private InvoiceOcrService ocrService;
    @Autowired
    private InvoiceExportManage exportManage;
    @Autowired
    private InvoiceStrategyManager invoiceStrategyManager;
    @Autowired
    private FileMapper fileMapper;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsInvoiceRecordService ecsInvoiceRecordService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsConfigService configService;
    @Autowired
    private EcsInvoiceLocalService ecsInvoiceLocalService;

    @Override
    public List<EcsInvoiceEntity> getList(EcsInvoicePagination ecsInvoicePagination) {
        return this.getTypeList(ecsInvoicePagination, "0");
    }

    @Override
    public List<EcsInvoiceEntity> getTypeList(EcsInvoicePagination pagination, String dataType) {
        Object object;
        QueryWrapper invoiceQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(invoiceQueryWrapper, pagination.getMenuId(), "ecs_invoice"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsInvoiceEntity>();
            }
            invoiceQueryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(invoiceQueryWrapper, pagination.getMenuId(), "ecs_invoice"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return new ArrayList<EcsInvoiceEntity>();
            }
            invoiceQueryWrapper = (QueryWrapper)object;
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)invoiceQueryWrapper.lambda().eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark())).eq(StringUtils.isNotBlank((CharSequence)pagination.getInvoiceType()), EcsInvoiceEntity::getInvoiceType, (Object)pagination.getInvoiceType())).like(StringUtils.isNotBlank((CharSequence)pagination.getInvoiceNumber()), EcsInvoiceEntity::getInvoiceNumber, (Object)pagination.getInvoiceNumber())).ge(StringUtils.isNotBlank((CharSequence)pagination.getStartTime()), EcsInvoiceEntity::getInvoiceDate, (Object)pagination.getStartTime())).le(StringUtils.isNotBlank((CharSequence)pagination.getEndTime()), EcsInvoiceEntity::getInvoiceDate, (Object)pagination.getEndTime());
        QueryWrapper recordsQueryWrapper = new QueryWrapper();
        int recordQuery = 0;
        if (StringUtils.isNotBlank((CharSequence)pagination.getRecordStatus())) {
            ++recordQuery;
            recordsQueryWrapper.lambda().eq(EcsRecordsEntity::getAuditStatus, (Object)pagination.getRecordStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getUserId())) {
            ++recordQuery;
            recordsQueryWrapper.lambda().eq(EcsRecordsEntity::getUserId, (Object)pagination.getUserId());
        }
        if (recordQuery > 0) {
            recordsQueryWrapper.lambda().select(new SFunction[]{EcsRecordsEntity::getId}).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark());
            List recordsList = this.recordsService.list((Wrapper)recordsQueryWrapper);
            Set recordIds = recordsList.stream().map(EcsRecordsEntity::getId).collect(Collectors.toSet());
            if (CollUtil.isEmpty(recordIds)) {
                return new ArrayList<EcsInvoiceEntity>();
            }
            invoiceQueryWrapper.lambda().in(EcsInvoiceEntity::getRecordId, recordIds);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            invoiceQueryWrapper.lambda().orderByDesc(EcsBaseEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                EcsInvoiceEntity invoiceEntity = new EcsInvoiceEntity();
                Field declaredField = invoiceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                invoiceQueryWrapper = "asc".equalsIgnoreCase(pagination.getSort()) ? (QueryWrapper)invoiceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)invoiceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                log.error("\u6392\u5e8f\u5b57\u6bb5\u4e0d\u5b58\u5728", (Throwable)e);
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)invoiceQueryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)invoiceQueryWrapper);
    }

    @Override
    @DSTransactional
    public EcsInvoiceEntity saveInvoiceData(EcsInvoiceInfoVO invoice, AnnotationContext annotationContext) {
        String organizeId = this.userProvider.get().getOrganizeId();
        EcsInvoiceEntity invoiceEntity = (EcsInvoiceEntity)JsonUtil.getJsonToBean((Object)invoice, EcsInvoiceEntity.class);
        invoiceEntity.setCompanyId(organizeId);
        Object duplicate = annotationContext.getMetaData("duplicateId");
        invoiceEntity.setErrorFields(JsonUtil.getObjectToString(annotationContext.getErrorFields()));
        if (duplicate != null) {
            invoiceEntity.setId(duplicate.toString());
            invoiceEntity.setDeleteMark(DeleteMarkEnum.DELETE.getDeleteMark());
            this.updateById(invoiceEntity);
        } else {
            invoiceEntity.setId(RandomUtil.uuId());
            invoiceEntity.setDeleteMark(DeleteMarkEnum.DELETE.getDeleteMark());
            this.save(invoiceEntity);
        }
        return invoiceEntity;
    }

    @Override
    public EcsInvoiceInfoVO recognizeInvoice(Map<String, Object> data) throws Exception {
        try {
            AnnotationContext annotationContext = new AnnotationContext();
            String url = data.get("url").toString();
            data.forEach((key, value) -> {
                if (value != null) {
                    annotationContext.addMetaData((String)key, value.toString());
                }
            });
            FileEntity fileEntity = this.getInvoiceStoragePath(url);
            MultipartFile fileItem = FileUtil.createFileItem((File)new File(fileEntity.getStoragePath()));
            boolean preHandleImage = false;
            EcsConfigEntity preHandleImage1 = this.configService.getByKeyName("preHandleImage", "1");
            if (preHandleImage1 != null) {
                preHandleImage = "1".equals(preHandleImage1.getKeyValue());
            }
            EcsInvoiceInfoVO ocr = this.ocrService.ocr(fileItem, fileEntity.getSuffix(), preHandleImage);
            boolean sourcePdf = this.isSourcePdf(fileEntity.getStoragePath(), fileEntity.getSuffix());
            ocr.setFileType(sourcePdf ? "50" : "10");
            this.invoiceStrategyManager.execute(ocr, annotationContext);
            EcsUploadVO ecsUploadVO = new EcsUploadVO();
            ecsUploadVO.setName(fileEntity.getFileName());
            ecsUploadVO.setUrl(fileEntity.getUrl());
            ecsUploadVO.setSecondFilePath(fileEntity.getSecondFilePath());
            ecsUploadVO.setFileVersionId(fileEntity.getFileVersionId());
            ecsUploadVO.setFileDigest(fileEntity.getFileDigest());
            ecsUploadVO.setFileId(fileEntity.getObjName());
            ocr.setUploadFile(JsonUtil.getObjectToString((Object)Lists.newArrayList((Object[])new EcsUploadVO[]{ecsUploadVO})));
            EcsInvoiceEntity entity = this.saveInvoiceData(ocr, annotationContext);
            EcsInvoiceInfoVO jsonToBean = (EcsInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsInvoiceInfoVO.class);
            List<String> annotations = annotationContext.getAnnotations();
            String specialMark = annotations.isEmpty() ? "" : StringUtils.join(annotations, (String)",");
            jsonToBean.setSpecialMark(specialMark);
            jsonToBean.setErrorFields(JsonUtil.getObjectToString(annotationContext.getErrorFields()));
            this.ecsInvoiceLocalService.saveInvoiceData(entity.getId(), fileEntity.getUrl());
            return jsonToBean;
        }
        catch (InvoiceValidateException e) {
            log.error("Failed to recognize invoice", (Throwable)e);
            throw new DataException(e.getMessage());
        }
        catch (Exception e) {
            log.error("Failed to recognize invoice", (Throwable)e);
            throw new DataException("\u53d1\u7968\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u53d1\u7968\uff01");
        }
    }

    @Override
    public EcsInvoiceInfoVO manualCreate(Map<String, Object> data) throws Exception {
        try {
            boolean sourcePdf;
            AnnotationContext annotationContext = new AnnotationContext();
            String url = data.get("url").toString();
            data.forEach((key, value) -> {
                if (value != null) {
                    annotationContext.addMetaData((String)key, value.toString());
                }
            });
            FileEntity fileEntity = this.getInvoiceStoragePath(url);
            MultipartFile fileItem = FileUtil.createFileItem((File)new File(fileEntity.getStoragePath()));
            boolean preHandleImage = false;
            EcsConfigEntity preHandleImage1 = this.configService.getByKeyName("preHandleImage", "1");
            if (preHandleImage1 != null) {
                preHandleImage = "1".equals(preHandleImage1.getKeyValue());
            }
            EcsInvoiceInfoVO ocr = this.ocrService.ocr(fileItem, fileEntity.getSuffix(), preHandleImage);
            Object invoiceData = data.get("invoiceData");
            EcsInvoiceInfoVO jsonToBean1 = (EcsInvoiceInfoVO)JsonUtil.getJsonToBean((Object)invoiceData, EcsInvoiceInfoVO.class);
            if (jsonToBean1 != null) {
                ocr.setInvoiceNumber(jsonToBean1.getInvoiceNumber());
                ocr.setInvoiceDate(jsonToBean1.getInvoiceDate());
                ocr.setInvoiceAmount(jsonToBean1.getInvoiceAmount());
                ocr.setInvoiceAmountWords(ConvertNumberToUpper.digitUppercase(ocr.getInvoiceAmount().doubleValue()));
                ocr.setPassengerName(jsonToBean1.getPassengerName());
                ocr.setTravelDate(jsonToBean1.getTravelDate());
                ocr.setDepartureStation(jsonToBean1.getDepartureStation());
                ocr.setArrivalStation(jsonToBean1.getArrivalStation());
                if (StringUtils.isNotBlank((CharSequence)jsonToBean1.getPurchaserName())) {
                    ocr.setPurchaserName(jsonToBean1.getPurchaserName());
                }
                if (StringUtils.isNotBlank((CharSequence)jsonToBean1.getPurchaserTaxCode())) {
                    ocr.setPurchaserTaxCode(jsonToBean1.getPurchaserTaxCode());
                }
            }
            ocr.setFileType((sourcePdf = this.isSourcePdf(fileEntity.getStoragePath(), fileEntity.getSuffix())) ? "50" : "10");
            this.invoiceStrategyManager.execute(ocr, annotationContext);
            EcsUploadVO ecsUploadVO = new EcsUploadVO();
            ecsUploadVO.setName(fileEntity.getFileName());
            ecsUploadVO.setUrl(fileEntity.getUrl());
            ecsUploadVO.setSecondFilePath(fileEntity.getSecondFilePath());
            ecsUploadVO.setFileVersionId(fileEntity.getFileVersionId());
            ecsUploadVO.setFileDigest(fileEntity.getFileDigest());
            ecsUploadVO.setFileId(fileEntity.getObjName());
            ocr.setUploadFile(JsonUtil.getObjectToString((Object)Lists.newArrayList((Object[])new EcsUploadVO[]{ecsUploadVO})));
            EcsInvoiceEntity entity = this.saveInvoiceData(ocr, annotationContext);
            EcsInvoiceInfoVO jsonToBean = (EcsInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, EcsInvoiceInfoVO.class);
            List<String> annotations = annotationContext.getAnnotations();
            String specialMark = annotations.isEmpty() ? "" : StringUtils.join(annotations, (String)",");
            specialMark = "\u98ce\u9669\u53d1\u7968\uff0c\u9700\u4eba\u5de5\u5ba1\u6838," + specialMark;
            jsonToBean.setSpecialMark(specialMark);
            jsonToBean.setErrorFields(JsonUtil.getObjectToString(annotationContext.getErrorFields()));
            this.ecsInvoiceLocalService.saveInvoiceData(entity.getId(), fileEntity.getUrl());
            return jsonToBean;
        }
        catch (InvoiceValidateException e) {
            log.error("Failed to recognize invoice", (Throwable)e);
            throw new DataException(e.getMessage());
        }
        catch (Exception e) {
            log.error("Failed to recognize invoice", (Throwable)e);
            throw new DataException("\u53d1\u7968\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u53d1\u7968\uff01");
        }
    }

    @Override
    public DownloadVO export(EcsInvoicePaginationExportModel exportModel) {
        String selectKey = exportModel.getSelectKey();
        if (StringUtils.isBlank((CharSequence)selectKey)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        String[] keys = selectKey.split(",");
        EcsInvoicePagination pagination = (EcsInvoicePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), EcsInvoicePagination.class));
        List<EcsInvoiceEntity> typeList = this.getTypeList(pagination, exportModel.getDataType());
        List jsonToList = JsonUtil.getJsonToList(typeList, EcsInvoiceInfoVO.class);
        HashSet<String> recordIds = new HashSet<String>();
        for (EcsInvoiceInfoVO ecsInvoiceEntity : jsonToList) {
            recordIds.add(ecsInvoiceEntity.getRecordId());
        }
        if (CollUtil.isNotEmpty(recordIds)) {
            List recordsList = this.recordsService.listByIds(recordIds);
            Map<String, EcsRecordsEntity> collect = recordsList.stream().collect(Collectors.toMap(EcsRecordsEntity::getId, a -> a));
            for (EcsInvoiceInfoVO ecsInvoiceEntity : jsonToList) {
                EcsRecordsEntity entity = collect.get(ecsInvoiceEntity.getRecordId());
                if (entity == null) continue;
                ecsInvoiceEntity.setRecordReimbNumber(entity.getOrderNumber());
                ecsInvoiceEntity.setRecordReimbDate(DateUtil.formatDate((Date)entity.getCreatorTime()));
                ecsInvoiceEntity.setRecordReimbUserId(entity.getUserId());
                ecsInvoiceEntity.setRecordReimbUserName(this.baseDataUtil.userSelectValue(entity.getUserId()));
                ecsInvoiceEntity.setRecordStatus(entity.getAuditStatus());
                ecsInvoiceEntity.setRecordStatusName(this.baseDataUtil.getDictName(entity.getAuditStatus(), "EcsRecordStatus"));
            }
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(typeList, (String)"yyyy-MM-dd HH:mm:ss"));
        return this.exportManage.doExport(exportModel.getInvoiceOp(), Arrays.asList(keys), mapList);
    }

    public FileEntity getInvoiceStoragePath(String url) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FileEntity::getUrl, (Object)url)).eq(FileEntity::getModular, (Object)"ecs");
        return (FileEntity)this.fileMapper.selectOne((Wrapper)queryWrapper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BufferedImage pdfToImage(String url) {
        FileEntity invoiceStoragePath = this.getInvoiceStoragePath(url);
        try (PDDocument document = Loader.loadPDF((File)new File(invoiceStoragePath.getStoragePath()));){
            PDFRenderer renderer = new PDFRenderer(document);
            BufferedImage bufferedImage = renderer.renderImageWithDPI(0, 400.0f);
            return bufferedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void receiveInvoice(Map<String, Object> data) throws Exception {
        String storageLocation = data.get("storageLocation").toString();
        String invoiceNumber = data.get("invoiceNumber").toString();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsInvoiceEntity::getInvoiceNumber, (Object)invoiceNumber)).eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        EcsInvoiceEntity invoice = (EcsInvoiceEntity)this.getOne((Wrapper)queryWrapper, false);
        if (invoice == null) {
            throw new DataException("\u672a\u627e\u5230\u53d1\u7968\u4fe1\u606f");
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper1.lambda().eq(EcsInvoiceRecordEntity::getInvoiceId, (Object)invoiceNumber)).eq(EcsInvoiceRecordEntity::getInvoiceStatus, (Object)InvoiceRecordEnum.PENDING.getCode());
        EcsInvoiceRecordEntity one = (EcsInvoiceRecordEntity)this.ecsInvoiceRecordService.getOne((Wrapper)queryWrapper1, false);
        if (one == null) {
            throw new DataException("\u672a\u627e\u5230\u53d1\u7968\u8bb0\u5f55\u4fe1\u606f");
        }
        one.setStorageLocation(storageLocation);
        one.setReceivedUserId(this.userProvider.get().getUserId());
        one.setReceivedTime(new Date());
        this.ecsInvoiceRecordService.updateById(one);
    }

    /*
     * Exception decompiling
     */
    private boolean isSourcePdf(String pdfPath, String suffix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 34[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

