/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.util.DateUtil;
import com.bringspring.ecs.enums.EcsMessageTypeEnum;
import com.bringspring.ecs.enums.SendCashierTypeEnum;
import com.bringspring.ecs.service.EcsMessageService;
import com.bringspring.ecs.utils.EcsMessageUtils;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsMessageServiceImpl
implements EcsMessageService {
    private static final Logger log = LoggerFactory.getLogger(EcsMessageServiceImpl.class);
    @Autowired
    private EcsMessageUtils ecsMessageUtils;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public void sendAuditMessage(String id, String userId, String creatorUserName, Supplier<String> titleSupplier, Supplier<String> contentSupplier) {
        FlowTaskEntity flowTaskSubmited = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getFlowId, FlowTaskEntity::getThisStepId, FlowTaskEntity::getStatus, FlowTaskEntity::getFlowCode, FlowTaskEntity::getFullName, FlowTaskEntity::getFlowName});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("recordId", id);
        params.put("flowState", String.valueOf(flowTaskSubmited.getStatus()));
        params.put("flowId", flowTaskSubmited.getFlowId());
        params.put("enCode", flowTaskSubmited.getFlowCode());
        params.put("processId", id);
        params.put("type", "0");
        HashMap<String, String> otherKey = new HashMap<String, String>();
        otherKey.put("enCode", flowTaskSubmited.getFlowCode());
        otherKey.put("formType", "1");
        otherKey.put("processId", id);
        otherKey.put("type", "2");
        otherKey.put("taskOperatorId", null);
        otherKey.put("fullName", flowTaskSubmited.getFullName());
        otherKey.put("flowId", flowTaskSubmited.getFlowId());
        otherKey.put("flowName", flowTaskSubmited.getFlowName());
        otherKey.put("status", String.valueOf(flowTaskSubmited.getStatus()));
        otherKey.put("taskId", flowTaskSubmited.getId());
        otherKey.put("taskNodeId", flowTaskSubmited.getThisStepId());
        String messageTitle = titleSupplier.get();
        String messageContent = contentSupplier.get();
        this.sendAuditMessage(Lists.newArrayList((Object[])new String[]{userId}), messageTitle, messageContent, creatorUserName, params, otherKey);
    }

    @Override
    public void sendAuditMessage(List<String> userIds, String title, String content, String creatorUser, Map<String, String> params, Map<String, String> otherKey) {
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        String taskCode = EcsMessageTypeEnum.ECS_REIMB_AUDIT_SUCCESS.getMessage();
        String sendCode = EcsMessageTypeEnum.ECS_REIMB_AUDIT_SUCCESS.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        keys.put("CreatorUser", creatorUser);
        keys.put("MessageTime", DateUtil.dateFormat((Date)new Date()));
        String params1 = HttpUtil.toParams(params);
        String appUrl = "/#/pages/workFlow/flowCenter/index?" + params1;
        String pcUrl = "/#/ecs/reimbursementList/index.vue?" + params1;
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.ecsMessageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, userIds.get(0), termType, null, otherKey);
    }

    @Override
    public void sendPrintMessage(List<String> userIds, String title, String content, Map<String, String> params) {
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        String taskCode = EcsMessageTypeEnum.ECS_REIMB_PRINT.getMessage();
        String sendCode = EcsMessageTypeEnum.ECS_REIMB_PRINT.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        String params1 = HttpUtil.toParams(params);
        String appUrl = "";
        String pcUrl = "/#/ecs/reimbursementList/index.vue?" + params1;
        String termType = TermTypeEnum.TERM_PC.getCode();
        String termTypeDesc = "\u60a8\u7684\u5f85\u6253\u5370\u7684\u62a5\u9500\u5355\u636e\uff0c\u8bf7\u524d\u5f80PC\u7aef\u9875\u9762\u67e5\u770b\u5e76\u6253\u5370";
        this.ecsMessageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, userIds.get(0), termType, termTypeDesc, null);
    }

    @Override
    public void sendCashierMessage(String type, List<String> userIds, String title, String content, Map<String, String> params, String desc) {
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        String taskCode = EcsMessageTypeEnum.ECS_CASHIER.getMessage();
        String sendCode = EcsMessageTypeEnum.ECS_CASHIER.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        String params1 = HttpUtil.toParams(params);
        String appUrl = "";
        String pcUrl = "";
        if (SendCashierTypeEnum.CASHIER_1.getCode().equals(type)) {
            pcUrl = "/#/ecs/reimbursementList/index.vue";
        }
        if (SendCashierTypeEnum.CASHIER_2.getCode().equals(type)) {
            pcUrl = "/#/ecs/paymentReview/index.vue";
        }
        if (SendCashierTypeEnum.CASHIER_3.getCode().equals(type)) {
            pcUrl = "/#/ecs/skReview/index.vue";
        }
        String termType = TermTypeEnum.TERM_PC.getCode();
        String termTypeDesc = "\u60a8\u7684\u5f85\u5904\u7406" + desc + "\u7684\u62a5\u9500\u5355\u636e\uff0c\u8bf7\u524d\u5f80PC\u7aef\u9875\u9762\u67e5\u770b\u5904\u7406";
        this.ecsMessageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, String.join((CharSequence)",", userIds), termType, termTypeDesc, null);
    }

    @Override
    public void sendReceiveInvoiceMessage(List<String> userIds, Supplier<String> titleSupplier, Supplier<String> contentSupplier) {
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        String taskCode = EcsMessageTypeEnum.ECS_REIMB_PRINT.getMessage();
        String sendCode = EcsMessageTypeEnum.ECS_REIMB_PRINT.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", titleSupplier.get());
        keys.put("content", contentSupplier.get());
        String appUrl = "";
        String pcUrl = "/#/ecs/reimbursementList/index.vue";
        String termType = TermTypeEnum.TERM_PC.getCode();
        String termTypeDesc = "\u8bf7\u524d\u5f80PC\u7aef\u9875\u9762\u67e5\u770b";
        this.ecsMessageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollUtil.join(userIds, (CharSequence)","), termType, termTypeDesc, null);
    }

    @Override
    public void sendLoanMessage(List<String> userIds, Supplier<String> titleSupplier, Supplier<String> contentSupplier) {
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        String taskCode = EcsMessageTypeEnum.ECS_ADVANCE.getMessage();
        String sendCode = EcsMessageTypeEnum.ECS_ADVANCE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", titleSupplier.get());
        keys.put("content", contentSupplier.get());
        String appUrl = "";
        String pcUrl = "/#/ecs/advancePayment/list/index.vue";
        String termType = TermTypeEnum.TERM_PC.getCode();
        String termTypeDesc = "\u8bf7\u524d\u5f80PC\u7aef\u9875\u9762\u67e5\u770b";
        this.ecsMessageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollUtil.join(userIds, (CharSequence)","), termType, termTypeDesc, null);
    }

    @Override
    public void sendPurchaseMessage(String type, List<String> userIds, String title, String content, Map<String, String> params, String desc) {
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        String taskCode = EcsMessageTypeEnum.ECS_CASHIER.getMessage();
        String sendCode = EcsMessageTypeEnum.ECS_CASHIER.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        String params1 = HttpUtil.toParams(params);
        String appUrl = "";
        String pcUrl = "";
        if (SendCashierTypeEnum.CASHIER_1.getCode().equals(type)) {
            pcUrl = "/#/ecs/paymentcategories/index.vue";
        }
        if (SendCashierTypeEnum.CASHIER_2.getCode().equals(type)) {
            pcUrl = "/#/ecs/paymentcategories/review.vue";
        }
        String termType = TermTypeEnum.TERM_PC.getCode();
        String termTypeDesc = "\u60a8\u7684\u5f85\u5904\u7406" + desc + "\u7684\u4ed8\u6b3e\u5355\u636e\uff0c\u8bf7\u524d\u5f80PC\u7aef\u9875\u9762\u67e5\u770b\u5904\u7406";
        this.ecsMessageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, String.join((CharSequence)",", userIds), termType, termTypeDesc, null);
    }
}

