/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.docking.entity.vo.PaymentVO;
import com.bringspring.ecs.docking.service.SkPaymentService;
import com.bringspring.ecs.entity.EcsCompanyAccountEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsPaymentCategoriesEntity;
import com.bringspring.ecs.enums.RecordAuditEnum;
import com.bringspring.ecs.enums.RecordReviewStatusEnum;
import com.bringspring.ecs.enums.SendCashierTypeEnum;
import com.bringspring.ecs.mapper.EcsPaymentCategoriesMapper;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesCrForm;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesPagination;
import com.bringspring.ecs.model.ecspaymentcategories.EcsPaymentCategoriesUpForm;
import com.bringspring.ecs.model.ecspaymentcategories.PaymentCategoriesVO;
import com.bringspring.ecs.model.records.EcsRecordsPaymentVO;
import com.bringspring.ecs.service.EcsCompanyAccountService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsMessageService;
import com.bringspring.ecs.service.EcsPaymentCategoriesService;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsPaymentCategoriesServiceImpl
extends ServiceImpl<EcsPaymentCategoriesMapper, EcsPaymentCategoriesEntity>
implements EcsPaymentCategoriesService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private EcsMessageService ecsMessageService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private SkPaymentService skPaymentService;
    @Autowired
    private EcsCompanyAccountService companyAccountService;

    @Override
    public List<EcsPaymentCategoriesEntity> getList(EcsPaymentCategoriesPagination ecspaymentCategoriesPagination) {
        return this.getTypeList(ecspaymentCategoriesPagination, "0");
    }

    @Override
    public List<EcsPaymentCategoriesEntity> getTypeList(EcsPaymentCategoriesPagination ecspaymentCategoriesPagination, String dataType) {
        QueryWrapper ecspaymentCategoriesQueryWrapper = this.getQueryWrapper(ecspaymentCategoriesPagination);
        if (Objects.isNull(ecspaymentCategoriesQueryWrapper)) {
            return new ArrayList<EcsPaymentCategoriesEntity>();
        }
        if (StringUtils.isEmpty((String)ecspaymentCategoriesPagination.getSidx())) {
            ecspaymentCategoriesQueryWrapper.lambda().orderByDesc(EcsPaymentCategoriesEntity::getId);
        } else {
            try {
                String sidx = ecspaymentCategoriesPagination.getSidx();
                EcsPaymentCategoriesEntity ecspaymentCategoriesEntity = new EcsPaymentCategoriesEntity();
                Field declaredField = ecspaymentCategoriesEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecspaymentCategoriesQueryWrapper = "asc".equals(ecspaymentCategoriesPagination.getSort().toLowerCase()) ? (QueryWrapper)ecspaymentCategoriesQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecspaymentCategoriesQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            Page page = new Page(ecspaymentCategoriesPagination.getCurrentPage(), ecspaymentCategoriesPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecspaymentCategoriesQueryWrapper);
            return ecspaymentCategoriesPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)ecspaymentCategoriesQueryWrapper);
    }

    @Override
    public EcsPaymentCategoriesEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsPaymentCategoriesEntity::getId, (Object)id);
        return (EcsPaymentCategoriesEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(EcsPaymentCategoriesCrForm ecspaymentCategoriesCrForm) {
        String mainId = RandomUtil.uuId();
        EcsPaymentCategoriesEntity entity = (EcsPaymentCategoriesEntity)JsonUtil.getJsonToBean((Object)ecspaymentCategoriesCrForm, EcsPaymentCategoriesEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, EcsPaymentCategoriesUpForm ecspaymentCategoriesUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsPaymentCategoriesEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsPaymentCategoriesEntity subentity = (EcsPaymentCategoriesEntity)JsonUtil.getJsonToBean((Object)ecspaymentCategoriesUpForm, EcsPaymentCategoriesEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public Map<String, Object> getSummaryInformation(EcsPaymentCategoriesPagination pagination) {
        Map map = MapUtil.newHashMap();
        map.put("totalPaymentAmount", "0");
        QueryWrapper<EcsPaymentCategoriesEntity> queryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{"coalesce(sum(pay_amount),0) as totalPaymentAmount"});
        map = this.getMap((Wrapper)queryWrapper);
        return map;
    }

    @Override
    @DSTransactional
    public void saveRecord(PaymentCategoriesVO paymentCategoriesVO) throws DataException {
        String billNumber = this.baseDataUtil.getBillNumber("PaymentCategories", Boolean.valueOf(false));
        EcsPaymentCategoriesEntity paymentCategoriesEntity = new EcsPaymentCategoriesEntity();
        BeanUtils.copyProperties((Object)paymentCategoriesVO, (Object)paymentCategoriesEntity);
        paymentCategoriesEntity.setId(RandomUtil.uuId());
        paymentCategoriesEntity.setOrderNumber(billNumber);
        paymentCategoriesEntity.setAuditStatus(RecordAuditEnum.WAITING_PAYMENT.getCode());
        paymentCategoriesEntity.setReviewStatus(RecordReviewStatusEnum.NOT_SUBMITTED.getCode());
        this.save(paymentCategoriesEntity);
    }

    @Override
    public ActionResult<?> batchReviewPayment(EcsRecordsPaymentVO paymentVO) {
        EcsPaymentCategoriesEntity paymentCategories;
        EcsCompanyEntity companyEntity;
        if (StrUtil.isEmpty((CharSequence)paymentVO.getPayAccount())) {
            return ActionResult.fail((String)"\u4ed8\u6b3e\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)paymentVO.getBankPscpt())) {
            return ActionResult.fail((String)"\u94f6\u884c\u9644\u8a00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> ids = paymentVO.getRecords();
        List list = this.listByIds(ids);
        UserInfo userInfo = this.userProvider.get();
        String userId = userInfo.getUserId();
        String userName = userInfo.getRealName();
        ArrayList entityList = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)list) && (StrUtil.isEmpty((CharSequence)(companyEntity = this.ecsCompanyService.getInfo((paymentCategories = (EcsPaymentCategoriesEntity)list.get(0)).getReimbCompany())).getCashierRole()) || StrUtil.isEmpty((CharSequence)companyEntity.getPaymentRole()))) {
            return ActionResult.fail((String)(companyEntity.getName() + "\u672a\u8bbe\u7f6e\u51fa\u7eb3\u5ba1\u6838\u6216\u8005\u4ed8\u6b3e\u590d\u6838\u4eba!"));
        }
        list.iterator().forEachRemaining(entity -> {
            EcsPaymentCategoriesEntity newEntity = new EcsPaymentCategoriesEntity();
            newEntity.setId(entity.getId());
            newEntity.setReviewStatus(RecordReviewStatusEnum.SUBMITTED.getCode());
            newEntity.setAuditStatus(RecordAuditEnum.PAYMENT_IN.getCode());
            newEntity.setPayAccount(paymentVO.getPayAccount());
            newEntity.setPayRemark(paymentVO.getPayRemark());
            newEntity.setBankPscpt(paymentVO.getBankPscpt());
            newEntity.setSubmitReviewTime(new Date());
            newEntity.setReimbCompany(entity.getReimbCompany());
            newEntity.setSubmitReviewUserId(userId);
            newEntity.setSubmitReviewUserName(userName);
            entityList.add(newEntity);
        });
        if (!entityList.isEmpty()) {
            String title = String.format("\u60a8\u6709%d\u7b14\u91c7\u8d2d\u5f85\u4ed8\u6b3e\u590d\u6838\u7684\u62a5\u9500\u5355\u5f85\u5904\u7406", entityList.size());
            HashMap<String, String> map = new HashMap<String, String>();
            List<String> userIds = this.getUserIdsByReimbCompany((EcsPaymentCategoriesEntity)entityList.get(0), "2");
            this.ecsMessageService.sendCashierMessage(SendCashierTypeEnum.CASHIER_2.getCode(), userIds, title, null, map, "\u91c7\u8d2d\u4ed8\u6b3e\u590d\u6838");
            this.updateBatchById(entityList);
        }
        return ActionResult.success((String)"\u590d\u6838\u6210\u529f");
    }

    @Override
    public List<String> getUserIdsByReimbCompany(EcsPaymentCategoriesEntity entity, String type) {
        String reimbCompany = entity.getReimbCompany();
        EcsCompanyEntity companyEntity = this.ecsCompanyService.getInfo(reimbCompany);
        String paymentRole = companyEntity.getPaymentRole();
        String cashierRole = companyEntity.getCashierRole();
        String roleToUse = "";
        if ("1".equals(type)) {
            roleToUse = companyEntity.getCashierRole();
        } else if ("2".equals(type)) {
            roleToUse = companyEntity.getPaymentRole();
        }
        if (StrUtil.isNotBlank((CharSequence)roleToUse)) {
            List data = this.userRelationService.getListByObjectId(roleToUse);
            return data.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void batchReview(List<String> ids) {
        UserInfo userInfo = this.userProvider.get();
        List list = this.listByIds(ids);
        ArrayList<EcsPaymentCategoriesEntity> needUpdateList = new ArrayList<EcsPaymentCategoriesEntity>();
        for (EcsPaymentCategoriesEntity entity : list) {
            if (!Objects.equals(entity.getReviewStatus(), RecordReviewStatusEnum.SUBMITTED.getCode())) continue;
            this.processEntity(entity, userInfo, needUpdateList);
        }
        if (CollUtil.isNotEmpty(needUpdateList)) {
            this.updateBatchById(needUpdateList);
        }
    }

    @Override
    public PaymentVO getPaymentInfo(String id) {
        EcsPaymentCategoriesEntity recordsEntity = this.getInfo(id);
        EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)recordsEntity.getPayAccount())).eq(EcsCompanyAccountEntity::getCompanyId, (Object)recordsEntity.getReimbCompany()));
        PaymentVO vo = new PaymentVO();
        vo.setEncode("EcsPaymentCategoriesServiceImpl");
        vo.setSourceModule("ECS_PURCHASE_PAYMENT");
        vo.setSourceId(id);
        vo.setSourceCode(recordsEntity.getOrderNumber());
        vo.setTitle(recordsEntity.getTitle());
        vo.setPypartyAccnum(recordsEntity.getPayAccount());
        vo.setRcvpyAccnum(recordsEntity.getBankCardNo().replaceAll("\\s+", ""));
        vo.setRcvpyAccnm(recordsEntity.getRcvAccName());
        vo.setBankFirmCode(recordsEntity.getBankFirmCode());
        vo.setPyAccTp("00");
        vo.setAmt(recordsEntity.getPayAmount().setScale(2, RoundingMode.HALF_UP));
        String pscpt = accountEntity.getOpenBank().contains("\u6c11\u751f\u94f6\u884c") ? "386" : (StrUtil.isNotBlank((CharSequence)recordsEntity.getBankPscpt()) ? recordsEntity.getBankPscpt() : recordsEntity.getTitle());
        vo.setPscpt(pscpt);
        return vo;
    }

    @Override
    public List<Map<String, Object>> countByState(EcsPaymentCategoriesPagination pagination) {
        QueryWrapper<EcsPaymentCategoriesEntity> queryWrapper = this.getQueryWrapper(pagination);
        if (Objects.isNull(queryWrapper)) {
            return new ArrayList<Map<String, Object>>();
        }
        queryWrapper.select(new String[]{"count(*) as count,audit_status as state"});
        queryWrapper.groupBy((Object)"state");
        return this.listMaps((Wrapper)queryWrapper);
    }

    @Override
    public void updatePaymentStateById(String id) {
        EcsPaymentCategoriesEntity entity = this.getInfo(id);
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(EcsPaymentCategoriesEntity::getId, (Object)id)).set(EcsPaymentCategoriesEntity::getAuditStatus, (Object)RecordAuditEnum.PAID.getCode()));
    }

    private void processEntity(EcsPaymentCategoriesEntity entity, UserInfo userInfo, List<EcsPaymentCategoriesEntity> needUpdateList) {
        String payAccount = entity.getPayAccount();
        EcsCompanyAccountEntity accountEntity = (EcsCompanyAccountEntity)this.companyAccountService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EcsCompanyAccountEntity::getAccount, (Object)payAccount)).eq(EcsCompanyAccountEntity::getCompanyId, (Object)entity.getReimbCompany()));
        EcsPaymentCategoriesEntity newEntity = this.createNewEntity(entity, userInfo);
        if (entity.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            this.handlePaidCase(newEntity, entity, needUpdateList);
        } else {
            this.handleUnpaidCase(newEntity, entity, accountEntity, needUpdateList);
        }
    }

    private void handleUnpaidCase(EcsPaymentCategoriesEntity newEntity, EcsPaymentCategoriesEntity originalEntity, EcsCompanyAccountEntity accountEntity, List<EcsPaymentCategoriesEntity> needUpdateList) {
        if ("1".equals(accountEntity.getIsZl())) {
            this.processCashierPayment(newEntity, originalEntity, needUpdateList);
        } else {
            this.handlePaidCase(newEntity, originalEntity, needUpdateList);
        }
    }

    private void handlePaidCase(EcsPaymentCategoriesEntity newEntity, EcsPaymentCategoriesEntity originalEntity, List<EcsPaymentCategoriesEntity> needUpdateList) {
        newEntity.setAuditStatus(RecordAuditEnum.PAID.getCode());
        needUpdateList.add(newEntity);
    }

    private void processCashierPayment(EcsPaymentCategoriesEntity newEntity, EcsPaymentCategoriesEntity originalEntity, List<EcsPaymentCategoriesEntity> needUpdateList) {
        PaymentVO paymentInfo = this.getPaymentInfo(originalEntity.getId());
        ActionResult<?> actionResult = this.skPaymentService.singlePayment(paymentInfo);
        if (actionResult.getCode() == 200) {
            needUpdateList.add(newEntity);
            this.sendCashierMessage(needUpdateList);
        }
    }

    private EcsPaymentCategoriesEntity createNewEntity(EcsPaymentCategoriesEntity entity, UserInfo userInfo) {
        EcsPaymentCategoriesEntity newEntity = new EcsPaymentCategoriesEntity();
        newEntity.setId(entity.getId());
        newEntity.setReviewStatus(RecordReviewStatusEnum.REVIEWED.getCode());
        newEntity.setReviewTime(new Date());
        newEntity.setReimbCompany(entity.getReimbCompany());
        newEntity.setReviewUserId(userInfo.getUserId());
        newEntity.setReimbCompany(entity.getReimbCompany());
        newEntity.setPayAmount(entity.getPayAmount());
        return newEntity;
    }

    private void sendCashierMessage(List<EcsPaymentCategoriesEntity> needUpdateList) {
        String title = String.format("\u60a8\u6709%d\u7b14,\u91c7\u8d2d\u5f85\u4ed8\u6b3e\u7684\u5355\u636e\u5f85\u5904\u7406", needUpdateList.size());
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> userIds = this.getUserIdsByReimbCompany(needUpdateList.get(0), "1");
        this.ecsMessageService.sendPurchaseMessage(SendCashierTypeEnum.CASHIER_3.getCode(), userIds, title, null, map, "\u4ed8\u6b3e");
    }

    private QueryWrapper<EcsPaymentCategoriesEntity> getQueryWrapper(EcsPaymentCategoriesPagination pagination) {
        Object object;
        QueryWrapper queryWrapper = new QueryWrapper();
        UserInfo userInfo = this.userProvider.get();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && pagination.getIsAuth() == 1 && !userInfo.getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_payment_categories"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (!isPc && appPermission && pagination.getIsAuth() == 1 && !userInfo.getIsAdministrator().booleanValue()) {
            object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "ecs_payment_categories"));
            if (ObjectUtil.isEmpty((Object)object)) {
                return null;
            }
            queryWrapper = (QueryWrapper)object;
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getCompanyId())) {
            String[] split = pagination.getCompanyId().split(",");
            queryWrapper.lambda().in(EcsPaymentCategoriesEntity::getCompanyId, Arrays.asList(split));
        }
        if ("-1".equals(pagination.getAuditStatus())) {
            pagination.setAuditStatus(null);
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getReviewStatus())) {
            queryWrapper.lambda().eq(EcsPaymentCategoriesEntity::getReviewStatus, (Object)pagination.getReviewStatus());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(StringUtils.isNotBlank((CharSequence)pagination.getAuditStatus()), EcsPaymentCategoriesEntity::getAuditStatus, (Object)pagination.getAuditStatus())).eq(EcsPaymentCategoriesEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode())).like(StringUtils.isNotBlank((CharSequence)pagination.getTitle()), EcsPaymentCategoriesEntity::getTitle, (Object)pagination.getTitle())).like(StringUtils.isNotBlank((CharSequence)pagination.getOrderNumber()), EcsPaymentCategoriesEntity::getOrderNumber, (Object)pagination.getOrderNumber());
        if (Objects.nonNull(pagination.getSubmitReviewStartTime())) {
            queryWrapper.lambda().ge(EcsPaymentCategoriesEntity::getSubmitReviewTime, (Object)pagination.getSubmitReviewStartTime());
        }
        if (Objects.nonNull(pagination.getSubmitReviewEndTime())) {
            queryWrapper.lambda().le(EcsPaymentCategoriesEntity::getSubmitReviewTime, (Object)pagination.getSubmitReviewEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)pagination.getReimbCompanyId())) {
            queryWrapper.lambda().eq(EcsPaymentCategoriesEntity::getReimbCompany, (Object)pagination.getReimbCompanyId());
        }
        return queryWrapper;
    }

    @Override
    @DSTransactional
    public void delete(EcsPaymentCategoriesEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

