/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecs.docking.entity.vo.PaymentVO;
import com.bringspring.ecs.docking.enums.PayStateEnums;
import com.bringspring.ecs.docking.service.VoucherPushService;
import com.bringspring.ecs.docking.utils.PaymentUtils;
import com.bringspring.ecs.entity.EcsPaymentRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.RecordAuditEnum;
import com.bringspring.ecs.enums.VoucherPushStateEnum;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.ecs.mapper.EcsPaymentRecordsMapper;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsCrForm;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsPagination;
import com.bringspring.ecs.model.ecspaymentrecords.EcsPaymentRecordsUpForm;
import com.bringspring.ecs.service.EcsMessageService;
import com.bringspring.ecs.service.EcsPaymentRecordsService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsPaymentRecordsServiceImpl
extends ServiceImpl<EcsPaymentRecordsMapper, EcsPaymentRecordsEntity>
implements EcsPaymentRecordsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsMessageService ecsMessageService;
    @Autowired
    private EcsRecordsService ecsRecordsService;
    @Autowired
    private VoucherPushService voucherPushService;
    @Autowired
    private PaymentUtils paymentUtils;

    @Override
    public List<EcsPaymentRecordsEntity> getList(EcsPaymentRecordsPagination ecsPaymentRecordsPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsPaymentRecordsNum = 0;
        QueryWrapper ecsPaymentRecordsQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getSourceId())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getSourceId, (Object)ecsPaymentRecordsPagination.getSourceId());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getSourceCode())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getSourceCode, (Object)ecsPaymentRecordsPagination.getSourceCode());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getSourceType())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getSourceType, (Object)ecsPaymentRecordsPagination.getSourceType());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getPayState())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getPayState, (Object)ecsPaymentRecordsPagination.getPayState());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getReceiptState())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getReceiptState, (Object)ecsPaymentRecordsPagination.getReceiptState());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getReceiptUrl())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getReceiptUrl, (Object)ecsPaymentRecordsPagination.getReceiptUrl());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getDescription())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getDescription, (Object)ecsPaymentRecordsPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            ecsPaymentRecordsQueryWrapper.lambda().in(EcsPaymentRecordsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsPaymentRecordsPagination.getSidx())) {
            ecsPaymentRecordsQueryWrapper.lambda().orderByDesc(EcsPaymentRecordsEntity::getId);
        } else {
            try {
                String sidx = ecsPaymentRecordsPagination.getSidx();
                EcsPaymentRecordsEntity ecsPaymentRecordsEntity = new EcsPaymentRecordsEntity();
                Field declaredField = ecsPaymentRecordsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsPaymentRecordsQueryWrapper = "asc".equals(ecsPaymentRecordsPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsPaymentRecordsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsPaymentRecordsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecsPaymentRecordsPagination.getCurrentPage(), ecsPaymentRecordsPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecsPaymentRecordsQueryWrapper);
            return ecsPaymentRecordsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecsPaymentRecordsPagination.setData(list, list.size());
    }

    @Override
    public List<EcsPaymentRecordsEntity> getTypeList(EcsPaymentRecordsPagination ecsPaymentRecordsPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecsPaymentRecordsNum = 0;
        QueryWrapper ecsPaymentRecordsQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getSourceId())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getSourceId, (Object)ecsPaymentRecordsPagination.getSourceId());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getSourceCode())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getSourceCode, (Object)ecsPaymentRecordsPagination.getSourceCode());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getSourceType())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getSourceType, (Object)ecsPaymentRecordsPagination.getSourceType());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getPayState())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getPayState, (Object)ecsPaymentRecordsPagination.getPayState());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getReceiptState())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getReceiptState, (Object)ecsPaymentRecordsPagination.getReceiptState());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getReceiptUrl())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getReceiptUrl, (Object)ecsPaymentRecordsPagination.getReceiptUrl());
        }
        if (StringUtils.isNotEmpty((String)ecsPaymentRecordsPagination.getDescription())) {
            ++ecsPaymentRecordsNum;
            ecsPaymentRecordsQueryWrapper.lambda().like(EcsPaymentRecordsEntity::getDescription, (Object)ecsPaymentRecordsPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            ecsPaymentRecordsQueryWrapper.lambda().in(EcsPaymentRecordsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecsPaymentRecordsPagination.getSidx())) {
            ecsPaymentRecordsQueryWrapper.lambda().orderByDesc(EcsPaymentRecordsEntity::getId);
        } else {
            try {
                String sidx = ecsPaymentRecordsPagination.getSidx();
                EcsPaymentRecordsEntity ecsPaymentRecordsEntity = new EcsPaymentRecordsEntity();
                Field declaredField = ecsPaymentRecordsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecsPaymentRecordsQueryWrapper = "asc".equals(ecsPaymentRecordsPagination.getSort().toLowerCase()) ? (QueryWrapper)ecsPaymentRecordsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecsPaymentRecordsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecsPaymentRecordsPagination.getCurrentPage(), ecsPaymentRecordsPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecsPaymentRecordsQueryWrapper);
                return ecsPaymentRecordsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecsPaymentRecordsPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecsPaymentRecordsQueryWrapper);
    }

    @Override
    public EcsPaymentRecordsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcsPaymentRecordsEntity::getId, (Object)id);
        return (EcsPaymentRecordsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(EcsPaymentRecordsCrForm ecsPaymentRecordsCrForm) {
        String mainId = RandomUtil.uuId();
        EcsPaymentRecordsEntity entity = (EcsPaymentRecordsEntity)JsonUtil.getJsonToBean((Object)ecsPaymentRecordsCrForm, EcsPaymentRecordsEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, EcsPaymentRecordsUpForm ecsPaymentRecordsUpForm) {
        UserInfo userInfo = this.userProvider.get();
        EcsPaymentRecordsEntity entity = this.getInfo(id);
        if (entity != null) {
            EcsPaymentRecordsEntity subentity = (EcsPaymentRecordsEntity)JsonUtil.getJsonToBean((Object)ecsPaymentRecordsUpForm, EcsPaymentRecordsEntity.class);
            this.updateById(subentity);
            this.recordsService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(EcsRecordsEntity::getId, (Object)entity.getSourceId())).set(EcsRecordsEntity::getAuditStatus, (Object)RecordAuditEnum.PAID.getCode()));
        }
    }

    @Override
    public void savePaymentRecord(PaymentVO paymentVO) {
        EcsPaymentRecordsEntity paymentRecordsEntity = new EcsPaymentRecordsEntity();
        paymentRecordsEntity.setId(RandomUtil.uuId());
        paymentRecordsEntity.setEnCode(paymentVO.getEncode());
        paymentRecordsEntity.setSourceId(paymentVO.getSourceId());
        paymentRecordsEntity.setSourceCode(paymentVO.getSourceCode());
        paymentRecordsEntity.setSourceType(paymentVO.getSourceModule());
        paymentRecordsEntity.setTitle(paymentVO.getTitle());
        paymentRecordsEntity.setPayAcc(paymentVO.getPypartyAccnum());
        paymentRecordsEntity.setRcvAcc(paymentVO.getRcvpyAccnum());
        paymentRecordsEntity.setRcvAccName(paymentVO.getRcvpyAccnm());
        paymentRecordsEntity.setAmt(paymentVO.getAmt());
        this.save(paymentRecordsEntity);
    }

    @Override
    public void updatePaymentState(String id, String statusText, String PayStatus) {
        EcsPaymentRecordsEntity recordsEntity = (EcsPaymentRecordsEntity)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsPaymentRecordsEntity::getId, (Object)id));
        if (ObjectUtil.isNotEmpty((Object)recordsEntity)) {
            if (StrUtil.isNotBlank((CharSequence)PayStatus)) {
                this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(EcsPaymentRecordsEntity::getPayState, (Object)PayStatus)).eq(EcsPaymentRecordsEntity::getId, (Object)recordsEntity.getId()));
            }
            if (StrUtil.isNotBlank((CharSequence)PayStatus) && PayStateEnums.PYSTAT_04.getCode().equals(PayStatus)) {
                this.paymentUtils.event(id);
            }
            if (this.isPayStatusValid(PayStatus)) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.eq(EcsPaymentRecordsEntity::getId, (Object)recordsEntity.getId());
                try {
                    boolean voucher = this.voucherPushService.pushPayVoucher(recordsEntity.getId());
                    ((LambdaUpdateWrapper)updateWrapper.set(EcsPaymentRecordsEntity::getPayVoucherTime, (Object)new Date())).set(EcsPaymentRecordsEntity::getPayVoucherStatus, (Object)(voucher ? VoucherPushStateEnum.SUCCESS.getCode() : VoucherPushStateEnum.FAIL.getCode()));
                    if (voucher) {
                        String voucherNum = this.voucherPushService.getVoucherNum(recordsEntity.getId());
                        updateWrapper.set(EcsPaymentRecordsEntity::getPayVoucherNum, (Object)voucherNum);
                    }
                }
                catch (VoucherPushException voucherPushException) {
                    // empty catch block
                }
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    private boolean isPayStatusValid(String payStatus) {
        return StrUtil.isNotBlank((CharSequence)payStatus) && (PayStateEnums.PYSTAT_04.getCode().equals(payStatus) || PayStateEnums.PYSTAT_05.getCode().equals(payStatus));
    }

    @Override
    public void updatePaymentRecepit(String code, String receiptUrl) {
        EcsPaymentRecordsEntity recordsEntity = (EcsPaymentRecordsEntity)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsPaymentRecordsEntity::getSourceCode, (Object)code));
        if (ObjectUtil.isNotEmpty((Object)recordsEntity)) {
            if (!recordsEntity.getPayState().equals(PayStateEnums.PYSTAT_04.getCode()) && StrUtil.isNotBlank((CharSequence)receiptUrl)) {
                this.paymentUtils.event(recordsEntity.getId());
            }
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(EcsPaymentRecordsEntity::getId, (Object)recordsEntity.getId());
            if (StrUtil.isNotBlank((CharSequence)receiptUrl)) {
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(EcsPaymentRecordsEntity::getReceiptUrl, (Object)receiptUrl)).set(EcsPaymentRecordsEntity::getReceiptState, (Object)"1")).set(EcsPaymentRecordsEntity::getPayState, (Object)PayStateEnums.PYSTAT_04.getCode());
            }
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public EcsPaymentRecordsEntity getPaymentRecord(String sourceId) {
        return (EcsPaymentRecordsEntity)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(EcsPaymentRecordsEntity::getSourceId, (Object)sourceId));
    }

    @Override
    public List<EcsPaymentRecordsEntity> getPaymentRecordBylvmsg() {
        List paymentRecordsEntities = this.list((Wrapper)Wrappers.lambdaQuery().ne(EcsPaymentRecordsEntity::getPayState, (Object)PayStateEnums.PYSTAT_04.getCode()));
        return paymentRecordsEntities;
    }

    @Override
    @DSTransactional
    public void delete(EcsPaymentRecordsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

