/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.ecs.constants.GlobalConstants;
import com.bringspring.ecs.entity.EcsAdvancePaymentEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.entity.EcsRecordsSubsidyEntity;
import com.bringspring.ecs.enums.CompanyTaxpayerTypeEnum;
import com.bringspring.ecs.model.bankcard.EcsBankCardInfoVO;
import com.bringspring.ecs.model.ecsadvancepayment.EcsAdvancePaymentInfoVO;
import com.bringspring.ecs.model.ecsbudgetorganizeaccount.EcsUploadVO;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.model.pdf.EcsFlowInfoVO;
import com.bringspring.ecs.model.pdf.EcsRecordPdfChargesVO;
import com.bringspring.ecs.model.pdf.EcsRecordPdfFlowVO;
import com.bringspring.ecs.model.pdf.EcsRecordPdfInvoiceFileVO;
import com.bringspring.ecs.model.pdf.EcsRecordPdfVO;
import com.bringspring.ecs.model.records.EcsRecordsInfoVO;
import com.bringspring.ecs.model.subject.EcsRecordsChargesDetailInfoVO;
import com.bringspring.ecs.service.EcsAdvancePaymentService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsPdfService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.ecs.utils.ConvertNumberToUpper;
import com.bringspring.ecs.utils.TransformImageUtil;
import com.bringspring.files.entity.FileEntity;
import com.bringspring.files.mapper.FileMapper;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorRecordService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PageHeader;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.component.Barcode;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.component.Image;
import org.dromara.pdf.pdfbox.core.component.Rectangle;
import org.dromara.pdf.pdfbox.core.component.Table;
import org.dromara.pdf.pdfbox.core.component.TableCell;
import org.dromara.pdf.pdfbox.core.component.TableHeader;
import org.dromara.pdf.pdfbox.core.component.TableRow;
import org.dromara.pdf.pdfbox.core.component.Textarea;
import org.dromara.pdf.pdfbox.core.enums.BarcodeType;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.core.ext.processor.RenderProcessor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcsPdfServiceImpl
implements EcsPdfService {
    private static final Logger log = LoggerFactory.getLogger(EcsPdfServiceImpl.class);
    private static final float FONT_SIZE = 9.0f;
    private static final Color COLOR_CUSTOM_FILL_GRAY = new Color(0xF2F2F2);
    private static final Color COLOR_CUSTOM_LINE_GRAY = new Color(0xD7D7D7);
    private static final String FONT_BOLD_NAME = "\u601d\u6e90\u9ed1\u4f53 Bold";
    private static final String FONT_REGULAR_NAME = "\u601d\u6e90\u9ed1\u4f53";
    private static final PageSize A5_PAGE_SIZE = PageSize.create((float)(210.0f * PageSize.getUnit()), (float)(148.0f * PageSize.getUnit()));
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private EcsRecordsService recordsService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private FileMapper fileMapper;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskOperatorRecordService taskOperatorRecordService;
    @Autowired
    private FlowTaskNodeService taskNodeService;
    @Autowired
    private EcsAdvancePaymentService ecsAdvancePaymentService;

    @Override
    public EcsUploadVO getRecordPDF(String id) {
        EcsRecordsEntity recordEntity = (EcsRecordsEntity)this.recordsService.getById((Serializable)((Object)id));
        if ("1".equals(recordEntity.getIsPrinted())) {
            recordEntity.setIsPrinted("2");
            this.recordsService.updateById(recordEntity);
        }
        String reimbPerson = this.baseDataUtil.userSelectValue(recordEntity.getUserId());
        String reimbDate = DateUtil.formatDate((Date)recordEntity.getCreatorTime());
        String companyCode = GlobalConstants.PDF_COMPANY_NAME.getOrDefault(recordEntity.getCompanyId(), "RK");
        String fileName = companyCode + "_" + recordEntity.getOrderNumber() + "_" + reimbPerson + "_" + recordEntity.getRecordType() + ".pdf";
        String datePath = reimbDate.replace("-", File.separator) + File.separator;
        String url = "/api/file/Image/EcsReimbursement/" + datePath + "ecs/" + fileName;
        String secondFilePath = datePath + "ecs/";
        EcsUploadVO ecsUploadVO = new EcsUploadVO();
        ecsUploadVO.setName(fileName);
        ecsUploadVO.setUrl(url);
        ecsUploadVO.setSecondFilePath(secondFilePath);
        ecsUploadVO.setFileVersionId(null);
        ecsUploadVO.setFileDigest(null);
        ecsUploadVO.setFileId(fileName);
        return ecsUploadVO;
    }

    @Override
    public DownloadVO generatePDF(String id, EcsRecordsInfoVO vo) {
        EcsRecordPdfChargesVO itemVO;
        EcsBankCardInfoVO bankCardInfo = vo.getBankCardInfo();
        String bankInfo = bankCardInfo.getUsername() + "  " + bankCardInfo.getCardNumber().replaceAll(" ", "");
        String reimbCompanyId = vo.getReimbCompany();
        EcsCompanyEntity companyEntity = (EcsCompanyEntity)this.ecsCompanyService.getById((Serializable)((Object)reimbCompanyId));
        DecimalFormat df = new DecimalFormat("#,##0.00");
        EcsRecordPdfVO pdfVO = new EcsRecordPdfVO();
        pdfVO.setTitle("\u8d39\u7528\u62a5\u9500\u5355");
        pdfVO.setFileName(vo.getTitle());
        pdfVO.setReimbCompanyName(companyEntity.getName());
        pdfVO.setTaxpayerType(companyEntity.getTaxpayerType());
        pdfVO.setReimbDate(DateUtil.formatDate((Date)DateUtil.parse((CharSequence)vo.getCreatorTime())));
        pdfVO.setOrderNumber(vo.getOrderNumber());
        String reimbUserId = vo.getUserId();
        UserEntity reimbUser = (UserEntity)this.userService.getById((Serializable)((Object)reimbUserId));
        pdfVO.setReimbPerson(reimbUser.getRealName());
        pdfVO.setReimbPersonCode(reimbUser.getCode());
        pdfVO.setOrganization(vo.getOrganization());
        pdfVO.setOrganizationName(vo.getOrganizationName());
        String creatorUserId = vo.getCreatorUserId();
        UserEntity creatorUser = (UserEntity)this.userService.getById((Serializable)((Object)creatorUserId));
        pdfVO.setSubmitPerson(creatorUser.getRealName());
        pdfVO.setSubmitPersonCode(creatorUser.getCode());
        pdfVO.setBankInfo(bankInfo);
        pdfVO.setBranchName(bankCardInfo.getBankName());
        pdfVO.setPayAmount("\u00a5 " + df.format(vo.getPayableAmount().setScale(2, RoundingMode.HALF_UP)));
        pdfVO.setReimbAmountCN(ConvertNumberToUpper.digitUppercase(vo.getReimbAmount().doubleValue()));
        pdfVO.setWriteOffAmount("\u00a5 0.00");
        pdfVO.setTotalAmount("\u00a5 " + df.format(vo.getReimbAmount().setScale(2, RoundingMode.HALF_UP)));
        AtomicInteger totalFileNumber = new AtomicInteger(0);
        ArrayList<EcsRecordPdfChargesVO> itemVOList = new ArrayList<EcsRecordPdfChargesVO>();
        if (CollUtil.isNotEmpty(vo.getSubjectList())) {
            Map collect = vo.getSubjectList().stream().collect(Collectors.groupingBy(EcsRecordsChargesDetailInfoVO::getChargesTypeCode, TreeMap::new, Collectors.toList()));
            collect.forEach((key, value) -> {
                EcsRecordPdfChargesVO itemVO = new EcsRecordPdfChargesVO();
                String subjectName = ((EcsRecordsChargesDetailInfoVO)value.get(0)).getSubjectName() + "/" + ((EcsRecordsChargesDetailInfoVO)value.get(0)).getChargesTypeName();
                itemVO.setSubjectName(subjectName);
                int fileNumber = 0;
                for (EcsRecordsChargesDetailInfoVO ecsRecordsChargesDetailInfoVO : value) {
                    fileNumber += ecsRecordsChargesDetailInfoVO.getFileSizeNum().intValue();
                }
                itemVO.setFileNumber(fileNumber);
                BigDecimal totalAmount = value.stream().map(EcsRecordsChargesDetailInfoVO::getActualAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalReimbAmount = value.stream().map(EcsRecordsChargesDetailInfoVO::getReimbAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemVO.setItemAmount("\u00a5 " + df.format(totalAmount.add(totalReimbAmount).setScale(2, RoundingMode.HALF_UP)));
                itemVOList.add(itemVO);
                totalFileNumber.addAndGet(fileNumber);
            });
            ArrayList invoiceFiles = new ArrayList();
            for (EcsRecordsChargesDetailInfoVO ecsRecordsChargesDetailInfoVO : vo.getSubjectList()) {
                List<EcsInvoiceInfoVO> invoiceList = ecsRecordsChargesDetailInfoVO.getInvoiceList();
                for (EcsInvoiceInfoVO ecsInvoiceInfoVO : invoiceList) {
                    List jsonToListMap = JsonUtil.getJsonToListMap((String)ecsInvoiceInfoVO.getUploadFile());
                    for (Map invoice : jsonToListMap) {
                        EcsRecordPdfInvoiceFileVO ecsRecordPdfInvoiceFileVO = new EcsRecordPdfInvoiceFileVO();
                        ecsRecordPdfInvoiceFileVO.setPath(invoice.get("url").toString());
                        int status = ecsInvoiceInfoVO.getVerifyStatus() == null ? 0 : ecsInvoiceInfoVO.getVerifyStatus();
                        ecsRecordPdfInvoiceFileVO.setVerifyStatus(status);
                        Date time = ecsInvoiceInfoVO.getVerifyTime() == null ? new Date() : ecsInvoiceInfoVO.getVerifyTime();
                        ecsRecordPdfInvoiceFileVO.setVerifyTime(time);
                        ecsRecordPdfInvoiceFileVO.setInvoiceKind(ecsInvoiceInfoVO.getInvoiceKind());
                        ecsRecordPdfInvoiceFileVO.setInvoiceType(ecsInvoiceInfoVO.getInvoiceType());
                        ecsRecordPdfInvoiceFileVO.setOcrSource(ecsInvoiceInfoVO.getOcrSource());
                        ecsRecordPdfInvoiceFileVO.setInvoiceDate(ecsInvoiceInfoVO.getInvoiceDate());
                        ecsRecordPdfInvoiceFileVO.setInvoiceOp(ecsInvoiceInfoVO.getInvoiceOp());
                        ecsRecordPdfInvoiceFileVO.setInvoiceNumber(ecsInvoiceInfoVO.getInvoiceNumber());
                        ecsRecordPdfInvoiceFileVO.setTaxRate(ecsInvoiceInfoVO.getInvoiceTaxRate() == null ? "" : ecsInvoiceInfoVO.getInvoiceTaxRate());
                        ecsRecordPdfInvoiceFileVO.setPreTaxAmount(ecsInvoiceInfoVO.getInvoiceAmountPreTax());
                        ecsRecordPdfInvoiceFileVO.setTaxAmount(ecsInvoiceInfoVO.getInvoiceTax());
                        ecsRecordPdfInvoiceFileVO.setDeductibleTax(ecsInvoiceInfoVO.getDeductibleTax());
                        ecsRecordPdfInvoiceFileVO.setTotalAmount(ecsInvoiceInfoVO.getInvoiceAmount());
                        invoiceFiles.add(ecsRecordPdfInvoiceFileVO);
                    }
                }
            }
            List urls = invoiceFiles.stream().map(EcsRecordPdfInvoiceFileVO::getPath).collect(Collectors.toList());
            List fileEntities = this.fileMapper.selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{FileEntity::getStoragePath, FileEntity::getUrl}).in(FileEntity::getUrl, urls)).eq(FileEntity::getModular, (Object)"ecs"));
            for (FileEntity fileEntity : fileEntities) {
                Iterator iterator = invoiceFiles.iterator();
                while (iterator.hasNext()) {
                    EcsRecordPdfInvoiceFileVO file = (EcsRecordPdfInvoiceFileVO)iterator.next();
                    if (!fileEntity.getUrl().equals(file.getPath())) continue;
                    file.setPath(fileEntity.getStoragePath());
                }
            }
            pdfVO.setInvoiceFiles(invoiceFiles);
        }
        pdfVO.setTotalFileNumber(totalFileNumber.get());
        if ("\u5dee\u65c5\u8d39".equals(vo.getRecordType()) && itemVOList.size() < 2) {
            int recordFlag = 0;
            for (EcsRecordPdfChargesVO ecsRecordPdfChargesVO : itemVOList) {
                if ("01\u5dee\u65c5\u8d39/\u4ea4\u901a\u8d39".equals(ecsRecordPdfChargesVO.getSubjectName())) {
                    recordFlag = 2;
                }
                if (!"01\u5dee\u65c5\u8d39/\u4f4f\u5bbf\u8d39".equals(ecsRecordPdfChargesVO.getSubjectName())) continue;
                recordFlag = 1;
            }
            if (recordFlag == 1) {
                itemVO = new EcsRecordPdfChargesVO();
                itemVO.setSubjectName("01\u5dee\u65c5\u8d39/\u4ea4\u901a\u8d39");
                itemVO.setFileNumber(0);
                itemVO.setItemAmount("\u00a5 0.00");
                itemVOList.add(0, itemVO);
            } else if (recordFlag == 2) {
                itemVO = new EcsRecordPdfChargesVO();
                itemVO.setSubjectName("01\u5dee\u65c5\u8d39/\u4f4f\u5bbf\u8d39");
                itemVO.setFileNumber(0);
                itemVO.setItemAmount("\u00a5 0.00");
                itemVOList.add(itemVO);
            } else if (recordFlag == 0) {
                itemVO = new EcsRecordPdfChargesVO();
                itemVO.setSubjectName("01\u5dee\u65c5\u8d39/\u4ea4\u901a\u8d39");
                itemVO.setFileNumber(0);
                itemVO.setItemAmount("\u00a5 0.00");
                itemVOList.add(itemVO);
                EcsRecordPdfChargesVO itemVO1 = new EcsRecordPdfChargesVO();
                itemVO1.setSubjectName("01\u5dee\u65c5\u8d39/\u4f4f\u5bbf\u8d39");
                itemVO1.setFileNumber(0);
                itemVO1.setItemAmount("\u00a5 0.00");
                itemVOList.add(itemVO1);
            }
        }
        if (CollUtil.isNotEmpty(vo.getSubsidyList())) {
            BigDecimal totalSubsidyAmount = vo.getSubsidyList().stream().map(EcsRecordsSubsidyEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            itemVO = new EcsRecordPdfChargesVO();
            itemVO.setSubjectName("01\u5dee\u65c5\u8d39/\u51fa\u5dee\u8865\u52a9");
            itemVO.setFileNumber(0);
            itemVO.setItemAmount("\u00a5 " + df.format(totalSubsidyAmount));
            itemVOList.add(itemVO);
        }
        pdfVO.setItems(itemVOList);
        List<EcsRecordPdfFlowVO> approvalList = this.getFlowList(id, vo.getCreatorUserId());
        pdfVO.setFlowList(approvalList);
        EcsFlowInfoVO flowInfo = this.getFlowInfo(approvalList);
        pdfVO.setFlowInfo(flowInfo);
        pdfVO.setCompanyId(vo.getCompanyId());
        pdfVO.setReimbTemplate(vo.getRecordType());
        return this.generatePDF(pdfVO);
    }

    @Override
    public EcsUploadVO getAdvancePDF(String id) {
        EcsAdvancePaymentEntity entity = (EcsAdvancePaymentEntity)this.ecsAdvancePaymentService.getById((Serializable)((Object)id));
        if ("1".equals(entity.getIsPrinted())) {
            entity.setIsPrinted("2");
            this.ecsAdvancePaymentService.updateById(entity);
        }
        String reimbPerson = this.baseDataUtil.userSelectValue(entity.getUserId());
        String reimbDate = DateUtil.formatDate((Date)entity.getAdvanceSubmitTime());
        String companyCode = GlobalConstants.PDF_COMPANY_NAME.getOrDefault(entity.getCompanyId(), "RK");
        String fileName = companyCode + "_" + entity.getOrderNumber() + "_" + reimbPerson + "_" + entity.getRecordType() + ".pdf";
        String datePath = reimbDate.replace("-", File.separator) + File.separator;
        String url = "/api/file/Image/EcsReimbursement/" + datePath + "ecs/" + fileName;
        String secondFilePath = datePath + "ecs/";
        EcsUploadVO ecsUploadVO = new EcsUploadVO();
        ecsUploadVO.setName(fileName);
        ecsUploadVO.setUrl(url);
        ecsUploadVO.setSecondFilePath(secondFilePath);
        ecsUploadVO.setFileVersionId(null);
        ecsUploadVO.setFileDigest(null);
        ecsUploadVO.setFileId(fileName);
        return ecsUploadVO;
    }

    @Override
    public DownloadVO generatePDF(String id, EcsAdvancePaymentInfoVO vo) {
        EcsBankCardInfoVO bankCardInfo = vo.getBankCardInfo();
        String bankInfo = bankCardInfo.getUsername() + "  " + bankCardInfo.getCardNumber().replaceAll(" ", "");
        String reimbCompanyId = vo.getReimbCompany();
        EcsCompanyEntity companyEntity = (EcsCompanyEntity)this.ecsCompanyService.getById((Serializable)((Object)reimbCompanyId));
        DecimalFormat df = new DecimalFormat("#,##0.00");
        EcsRecordPdfVO pdfVO = new EcsRecordPdfVO();
        String title = "\u501f\u6b3e\u5355";
        if (StringUtils.isNotBlank((CharSequence)vo.getRecordType())) {
            title = title + "-" + vo.getRecordType();
        }
        pdfVO.setTitle(title);
        pdfVO.setFileName(vo.getTitle());
        pdfVO.setReimbCompanyName(companyEntity.getName());
        pdfVO.setTaxpayerType(companyEntity.getTaxpayerType());
        pdfVO.setReimbDate(DateUtil.formatDate((Date)vo.getAdvanceSubmitTime()));
        pdfVO.setOrderNumber(vo.getOrderNumber());
        String reimbUserId = vo.getCreatorUserId();
        UserEntity reimbUser = (UserEntity)this.userService.getById((Serializable)((Object)reimbUserId));
        pdfVO.setReimbPerson(reimbUser.getRealName());
        pdfVO.setReimbPersonCode(reimbUser.getCode());
        pdfVO.setOrganization(vo.getOrganizationId());
        pdfVO.setOrganizationName(vo.getOrganizationName());
        String creatorUserId = vo.getCreatorUserId();
        UserEntity creatorUser = (UserEntity)this.userService.getById((Serializable)((Object)creatorUserId));
        pdfVO.setSubmitPerson(creatorUser.getRealName());
        pdfVO.setSubmitPersonCode(creatorUser.getCode());
        pdfVO.setBankInfo(bankInfo);
        pdfVO.setBranchName(bankCardInfo.getBankName());
        pdfVO.setPayAmount("\u00a5 " + df.format(vo.getTotalAdvanceAmount().setScale(2, RoundingMode.HALF_UP)));
        pdfVO.setReimbAmountCN(ConvertNumberToUpper.digitUppercase(vo.getTotalAdvanceAmount().doubleValue()));
        pdfVO.setWriteOffAmount("\u00a5 0.00");
        pdfVO.setTotalAmount("\u00a5 " + df.format(vo.getTotalAdvanceAmount().setScale(2, RoundingMode.HALF_UP)));
        EcsRecordPdfChargesVO ecsRecordPdfChargesVO = new EcsRecordPdfChargesVO();
        ecsRecordPdfChargesVO.setSubjectName(vo.getParentSubjectName() + "/" + vo.getSubjectName());
        ecsRecordPdfChargesVO.setFileNumber(0);
        ecsRecordPdfChargesVO.setItemAmount("\u00a5 " + df.format(vo.getTotalAdvanceAmount().setScale(2, RoundingMode.HALF_UP)));
        pdfVO.setItems(Lists.newArrayList((Object[])new EcsRecordPdfChargesVO[]{ecsRecordPdfChargesVO}));
        List<EcsRecordPdfFlowVO> approvalList = this.getFlowList(id, vo.getCreatorUserId());
        pdfVO.setFlowList(approvalList);
        EcsFlowInfoVO flowInfo = this.getFlowInfo(approvalList);
        pdfVO.setFlowInfo(flowInfo);
        pdfVO.setCompanyId(vo.getCompanyId());
        pdfVO.setReimbTemplate(vo.getRecordType());
        return this.generatePDF(pdfVO);
    }

    private List<EcsRecordPdfFlowVO> getFlowList(String processId, String creatorUserId) {
        ArrayList<EcsRecordPdfFlowVO> approvalList = new ArrayList<EcsRecordPdfFlowVO>();
        try {
            FlowTaskEntity flowTaskEntity = this.flowTaskService.getDraftTaskByProcessId(processId);
            String taskId = flowTaskEntity.getId();
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskNodeEntity::getTaskId, (Object)taskId)).eq(FlowTaskNodeEntity::getState, (Object)"0")).orderByAsc(FlowTaskNodeEntity::getSortCode)).orderByAsc(FlowTaskNodeEntity::getCreatorTime);
            List nodeList = this.taskNodeService.list((Wrapper)queryWrapper);
            List taskRecordList = this.taskOperatorRecordService.getList(taskId);
            String lastTimeNodeId = "";
            for (FlowTaskNodeEntity node : nodeList) {
                if ("start".equals(node.getNodeType())) {
                    EcsRecordPdfFlowVO flowVO = new EcsRecordPdfFlowVO();
                    flowVO.setNodeStatus("2");
                    flowVO.setNodeName("\u5f00\u59cb");
                    flowVO.setOperator(creatorUserId);
                    flowVO.setOperateTime(DateUtil.format((Date)node.getCreatorTime(), (String)"yyyy-MM-dd HH:mm"));
                    flowVO.setOperateDesc("");
                    approvalList.add(flowVO);
                    continue;
                }
                List taskRecord = taskRecordList.stream().filter(record -> node.getId().equals(record.getTaskNodeId())).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(taskRecord)) {
                    for (FlowTaskOperatorRecordEntity record2 : taskRecord) {
                        EcsRecordPdfFlowVO flowVO = new EcsRecordPdfFlowVO();
                        flowVO.setNodeStatus(record2.getHandleStatus().toString());
                        flowVO.setNodeName(record2.getNodeName());
                        flowVO.setOperator(record2.getHandleId());
                        flowVO.setOperateTime(DateUtil.format((Date)record2.getHandleTime(), (String)"yyyy-MM-dd HH:mm"));
                        flowVO.setOperateDesc(StringUtils.defaultString((String)record2.getHandleOpinion()));
                        approvalList.add(flowVO);
                    }
                    continue;
                }
                if (node.getCompletion() != 1) continue;
                Optional<FlowTaskOperatorRecordEntity> max = taskRecordList.stream().filter(record -> Objects.equals(node.getNodeCode(), record.getNodeCode())).max(Comparator.comparing(FlowTaskOperatorRecordEntity::getHandleTime));
                max.ifPresent(record -> {
                    EcsRecordPdfFlowVO flowVO = new EcsRecordPdfFlowVO();
                    flowVO.setNodeStatus(record.getHandleStatus().toString());
                    flowVO.setNodeName(node.getNodeName());
                    flowVO.setOperator(record.getHandleId());
                    flowVO.setOperateTime(DateUtil.format((Date)record.getHandleTime(), (String)"yyyy-MM-dd HH:mm"));
                    flowVO.setOperateDesc(StringUtils.defaultString((String)record.getHandleOpinion()));
                    approvalList.add(flowVO);
                });
            }
            if (!approvalList.isEmpty() && FlowTaskStatusEnum.Adopt.getCode().equals(flowTaskEntity.getStatus())) {
                EcsRecordPdfFlowVO lstNode = (EcsRecordPdfFlowVO)approvalList.get(approvalList.size() - 1);
                EcsRecordPdfFlowVO flowVO = new EcsRecordPdfFlowVO();
                flowVO.setNodeStatus("5");
                flowVO.setNodeName("\u7ed3\u675f");
                flowVO.setOperator(lstNode.getOperator());
                flowVO.setOperateTime(lstNode.getOperateTime());
                flowVO.setOperateDesc("");
                approvalList.add(flowVO);
            }
            for (EcsRecordPdfFlowVO ecsRecordPdfFlowVO : approvalList) {
                if (ecsRecordPdfFlowVO.getOperator() == null) continue;
                if ("0".equals(ecsRecordPdfFlowVO.getNodeStatus())) {
                    ecsRecordPdfFlowVO.setNodeStatus("\u5ba1\u6279\u62d2\u7edd");
                    continue;
                }
                if ("1".equals(ecsRecordPdfFlowVO.getNodeStatus())) {
                    ecsRecordPdfFlowVO.setNodeStatus("\u5ba1\u6279\u901a\u8fc7");
                    continue;
                }
                if ("2".equals(ecsRecordPdfFlowVO.getNodeStatus())) {
                    ecsRecordPdfFlowVO.setNodeStatus("\u521b\u5efa\u6210\u529f");
                    continue;
                }
                if ("3".equals(ecsRecordPdfFlowVO.getNodeStatus())) {
                    ecsRecordPdfFlowVO.setNodeStatus("\u64a4\u56de");
                    continue;
                }
                if ("4".equals(ecsRecordPdfFlowVO.getNodeStatus())) {
                    ecsRecordPdfFlowVO.setNodeStatus("\u7ec8\u6b62");
                    continue;
                }
                if (!"5".equals(ecsRecordPdfFlowVO.getNodeStatus())) continue;
                ecsRecordPdfFlowVO.setNodeStatus("\u5ba1\u6279\u7ed3\u675f");
            }
            for (EcsRecordPdfFlowVO ecsRecordPdfFlowVO : approvalList) {
                if (!StringUtils.isNotBlank((CharSequence)ecsRecordPdfFlowVO.getOperator())) continue;
                String currUserId = ecsRecordPdfFlowVO.getOperator();
                ecsRecordPdfFlowVO.setOperator(this.baseDataUtil.userSelectValue(currUserId));
                List listByUserId = this.positionService.getListByUserId(currUserId);
                if (!CollUtil.isNotEmpty((Collection)listByUserId)) continue;
                String dutyName = ((PositionEntity)listByUserId.get(0)).getFullName();
                ecsRecordPdfFlowVO.setDutyName(dutyName);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25", (Throwable)e);
        }
        return approvalList;
    }

    private EcsFlowInfoVO getFlowInfo(List<EcsRecordPdfFlowVO> flowVOList) {
        EcsFlowInfoVO flowInfoVO = new EcsFlowInfoVO();
        for (EcsRecordPdfFlowVO ecsRecordPdfFlowVO : flowVOList) {
            String nodeName = ecsRecordPdfFlowVO.getNodeName();
            if (nodeName == null || "\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7".equals(ecsRecordPdfFlowVO.getOperateDesc())) continue;
            switch (nodeName) {
                case "\u62a5\u9500\u4eba\u4e3b\u7ba1": {
                    flowInfoVO.setReimbManager1(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
                case "\u62a5\u9500\u4eba\u4e8c\u7ea7\u4e3b\u7ba1": {
                    flowInfoVO.setReimbManager2(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
                case "\u62a5\u9500\u4eba\u4e09\u7ea7\u5ba1\u6279": {
                    flowInfoVO.setReimbManager3(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
                case "\u8d39\u7528\u5f52\u5c5e\u4e00\u7ea7\u5ba1\u6279": {
                    flowInfoVO.setDeptManager1(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
                case "\u8d39\u7528\u5f52\u5c5e\u4e8c\u7ea7\u5ba1\u6279": {
                    flowInfoVO.setDeptManager2(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
                case "\u8d22\u52a1\u590d\u6838": {
                    flowInfoVO.setFinanceReview(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
                case "\u8d22\u52a1\u4e3b\u7ba1": {
                    flowInfoVO.setFinanceManager(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
                case "\u51fa\u7eb3\u652f\u4ed8": {
                    flowInfoVO.setCashier(ecsRecordPdfFlowVO.getOperator());
                    break;
                }
            }
        }
        return flowInfoVO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DownloadVO generatePDF(EcsRecordPdfVO pdfVO) {
        PdfHandler.disableScanSystemFonts();
        String path = this.configValueUtil.getPath();
        PdfHandler.getFontHandler().addFont(new File[]{new File(path + "Fonts/SourceHanSansSC-Regular.ttf"), new File(path + "Fonts/SourceHanSansSC-Bold.ttf")});
        try (Document document = PdfHandler.getDocumentHandler().create();){
            document.setFontName(FONT_REGULAR_NAME);
            document.setFontSize(9.0f);
            this.addFormTable(pdfVO, document);
            this.addApprovalFlowToPDF(pdfVO, document);
            if (!CollUtil.isEmpty(pdfVO.getInvoiceFiles())) {
                if (!(CompanyTaxpayerTypeEnum.SMALL_SCALE_TAXPAYER.getCode().equals(pdfVO.getTaxpayerType()) || "\u63a2\u4eb2\u5047".equals(pdfVO.getReimbTemplate()) || "\u62db\u5f85\u8d39".equals(pdfVO.getReimbTemplate()))) {
                    this.addInvoiceDetailTable(pdfVO, document);
                }
                this.addImagesToPDF(pdfVO, document);
            }
            String orderNumber = pdfVO.getOrderNumber();
            List pages = document.getPages();
            if (CollUtil.isNotEmpty((Collection)pages)) {
                int totalPageNum = pages.size();
                for (int i = 0; i < pages.size(); ++i) {
                    Page page = (Page)pages.get(i);
                    page.setMarginTop(20.0f);
                    PageHeader pageHeader = new PageHeader(page);
                    pageHeader.setContentHorizontalAlignment(HorizontalAlignment.RIGHT);
                    pageHeader.setContentVerticalAlignment(VerticalAlignment.CENTER);
                    pageHeader.setHeight(10.0f);
                    Textarea headerText = new Textarea(pageHeader.getPage());
                    headerText.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                    headerText.setFontSize(8.0f);
                    headerText.setText(orderNumber + "    " + (i + 1) + " / " + totalPageNum);
                    pageHeader.setComponents(new Component[]{headerText});
                    pageHeader.render();
                }
            }
            String companyCode = GlobalConstants.PDF_COMPANY_NAME.getOrDefault(pdfVO.getCompanyId(), "RK");
            String fileName = companyCode + "_" + pdfVO.getOrderNumber() + "_" + pdfVO.getReimbPerson() + "_" + pdfVO.getReimbTemplate() + ".pdf";
            String datePath = pdfVO.getReimbDate().replace("-", File.separator) + File.separator;
            String filePath = this.configValueUtil.getEcsReimbursementFilePath() + datePath + "ecs" + File.separator;
            if (!FileUtil.fileIsExists((String)filePath)) {
                FileUtil.createDirs((String)filePath);
            }
            document.save(filePath + fileName);
            DownloadVO downloadVO = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile((String)(pdfVO.getReimbPerson() + "#" + datePath + "ecs" + File.separator + fileName + "#EcsReimbursement"))).build();
            return downloadVO;
        }
        catch (Exception e) {
            log.error("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private void addFormTable(EcsRecordPdfVO pdfVO, Document document) {
        String recordType = StringUtils.isBlank((CharSequence)pdfVO.getTitle()) ? "\u62a5\u9500" : (pdfVO.getTitle().startsWith("\u501f\u6b3e\u5355") ? "\u501f\u6b3e" : "\u62a5\u9500");
        Page page = new Page(document, A5_PAGE_SIZE);
        page.setMarginTop(40.0f);
        page.setMarginLeft(55.0f);
        page.setMarginRight(40.0f);
        this.drawTitle(page, pdfVO.getOrderNumber(), pdfVO.getTitle());
        Textarea textarea = new Textarea(page);
        textarea.setRise(Float.valueOf(3.0f));
        textarea.setMarginBottom(5.0f);
        textarea.setLeading(15.0f);
        textarea.setFontSize(10.0f);
        textarea.setFontName(FONT_BOLD_NAME);
        textarea.setText(pdfVO.getReimbCompanyName());
        textarea.render();
        textarea.setRelativeBeginX(Float.valueOf(100.0f));
        textarea.setMarginBottom(5.0f);
        textarea.setFontName(FONT_REGULAR_NAME);
        textarea.setText(recordType + "\u65f6\u95f4  " + pdfVO.getReimbDate());
        textarea.render();
        textarea.setFontSize(9.0f);
        textarea.setMarginBottom(5.0f);
        textarea.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        textarea.setText(pdfVO.getOrderNumber());
        textarea.render();
        ArrayList firstRow = Lists.newArrayList((Object[])new String[]{"\u586b\u62a5\u4eba", pdfVO.getSubmitPerson() + "(" + pdfVO.getSubmitPersonCode() + ")", "\u8d39\u7528\u627f\u529e\u90e8\u95e8", pdfVO.getOrganizationName(), "\u91c7\u8d2d\u5408\u540c\u53f7", pdfVO.getContractNumber()});
        this.drawReimbRows(page, firstRow, 50.0f, 75.0f, 75.0f, 120.0f, 70.0f, 110.0f);
        ArrayList secondRow = Lists.newArrayList((Object[])new String[]{recordType + "\u4eba", pdfVO.getReimbPerson() + "(" + pdfVO.getReimbPersonCode() + ")", "\u4ed8\u6b3e\u81f3", pdfVO.getBankInfo(), pdfVO.getBranchName()});
        this.drawReimbRows(page, secondRow, 50.0f, 75.0f, 50.0f, 145.0f, 180.0f);
        ArrayList thirdRow = Lists.newArrayList((Object[])new String[]{"\u4ed8\u6b3e\u91d1\u989d", pdfVO.getPayAmount(), "\u6838\u9500\u91d1\u989d", pdfVO.getWriteOffAmount(), recordType + "\u603b\u91d1\u989d", pdfVO.getTotalAmount()});
        this.drawReimbRows(page, thirdRow, 50.0f, 100.0f, 50.0f, 100.0f, 80.0f, 120.0f);
        ArrayList fourthRow = Lists.newArrayList((Object[])new String[]{recordType + "\u91d1\u989d (\u5927\u5199)", pdfVO.getReimbAmountCN(), pdfVO.getTotalFileNumber() + "\u5f20", pdfVO.getTotalAmount()});
        float[] fourthWidths = new float[]{110.0f, 220.0f, 70.0f, 100.0f};
        Table table = new Table(page);
        table.setCellWidths(fourthWidths);
        table.setIsBorder(true);
        table.setContentVerticalAlignment(VerticalAlignment.CENTER);
        TableRow tableRow = new TableRow(table);
        tableRow.setHeight(25.0f);
        tableRow.setBackgroundColor(COLOR_CUSTOM_FILL_GRAY);
        for (int i = 0; i < fourthRow.size(); ++i) {
            Textarea textareaa = new Textarea(page);
            textareaa.setText((String)fourthRow.get(i));
            TableCell cell = new TableCell(tableRow);
            cell.setContentMarginLeft(Float.valueOf(5.0f));
            cell.addComponents(new Component[]{textareaa});
            if (i == fourthRow.size() - 1) {
                cell.setContentHorizontalAlignment(HorizontalAlignment.RIGHT);
                cell.setContentMarginRight(Float.valueOf(5.0f));
            }
            tableRow.addCells(new TableCell[]{cell});
        }
        table.addRows(new TableRow[]{tableRow});
        table.render();
        this.drawItems(page, pdfVO.getItems(), 330.0f, 70.0f, 100.0f);
        EcsFlowInfoVO flowInfo = pdfVO.getFlowInfo();
        ArrayList flowLists = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"\u62a5\u9500\u4eba\u4e00\u7ea7\u5ba1\u6279\uff1a  " + StringUtils.defaultString((String)flowInfo.getReimbManager1()), "\u62a5\u9500\u4eba\u4e8c\u7ea7\u5ba1\u6279\uff1a  " + StringUtils.defaultString((String)flowInfo.getReimbManager2()), "\u62a5\u9500\u4eba\u4e09\u7ea7\u5ba1\u6279\uff1a  " + StringUtils.defaultString((String)flowInfo.getReimbManager3())}), Lists.newArrayList((Object[])new String[]{"\u8d39\u7528\u5f52\u5c5e\u4e00\u7ea7\u5ba1\u6279\uff1a  " + StringUtils.defaultString((String)flowInfo.getDeptManager1()), "\u8d39\u7528\u5f52\u5c5e\u4e00\u7ea7\u5ba1\u6279\uff1a  " + StringUtils.defaultString((String)flowInfo.getDeptManager1()), ""}), Lists.newArrayList((Object[])new String[]{"\u8d22\u52a1\u590d\u6838\uff1a  " + StringUtils.defaultString((String)flowInfo.getFinanceReview()), "\u8d22\u52a1\u4e3b\u7ba1\uff1a  " + StringUtils.defaultString((String)flowInfo.getFinanceManager()), "\u51fa\u7eb3\u652f\u4ed8\uff1a  " + StringUtils.defaultString((String)flowInfo.getCashier())})});
        Table flowTable = new Table(page);
        flowTable.setCellWidths(new float[]{150.0f, 150.0f, 150.0f});
        flowTable.setIsBorder(false);
        flowTable.setContentVerticalAlignment(VerticalAlignment.CENTER);
        flowTable.setContentHorizontalAlignment(HorizontalAlignment.LEFT);
        for (int i = 0; i < 3; ++i) {
            List flowList = (List)flowLists.get(i);
            TableRow flowRow = new TableRow(flowTable);
            flowRow.setHeight(20.0f);
            for (int j = 0; j < flowList.size(); ++j) {
                Textarea flowInfoText = new Textarea(page);
                flowInfoText.setFontName(FONT_BOLD_NAME);
                flowInfoText.setText((String)flowList.get(j));
                TableCell cell = new TableCell(flowRow);
                cell.addComponents(new Component[]{flowInfoText});
                flowRow.addCells(new TableCell[]{cell});
            }
            flowTable.addRows(new TableRow[]{flowRow});
        }
        flowTable.render();
        document.appendPage(new Page[]{page});
    }

    private void drawTitle(Page page, String orderNumber, String title) {
        Textarea textarea = new Textarea(page);
        textarea.setFontName(FONT_BOLD_NAME);
        textarea.setFontSize(18.0f);
        title = StringUtils.isBlank((CharSequence)title) ? "\u8d39\u7528\u62a5\u9500\u5355" : title;
        textarea.setText(title);
        textarea.setHorizontalAlignment(HorizontalAlignment.CENTER);
        textarea.render();
        Barcode barcode = new Barcode(page);
        barcode.setCodeType(BarcodeType.CODE_128);
        barcode.setWidth(100);
        barcode.setHeight(25);
        barcode.setImageWidth(80);
        barcode.setImageHeight(18);
        barcode.setContent(orderNumber);
        barcode.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        barcode.render();
    }

    private void drawReimbRows(Page page, List<String> content, float ... widths) {
        Table table = new Table(page);
        table.setCellWidths(widths);
        table.setIsBorder(true);
        table.setContentVerticalAlignment(VerticalAlignment.CENTER);
        TableRow tableRow = new TableRow(table);
        tableRow.setHeight(25.0f);
        for (int i = 0; i < content.size(); ++i) {
            Textarea textarea = new Textarea(page);
            textarea.setText(content.get(i));
            TableCell cell = new TableCell(tableRow);
            cell.setContentMarginLeft(Float.valueOf(5.0f));
            cell.addComponents(new Component[]{textarea});
            tableRow.addCells(new TableCell[]{cell});
        }
        table.addRows(new TableRow[]{tableRow});
        table.render();
    }

    private void drawItems(Page page, List<EcsRecordPdfChargesVO> items, float ... widths) {
        Table table = new Table(page);
        table.setCellWidths(widths);
        table.setIsBorder(true);
        table.setContentVerticalAlignment(VerticalAlignment.CENTER);
        for (EcsRecordPdfChargesVO item : items) {
            TableRow tableRow = new TableRow(table);
            tableRow.setHeight(25.0f);
            Textarea textarea1 = new Textarea(page);
            textarea1.setText(item.getSubjectName());
            TableCell cell1 = new TableCell(tableRow);
            cell1.setContentMarginLeft(Float.valueOf(5.0f));
            cell1.addComponents(new Component[]{textarea1});
            Textarea textarea2 = new Textarea(page);
            textarea2.setText(item.getFileNumber() + "\u5f20");
            TableCell cell2 = new TableCell(tableRow);
            cell2.setContentMarginLeft(Float.valueOf(5.0f));
            cell2.addComponents(new Component[]{textarea2});
            Textarea textarea3 = new Textarea(page);
            textarea3.setText(item.getItemAmount());
            TableCell cell3 = new TableCell(tableRow);
            cell3.setContentMarginLeft(Float.valueOf(5.0f));
            cell3.setContentMarginRight(Float.valueOf(5.0f));
            cell3.setContentHorizontalAlignment(HorizontalAlignment.RIGHT);
            cell3.addComponents(new Component[]{textarea3});
            tableRow.addCells(new TableCell[]{cell1, cell2, cell3});
            table.addRows(new TableRow[]{tableRow});
        }
        table.render();
    }

    private void addInvoiceDetailTable(EcsRecordPdfVO pdfVO, Document document) {
        Page page = new Page(document, A5_PAGE_SIZE);
        page.setFontSize(9.0f);
        page.setMarginTop(40.0f);
        page.setMarginLeft(35.0f);
        page.setMarginRight(30.0f);
        page.setMarginBottom(30.0f);
        Textarea textarea = new Textarea(page);
        textarea.setFontName(FONT_BOLD_NAME);
        textarea.setFontSize(18.0f);
        textarea.setText("\u53d1\u7968\u5217\u8868");
        textarea.setHorizontalAlignment(HorizontalAlignment.CENTER);
        textarea.setMarginBottom(25.0f);
        textarea.render();
        Table table = new Table(page);
        table.setIsTogether(Boolean.valueOf(true));
        table.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
        table.setContentVerticalAlignment(VerticalAlignment.CENTER);
        table.setIsBorder(true);
        table.setCellWidths(new float[]{25.0f, 107.0f, 120.0f, 44.0f, 62.0f, 50.0f, 62.0f, 60.0f});
        table.setBorderColor(COLOR_CUSTOM_LINE_GRAY);
        table.setMarginTop(30.0f);
        TableHeader tableHeaders = new TableHeader(table);
        TableRow headerRow = new TableRow(table);
        headerRow.setHeight(30.0f);
        headerRow.setBackgroundColor(COLOR_CUSTOM_FILL_GRAY);
        ArrayList headerNames = Lists.newArrayList((Object[])new String[]{"\u5e8f\u53f7", "\u53d1\u7968\u7c7b\u522b", "\u53d1\u7968\u53f7\u7801", "\u7a0e\u7387", "\u4e0d\u542b\u7a0e\u91d1\u989d", "\u7a0e\u989d", "\u53ef\u62b5\u6263\u7a0e\u989d", "\u4ef7\u7a0e\u5408\u8ba1"});
        for (String headerName : headerNames) {
            Textarea headerText = new Textarea(table.getPage());
            headerText.setText(headerName);
            headerText.setFontSize(10.0f);
            headerText.setFontName(FONT_BOLD_NAME);
            TableCell cell = new TableCell(headerRow);
            cell.setComponents(new Component[]{headerText});
            cell.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
            cell.setContentVerticalAlignment(VerticalAlignment.CENTER);
            headerRow.addCells(new TableCell[]{cell});
        }
        tableHeaders.addRows(new TableRow[]{headerRow});
        table.setHeader(tableHeaders);
        List<EcsRecordPdfInvoiceFileVO> invoiceFiles = pdfVO.getInvoiceFiles();
        BigDecimal[] totalAmountArr = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        BigDecimal[] calculateDeductibleTax = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        for (int i = 0; i < invoiceFiles.size(); ++i) {
            EcsRecordPdfInvoiceFileVO invoiceFileVO = invoiceFiles.get(i);
            TableRow dataRow = new TableRow(table);
            dataRow.setHeight(25.0f);
            ArrayList data = Lists.newArrayList((Object[])new String[]{"" + (i + 1), invoiceFileVO.getInvoiceType(), invoiceFileVO.getInvoiceNumber(), invoiceFileVO.getTaxRate(), this.convertAmount(invoiceFileVO.getPreTaxAmount()), this.convertAmount(invoiceFileVO.getTaxAmount()), this.convertAmount(invoiceFileVO.getDeductibleTax()), this.convertAmount(invoiceFileVO.getTotalAmount())});
            this.calculateTotalAmount(totalAmountArr, invoiceFileVO);
            if (!("vat_digital_invoice".equals(invoiceFileVO.getInvoiceOp()) || "vat_invoice".equals(invoiceFileVO.getInvoiceOp()) || "flight_digital_ticket".equals(invoiceFileVO.getInvoiceOp()))) {
                this.calculateTotalAmount(calculateDeductibleTax, invoiceFileVO);
            }
            for (int i1 = 0; i1 < data.size(); ++i1) {
                Textarea dataText = new Textarea(table.getPage());
                dataText.setText((String)data.get(i1));
                TableCell cell = new TableCell(dataRow);
                cell.setComponents(new Component[]{dataText});
                cell.setContentHorizontalAlignment(HorizontalAlignment.LEFT);
                if (i1 == 0) {
                    cell.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
                }
                if (i1 >= 3) {
                    cell.setContentHorizontalAlignment(HorizontalAlignment.RIGHT);
                }
                cell.setContentVerticalAlignment(VerticalAlignment.CENTER);
                cell.setContentMarginLeft(Float.valueOf(2.0f));
                cell.setContentMarginRight(Float.valueOf(2.0f));
                dataRow.addCells(new TableCell[]{cell});
            }
            table.addRows(new TableRow[]{dataRow});
        }
        table.render();
        table = new Table(page);
        table.setIsTogether(Boolean.valueOf(true));
        table.setIsBorder(true);
        table.setBorderColor(COLOR_CUSTOM_LINE_GRAY);
        table.setCellWidths(new float[]{297.0f, 62.0f, 50.0f, 62.0f, 60.0f});
        ArrayList totalName = Lists.newArrayList((Object[])new String[]{"\u5408\u8ba1", "\u8ba1\u7b97\u62b5\u6263\u5c0f\u8ba1"});
        for (int i = 0; i < 2; ++i) {
            TableRow totalRow = new TableRow(table);
            totalRow.setHeight(25.0f);
            for (int j = 0; j < 5; ++j) {
                TableCell cell = new TableCell(totalRow);
                cell.setContentHorizontalAlignment(HorizontalAlignment.RIGHT);
                cell.setContentVerticalAlignment(VerticalAlignment.CENTER);
                cell.setContentMarginLeft(Float.valueOf(2.0f));
                cell.setContentMarginRight(Float.valueOf(2.0f));
                Textarea textarea1 = new Textarea(table.getPage());
                String text = "";
                if (j == 0) {
                    text = (String)totalName.get(i);
                    cell.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
                } else {
                    text = this.convertAmount(i == 0 ? totalAmountArr[j - 1] : calculateDeductibleTax[j - 1]);
                }
                textarea1.setText(text);
                cell.addComponents(new Component[]{textarea1});
                totalRow.addCells(new TableCell[]{cell});
            }
            table.addRows(new TableRow[]{totalRow});
        }
        table.render();
        document.appendPage(new Page[]{page});
    }

    private void calculateTotalAmount(BigDecimal[] calculateDeductibleTax, EcsRecordPdfInvoiceFileVO invoiceFileVO) {
        calculateDeductibleTax[0] = invoiceFileVO.getPreTaxAmount() != null ? calculateDeductibleTax[0].add(invoiceFileVO.getPreTaxAmount()) : calculateDeductibleTax[0];
        calculateDeductibleTax[1] = invoiceFileVO.getTaxAmount() != null ? calculateDeductibleTax[1].add(invoiceFileVO.getTaxAmount()) : calculateDeductibleTax[1];
        calculateDeductibleTax[2] = invoiceFileVO.getDeductibleTax() != null ? calculateDeductibleTax[2].add(invoiceFileVO.getDeductibleTax()) : calculateDeductibleTax[2];
        calculateDeductibleTax[3] = invoiceFileVO.getTotalAmount() != null ? calculateDeductibleTax[3].add(invoiceFileVO.getTotalAmount()) : calculateDeductibleTax[3];
    }

    private String convertAmount(BigDecimal amount) {
        if (amount == null) {
            return " - ";
        }
        DecimalFormat df = new DecimalFormat("#,##0.00");
        return df.format(amount);
    }

    private void addApprovalFlowToPDF(EcsRecordPdfVO pdfVO, Document document) {
        Page page = new Page(document, A5_PAGE_SIZE);
        page.setFontSize(9.0f);
        page.setMarginTop(40.0f);
        page.setMarginLeft(55.0f);
        page.setMarginRight(40.0f);
        page.setMarginBottom(30.0f);
        Textarea textarea = new Textarea(page);
        textarea.setFontName(FONT_BOLD_NAME);
        textarea.setFontSize(18.0f);
        textarea.setText("\u5ba1\u6279\u6d41\u7a0b");
        textarea.setHorizontalAlignment(HorizontalAlignment.CENTER);
        textarea.setMarginBottom(25.0f);
        textarea.render();
        Table table = new Table(page);
        table.setIsTogether(Boolean.valueOf(true));
        table.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
        table.setContentVerticalAlignment(VerticalAlignment.CENTER);
        table.setIsBorder(true);
        table.setCellWidths(new float[]{25.0f, 100.0f, 50.0f, 85.0f, 100.0f, 140.0f});
        table.setBorderColor(COLOR_CUSTOM_LINE_GRAY);
        table.setMarginTop(30.0f);
        TableHeader tableHeaders = new TableHeader(table);
        TableRow headerRow = new TableRow(table);
        headerRow.setHeight(30.0f);
        headerRow.setBackgroundColor(COLOR_CUSTOM_FILL_GRAY);
        ArrayList headerNames = Lists.newArrayList((Object[])new String[]{"\u5e8f\u53f7", "\u6b65\u9aa4", "\u64cd\u4f5c\u4eba", "\u804c\u52a1", "\u64cd\u4f5c\u65f6\u95f4", "\u5ba1\u6838\u610f\u89c1"});
        for (String headerName : headerNames) {
            Textarea headerText = new Textarea(table.getPage());
            headerText.setText(headerName);
            headerText.setFontSize(10.0f);
            headerText.setFontName(FONT_BOLD_NAME);
            TableCell cell = new TableCell(headerRow);
            cell.setComponents(new Component[]{headerText});
            cell.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
            cell.setContentVerticalAlignment(VerticalAlignment.CENTER);
            headerRow.addCells(new TableCell[]{cell});
        }
        tableHeaders.addRows(new TableRow[]{headerRow});
        table.setHeader(tableHeaders);
        List<EcsRecordPdfFlowVO> flowList = pdfVO.getFlowList();
        for (int i = 0; i < flowList.size(); ++i) {
            EcsRecordPdfFlowVO ecsRecordPdfFlowVO = flowList.get(i);
            TableRow dataRow = new TableRow(table);
            dataRow.setHeight(25.0f);
            ArrayList data = Lists.newArrayList((Object[])new String[]{"" + (i + 1), ecsRecordPdfFlowVO.getNodeName(), ecsRecordPdfFlowVO.getOperator(), ecsRecordPdfFlowVO.getDutyName(), ecsRecordPdfFlowVO.getOperateTime(), ecsRecordPdfFlowVO.getOperateDesc()});
            for (String datum : data) {
                Textarea dataText = new Textarea(table.getPage());
                dataText.setText(datum);
                TableCell cell = new TableCell(dataRow);
                cell.setComponents(new Component[]{dataText});
                cell.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
                cell.setContentVerticalAlignment(VerticalAlignment.CENTER);
                dataRow.addCells(new TableCell[]{cell});
            }
            table.addRows(new TableRow[]{dataRow});
        }
        table.render();
        document.appendPage(new Page[]{page});
    }

    private void addImagesToPDF(EcsRecordPdfVO pdfVO, Document document) {
        List<EcsRecordPdfInvoiceFileVO> invoiceFiles = pdfVO.getInvoiceFiles();
        if (CollUtil.isEmpty(invoiceFiles)) {
            return;
        }
        ArrayList<EcsRecordPdfInvoiceFileVO> paperTrainTicketFiles = new ArrayList<EcsRecordPdfInvoiceFileVO>();
        ArrayList<EcsRecordPdfInvoiceFileVO> trainTicketFiles = new ArrayList<EcsRecordPdfInvoiceFileVO>();
        ArrayList<EcsRecordPdfInvoiceFileVO> otherFiles = new ArrayList<EcsRecordPdfInvoiceFileVO>();
        for (EcsRecordPdfInvoiceFileVO invoiceFile : invoiceFiles) {
            try {
                BufferedImage bufferedImage = invoiceFile.getPath().toLowerCase().endsWith("pdf") ? this.pdfToImage(invoiceFile.getPath()) : TransformImageUtil.correctImageOrientation(new File(invoiceFile.getPath()));
                BufferedImage bufferedImage1 = TransformImageUtil.processImage2(bufferedImage);
                invoiceFile.setImage(bufferedImage1);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0PDF\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
            if ("\u706b\u8f66\u7968".equals(invoiceFile.getInvoiceType()) && invoiceFile.getInvoiceKind().contains("\u7eb8\u8d28")) {
                paperTrainTicketFiles.add(invoiceFile);
                continue;
            }
            if ("\u706b\u8f66\u7968".equals(invoiceFile.getInvoiceType())) {
                trainTicketFiles.add(invoiceFile);
                continue;
            }
            otherFiles.add(invoiceFile);
        }
        ArrayList<EcsRecordPdfInvoiceFileVO> allFiles = new ArrayList<EcsRecordPdfInvoiceFileVO>();
        allFiles.addAll(trainTicketFiles);
        allFiles.addAll(otherFiles);
        if (!paperTrainTicketFiles.isEmpty()) {
            int size = paperTrainTicketFiles.size();
            int pageNum = size % 2 == 0 ? size / 2 : size / 2 + 1;
            for (int i = 0; i < pageNum; ++i) {
                Page page = new Page(document, A5_PAGE_SIZE);
                page.setMarginTop(30.0f);
                page.setMarginLeft(45.0f);
                page.setMarginRight(40.0f);
                page.setFontSize(9.0f);
                page.setFontName(FONT_REGULAR_NAME);
                int start = i * 2;
                int end = Math.min((i + 1) * 2, size);
                List subList = paperTrainTicketFiles.subList(start, end);
                for (EcsRecordPdfInvoiceFileVO invoiceFile : subList) {
                    Table table = new Table(page);
                    table.setIsBorder(false);
                    table.setCellWidths(new float[]{45.0f, 170.0f, 285.0f});
                    TableRow tableRow = new TableRow(table);
                    tableRow.setHeight(60.0f * PageSize.getUnit());
                    TableCell cell1 = new TableCell(tableRow);
                    cell1.setIsBorder(true);
                    cell1.setIsEnableUpLine(Boolean.valueOf(true));
                    cell1.setIsEnableDownLine(Boolean.valueOf(true));
                    Textarea textarea1 = new Textarea(page);
                    textarea1.setTextList(Arrays.asList("\u7eb8\u8d28\u53d1\u7968\u7c98\u8d34\u5904".split("")));
                    textarea1.setHorizontalAlignment(HorizontalAlignment.CENTER);
                    textarea1.setLeading(5.0f);
                    cell1.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
                    cell1.setContentVerticalAlignment(VerticalAlignment.CENTER);
                    cell1.addComponents(new Component[]{textarea1});
                    TableCell cell2 = new TableCell(tableRow);
                    TableCell cell3 = new TableCell(tableRow);
                    Image image = new Image(page);
                    image.setImage(invoiceFile.getImage());
                    image.setWidth((int)(100.0f * PageSize.getUnit()));
                    image.setHeight((int)(60.0f * PageSize.getUnit()));
                    cell3.addComponents(new Component[]{image});
                    tableRow.addCells(new TableCell[]{cell1, cell2, cell3});
                    table.addRows(new TableRow[]{tableRow});
                    table.render();
                    this.drawInvoiceInfo(page, invoiceFile);
                }
                document.appendPage(new Page[]{page});
            }
        }
        if (!allFiles.isEmpty()) {
            for (EcsRecordPdfInvoiceFileVO allFile : allFiles) {
                Page page = new Page(document, A5_PAGE_SIZE);
                page.setMarginTop(30.0f);
                page.setMarginLeft(45.0f);
                page.setMarginRight(40.0f);
                page.setFontSize(9.0f);
                page.setFontName(FONT_REGULAR_NAME);
                Table table = new Table(page);
                table.setIsBorder(false);
                table.setCellWidths(new float[]{45.0f, 455.0f});
                TableRow tableRow = new TableRow(table);
                tableRow.setHeight(126.0f * PageSize.getUnit());
                TableCell cell1 = new TableCell(tableRow);
                if (allFile.getInvoiceKind().equals("\u7eb8\u8d28\u53d1\u7968")) {
                    Textarea textarea1 = new Textarea(page);
                    textarea1.setTextList(Arrays.asList("\u7eb8\u8d28\u53d1\u7968\u7c98\u8d34\u5904".split("")));
                    textarea1.setHorizontalAlignment(HorizontalAlignment.CENTER);
                    textarea1.setLeading(5.0f);
                    cell1.setIsBorder(true);
                    cell1.setIsEnableUpLine(Boolean.valueOf(true));
                    cell1.setIsEnableDownLine(Boolean.valueOf(true));
                    cell1.setContentHorizontalAlignment(HorizontalAlignment.CENTER);
                    cell1.setContentVerticalAlignment(VerticalAlignment.CENTER);
                    cell1.addComponents(new Component[]{textarea1});
                }
                TableCell cell3 = new TableCell(tableRow);
                Image image = new Image(page);
                image.setImage(allFile.getImage());
                image.setWidth(455);
                image.setHeight((int)(126.0f * PageSize.getUnit()));
                image.setScale(Float.valueOf(0.9f));
                cell3.addComponents(new Component[]{image});
                cell3.setContentMarginLeft(Float.valueOf(10.0f));
                tableRow.addCells(new TableCell[]{cell1, cell3});
                table.addRows(new TableRow[]{tableRow});
                table.render();
                this.drawInvoiceInfo(page, allFile);
                document.appendPage(new Page[]{page});
            }
        }
    }

    public BufferedImage pdfToImage(String pdfPath) {
        try {
            return this.pdfToImage(pdfPath, 300);
        }
        catch (Exception e) {
            return this.pdfToImage(pdfPath, 72);
        }
    }

    public BufferedImage pdfToImage(String pdfPath, int dpi) {
        try (Document document = PdfHandler.getDocumentHandler().load(pdfPath);){
            RenderProcessor processor = PdfHandler.getDocumentProcessor((Document)document).getRenderProcessor();
            processor.setDpi((float)dpi);
            BufferedImage bufferedImage = processor.image(ImageType.PNG, 0);
            return bufferedImage;
        }
    }

    private void drawInvoiceInfo(Page page, EcsRecordPdfInvoiceFileVO fileVO) {
        String ocrSource = "aliyun".equals(fileVO.getOcrSource()) ? "\u963f\u91ccOCR" : ("baidu".equals(fileVO.getOcrSource()) ? "\u767e\u5ea6OCR" : ("textin".equals(fileVO.getOcrSource()) ? "TextIn" : "\u672a\u77e5"));
        Integer verifyStatus = fileVO.getVerifyStatus();
        String text = "";
        if (verifyStatus == 1) {
            String format = DateUtil.format((Date)fileVO.getVerifyTime(), (String)"yyyy-MM-dd HH:mm:ss");
            text = fileVO.getInvoiceKind() + "-" + ocrSource + format + "    \u4eba\u5de5\u6838\u5bf9";
        } else {
            text = fileVO.getInvoiceKind() + "-" + ocrSource + "    \u4eba\u5de5\u6838\u5bf9";
        }
        Table table = new Table(page);
        table.setIsBorder(false);
        table.setCellWidths(new float[]{470.0f, 30.0f});
        TableRow tableRow = new TableRow(table);
        tableRow.setHeight(10.0f);
        TableCell cell1 = new TableCell(tableRow);
        Textarea textarea1 = new Textarea(page);
        textarea1.setText(text);
        textarea1.setHorizontalAlignment(HorizontalAlignment.CENTER);
        textarea1.setLeading(5.0f);
        cell1.setContentHorizontalAlignment(HorizontalAlignment.RIGHT);
        cell1.setContentVerticalAlignment(VerticalAlignment.CENTER);
        cell1.addComponents(new Component[]{textarea1});
        TableCell cell2 = new TableCell(tableRow);
        cell2.setContentMarginLeft(Float.valueOf(10.0f));
        Rectangle rectangle = new Rectangle(page);
        rectangle.setWidth(9.0f);
        rectangle.setHeight(9.0f);
        rectangle.setBorderColor(Color.BLACK);
        rectangle.setIsWrap(Boolean.valueOf(false));
        cell2.addComponents(new Component[]{rectangle});
        tableRow.addCells(new TableCell[]{cell1, cell2});
        table.addRows(new TableRow[]{tableRow});
        table.render();
    }
}

