/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.export;

import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractExcelExporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelExporter.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;

    public final DownloadVO export(String exportType, List<String> columnList, List<Map<String, Object>> data) {
        List<ExcelExportEntity> allExportEntity = this.getExportEntity();
        ArrayList<ExcelExportEntity> exportEntity = new ArrayList<ExcelExportEntity>();
        for (ExcelExportEntity excelExportEntity : allExportEntity) {
            if (!columnList.contains(excelExportEntity.getKey().toString())) continue;
            exportEntity.add(excelExportEntity);
        }
        return this.doExport(exportEntity, columnList, data);
    }

    public abstract DownloadVO doExport(List<ExcelExportEntity> var1, List<String> var2, List<Map<String, Object>> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO downloadVO(String name, Workbook workbook) {
        DownloadVO downloadVO = new DownloadVO();
        try {
            String fileName = this.configValueUtil.getTemporaryFilePath() + name;
            FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
            try {
                workbook.write((OutputStream)output);
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                downloadVO.setName(name);
                downloadVO.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
            }
            finally {
                if (Collections.singletonList(output).get(0) != null) {
                    output.close();
                }
            }
        }
        catch (IOException e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return downloadVO;
    }

    public List<ExcelExportEntity> getExportEntity() {
        ArrayList<ExcelExportEntity> exportList = new ArrayList<ExcelExportEntity>();
        ArrayList<ExcelExportEntity> commonExportList = new ArrayList<ExcelExportEntity>();
        commonExportList.add(new ExcelExportEntity("\u53d1\u7968\u7c7b\u522b(\u53d1\u7968\u4e3b\u4f53)", (Object)"invoiceType", 30));
        commonExportList.add(new ExcelExportEntity("\u5355\u53f7(\u5355\u636e)", (Object)"recordReimbNumber", 30));
        commonExportList.add(new ExcelExportEntity("\u63d0\u4ea4\u65e5\u671f(\u5355\u636e)", (Object)"recordReimbDate", 30));
        commonExportList.add(new ExcelExportEntity("\u5ba1\u6279\u72b6\u6001(\u5355\u636e)", (Object)"recordStatusName", 20));
        commonExportList.add(new ExcelExportEntity("\u53d1\u7968\u65e5\u671f(\u53d1\u7968\u4e3b\u4f53)", (Object)"invoiceDate", 30));
        commonExportList.add(new ExcelExportEntity("\u4e0d\u8ba1\u7a0e\u91d1\u989d", (Object)"invoiceAmountPreTax", 20));
        commonExportList.add(new ExcelExportEntity("\u7a0e\u989d(\u53d1\u7968\u4e3b\u4f53)", (Object)"invoiceTax", 20));
        commonExportList.add(new ExcelExportEntity("\u53ef\u62b5\u6263\u7a0e\u989d", (Object)"deductibleTax", 20));
        commonExportList.add(new ExcelExportEntity("\u53d1\u7968\u4ee3\u7801(\u53d1\u7968\u4e3b\u4f53)", (Object)"invoiceNumber", 30));
        commonExportList.add(new ExcelExportEntity("\u53d1\u7968\u53f7\u7801(\u53d1\u7968\u4e3b\u4f53)", (Object)"invoiceCode", 30));
        commonExportList.add(new ExcelExportEntity("\u4ef7\u7a0e\u5408\u8ba1(\u53d1\u7968\u4e3b\u4f53)", (Object)"invoiceAmount", 30));
        commonExportList.add(new ExcelExportEntity("\u9500\u552e\u65b9\u540d\u79f0(\u53d1\u7968\u4e3b\u4f53)", (Object)"sellerName", 30));
        commonExportList.add(new ExcelExportEntity("\u8d2d\u4e70\u65b9\u540d\u79f0(\u53d1\u7968\u4e3b\u4f53)", (Object)"purchaserName", 30));
        commonExportList.add(new ExcelExportEntity("\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7(\u53d1\u7968\u4e3b\u4f53)", (Object)"purchaserTaxCode", 30));
        exportList.addAll(commonExportList);
        return exportList;
    }
}

