/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.config;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.ocr_api20210707.AsyncClient;
import com.aliyun.sdk.service.ocr_api20210707.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.ocr_api20210707.models.RecognizeMixedInvoicesRequest;
import com.aliyun.sdk.service.ocr_api20210707.models.RecognizeMixedInvoicesResponse;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.ocr.model.AliyunResult;
import com.bringspring.ecs.strategy.ocr.parse.InvoiceOcrResultParseFactory;
import darabonba.core.client.ClientOverrideConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.web.multipart.MultipartFile;

public class AliyunOcrClient
implements OcrClient<AliyunResult> {
    private final AsyncClient client;
    private final InvoiceOcrResultParseFactory<AliyunResult> resultParseFactory;

    public AliyunOcrClient(String accessKey, String accessKeySecret, InvoiceOcrResultParseFactory<AliyunResult> resultParseFactory) {
        this.resultParseFactory = resultParseFactory;
        StaticCredentialProvider provider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(accessKey).accessKeySecret(accessKeySecret).build());
        this.client = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().credentialsProvider((ICredentialProvider)provider)).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride("ocr-api.cn-hangzhou.aliyuncs.com"))).build();
    }

    @Override
    public String recognize(MultipartFile file, String suffix, Boolean prevHandleImage) throws IOException, ExecutionException, InterruptedException {
        RecognizeMixedInvoicesRequest build = RecognizeMixedInvoicesRequest.builder().body(file.getInputStream()).build();
        CompletableFuture mixedInvoices = this.client.recognizeMixedInvoices(build);
        RecognizeMixedInvoicesResponse response = (RecognizeMixedInvoicesResponse)mixedInvoices.get();
        String data = response.getBody().getData();
        Map stringObjectMap = JsonUtil.stringToMap((String)data);
        String subMsgs = stringObjectMap.get("subMsgs").toString();
        List jsonToList = JsonUtil.getJsonToList((String)subMsgs, AliyunResult.class);
        AliyunResult aliyunResult = (AliyunResult)jsonToList.get(0);
        return JsonUtil.getObjectToString((Object)aliyunResult);
    }

    @Override
    public void verification(EcsInvoiceInfoVO invoice) {
    }

    @Override
    public String verification(String invoiceCode, String invoiceNumber, String invoiceDate, String invoiceType, String checkCode, String totalAmount) {
        return "";
    }

    @Override
    public EcsInvoiceInfoVO parse(AliyunResult aliyunResult) throws DataException {
        return this.resultParseFactory.parse(aliyunResult);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public AsyncClient getClient() {
        return this.client;
    }

    public InvoiceOcrResultParseFactory<AliyunResult> getResultParseFactory() {
        return this.resultParseFactory;
    }
}

