/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.config;

import com.baidu.aip.ocr.AipOcr;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.ocr.model.BaiduResult;
import com.bringspring.ecs.strategy.ocr.parse.InvoiceOcrResultParseFactory;
import com.bringspring.ecs.strategy.validate.enums.BaiduVerifyResultEnum;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.multipart.MultipartFile;

public class BaiduOcrClient
implements OcrClient<BaiduResult> {
    private final AipOcr client;
    private final InvoiceOcrResultParseFactory<BaiduResult> resultParseFactory;

    public BaiduOcrClient(String appId, String accessKey, String accessKeySecret, InvoiceOcrResultParseFactory<BaiduResult> resultParseFactory) {
        this.resultParseFactory = resultParseFactory;
        this.client = new AipOcr(appId, accessKey, accessKeySecret);
    }

    @Override
    public String recognize(MultipartFile file, String suffix, Boolean prevHandleImage) throws IOException, ExecutionException, InterruptedException {
        JSONObject jsonObject = "pdf".equalsIgnoreCase(suffix) ? this.client.multipleInvoicePdf(file.getBytes(), 1, null) : this.client.multipleInvoice(file.getBytes(), null);
        Object multipleWordsResult = jsonObject.get("words_result");
        if (multipleWordsResult == null) {
            return null;
        }
        Object o = ((JSONArray)multipleWordsResult).get(0);
        return JsonUtil.getObjectToString((Object)o);
    }

    @Override
    public String verification(String invoiceCode, String invoiceNumber, String invoiceDate, String invoiceType, String checkCode, String totalAmount) {
        return this.client.vatInvoiceVerification(invoiceCode, invoiceNumber, invoiceDate, invoiceType, checkCode, totalAmount).toString();
    }

    @Override
    public void verification(EcsInvoiceInfoVO invoice) throws InvoiceValidateException {
        String invoiceOp = invoice.getInvoiceOp();
        String invoiceKind = invoice.getInvoiceKind();
        if ("vat_invoice".equals(invoiceOp) || "invoice".equals(invoiceOp)) {
            this.baiduVerification(invoice);
        }
        if ("train_ticket".equals(invoiceOp) && "\u7535\u5b50\u53d1\u7968".equals(invoiceKind)) {
            BigDecimal invoiceAmount = invoice.getInvoiceAmount();
            String checkCode = invoice.getCheckCode();
            String invoiceType = "elec_train_ticket_invoice";
            String invoiceDate = DateUtil.format((Date)DateUtil.parseDate((CharSequence)invoice.getInvoiceDate()), (String)"yyyyMMdd");
            String invoiceNumber = invoice.getInvoiceNumber();
            String invoiceCode = invoice.getInvoiceCode();
            String jsonObject = this.verification(invoiceCode, invoiceNumber, invoiceDate, invoiceType, checkCode, invoiceAmount.toString());
            this.checkResult(jsonObject);
        }
    }

    public void baiduVerification(EcsInvoiceInfoVO invoice) throws InvoiceValidateException {
        BigDecimal invoiceAmount = invoice.getInvoiceAmount();
        BigDecimal invoiceAmountPreTax = invoice.getInvoiceAmountPreTax();
        String verificationInvoiceAmount = this.getVerificationInvoiceAmount(invoice.getInvoiceType(), invoiceAmount, invoiceAmountPreTax);
        String checkCode = invoice.getCheckCode();
        String invoiceType = this.getVerificationInvoiceType(invoice.getInvoiceType());
        String invoiceDate = DateUtil.format((Date)DateUtil.parseDate((CharSequence)invoice.getInvoiceDate()), (String)"yyyyMMdd");
        String invoiceNumber = invoice.getInvoiceNumber();
        String invoiceCode = invoice.getInvoiceCode();
        String jsonObject = this.verification(invoiceCode, invoiceNumber, invoiceDate, invoiceType, checkCode, verificationInvoiceAmount);
        this.checkResult(jsonObject);
    }

    private void checkResult(String result) throws InvoiceValidateException {
        JSONObject jsonObject = (JSONObject)JsonUtil.getJsonToBean((String)result, JSONObject.class);
        if (jsonObject == null) {
            throw new InvoiceValidateException("\u4f60\u63d0\u4ea4\u7684\u53d1\u7968\uff0c\u6709\u672a\u901a\u8fc7\u9a8c\u771f\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
        }
        String verifyResult = jsonObject.getString("VerifyResult");
        if ("0001".equals(verifyResult)) {
            return;
        }
        String nameByCode = BaiduVerifyResultEnum.getNameByCode(verifyResult);
        throw new InvoiceValidateException(nameByCode);
    }

    private String getVerificationInvoiceType(String invoiceType) {
        if ("\u666e\u901a\u53d1\u7968".equals(invoiceType) || "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968".equals(invoiceType)) {
            return "normal_invoice";
        }
        if ("\u4e13\u7528\u53d1\u7968".equals(invoiceType) || "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968".equals(invoiceType)) {
            return "special_vat_invoice";
        }
        if ("\u7535\u5b50\u666e\u901a\u53d1\u7968".equals(invoiceType) || "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u7535\u5b50)".equals(invoiceType)) {
            return "elec_normal_invoice";
        }
        if ("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u5f0f)".equals(invoiceType)) {
            return "roll_normal_invoice";
        }
        if ("\u7535\u5b50\u4e13\u7528\u53d1\u7968".equals(invoiceType) || "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968".equals(invoiceType)) {
            return "elec_special_vat_invoice";
        }
        if ("\u901a\u884c\u8d39\u7535\u5b50\u666e\u7968".equals(invoiceType) || "\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968".equals(invoiceType)) {
            return "toll_elec_normal_invoice";
        }
        if ("\u533a\u5757\u94fe\u53d1\u7968".equals(invoiceType) || "\u533a\u5757\u94fe\u7535\u5b50\u53d1\u7968".equals(invoiceType)) {
            return "blockchain_invoice";
        }
        if ("\u7535\u5b50\u53d1\u7968(\u4e13\u7528\u53d1\u7968)".equals(invoiceType) || "\u5168\u7535\u53d1\u7968(\u4e13\u7528\u53d1\u7968)".equals(invoiceType)) {
            return "elec_invoice_special";
        }
        if ("\u7535\u5b50\u53d1\u7968(\u666e\u901a\u53d1\u7968)".equals(invoiceType) || "\u5168\u7535\u53d1\u7968(\u666e\u901a\u53d1\u7968)".equals(invoiceType)) {
            return "elec_invoice_normal";
        }
        if ("\u8d27\u8fd0\u8fd0\u8f93\u4e1a\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968".equals(invoiceType)) {
            return "special_freight_transport_invoice";
        }
        if ("\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968".equals(invoiceType)) {
            return "motor_vehicle_invoice";
        }
        if ("\u4e8c\u624b\u8f66\u9500\u552e\u53d1\u7968".equals(invoiceType)) {
            return "used_vehicle_invoice";
        }
        return "";
    }

    private String getVerificationInvoiceAmount(String invoiceType, BigDecimal invoiceAmount, BigDecimal preTaxAmount) {
        if ("special_vat_invoice".equals(invoiceType) || "elec_special_vat_invoice".equals(invoiceType) || "special_freight_transport_invoice".equals(invoiceType) || "motor_vehicle_invoice".equals(invoiceType)) {
            return preTaxAmount.toString();
        }
        if ("used_vehicle_invoice".equals(invoiceType)) {
            return invoiceAmount.toString();
        }
        if ("elec_invoice_special".equals(invoiceType) || "elec_invoice_normal".equals(invoiceType)) {
            return invoiceAmount.toString();
        }
        return null;
    }

    @Override
    public EcsInvoiceInfoVO parse(BaiduResult baiduResult) throws DataException {
        return this.resultParseFactory.parse(baiduResult);
    }

    public AipOcr getClient() {
        return this.client;
    }

    public InvoiceOcrResultParseFactory<BaiduResult> getResultParseFactory() {
        return this.resultParseFactory;
    }
}

