/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.ocr.config;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.ocr.config.OcrClient;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextInInvalidMarkEnum;
import com.bringspring.ecs.strategy.ocr.impl.textin.enums.TextinVerifyCodeEnum;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.response.TextInObjectData;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.verify.VerifyResponse;
import com.bringspring.ecs.strategy.ocr.impl.textin.model.verify.VerifyResult;
import com.bringspring.ecs.strategy.ocr.parse.InvoiceOcrResultParseFactory;
import com.bringspring.ecs.utils.ImageEnhancer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

public class TextInOcrClient
implements OcrClient<TextInObjectData> {
    private static final Logger log = LoggerFactory.getLogger(TextInOcrClient.class);
    private static final String url = "https://api.textin.com/ai/service/v1/bill_recognize_v2?merge_digital_elec_invoice=1&verify_vat=1";
    private static final String VERIFY_VAT_URL = "https://api.textin.com/robot/v1.0/api/verify_vat";
    private final InvoiceOcrResultParseFactory<TextInObjectData> resultParseFactory;
    private final RestTemplate restTemplate;
    private final String appId;
    private final String secretCode;

    public TextInOcrClient(String accessKey, String accessKeySecret, InvoiceOcrResultParseFactory<TextInObjectData> resultParseFactory) {
        this.appId = accessKey;
        this.secretCode = accessKeySecret;
        this.resultParseFactory = resultParseFactory;
        this.restTemplate = new RestTemplate();
    }

    @Override
    public String recognize(MultipartFile file, String suffix, Boolean prevHandleImage) throws IOException, ExecutionException, InterruptedException {
        try {
            byte[] bytes = file.getBytes();
            if (prevHandleImage.booleanValue()) {
                try {
                    bytes = ImageEnhancer.processFile(file, suffix);
                }
                catch (IOException e) {
                    bytes = file.getBytes();
                }
            }
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/octet-stream");
            headers.set("x-ti-app-id", this.appId);
            headers.set("x-ti-secret-code", this.secretCode);
            HttpEntity request = new HttpEntity((Object)bytes, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            return (String)response.getBody();
        }
        catch (Exception e) {
            log.error("TextInOcrClient recognize error", (Throwable)e);
            return null;
        }
    }

    @Override
    public String verification(String invoiceCode, String invoiceNumber, String invoiceDate, String invoiceType, String checkCode, String totalAmount) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("x-ti-app-id", this.appId);
            headers.set("x-ti-secret-code", this.secretCode);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("invoice_code", invoiceCode);
            params.put("invoice_no", invoiceNumber);
            if (StringUtils.isNotBlank((CharSequence)invoiceDate) && invoiceDate.length() > 8) {
                invoiceDate = DateUtil.format((Date)DateUtil.parseDate((CharSequence)invoiceDate), (String)"yyyyMMdd");
            }
            params.put("invoice_date", invoiceDate);
            params.put("invoice_sum", totalAmount);
            if (StringUtils.isNotBlank((CharSequence)checkCode) && checkCode.length() > 6) {
                checkCode = checkCode.substring(checkCode.length() - 6);
            }
            params.put("verify_code", checkCode);
            HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(VERIFY_VAT_URL, (Object)request, String.class, new Object[0]);
            return (String)response.getBody();
        }
        catch (Exception e) {
            log.error("TextInOcrClient recognize error", (Throwable)e);
            return null;
        }
    }

    @Override
    public void verification(EcsInvoiceInfoVO invoice) throws InvoiceValidateException {
        BigDecimal invoiceSum;
        String checkCode;
        String invoiceType;
        String invoiceDate;
        String invoiceNumber;
        String invoiceCode;
        String invoiceOp = invoice.getInvoiceOp();
        String jsonObject = "";
        if ("vat_digital_invoice".equals(invoiceOp) || "railway_digital_ticket".equals(invoiceOp) || "flight_digital_ticket".equals(invoiceOp)) {
            String invoiceNumber2 = invoice.getInvoiceNumber();
            String invoiceDate2 = invoice.getInvoiceDate();
            String invoiceType2 = invoice.getInvoiceType();
            BigDecimal invoiceSum2 = invoice.getInvoiceSum();
            jsonObject = this.verification(null, invoiceNumber2, invoiceDate2, invoiceType2, null, invoiceSum2.toString());
        } else if ("vat_invoice".equals(invoiceOp)) {
            invoiceCode = invoice.getInvoiceCode();
            invoiceNumber = invoice.getInvoiceNumber();
            invoiceDate = invoice.getInvoiceDate();
            invoiceType = invoice.getInvoiceType();
            checkCode = invoice.getCheckCode();
            invoiceSum = invoice.getInvoiceAmountPreTax();
            jsonObject = this.verification(invoiceCode, invoiceNumber, invoiceDate, invoiceType, checkCode, invoiceSum.toString());
        } else if ("vat_volume_invoice".equals(invoiceOp)) {
            invoiceCode = invoice.getInvoiceCode();
            invoiceNumber = invoice.getInvoiceNumber();
            invoiceDate = invoice.getInvoiceDate();
            invoiceType = invoice.getInvoiceType();
            checkCode = invoice.getCheckCode();
            invoiceSum = invoice.getInvoiceAmountPreTax();
            jsonObject = this.verification(invoiceCode, invoiceNumber, invoiceDate, invoiceType, checkCode, null);
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject)) {
            try {
                VerifyResponse jsonToBean = (VerifyResponse)JsonUtil.getJsonToBean((String)jsonObject, VerifyResponse.class);
                VerifyResult result = jsonToBean.getResult();
                String code = result.getCode();
                TextinVerifyCodeEnum textinVerifyCodeEnum = TextinVerifyCodeEnum.fromCode(code);
                if (!TextinVerifyCodeEnum.SUCCESS.equals((Object)textinVerifyCodeEnum)) {
                    throw new InvoiceValidateException("\u53d1\u7968\u9a8c\u771f\u5931\u8d25\uff1a" + textinVerifyCodeEnum.getDesc());
                }
                TextInInvalidMarkEnum markEnum = TextInInvalidMarkEnum.fromCode(result.getInvalid_mark());
                switch (markEnum) {
                    case N: {
                        break;
                    }
                    case Y: 
                    case H: 
                    case SEVEN: 
                    case EIGHT: 
                    case EMPTY: {
                        TextInInvalidMarkEnum textInInvalidMarkEnum = TextInInvalidMarkEnum.fromCode(result.getInvalid_mark());
                        throw new InvoiceValidateException("\u53d1\u7968\u9a8c\u771f\u5931\u8d25\uff1a\u53d1\u7968" + textInInvalidMarkEnum.getDesc());
                    }
                }
                invoice.setVerifyStatus(1);
                invoice.setVerifyTime(new Date());
            }
            catch (InvoiceValidateException e) {
                log.error("\u53d1\u7968\u9a8c\u771f\u5931\u8d25:{}", (Object)JsonUtil.getObjectToString((Object)invoice));
                throw e;
            }
            catch (Exception e) {
                log.error("\u53d1\u7968\u9a8c\u771f\u5931\u8d25:{},{}", (Object)JsonUtil.getObjectToString((Object)invoice), (Object)e.getMessage());
                throw new InvoiceValidateException("\u53d1\u7968\u9a8c\u771f\u5931\u8d25\uff01");
            }
        }
    }

    private boolean isRetryableError(String code) {
        return TextinVerifyCodeEnum.INCOMPLETE_REQUEST.getCode().equals(code);
    }

    @Override
    public EcsInvoiceInfoVO parse(TextInObjectData result) throws DataException {
        return this.resultParseFactory.parse(result);
    }
}

